/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.budget.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.budget.entity.BudgetCheckHead;
import com.els.modules.budget.entity.BudgetCheckItem;
import com.els.modules.budget.entity.BudgetManage;
import com.els.modules.budget.service.BudgetCheckHeadService;
import com.els.modules.budget.service.BudgetCheckItemService;
import com.els.modules.budget.vo.BudgetCheckVo;
import com.els.modules.demand.api.dto.PurchaseRequestHeadDTO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u9884\u7b97\u6821\u9a8c\u5934\u8868")
@RestController
@RequestMapping(value={"/budget/budgetCheckHead"})
public class BudgetCheckHeadController
extends BaseController<BudgetCheckHead, BudgetCheckHeadService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BudgetCheckHeadController.class);
    @Autowired
    private BudgetCheckHeadService budgetCheckHeadService;
    @Autowired
    private BudgetCheckItemService budgetCheckItemService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_budgetCheckHead_";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    @AutoLog(value="\u9884\u7b97\u6821\u9a8c\u5934\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="budgetCheck")
    @RequiresPermissions(value={"budgetCheck#budgetCheckHead:list"})
    public Result<?> queryPageList(BudgetCheckHead budgetCheckHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)budgetCheckHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        IPage pageList = this.budgetCheckHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u9884\u7b97\u6821\u9a8c\u5934\u8868-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"budgetCheck#budgetCheckHead:add"})
    @PermissionDataOpt(businessType="budgetCheck", beanClass=BudgetCheckHeadService.class)
    @FormCommit
    public Result<?> add(@RequestBody BudgetCheckVo budgetCheckVo) {
        BudgetCheckHead budgetCheckHead = new BudgetCheckHead();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.and(b -> ((QueryWrapper)((QueryWrapper)b.eq((Object)"purchase_request_type", (Object)budgetCheckVo.getPurchaseRequestType())).or()).eq((Object)"budget_manage_type", (Object)budgetCheckVo.getBudgetManageType()));
        List list = this.budgetCheckHeadService.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_UdJOIMKWViFAvAc_5febcadf", (String)"\u9884\u7b97\u6821\u9a8c\u5df2\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u7c7b\u578b"));
        }
        this.verifyFiledType(budgetCheckVo.getBudgetCheckItems());
        BeanUtils.copyProperties((Object)((Object)budgetCheckVo), (Object)((Object)budgetCheckHead));
        this.budgetCheckHeadService.saveBudgetCheckHead(budgetCheckHead);
        budgetCheckVo.setId(budgetCheckHead.getId());
        this.saveBudgetCheckItem(budgetCheckVo);
        return Result.ok((Object)((Object)budgetCheckHead));
    }

    @SrmValidated
    @AutoLog(value="\u9884\u7b97\u6821\u9a8c\u5934\u8868-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"budgetCheck#budgetCheckHead:edit"})
    @PermissionDataOpt(businessType="budgetCheck", beanClass=BudgetCheckHeadService.class)
    public Result<?> edit(@RequestBody BudgetCheckVo budgetCheckVo) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, budgetCheckVo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFiKRcsSTVBtk_2ef68e36", (String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.and(b -> ((QueryWrapper)((QueryWrapper)b.eq((Object)"purchase_request_type", (Object)budgetCheckVo.getPurchaseRequestType())).or()).eq((Object)"budget_manage_type", (Object)budgetCheckVo.getBudgetManageType()));
            List list = this.budgetCheckHeadService.list((Wrapper)queryWrapper);
            if (!CollectionUtils.isEmpty((Collection)list) && !((BudgetCheckHead)((Object)list.get(0))).getId().equals(budgetCheckVo.getId())) {
                Result result = Result.error((String)I18nUtil.translate((String)"i18n_alert_UdJOIMKWViFAvAc_5febcadf", (String)"\u9884\u7b97\u6821\u9a8c\u5df2\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u7c7b\u578b"));
                return result;
            }
            this.verifyFiledType(budgetCheckVo.getBudgetCheckItems());
            this.budgetCheckItemService.delByHeadId(budgetCheckVo.getId());
            this.saveBudgetCheckItem(budgetCheckVo);
            BudgetCheckHead budgetCheckHead = new BudgetCheckHead();
            BeanUtils.copyProperties((Object)((Object)budgetCheckVo), (Object)((Object)budgetCheckHead));
            this.budgetCheckHeadService.updateBudgetCheckHead(budgetCheckHead);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, budgetCheckVo.getId());
        }
        String id = budgetCheckVo.getId();
        return this.queryById(id);
    }

    private void saveBudgetCheckItem(BudgetCheckVo budgetCheckVo) {
        List<BudgetCheckItem> budgetCheckItems = budgetCheckVo.getBudgetCheckItems();
        budgetCheckItems.forEach(object -> object.setHeadId(budgetCheckVo.getId()));
        this.budgetCheckItemService.saveBatch(budgetCheckItems);
    }

    @AutoLog(value="\u9884\u7b97\u6821\u9a8c\u5934\u8868-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"budgetCheck#budgetCheckHead:delete"})
    @PermissionDataOpt(businessType="budgetCheck", beanClass=BudgetCheckHeadService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.budgetCheckHeadService.delBudgetCheckHead(id);
        this.budgetCheckItemService.delByHeadId(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9884\u7b97\u6821\u9a8c\u5934\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"budgetCheck#budgetCheckHead:queryByBudgetId"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        BudgetCheckHead budgetCheckHead = (BudgetCheckHead)((Object)this.budgetCheckHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)budgetCheckHead));
    }

    @AutoLog(value="\u9884\u7b97\u6821\u9a8c\u5934\u8868-\u901a\u8fc7id\u67e5\u770b\u8be6\u60c5")
    @Operation(summary="\u901a\u8fc7id\u67e5\u770b\u8be6\u60c5", description="\u901a\u8fc7id\u67e5\u770b\u8be6\u60c5")
    @GetMapping(value={"/viewDetail"})
    @RequiresPermissions(value={"budgetCheck#budgetCheckHead:view"})
    public Result<?> viewDetail(@RequestParam(name="id", required=true) String id) {
        BudgetCheckVo budgetCheckVo = this.budgetCheckHeadService.viewDetail(id);
        return Result.ok((Object)((Object)budgetCheckVo));
    }

    private void verifyFiledType(List<BudgetCheckItem> budgetCheckItems) {
        PurchaseRequestHeadDTO purchaseRequestHead = new PurchaseRequestHeadDTO();
        BudgetManage budgetManage = new BudgetManage();
        for (BudgetCheckItem budgetCheckItem : budgetCheckItems) {
            try {
                Field declaredField1 = purchaseRequestHead.getClass().getDeclaredField(budgetCheckItem.getPurchaseRequestField());
                String fieldType1 = declaredField1.getGenericType().toString();
                Field declaredField2 = ((Object)((Object)budgetManage)).getClass().getDeclaredField(budgetCheckItem.getBudgetManageField());
                String fieldType2 = declaredField2.getGenericType().toString();
                if ("class java.lang.String".equals(fieldType2) || fieldType2.equals(fieldType1)) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVJOUUdRvJOAcxIRWShER_b02b624d", (String)"\u91c7\u8d2d\u7533\u8bf7\u5b57\u6bb5\u4e0e\u9884\u7b97\u7ba1\u7406\u5b57\u6bb5\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u914d\u7f6e"));
            }
            catch (NoSuchFieldException e) {
                log.error("\u83b7\u53d6\u91c7\u8d2d\u7533\u8bf7\u5b57\u6bb5\u4e0e\u9884\u7b97\u7ba1\u7406\u5b57\u6bb5\u4fe1\u606f\u9519\u8bef", (Object)e.getMessage());
            }
        }
    }
}

