/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.budget.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.budget.entity.BudgetDetail;
import com.els.modules.budget.service.BudgetDetailService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u9884\u7b97\u660e\u7ec6\u8868")
@RestController
@RequestMapping(value={"/budget/budgetDetail"})
public class BudgetDetailController
extends BaseController<BudgetDetail, BudgetDetailService> {
    @Autowired
    private BudgetDetailService budgetDetailService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_budgetDetail_";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"budgetDetail#budgetDetail:listOccupy", "budgetDetail#budgetDetail:useAmount"})
    public Result<?> queryPageList(BudgetDetail budgetDetail, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)budgetDetail), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.budgetDetailService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u9884\u7b97\u5360\u7528\u67e5\u8be2", description="\u9884\u7b97\u5360\u7528\u67e5\u8be2")
    @GetMapping(value={"/countAmount"})
    @RequiresPermissions(value={"budgetDetail#budgetDetail:listOccupy", "budgetDetail#budgetDetail:useAmount"})
    public Result<?> countAmount(BudgetDetail budgetDetail, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)budgetDetail), (Map)req.getParameterMap());
        BigDecimal amount = this.budgetDetailService.countAmount((QueryWrapper<BudgetDetail>)queryWrapper);
        return Result.ok((Object)amount);
    }

    @SrmValidated
    @AutoLog(value="\u9884\u7b97\u660e\u7ec6\u8868-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"budgetDetail#budgetDetail:view"})
    @FormCommit
    public Result<?> add(@RequestBody BudgetDetail budgetDetail) {
        this.budgetDetailService.saveBudgetDetail(budgetDetail);
        return Result.ok((Object)((Object)budgetDetail));
    }

    @SrmValidated
    @AutoLog(value="\u9884\u7b97\u660e\u7ec6\u8868-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"budgetDetail#budgetDetail:edit"})
    public Result<?> edit(@RequestBody BudgetDetail budgetDetail) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, budgetDetail.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFiKRcsSTVBtk_2ef68e36", (String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.budgetDetailService.updateBudgetDetail(budgetDetail);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, budgetDetail.getId());
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9884\u7b97\u660e\u7ec6\u8868-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"budgetDetail#budgetDetail:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.budgetDetailService.delBudgetDetail(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9884\u7b97\u660e\u7ec6\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"budgetDetail#budgetDetail:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        BudgetDetail budgetDetail = (BudgetDetail)((Object)this.budgetDetailService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)budgetDetail));
    }
}

