/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.adapter;

import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.service.DictTranslateService;
import com.els.common.util.SpringContextUtils;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.PurchaseDeductCostItem;
import com.els.modules.finance.mapper.PurchaseDeductCostMapper;
import com.els.modules.finance.service.PurchaseDeductCostItemService;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseDeductCostAuditDubboAdapter")
public class PurchaseDeductCostAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Resource
    private PurchaseDeductCostMapper purchaseDeductCostMapper;
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;
    @Autowired
    private PurchaseDeductCostItemService purchaseDeductCostItemService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        PurchaseDeductCost head = (PurchaseDeductCost)((Object)this.purchaseDeductCostMapper.selectById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        List<PurchaseDeductCostItem> purchaseDeductCostItemList = this.purchaseDeductCostItemService.selectByMainId(flowCallbackDTO.getBusinessId());
        this.purchaseDeductCostService.sendDeductCost(head, purchaseDeductCostItemList);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseDeductCost head = (PurchaseDeductCost)((Object)this.purchaseDeductCostMapper.selectById((Serializable)((Object)id)));
        if (head != null) {
            return ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)head, new DictTranslateAspectParam());
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseDeductCost head = new PurchaseDeductCost();
        head.setId(flowCallbackDTO.getBusinessId());
        head.setAuditStatus(auditStatus);
        head.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchaseDeductCostMapper.updateById((Object)head);
    }
}

