/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.modules.delivery.api.dto.PurchaseRebateVoucherDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.delivery.api.service.PurchaseVoucherItemRpcService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.rebate.entity.PurchaseRebateProgress;
import com.els.modules.rebate.entity.PurchaseRebateRuleItem;
import com.els.modules.rebate.entity.PurchaseRebateRuleSupplement;
import com.els.modules.rebate.entity.PurchaseRebateRuleThreshold;
import com.els.modules.rebate.enumerate.PricingBasisEnum;
import com.els.modules.rebate.enumerate.RebateConditionEnum;
import com.els.modules.rebate.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.rebate.rpc.SupplierLocalRpcService;
import com.els.modules.rebate.service.impl.PurchaseRebateProcessService;
import com.els.modules.rebate.vo.CalculationResultDTO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RebateProcessPurchaseReturnService
extends PurchaseRebateProcessService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RebateProcessPurchaseReturnService.class);
    @Resource
    private PurchaseVoucherItemRpcService purchaseVoucherItemRpcService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    @Resource
    private SupplierLocalRpcService supplierLocalRpcService;

    @Override
    protected CalculationResultDTO beforeCalculate(PurchaseRebateProgress sheet, PurchaseRebateRuleItem rule) {
        CalculationResultDTO<List<PurchaseVoucherItemDTO>> resultDTO = new CalculationResultDTO<List<PurchaseVoucherItemDTO>>();
        List<PurchaseVoucherItemDTO> voucherItems = this.getPurchaseVoucherItem(sheet, rule);
        log.info("rebate:  rule get voucher list , ruleId : , {} ,  data : {} ", (Object)rule.getId(), (Object)JSON.toJSONString(voucherItems));
        if (CollectionUtils.isEmpty(voucherItems)) {
            log.info("\u89c4\u5219 ,{} \u6ca1\u6709\u5bf9\u5e94\u51ed\u8bc1\u5355 ", (Object)rule.getId());
            return resultDTO;
        }
        this.handleTotalAmountOrNumber(resultDTO, voucherItems, rule.getRebateCondition(), rule.getPricingBasis(), rule.getPriceJudgment(), rule.getAssessmentPrice());
        resultDTO.setObj(voucherItems);
        return resultDTO;
    }

    @Override
    protected CalculationResultDTO beforeCalculateThreshold(PurchaseRebateProgress sheet, PurchaseRebateRuleThreshold threshold) {
        CalculationResultDTO<List<PurchaseVoucherItemDTO>> resultDTO = new CalculationResultDTO<List<PurchaseVoucherItemDTO>>();
        List<PurchaseVoucherItemDTO> voucherItems = this.getPurchaseVoucherItemByThreshold(sheet, threshold);
        log.info("rebate: sheetId : {} ,  rule get voucher list , thresholdId : , {} ,  data : {} ", new Object[]{sheet.getId(), threshold.getId(), JSON.toJSONString(voucherItems)});
        if (CollectionUtils.isEmpty(voucherItems)) {
            log.info("\u95e8\u69dbid: {} \u6ca1\u6709\u5bf9\u5e94\u51ed\u8bc1\u5355 ", (Object)threshold.getId());
            return resultDTO;
        }
        this.handleTotalAmountOrNumber(resultDTO, voucherItems, threshold.getRebateCondition(), threshold.getPricingBasis(), threshold.getPriceJudgment(), threshold.getAssessmentPrice());
        resultDTO.setObj(voucherItems);
        return resultDTO;
    }

    @Override
    protected CalculationResultDTO beforeCalculateSupplement(PurchaseRebateProgress sheet, PurchaseRebateRuleSupplement supplement) {
        CalculationResultDTO<List<PurchaseVoucherItemDTO>> resultDTO = new CalculationResultDTO<List<PurchaseVoucherItemDTO>>();
        List<PurchaseVoucherItemDTO> voucherItems = this.getPurchaseVoucherItemBySupplement(sheet, supplement);
        log.info("rebate:  rule get voucher list , ruleId : , {} ,  data : {} ", (Object)supplement.getId(), (Object)JSON.toJSONString(voucherItems));
        if (CollectionUtils.isEmpty(voucherItems)) {
            log.info("\u89c4\u5219 ,{} \u6ca1\u6709\u5bf9\u5e94\u51ed\u8bc1\u5355 ", (Object)supplement.getId());
            return resultDTO;
        }
        this.handleTotalAmountOrNumber(resultDTO, voucherItems, supplement.getRebateCondition(), supplement.getPricingBasis(), supplement.getPriceJudgment(), supplement.getAssessmentPrice());
        resultDTO.setObj(voucherItems);
        return resultDTO;
    }

    private void handleTotalAmountOrNumber(CalculationResultDTO<List<PurchaseVoucherItemDTO>> resultDTO, List<PurchaseVoucherItemDTO> voucherItems, String rebateCondition, String pricingBasis, BigDecimal priceJudgment, BigDecimal assessmentPrice) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalNumber = BigDecimal.ZERO;
        BigDecimal totalVoucherQuantity = voucherItems.parallelStream().filter(item -> item.getVoucherQuantity() != null).map(PurchaseVoucherItemDTO::getVoucherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (RebateConditionEnum.AMOUNT.getValue().equals(rebateCondition)) {
            if (PricingBasisEnum.PRICE.getValue().equals(pricingBasis)) {
                for (PurchaseVoucherItemDTO item2 : voucherItems) {
                    totalAmount = this.handlePriceJudgmentAmount(priceJudgment, item2, item2.getPrice(), totalAmount);
                    totalNumber = this.handlePriceJudgmentNumber(priceJudgment, item2, item2.getPrice(), totalNumber);
                }
            } else if (PricingBasisEnum.NET_PRICE.getValue().equals(pricingBasis)) {
                for (PurchaseVoucherItemDTO item3 : voucherItems) {
                    totalAmount = this.handlePriceJudgmentAmount(priceJudgment, item3, item3.getNetPrice(), totalAmount);
                    totalNumber = this.handlePriceJudgmentNumber(priceJudgment, item3, item3.getNetPrice(), totalNumber);
                }
            } else if (PricingBasisEnum.ASSESSMENT_PRICE.getValue().equals(pricingBasis) && BigDecimal.ZERO.compareTo(totalVoucherQuantity) != 0 && BigDecimal.ZERO.compareTo(assessmentPrice) != 0) {
                totalAmount = totalVoucherQuantity.multiply(assessmentPrice);
            }
        } else if (RebateConditionEnum.NUMBER.getValue().equals(rebateCondition)) {
            totalNumber = totalVoucherQuantity;
        }
        resultDTO.setTotalAmount(totalAmount);
        resultDTO.setTotalNumber(totalNumber);
    }

    private BigDecimal handlePriceJudgmentAmount(BigDecimal priceJudgment, PurchaseVoucherItemDTO item, BigDecimal price, BigDecimal amount) {
        if (price != null && item.getVoucherQuantity() != null) {
            boolean flag;
            boolean bl = flag = priceJudgment != null && BigDecimal.ZERO.compareTo(priceJudgment) != 0 && price.compareTo(priceJudgment) < 0;
            if (flag) {
                log.info("rebate: \u91d1\u989d\u4e3a: " + price + "  \u4ef7\u683c\u5224\u65ad\u4e3a: " + priceJudgment);
                return amount;
            }
            BigDecimal positiveAmount = BigDecimal.ZERO;
            BigDecimal negativeAmount = BigDecimal.ZERO;
            if ("+".equals(item.getLoanDirection())) {
                positiveAmount = price.multiply(item.getVoucherQuantity());
            }
            if ("-".equals(item.getLoanDirection())) {
                negativeAmount = price.multiply(item.getVoucherQuantity());
            }
            BigDecimal current = positiveAmount.subtract(negativeAmount);
            current = this.handleScientificNotation(current);
            amount = amount.add(current);
        }
        return amount;
    }

    private BigDecimal handlePriceJudgmentNumber(BigDecimal priceJudgment, PurchaseVoucherItemDTO item, BigDecimal price, BigDecimal number) {
        if (price != null && item.getVoucherQuantity() != null) {
            boolean flag;
            boolean bl = flag = priceJudgment != null && BigDecimal.ZERO.compareTo(priceJudgment) != 0 && price.compareTo(priceJudgment) < 0;
            if (flag) {
                log.info("rebate: \u91d1\u989d\u4e3a: " + price + "  \u4ef7\u683c\u5224\u65ad\u4e3a: " + priceJudgment);
                return number;
            }
            BigDecimal positiveNumber = BigDecimal.ZERO;
            BigDecimal negativeNumber = BigDecimal.ZERO;
            if ("+".equals(item.getLoanDirection())) {
                positiveNumber = item.getVoucherQuantity();
            }
            if ("-".equals(item.getLoanDirection())) {
                negativeNumber = item.getVoucherQuantity();
            }
            BigDecimal current = positiveNumber.subtract(negativeNumber);
            current = this.handleScientificNotation(current);
            number = number.add(current);
        }
        return number;
    }

    private List<PurchaseVoucherItemDTO> getPurchaseVoucherItem(PurchaseRebateProgress sheet, PurchaseRebateRuleItem rule) {
        PurchaseRebateVoucherDTO dto = new PurchaseRebateVoucherDTO();
        Date calculationSheetEndDate = this.handleCalculationSheetEndDate(rule.getRebateSettlementCycle(), sheet.getEndDate());
        String rebateProduct = rule.getRebateProduct();
        this.handleProducts(dto, rebateProduct);
        String sourceRestriction = rule.getSourceRestriction();
        dto.setSheetBeginDate(sheet.getBeginDate());
        dto.setSheetEndDate(calculationSheetEndDate);
        dto.setCurrency(rule.getCurrency());
        if (calculationSheetEndDate == null) {
            dto.setSheetBeginDate(null);
        }
        dto.setToElsAccount(sheet.getToElsAccount());
        log.info("rebate: sheetId: {},  ruleId: {}, queryParam: {} , products: {}", new Object[]{sheet.getId(), rule.getId(), JSON.toJSONString((Object)dto), JSON.toJSONString((Object)rebateProduct)});
        return this.purchaseVoucherItemRpcService.selectCalculationVoucher(dto);
    }

    private List<PurchaseVoucherItemDTO> getPurchaseVoucherItemBySupplement(PurchaseRebateProgress sheet, PurchaseRebateRuleSupplement supplement) {
        PurchaseRebateVoucherDTO dto = new PurchaseRebateVoucherDTO();
        String rebateProduct = supplement.getRebateProduct();
        this.handleProducts(dto, rebateProduct);
        String sourceRestriction = supplement.getSourceRestriction();
        dto.setCurrency(supplement.getCurrency());
        dto.setToElsAccount(sheet.getToElsAccount());
        log.info("rebate: sheetId: {},  supplementId: {}, queryParam: {} , products: {}", new Object[]{sheet.getId(), supplement.getId(), JSON.toJSONString((Object)dto), JSON.toJSONString((Object)rebateProduct)});
        return this.purchaseVoucherItemRpcService.selectCalculationVoucher(dto);
    }

    private List<PurchaseVoucherItemDTO> getPurchaseVoucherItemByThreshold(PurchaseRebateProgress sheet, PurchaseRebateRuleThreshold threshold) {
        PurchaseRebateVoucherDTO dto = new PurchaseRebateVoucherDTO();
        String rebateProduct = threshold.getRebateProduct();
        this.handleProducts(dto, rebateProduct);
        String sourceRestriction = threshold.getSourceRestriction();
        dto.setCurrency(threshold.getCurrency());
        dto.setToElsAccount(sheet.getToElsAccount());
        log.info("rebate: sheetId: {},  thresholdId: {}, queryParam: {} , products: {}", new Object[]{sheet.getId(), threshold.getId(), JSON.toJSONString((Object)dto), JSON.toJSONString((Object)rebateProduct)});
        return this.purchaseVoucherItemRpcService.selectCalculationVoucher(dto);
    }

    private void handleSourceRestriction(PurchaseRebateVoucherDTO dto, String sourceRestriction) {
        if (StrUtil.isBlank((CharSequence)sourceRestriction)) {
            return;
        }
        ArrayList sourceRestrictions = Lists.newArrayList((Object[])sourceRestriction.split(","));
        if (CollectionUtils.isEmpty((Collection)sourceRestrictions)) {
            return;
        }
        List<SupplierMasterDataDTO> supplierMasterDataDTOList = this.supplierLocalRpcService.listByIds(sourceRestrictions);
        if (!CollectionUtils.isEmpty(supplierMasterDataDTOList)) {
            List sourceRestrictionCodes = supplierMasterDataDTOList.stream().map(SupplierMasterDataDTO::getToElsAccount).collect(Collectors.toList());
            dto.setSourceRestrictions(sourceRestrictionCodes);
        }
    }

    private void handleProducts(PurchaseRebateVoucherDTO dto, String rebateProduct) {
        if (StrUtil.isBlank((CharSequence)rebateProduct)) {
            return;
        }
        ArrayList products = Lists.newArrayList((Object[])rebateProduct.split(","));
        if (CollectionUtils.isEmpty((Collection)products)) {
            return;
        }
        List<PurchaseMaterialHeadDTO> purchaseMaterialHeadDTOList = this.purchaseMaterialHeadLocalRpcService.listByIds(products);
        if (!CollectionUtils.isEmpty(purchaseMaterialHeadDTOList)) {
            List productsCodes = purchaseMaterialHeadDTOList.stream().map(PurchaseMaterialHeadDTO::getMaterialNumber).collect(Collectors.toList());
            dto.setRebateProducts(productsCodes);
        }
    }
}

