/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.budget.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.budget.entity.BudgetAdjustment;
import com.els.modules.budget.entity.BudgetManage;
import com.els.modules.budget.mapper.BudgetAdjustmentMapper;
import com.els.modules.budget.service.BudgetAdjustmentService;
import com.els.modules.budget.service.BudgetManageService;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="budgetAdjustmentAuditDubboAdapter")
public class BudgetAdjustmentAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Autowired
    private BudgetAdjustmentMapper budgetAdjustmentMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private BudgetAdjustmentService budgetAdjustmentService;
    @Autowired
    private BudgetManageService budgetManageService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        String businessId = flowCallbackDTO.getBusinessId();
        BudgetAdjustment budgetAdjustment = (BudgetAdjustment)((Object)this.budgetAdjustmentService.getById((Serializable)((Object)businessId)));
        BudgetManage budgetManage = (BudgetManage)((Object)this.budgetManageService.getById((Serializable)((Object)budgetAdjustment.getBudgetId())));
        budgetManage.setActualBudget(budgetAdjustment.getAdjustedAmount());
        budgetManage.setAvailableAmount(budgetManage.getActualBudget().subtract(budgetManage.getActualUsedAmount()).subtract(budgetManage.getOccupiedAmount()));
        this.budgetManageService.updateBudgetManage(budgetManage);
        this.budgetManageService.updateAdjustmentAmount(budgetAdjustment.getBudgetId());
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        BudgetAdjustment head = (BudgetAdjustment)((Object)this.budgetAdjustmentService.getById((Serializable)((Object)id)));
        if (head != null) {
            return SrmUtil.toJSONObject((Object)((Object)head));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        BudgetAdjustment head = new BudgetAdjustment();
        head.setId(flowCallbackDTO.getBusinessId());
        head.setAuditStatus(auditStatus);
        this.budgetAdjustmentMapper.updateById((Object)head);
    }
}

