/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.budget.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.budget.entity.BudgetCheckItem;
import com.els.modules.budget.service.BudgetCheckItemService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u9884\u7b97\u6821\u9a8c\u884c\u8868")
@RestController
@RequestMapping(value={"/budget/budgetCheckItem"})
public class BudgetCheckItemController
extends BaseController<BudgetCheckItem, BudgetCheckItemService> {
    @Autowired
    private BudgetCheckItemService budgetCheckItemService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_budgetCheckItem_";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    @AutoLog(value="\u9884\u7b97\u6821\u9a8c\u884c\u8868-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"budgetCheckItem#budgetCheckItem:list"})
    public Result<?> queryPageList(BudgetCheckItem budgetCheckItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)budgetCheckItem), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.budgetCheckItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u9884\u7b97\u6821\u9a8c\u884c\u8868-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"budgetCheckItem#budgetCheckItem:add"})
    @FormCommit
    public Result<?> add(@RequestBody BudgetCheckItem budgetCheckItem) {
        this.budgetCheckItemService.saveBudgetCheckItem(budgetCheckItem);
        return Result.ok((Object)((Object)budgetCheckItem));
    }

    @SrmValidated
    @AutoLog(value="\u9884\u7b97\u6821\u9a8c\u884c\u8868-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"budgetCheckItem#budgetCheckItem:edit"})
    public Result<?> edit(@RequestBody BudgetCheckItem budgetCheckItem) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, budgetCheckItem.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFiKRcsSTVBtk_2ef68e36", (String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.budgetCheckItemService.updateBudgetCheckItem(budgetCheckItem);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, budgetCheckItem.getId());
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9884\u7b97\u6821\u9a8c\u884c\u8868-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"budgetCheckItem#budgetCheckItem:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.budgetCheckItemService.delBudgetCheckItem(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9884\u7b97\u6821\u9a8c\u884c\u8868-\u901a\u8fc7id\u67e5\u8be2")
    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"budgetCheckItem#budgetCheckItem:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        BudgetCheckItem budgetCheckItem = (BudgetCheckItem)((Object)this.budgetCheckItemService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)budgetCheckItem));
    }
}

