/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.adapter;

import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseDeductCostAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    private void checkParams(PurchaseDeductCost deductCost) {
        Assert.hasText((String)deductCost.getPurchaseOrg(), (String)I18nUtil.translate((String)"i18n_alert_empty_selectOrg", (String)"\u8bf7\u586b\u5199\u91c7\u8d2d\u7ec4\u7ec7"));
        Assert.hasText((String)deductCost.getCompany(), (String)I18nUtil.translate((String)"i18n_alert_empty_selectCompany", (String)"\u8bf7\u586b\u5199\u516c\u53f8"));
        Assert.hasText((String)deductCost.getToElsAccount(), (String)I18nUtil.translate((String)"i18n_alert_empty_selectSupplier", (String)"\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546"));
        Assert.notNull((Object)deductCost.getDeductTime(), (String)I18nUtil.translate((String)"i18n_alert_VSMVVKI_9991677e", (String)"\u8bf7\u586b\u5199\u6263\u6b3e\u65f6\u95f4"));
        Assert.hasText((String)deductCost.getDeductType(), (String)I18nUtil.translate((String)"i18n_alert_VSMVVAc_9993e330", (String)"\u8bf7\u586b\u5199\u6263\u6b3e\u7c7b\u578b"));
        Assert.notNull((Object)deductCost.getTaxAmount(), (String)I18nUtil.translate((String)"i18n_alert_VSMxfHf_9357adb4", (String)"\u8bf7\u586b\u5199\u542b\u7a0e\u91d1\u989d"));
        Assert.hasText((String)deductCost.getCurrency(), (String)I18nUtil.translate((String)"i18n_alert_ViFls_f7546863", (String)"\u8bf7\u9009\u62e9\u5e01\u79cd"));
        Assert.hasText((String)deductCost.getTaxCode(), (String)I18nUtil.translate((String)"i18n_alert_ViFfo_f757cc2a", (String)"\u8bf7\u9009\u62e9\u7a0e\u7801"));
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseDeductCost head = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)id)));
        return SrmUtil.toJSONObject((Object)((Object)head));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseDeductCost purchaseDeductCost = new PurchaseDeductCost();
        purchaseDeductCost.setId(flowCallbackDTO.getBusinessId());
        purchaseDeductCost.setAuditStatus(auditStatus);
        purchaseDeductCost.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchaseDeductCostService.updateById((Object)purchaseDeductCost);
    }
}

