/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.finance.api.enumerate.AddCostConfirmStatusEnum;
import com.els.modules.finance.api.enumerate.AddCostSourceEnum;
import com.els.modules.finance.api.enumerate.AddCostStatusEnum;
import com.els.modules.finance.entity.SaleAddCost;
import com.els.modules.finance.entity.SaleAddCostItem;
import com.els.modules.finance.service.SaleAddCostItemService;
import com.els.modules.finance.service.SaleAddCostService;
import com.els.modules.finance.vo.SaleAddCostVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u9500\u552e\u9644\u52a0\u8d39\u7528\u7ba1\u7406")
@RestController
@RequestMapping(value={"/finance/saleAddCost"})
public class SaleAddCostController
extends BaseController<SaleAddCost, SaleAddCostService> {
    @Autowired
    private SaleAddCostService saleAddCostService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleAddCostItemService saleAddCostItemService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_saleAddCost_";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"finance#saleAddCost:list"})
    public Result<?> queryPageList(SaleAddCost saleAddCost, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleAddCost), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleAddCostService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"finance#saleAddCost:list"})
    public Result<?> queryTabsCount(SaleAddCost saleAddCost, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"confirm_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"confirm_status");
        List list = ((SaleAddCostService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleAddCost::getConfirmStatus, SaleAddCost::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "confirmStatus", null, (long)all.intValue()));
        List srmAddCostConfirmStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmAddCostConfirmStatus", TenantContext.getTenant());
        for (DictDTO status : srmAddCostConfirmStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "confirmStatus", status.getValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u9644\u52a0\u8d39\u7528\u7ba1\u7406-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"finance#saleAddCost:add"})
    @FormCommit
    public Result<?> add(@RequestBody SaleAddCostVO saleAddCostVO) {
        SaleAddCost saleAddCost = new SaleAddCost();
        BeanUtils.copyProperties((Object)((Object)saleAddCostVO), (Object)((Object)saleAddCost));
        LoginUserDTO sysUser = LoginUserContext.getUser();
        saleAddCost.setElsAccount(sysUser.getElsAccount());
        saleAddCost.setSupplierName(sysUser.getEnterpriseName());
        saleAddCost.setCostStatus(AddCostStatusEnum.NO_RECONCILIATION.getValue());
        saleAddCost.setSourceType(AddCostSourceEnum.SRM.getValue());
        saleAddCost.setConfirmStatus(AddCostConfirmStatusEnum.NEW.getValue());
        this.saleAddCostService.saveSaleAddCost(saleAddCost, saleAddCostVO.getAddCostItemList());
        return Result.ok((Object)((Object)saleAddCost));
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u9644\u52a0\u8d39\u7528\u7ba1\u7406-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"finance#saleAddCost:edit"})
    public Result<?> edit(@RequestBody SaleAddCostVO saleAddCostVO) {
        SaleAddCost saleAddCost = new SaleAddCost();
        BeanUtils.copyProperties((Object)((Object)saleAddCostVO), (Object)((Object)saleAddCost));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, saleAddCostVO.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APBuutiKRcsSTVBtk_cfa36eb7", (String)"\u5f53\u524d\u9644\u52a0\u8d39\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            LoginUserDTO sysUser = LoginUserContext.getUser();
            saleAddCost.setElsAccount(sysUser.getElsAccount());
            saleAddCost.setSupplierName(sysUser.getEnterpriseName());
            this.saleAddCostService.updateSaleAddCost(saleAddCost, saleAddCostVO.getAddCostItemList());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, saleAddCostVO.getId());
        }
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u9644\u52a0\u8d39\u7528-\u53d1\u9001\u9644\u52a0\u8d39\u7528\u5355\u636e")
    @Operation(summary="\u53d1\u9001\u9644\u52a0\u8d39\u7528\u5355\u636e", description="\u53d1\u9001\u9644\u52a0\u8d39\u7528\u5355\u636e")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"finance#saleAddCost:publish"})
    public Result<?> publish(@RequestBody SaleAddCostVO saleAddCostVO) {
        SaleAddCost saleAddCost = new SaleAddCost();
        BeanUtils.copyProperties((Object)((Object)saleAddCostVO), (Object)((Object)saleAddCost));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, saleAddCostVO.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APBuutiKRcsSTVBtk_cfa36eb7", (String)"\u5f53\u524d\u9644\u52a0\u8d39\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.saleAddCostService.sendAddCost(saleAddCost, saleAddCostVO.getAddCostItemList());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, saleAddCostVO.getId());
        }
        return Result.ok((Object)((Object)saleAddCost));
    }

    @AutoLog(value="\u9500\u552e\u9644\u52a0\u8d39\u7528\u7ba1\u7406-\u4f5c\u5e9f")
    @Operation(summary="\u4f5c\u5e9f", description="\u4f5c\u5e9f")
    @PostMapping(value={"/invalid"})
    @RequiresPermissions(value={"finance#saleAddCost:invalid"})
    public Result<?> invalid(@RequestBody SaleAddCost saleAddCost) {
        this.saleAddCostService.invalidSaleAddCost(saleAddCost);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u9644\u52a0\u8d39\u7528\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"finance#saleAddCost:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.saleAddCostService.delSaleAddCost(id);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"finance#saleAddCost:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SaleAddCost saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SaleAddCostVO saleAddCostVO = new SaleAddCostVO();
        BeanUtils.copyProperties((Object)((Object)saleAddCost), (Object)((Object)saleAddCostVO));
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        saleAddCostVO.setSaleAttachmentList(saleAttachmentList);
        List<SaleAddCostItem> saleAddCostItemList = this.saleAddCostItemService.selectByMainId(id);
        saleAddCostVO.setAddCostItemList(saleAddCostItemList);
        return Result.ok((Object)((Object)saleAddCostVO));
    }
}

