/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.finance.api.enumerate.DeductCostConfirmStatusEnum;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.entity.SaleDeductCostItem;
import com.els.modules.finance.service.SaleDeductCostItemService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.finance.vo.SaleDeductCostVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u9500\u552e\u6263\u6b3e\u8d39\u7528\u7ba1\u7406")
@RestController
@RequestMapping(value={"/finance/saleDeductCost"})
public class SaleDeductCostController
extends BaseController<SaleDeductCost, SaleDeductCostService> {
    @Autowired
    private SaleDeductCostService saleDeductCostService;
    @Autowired
    private SaleDeductCostItemService saleDeductCostItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_saleDeductCost_";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"deductCost#saleDeductCost:list"})
    public Result<?> queryPageList(SaleDeductCost saleDeductCost, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleDeductCost), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleDeductCostService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"deductCost#saleDeductCost:list"})
    public Result<?> queryTabCount(SaleDeductCost saleDeductCost, HttpServletRequest request) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"confirm_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"confirm_status");
        List list = ((SaleDeductCostService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleDeductCost::getConfirmStatus, SaleDeductCost::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "confirmStatus", null, (long)all.intValue()));
        List srmAddCostConfirmStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmDeductConfirmStatus", TenantContext.getTenant());
        for (DictDTO status : srmAddCostConfirmStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "confirmStatus", status.getValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u6263\u6b3e\u8d39\u7528\u7ba1\u7406-\u540c\u6b65\u91c7\u8d2d\u9644\u4ef6")
    @Operation(summary="\u7f16\u8f91", description="\u540c\u6b65\u91c7\u8d2d\u9644\u4ef6")
    @PostMapping(value={"/asyPurchaseAttachment"})
    @RequiresPermissions(value={"deductCost#saleDeductCost:asyPurchaseAttachment"})
    public Result<?> asyPurchaseAttachment(@RequestBody SaleDeductCostVO vo) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APVVtiKRcsSTVBtk_9d4f0b09", (String)"\u5f53\u524d\u6263\u6b3e\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.saleDeductCostService.asyPurchaseAttachment(vo, vo.getSaleAttachmentList());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return this.commonSuccessResult(3);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"deductCost#saleDeductCost:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SaleDeductCostVO saleDeductCostVO = new SaleDeductCostVO();
        BeanUtils.copyProperties((Object)((Object)saleDeductCost), (Object)((Object)saleDeductCostVO));
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        List<SaleDeductCostItem> saleDeductCostItemList = this.saleDeductCostItemService.selectByMainId(id);
        saleDeductCostVO.setSaleAttachmentList(saleAttachmentList);
        saleDeductCostVO.setDeductCostItemList(saleDeductCostItemList);
        return Result.ok((Object)((Object)saleDeductCostVO));
    }

    @AutoLog(value="\u9500\u552e\u6263\u6b3e\u8d39\u7528\u7ba1\u7406-\u901a\u8fc7id\u786e\u8ba4")
    @Operation(summary="\u901a\u8fc7id\u786e\u8ba4", description="\u901a\u8fc7id\u786e\u8ba4")
    @PostMapping(value={"/confirmById"})
    @RequiresPermissions(value={"deductCost#saleDeductCost:confirmById"})
    public Result<?> confirmById(@RequestBody SaleDeductCostVO vo) {
        SaleDeductCost saleDeductCost = new SaleDeductCost();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)saleDeductCost));
        saleDeductCost.setConfirmStatus(DeductCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APVVtiKRcsSTVBtk_9d4f0b09", (String)"\u5f53\u524d\u6263\u6b3e\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.saleDeductCostService.replyDeductCost(saleDeductCost, vo.getDeductCostItemList());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u6263\u6b3e\u8d39\u7528\u7ba1\u7406-\u901a\u8fc7id\u62d2\u7edd")
    @Operation(summary="\u901a\u8fc7id\u62d2\u7edd", description="\u901a\u8fc7id\u62d2\u7edd")
    @PostMapping(value={"/rejectById"})
    @RequiresPermissions(value={"deductCost#saleDeductCost:rejectById"})
    public Result<?> rejectById(@RequestBody SaleDeductCostVO vo) {
        SaleDeductCost saleDeductCost = new SaleDeductCost();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)saleDeductCost));
        saleDeductCost.setConfirmStatus(DeductCostConfirmStatusEnum.REJECTED.getValue());
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APVVtiKRcsSTVBtk_9d4f0b09", (String)"\u5f53\u524d\u6263\u6b3e\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.saleDeductCostService.replyDeductCost(saleDeductCost, vo.getDeductCostItemList());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return this.commonSuccessResult(3);
    }
}

