/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.finance.entity.SalePaymentApplyHead;
import com.els.modules.finance.entity.SalePaymentApplyItem;
import com.els.modules.finance.mapper.SalePaymentApplyHeadMapper;
import com.els.modules.finance.mapper.SalePaymentApplyItemMapper;
import com.els.modules.finance.service.SalePaymentApplyHeadService;
import com.els.modules.finance.service.SalePaymentApplyItemService;
import com.els.modules.finance.vo.SalePaymentApplyHeadVO;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsSourceCase;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsSourceCaseService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SalePaymentApplyHeadServiceImpl
extends ServiceImpl<SalePaymentApplyHeadMapper, SalePaymentApplyHead>
implements SalePaymentApplyHeadService {
    @Resource
    private SalePaymentApplyHeadMapper salePaymentApplyHeadMapper;
    @Resource
    private SalePaymentApplyItemMapper salePaymentApplyItemMapper;
    @Resource
    @Lazy
    private SalePaymentApplyItemService salePaymentApplyItemService;
    @Autowired
    private ElsPurchaseStatisticsSourceCaseService elsPurchaseStatisticsSourceCaseService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SalePaymentApplyHead salePaymentApplyHead, List<SalePaymentApplyItem> salePaymentApplyItemList) {
        this.salePaymentApplyHeadMapper.insert((Object)salePaymentApplyHead);
        this.insertData(salePaymentApplyHead, salePaymentApplyItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SalePaymentApplyHead salePaymentApplyHead, List<SalePaymentApplyItem> salePaymentApplyItemList) {
        this.salePaymentApplyHeadMapper.updateById((Object)salePaymentApplyHead);
        this.salePaymentApplyItemMapper.deleteByMainId(salePaymentApplyHead.getId());
        this.insertData(salePaymentApplyHead, salePaymentApplyItemList);
    }

    private void insertData(SalePaymentApplyHead salePaymentApplyHead, List<SalePaymentApplyItem> salePaymentApplyItemList) {
        for (SalePaymentApplyItem entity : salePaymentApplyItemList) {
            entity.setHeadId(salePaymentApplyHead.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)salePaymentApplyHead);
        }
        if (!salePaymentApplyItemList.isEmpty()) {
            this.salePaymentApplyItemService.saveBatch(salePaymentApplyItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.salePaymentApplyItemMapper.deleteByMainId(id);
        this.salePaymentApplyHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.salePaymentApplyItemMapper.deleteByMainId(serializable.toString());
            this.salePaymentApplyHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public Map<String, ElsPurchaseStatisticsSourceCase> getStatisticsSourceMap(List<SalePaymentApplyItem> salePaymentApplyItemList) {
        HashMap<String, ElsPurchaseStatisticsSourceCase> map = new HashMap<String, ElsPurchaseStatisticsSourceCase>();
        Set sourceIds = salePaymentApplyItemList.stream().map(SalePaymentApplyItem::getSourceId).collect(Collectors.toSet());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", sourceIds);
        List list = this.elsPurchaseStatisticsSourceCaseService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return map;
        }
        for (ElsPurchaseStatisticsSourceCase elsPurchaseStatisticsSourceCase : list) {
            map.put(elsPurchaseStatisticsSourceCase.getSourceId(), elsPurchaseStatisticsSourceCase);
        }
        return map;
    }

    @Override
    public JSONObject getDataById(String id) {
        SalePaymentApplyHead salePaymentApplyHead = (SalePaymentApplyHead)((Object)this.getById((Serializable)((Object)id)));
        SalePaymentApplyHeadVO headVO = (SalePaymentApplyHeadVO)((Object)BeanUtil.copyProperties((Object)((Object)salePaymentApplyHead), SalePaymentApplyHeadVO.class, (String[])new String[0]));
        return ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)headVO, new DictTranslateAspectParam());
    }
}

