/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.rebate.entity.PurchaseRebateRule;
import com.els.modules.rebate.entity.SaleRebateRule;
import com.els.modules.rebate.enumerate.RuleStatusEnum;
import com.els.modules.rebate.mapper.PurchaseRebateRuleMapper;
import com.els.modules.rebate.mapper.SaleRebateRuleMapper;
import com.els.modules.rebate.service.SaleRebateRuleService;
import com.els.modules.rebate.vo.SaleRebateRuleVO;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleRebateRuleServiceImpl
extends BaseServiceImpl<SaleRebateRuleMapper, SaleRebateRule>
implements SaleRebateRuleService {
    @Resource
    private PurchaseRebateRuleMapper purchaseRebateRuleMapper;

    @Override
    public void add(SaleRebateRule saleRebateRule) {
        ((SaleRebateRuleMapper)this.baseMapper).insert((Object)saleRebateRule);
    }

    @Override
    public void edit(SaleRebateRule saleRebateRule) {
        int count = ((SaleRebateRuleMapper)this.baseMapper).updateById((Object)saleRebateRule);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((SaleRebateRuleMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleRebateRuleMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmOrRefused(SaleRebateRule saleRebateRule, String operation) {
        if ("confirm".equals(operation)) {
            saleRebateRule.setRuleStatus(RuleStatusEnum.CONFIRMED.getValue());
        } else if ("refused".equals(operation)) {
            saleRebateRule.setRuleStatus(RuleStatusEnum.RENTURNED.getValue());
        }
        this.updateById((Object)saleRebateRule);
        PurchaseRebateRule purchaseRebateRule = (PurchaseRebateRule)((Object)this.purchaseRebateRuleMapper.selectById((Serializable)((Object)saleRebateRule.getRelationId())));
        if (purchaseRebateRule != null) {
            purchaseRebateRule.setRuleStatus(saleRebateRule.getRuleStatus());
            purchaseRebateRule.setRejectReason(saleRebateRule.getRejectReason());
            this.purchaseRebateRuleMapper.updateById((Object)purchaseRebateRule);
        }
        this.sendMessage(saleRebateRule, purchaseRebateRule, operation);
    }

    @Override
    public void emailConfirmOrRefuesd(String id, String operation) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(ParentEntity::getId, (Object)id);
        SaleRebateRule saleRebateRule = (SaleRebateRule)((Object)this.getOne((Wrapper)lambdaQueryWrapper));
        if (saleRebateRule != null) {
            this.confirmOrRefused(saleRebateRule, operation);
        }
    }

    @Override
    public JSONObject getDataById(String id) {
        SaleRebateRule saleRebateRule = (SaleRebateRule)((Object)this.getById((Serializable)((Object)id)));
        SaleRebateRuleVO headVO = (SaleRebateRuleVO)((Object)BeanUtil.copyProperties((Object)((Object)saleRebateRule), SaleRebateRuleVO.class, (String[])new String[0]));
        return ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)headVO, new DictTranslateAspectParam());
    }

    private void sendMessage(SaleRebateRule saleRebateRule, PurchaseRebateRule purchaseRebateRule, String operation) {
        super.sendMessage(saleRebateRule.getBusAccount(), "saleRebateRule", operation, saleRebateRule.getId(), "rebateRuleBusDataServiceImpl", Arrays.asList(saleRebateRule.getToElsAccount()));
    }
}

