/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.api.dto.PurchaseMaterialCodeDTO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.rebate.rpc.PurchaseMaterialCodeLocalRpcService;
import com.els.modules.rebate.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.reconciliation.entity.PurchaseFinanceTaxCode;
import com.els.modules.reconciliation.mapper.PurchaseFinanceTaxCodeMapper;
import com.els.modules.reconciliation.service.PurchaseFinanceTaxCodeService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseFinanceTaxCodeServiceImpl
extends BaseServiceImpl<PurchaseFinanceTaxCodeMapper, PurchaseFinanceTaxCode>
implements PurchaseFinanceTaxCodeService {
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    @Resource
    private PurchaseMaterialCodeLocalRpcService purchaseMaterialCodeLocalRpcService;

    @Override
    public void add(PurchaseFinanceTaxCode purchaseFinanceTaxCode) {
        ((PurchaseFinanceTaxCodeMapper)this.baseMapper).insert((Object)purchaseFinanceTaxCode);
    }

    @Override
    public void edit(PurchaseFinanceTaxCode purchaseFinanceTaxCode) {
        int count = ((PurchaseFinanceTaxCodeMapper)this.baseMapper).updateById((Object)purchaseFinanceTaxCode);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PurchaseFinanceTaxCodeMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseFinanceTaxCodeMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void savePurchaseFinanceTaxCodeBatch(List<PurchaseFinanceTaxCode> entityList) {
        for (PurchaseFinanceTaxCode taxCode : entityList) {
            taxCode.setElsAccount(TenantContext.getTenant());
            taxCode.setCreateBy(SysUtil.getLoginUser().getSubAccount());
            taxCode.setCreateTime(new Date());
            taxCode.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
            taxCode.setUpdateTime(new Date());
            taxCode.setDeleted(CommonConstant.DEL_FLAG_0);
        }
        this.saveBatch(entityList);
    }

    @Override
    public List<PurchaseFinanceTaxCode> listTaxCodeBySale(Set<String> purchaseMaterialCodeSet, String busAccount) {
        if (CollectionUtils.isEmpty(purchaseMaterialCodeSet)) {
            return new ArrayList<PurchaseFinanceTaxCode>();
        }
        return ((PurchaseFinanceTaxCodeMapper)this.baseMapper).listTaxCodeBySale(purchaseMaterialCodeSet, busAccount);
    }

    @Override
    public List<PurchaseFinanceTaxCode> listFeeBySale(Set<String> goodsAndServicesNames, String busAccount, String category) {
        if (CollectionUtils.isEmpty(goodsAndServicesNames)) {
            return new ArrayList<PurchaseFinanceTaxCode>();
        }
        return ((PurchaseFinanceTaxCodeMapper)this.baseMapper).listFeeBySale(goodsAndServicesNames, busAccount, category);
    }

    @Override
    public Map<String, String> handleTaxCategoryCode(Map<String, PurchaseMaterialHeadDTO> materialHeadMap, List<String> materialNumbers, String busAccount) {
        List<PurchaseFinanceTaxCode> purchaseFinanceTaxCodeList;
        List<PurchaseMaterialCodeDTO> purchaseMaterialCodeList;
        HashMap<String, String> numberToCategoryCodeMap = new HashMap<String, String>();
        HashMap<String, String> numberToCodeMap = new HashMap<String, String>();
        HashMap<String, String> codeToCategoryCodeMap = new HashMap<String, String>();
        List<PurchaseMaterialHeadDTO> materialHeadList = this.purchaseMaterialHeadLocalRpcService.listByNumbersBySale(materialNumbers, busAccount);
        HashSet<String> cateCodeSet = new HashSet<String>();
        if (!CollectionUtils.isEmpty(materialHeadList)) {
            for (PurchaseMaterialHeadDTO dto : materialHeadList) {
                materialHeadMap.put(dto.getMaterialNumber(), dto);
                if (StrUtil.isBlank((CharSequence)dto.getCateCode())) continue;
                cateCodeSet.add(dto.getCateCode());
                numberToCodeMap.put(dto.getMaterialNumber(), dto.getCateCode());
            }
        }
        HashSet<String> purchaseMaterialCodeSet = new HashSet<String>();
        if (!CollectionUtils.isEmpty(cateCodeSet) && !CollectionUtils.isEmpty(purchaseMaterialCodeList = this.purchaseMaterialCodeLocalRpcService.listMaterialCodeBySale(new ArrayList<String>(cateCodeSet), busAccount))) {
            for (PurchaseMaterialCodeDTO purchaseMaterialCodeDTO : purchaseMaterialCodeList) {
                purchaseMaterialCodeSet.add(purchaseMaterialCodeDTO.getCateCode());
            }
        }
        if (!CollectionUtils.isEmpty(purchaseFinanceTaxCodeList = this.listTaxCodeBySale(purchaseMaterialCodeSet, busAccount))) {
            for (PurchaseFinanceTaxCode purchaseFinanceTaxCode : purchaseFinanceTaxCodeList) {
                codeToCategoryCodeMap.put(purchaseFinanceTaxCode.getCateCode(), purchaseFinanceTaxCode.getTaxCategoryCode());
            }
        }
        for (Map.Entry entry : numberToCodeMap.entrySet()) {
            String taxCode = (String)codeToCategoryCodeMap.get(entry.getValue());
            numberToCategoryCodeMap.put((String)entry.getKey(), taxCode);
        }
        return numberToCategoryCodeMap;
    }
}

