/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.utils;

import com.els.modules.reconciliation.enumerate.NatureCycleEnum;
import com.els.modules.reconciliation.utils.WeekUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class NatureCycleDateUtils {
    public static Map<String, Date> getBeginDateWithEndDate(String natureCycle, int beginCycle, int endCycle) {
        HashMap<String, Date> map = new HashMap<String, Date>();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT+8"));
        if (natureCycle.equals(NatureCycleEnum.WEEKLY.getValue())) {
            return map;
        }
        if (natureCycle.equals(NatureCycleEnum.MONTHLY.getValue())) {
            calendar.add(2, -1);
            int beforeActualMaxDay = calendar.getActualMaximum(5);
            calendar.set(5, beginCycle);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            map.put("beginDate", calendar.getTime());
            if (beforeActualMaxDay <= endCycle) {
                calendar.set(5, beforeActualMaxDay);
            } else {
                calendar.set(5, endCycle);
            }
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            map.put("endDate", calendar.getTime());
        } else if (natureCycle.equals(NatureCycleEnum.QUARTERLY.getValue())) {
            Date currentQuarterStartTime = NatureCycleDateUtils.getLastQuarterStartTime(calendar);
            Date currentQuarterEndTime = NatureCycleDateUtils.getLastQuarterEndTime(calendar);
            map.put("beginDate", currentQuarterStartTime);
            map.put("endDate", currentQuarterEndTime);
        } else {
            Date currentFirstOfYear = NatureCycleDateUtils.getFirstDayOfPreviousYear(calendar);
            Date currentLastOfYear = NatureCycleDateUtils.getLastDayOfPreviousYear(calendar);
            map.put("beginDate", currentFirstOfYear);
            map.put("endDate", currentLastOfYear);
        }
        return map;
    }

    public static List<Map<String, Date>> getEachWeekDateOfCurrYear(String natureCycle, int beginCycle, int endCycle) {
        ArrayList<Map<String, Date>> dateList = new ArrayList<Map<String, Date>>();
        if (!natureCycle.equals(NatureCycleEnum.WEEKLY.getValue())) {
            return dateList;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT+8"));
        int currYear = calendar.get(1);
        int currWeekNum = WeekUtils.getWeekOfYear(calendar.getTime());
        for (int i = 0; i < currWeekNum; ++i) {
            HashMap<String, Date> map = new HashMap<String, Date>();
            Date firstDayOfWeek = WeekUtils.getFirstDayOfWeek(currYear, i + 1);
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(firstDayOfWeek);
            int day = beginCycle - 1;
            ((Calendar)cal).add(5, day);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            System.out.println("day" + cal.getTime());
            map.put("beginDate", cal.getTime());
            int nextDay = endCycle - day - 1;
            ((Calendar)cal).add(5, nextDay);
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            map.put("endDate", cal.getTime());
            dateList.add(map);
        }
        return dateList;
    }

    private static Date getLastDayOfPreviousYear(Calendar calendar) {
        int currentYear = calendar.get(1);
        calendar.clear();
        calendar.set(1, currentYear);
        calendar.roll(6, -1);
        return calendar.getTime();
    }

    private static Date getFirstDayOfPreviousYear(Calendar calendar) {
        calendar.add(1, -1);
        int lastYear = calendar.get(1);
        calendar.clear();
        calendar.set(1, lastYear);
        return calendar.getTime();
    }

    private static Date getLastQuarterEndTime(Calendar calendar) {
        calendar.setTime(NatureCycleDateUtils.getLastQuarterStartTime(calendar));
        calendar.add(2, 2);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    private static Date getLastQuarterStartTime(Calendar calendar) {
        int currentMonth = calendar.get(2) + 1;
        Date lastSeason = null;
        try {
            if (currentMonth <= 3) {
                calendar.set(2, 0);
            } else if (currentMonth <= 6) {
                calendar.set(2, 3);
            } else if (currentMonth <= 9) {
                calendar.set(2, 6);
            } else if (currentMonth <= 12) {
                calendar.set(2, 9);
            }
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(2, -3);
            lastSeason = calendar.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lastSeason;
    }
}

