/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.budget.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.budget.entity.BudgetManage;
import com.els.modules.budget.mapper.BudgetManageMapper;
import com.els.modules.budget.service.BudgetManageService;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="budgetManageAuditDubboAdapter")
public class BudgetManageAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Autowired
    private BudgetManageMapper budgetManageMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private BudgetManageService budgetManageService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        BudgetManage head = (BudgetManage)((Object)this.budgetManageService.getById((Serializable)((Object)id)));
        if (head != null) {
            return SrmUtil.toJSONObject((Object)((Object)head));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        BudgetManage head = new BudgetManage();
        head.setId(flowCallbackDTO.getBusinessId());
        head.setAuditStatus(auditStatus);
        this.budgetManageMapper.updateById((Object)head);
    }
}

