/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.adapter;

import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SrmUtil;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheet;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetCalculateDetail;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetCertificate;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRegister;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleDetail;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleSupplement;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleThreshold;
import com.els.modules.rebate.enumerate.CalculationRebateCalculateResultEnum;
import com.els.modules.rebate.mapper.PurchaseRebateCalculationSheetMapper;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetCalculateDetailService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetCertificateService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRegisterService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRuleDetailService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRuleSupplementService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRuleThresholdService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetService;
import com.els.modules.rebate.vo.PurchaseRebateCalculationSheetVO;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseRebateCalculationSheetAuditDubboAdapter")
public class PurchaseRebateCalculationSheetAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Resource
    private PurchaseRebateCalculationSheetMapper purchaseRebateCalculationSheetMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private PurchaseRebateCalculationSheetService purchaseRebateCalculationSheetService;
    @Autowired
    private PurchaseRebateCalculationSheetCalculateDetailService purchaseRebateCalculationSheetCalculateDetailService;
    @Autowired
    private PurchaseRebateCalculationSheetCertificateService purchaseRebateCalculationSheetCertificateService;
    @Autowired
    private PurchaseRebateCalculationSheetRegisterService purchaseRebateCalculationSheetRegisterService;
    @Autowired
    private PurchaseRebateCalculationSheetRuleDetailService purchaseRebateCalculationSheetRuleDetailService;
    @Autowired
    private PurchaseRebateCalculationSheetRuleThresholdService purchaseRebateCalculationSheetRuleThresholdService;
    @Autowired
    private PurchaseRebateCalculationSheetRuleSupplementService purchaseRebateCalculationSheetRuleSupplementService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
        PurchaseRebateCalculationSheetVO vo = (PurchaseRebateCalculationSheetVO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString(this.getById(flowCallbackDTO.getBusinessId())), PurchaseRebateCalculationSheetVO.class));
        PurchaseRebateCalculationSheet sheet = new PurchaseRebateCalculationSheet();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)sheet));
        String calculateResult = sheet.getCalculateResult();
        if (!CalculationRebateCalculateResultEnum.CALCULATED_SUCCESS.getValue().equals(calculateResult)) {
            throw new ELSBootException("\u8fd4\u5229\u5355\u8ba1\u7b97\u6210\u529f\u624d\u53ef\u63d0\u5ba1");
        }
        BigDecimal rebateAmount = sheet.getRebateAmount();
        BigDecimal rebateQuantity = sheet.getRebateQuantity();
        if (!(rebateAmount != null && BigDecimal.ZERO.compareTo(rebateAmount) != 0 || rebateQuantity != null && BigDecimal.ZERO.compareTo(rebateQuantity) != 0)) {
            throw new ELSBootException("\u8fd4\u5229\u91d1\u989d/\u8fd4\u5229\u6570\u91cf=0\uff0c\u4e0d\u5141\u8bb8\u63d0\u5ba1\u8fd4\u5229\u8ba1\u7b97\u5355");
        }
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        PurchaseRebateCalculationSheetVO vo = new PurchaseRebateCalculationSheetVO();
        String id = flowCallbackDTO.getBusinessId();
        PurchaseRebateCalculationSheet purchaseRebateCalculationSheet = (PurchaseRebateCalculationSheet)((Object)this.purchaseRebateCalculationSheetService.getById((Serializable)((Object)id)));
        List<PurchaseRebateCalculationSheetCalculateDetail> calculateDetails = this.purchaseRebateCalculationSheetCalculateDetailService.selectByMainId(id);
        List<PurchaseRebateCalculationSheetCertificate> certificates = this.purchaseRebateCalculationSheetCertificateService.selectByMainId(id);
        List<PurchaseRebateCalculationSheetRegister> registers = this.purchaseRebateCalculationSheetRegisterService.selectByMainId(id);
        List<PurchaseRebateCalculationSheetRuleDetail> ruleDetails = this.purchaseRebateCalculationSheetRuleDetailService.selectByMainId(id);
        List<PurchaseRebateCalculationSheetRuleThreshold> thresholdList = this.purchaseRebateCalculationSheetRuleThresholdService.selectByMainId(id);
        List<PurchaseRebateCalculationSheetRuleSupplement> supplementList = this.purchaseRebateCalculationSheetRuleSupplementService.selectByMainId(id);
        vo.setRebateCalculationSheetCalculateDetails(calculateDetails);
        vo.setRebateCalculationSheetCertificates(certificates);
        vo.setRebateCalculationSheetRegisters(registers);
        vo.setRebateCalculationSheetRuleDetails(ruleDetails);
        vo.setRebateCalculationSheetRuleThresholds(thresholdList);
        vo.setRebateCalculationSheetRuleSupplements(supplementList);
        BeanUtils.copyProperties((Object)((Object)purchaseRebateCalculationSheet), (Object)((Object)vo));
        this.purchaseRebateCalculationSheetService.publish(purchaseRebateCalculationSheet, vo);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseRebateCalculationSheet head = (PurchaseRebateCalculationSheet)((Object)this.purchaseRebateCalculationSheetMapper.selectById((Serializable)((Object)id)));
        if (head != null) {
            return SrmUtil.toJSONObject((Object)((Object)head));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseRebateCalculationSheet head = new PurchaseRebateCalculationSheet();
        head.setId(flowCallbackDTO.getBusinessId());
        head.setAuditStatus(auditStatus);
        head.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchaseRebateCalculationSheetMapper.updateById((Object)head);
    }
}

