/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.job;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.confirm.rpc.InvokeDictInfoRpcService;
import com.els.modules.finance.api.dto.ElsFinanceReconciliationConfigDTO;
import com.els.modules.rebate.rpc.SupplierLocalRpcService;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchaseRecContractAcceptance;
import com.els.modules.reconciliation.entity.PurchaseRecContractPromise;
import com.els.modules.reconciliation.rpc.ElsReconciliationConfigRpcService;
import com.els.modules.reconciliation.service.PurchasePerformanceReconciliationService;
import com.els.modules.reconciliation.utils.NatureCycleDateUtils;
import com.els.modules.reconciliation.vo.PurchasePerformanceReconciliationVO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@RpcService(value="batchCreatePerformanceReconciliationJobRpcServiceImpl")
public class BatchCreatePerformanceReconciliationJob
implements JobRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchCreatePerformanceReconciliationJob.class);
    private final String LOCK_PREFIX = "schedule_BatchCreatePerformanceReconciliationJob";
    private final long EXPIRE_TIME = 50000L;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PurchasePerformanceReconciliationService purchasePerformanceReconciliationService;
    @Autowired
    private ElsReconciliationConfigRpcService reconciliationConfigRpcService;
    @Resource
    private TemplateRpcService templateRpcService;
    @Resource
    private SupplierLocalRpcService supplierLocalRpcService;
    @Resource
    private InvokeDictInfoRpcService invokeDictInfoRpcService;

    public void execute(String parameter) {
        String elsAccount;
        JSONObject object = JSONObject.parseObject((String)parameter);
        String string = elsAccount = StrUtil.isBlank((CharSequence)object.getString("elsAccount")) ? "100000" : object.getString("elsAccount");
        if (!this.redisUtil.tryGetDistributedLock("schedule_BatchCreatePerformanceReconciliationJob", elsAccount, 50000L)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_zRcIIZIetLSiKRcVxPVBRc_5e24526", (String)"\u6279\u91cf\u521b\u5efa\u5c65\u7ea6\u5bf9\u8d26\u5355\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        try {
            TenantContext.setTenant((String)elsAccount);
            log.info(":::BatchCreatePerformanceReconciliationJob start");
            ElsFinanceReconciliationConfigDTO reconciliationConfig = this.reconciliationConfigRpcService.getDefaultReconciliationConfig(elsAccount, "performanceReconciliation");
            Assert.isNotNull((Object)reconciliationConfig, (String)I18nUtil.translate((String)"i18n_field_ERLVVWERbLiN_89125164", (String)"\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u914d\u7f6e\u751f\u6210\u7b56\u7565\uff01"));
            log.info("BatchCreatePerformanceReconciliationJob getReconciliationConfig: {} ", (Object)JSON.toJSONString((Object)reconciliationConfig));
            ArrayList<PurchasePerformanceReconciliationVO> performanceReconciliationVOS = new ArrayList<PurchasePerformanceReconciliationVO>();
            this.fillPerformanceConfigData(performanceReconciliationVOS, reconciliationConfig, elsAccount);
            this.fillPerformanceTemplateData(performanceReconciliationVOS, reconciliationConfig);
            log.info("BatchCreatePerformanceReconciliationJob data: {} ", (Object)JSON.toJSONString(performanceReconciliationVOS));
            for (PurchasePerformanceReconciliationVO vo : performanceReconciliationVOS) {
                this.createPurchasePerformanceReconciliation(vo);
            }
            log.info(":::BatchCreatePerformanceReconciliationJob end");
        }
        catch (Exception e) {
            log.error(Thread.currentThread().getName() + "\u6279\u91cf\u521b\u5efa\u5c65\u7ea6\u5bf9\u8d26\u5355\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock("schedule_BatchCreatePerformanceReconciliationJob", elsAccount);
        }
    }

    private void fillPerformanceTemplateData(List<PurchasePerformanceReconciliationVO> performanceReconciliationVOS, ElsFinanceReconciliationConfigDTO reconciliationConfig) {
        TemplateHeadDTO templateHeadDTO = this.templateRpcService.getById(reconciliationConfig.getRelatedTemplateId());
        if (templateHeadDTO == null) {
            List templateHeadDTOS = this.templateRpcService.getDefaultTemplateByType("performanceReconciliation");
            if (CollUtil.isEmpty((Collection)templateHeadDTOS)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_LERCLESIrVKHRvj_ca9be39a", (String)"\u672a\u914d\u7f6e\u9ed8\u8ba4\u4e1a\u52a1\u6a21\u677f\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
            }
            templateHeadDTO = (TemplateHeadDTO)templateHeadDTOS.get(0);
        }
        for (PurchasePerformanceReconciliationVO vo : performanceReconciliationVOS) {
            vo.setTemplateAccount(templateHeadDTO.getElsAccount());
            vo.setTemplateNumber(templateHeadDTO.getTemplateNumber());
            vo.setTemplateName(templateHeadDTO.getTemplateName());
            vo.setTemplateVersion(String.valueOf(templateHeadDTO.getTemplateVersion()));
        }
    }

    private void fillPerformanceConfigData(List<PurchasePerformanceReconciliationVO> performanceReconciliationVOS, ElsFinanceReconciliationConfigDTO reconciliationConfig, String elsAccount) {
        String natureCycle = reconciliationConfig.getNatureCycle();
        int beginCycle = Integer.parseInt(reconciliationConfig.getBeginCycle());
        int endCycle = Integer.parseInt(reconciliationConfig.getEndCycle());
        Map<String, Date> beginDateWithEndDate = NatureCycleDateUtils.getBeginDateWithEndDate(natureCycle, beginCycle, endCycle);
        List<Map<String, Date>> eachWeekDateOfCurrYear = NatureCycleDateUtils.getEachWeekDateOfCurrYear(natureCycle, beginCycle, endCycle);
        List<String> accountGroupList = Arrays.asList(reconciliationConfig.getAccountGroup().split(","));
        List<SupplierMasterDataDTO> supplierMasterDataDTOList = this.supplierLocalRpcService.getSupplierMasterDataByAccountGroup(elsAccount, accountGroupList);
        Assert.isNotEmpty(supplierMasterDataDTOList, (String)I18nUtil.translate((String)"i18n_field_xMKBnRdXeDVjRdX_730ad793", (String)"\u4e0d\u5b58\u5728\u7b26\u5408\u4f9b\u5e94\u5546\u8d26\u6237\u7ec4\u7684\u4f9b\u5e94\u5546\uff01"));
        List<DictDTO> companyCodeList = this.invokeDictInfoRpcService.queryDictItemsByCode("purchase_organization_info#org_name#org_code#org_category_code='companyCode' && status='1'", elsAccount);
        if (CollectionUtils.isEmpty(eachWeekDateOfCurrYear)) {
            for (SupplierMasterDataDTO dto : supplierMasterDataDTOList) {
                for (DictDTO companyDTO : companyCodeList) {
                    this.setObjSameProperty(performanceReconciliationVOS, beginDateWithEndDate, elsAccount, dto, companyDTO);
                }
            }
        } else {
            for (SupplierMasterDataDTO dto : supplierMasterDataDTOList) {
                for (DictDTO companyDTO : companyCodeList) {
                    for (Map<String, Date> map : eachWeekDateOfCurrYear) {
                        this.setObjSameProperty(performanceReconciliationVOS, map, elsAccount, dto, companyDTO);
                    }
                }
            }
        }
    }

    private void setObjSameProperty(List<PurchasePerformanceReconciliationVO> performanceReconciliationVOS, Map<String, Date> beginDateWithEndDate, String elsAccount, SupplierMasterDataDTO dto, DictDTO companyDTO) {
        PurchasePerformanceReconciliationVO performanceReconciliationVO = new PurchasePerformanceReconciliationVO();
        performanceReconciliationVO.setElsAccount(elsAccount);
        performanceReconciliationVO.setToElsAccount(dto.getToElsAccount());
        performanceReconciliationVO.setSupplierCode(dto.getToElsAccount());
        performanceReconciliationVO.setSupplierName(dto.getSupplierName());
        performanceReconciliationVO.setBeginDate(beginDateWithEndDate.get("beginDate"));
        performanceReconciliationVO.setEndDate(beginDateWithEndDate.get("endDate"));
        performanceReconciliationVO.setCompany(companyDTO.getValue());
        performanceReconciliationVO.setCurrency(dto.getLocalCurrency());
        performanceReconciliationVOS.add(performanceReconciliationVO);
    }

    private void createPurchasePerformanceReconciliation(PurchasePerformanceReconciliationVO vo) {
        boolean flag;
        log.info("BatchCreatePerformanceReconciliationJob \u63d0\u53d6\u5355\u636e: {} ", (Object)JSON.toJSONString((Object)((Object)vo)));
        PurchasePerformanceReconciliationVO extractReconciliation = this.purchasePerformanceReconciliationService.extractReconciliation(vo);
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = extractReconciliation.getRecContractPromiseList();
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = extractReconciliation.getRecContractAcceptanceList();
        boolean bl = flag = CollectionUtils.isEmpty(purchaseRecContractPromiseList) && CollectionUtils.isEmpty(purchaseRecContractAcceptanceList);
        if (flag) {
            return;
        }
        PurchasePerformanceReconciliation purchaseReconciliation = new PurchasePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)extractReconciliation), (Object)((Object)purchaseReconciliation));
        try {
            log.info("BatchCreatePerformanceReconciliationJob \u521b\u5efa\u5c65\u7ea6\u5bf9\u8d26: {} ", (Object)JSON.toJSONString((Object)((Object)vo)));
            this.purchasePerformanceReconciliationService.saveMain(purchaseReconciliation, extractReconciliation);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5c65\u7ea6\u5bf9\u8d26\u5931\u8d25: {} ", (Object)e.getMessage());
        }
    }
}

