/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.reconciliation.entity.PurchaseInvoiceHookInformation;
import com.els.modules.reconciliation.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.PurchaseRecAcceptReturn;
import com.els.modules.reconciliation.entity.PurchaseRecAdditionalCharges;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.entity.PurchaseRecContractAcceptance;
import com.els.modules.reconciliation.entity.PurchaseRecContractPromise;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceHookInformationMapper;
import com.els.modules.reconciliation.service.PurchaseInvoiceHookInformationService;
import com.els.modules.reconciliation.vo.PurchaseInvoiceHookVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseInvoiceHookInformationServiceImpl
extends BaseServiceImpl<PurchaseInvoiceHookInformationMapper, PurchaseInvoiceHookInformation>
implements PurchaseInvoiceHookInformationService {
    @Override
    public void savePurchaseInvoiceHookInformation(PurchaseInvoiceHookInformation purchaseInvoiceHookInformation) {
        ((PurchaseInvoiceHookInformationMapper)this.baseMapper).insert((Object)purchaseInvoiceHookInformation);
    }

    @Override
    public void updatePurchaseInvoiceHookInformation(PurchaseInvoiceHookInformation purchaseInvoiceHookInformation) {
        ((PurchaseInvoiceHookInformationMapper)this.baseMapper).updateById((Object)purchaseInvoiceHookInformation);
    }

    @Override
    public void delPurchaseInvoiceHookInformation(String id) {
        ((PurchaseInvoiceHookInformationMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseInvoiceHookInformation(List<String> idList) {
        ((PurchaseInvoiceHookInformationMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<PurchaseInvoiceHookInformation> queryInvoiceHookList(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StrUtil.isBlank((CharSequence)id)) {
            return new ArrayList<PurchaseInvoiceHookInformation>();
        }
        queryWrapper.eq((Object)"invoice_id", (Object)id);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void deleteByInvoiceId(String id) {
        ((PurchaseInvoiceHookInformationMapper)this.baseMapper).deleteByInvoiceId(id);
    }

    @Override
    public void hook(PurchaseInvoiceHookVO invoiceHockVO) {
        ArrayList<PurchaseInvoiceHookInformation> list = new ArrayList<PurchaseInvoiceHookInformation>();
        if (!StrUtil.isBlank((CharSequence)invoiceHockVO.getId())) {
            this.deleteByInvoiceId(invoiceHockVO.getId());
        }
        this.hookPurchaseRecAcceptReturn(invoiceHockVO, list);
        this.hookPurchaseRecAdditionalCharges(invoiceHockVO, list);
        this.hookPurchaseRecCharge(invoiceHockVO, list);
        this.hookPurchasePrePaymentWriteOff(invoiceHockVO, list);
        this.hookPurchaseRecContractPromise(invoiceHockVO, list);
        this.hookPurchaseRecContractAcceptance(invoiceHockVO, list);
        this.saveBatch(list);
    }

    @Override
    public void handleBusinessList(PurchaseInvoiceHookVO vo, String reconciliationNumber) {
        PurchaseInvoiceHookInformation purchaseInvoiceHookInformation;
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(PurchaseInvoiceHookInformation::getReconciliationNumber, (Object)reconciliationNumber);
        List list = this.list((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        Map<String, PurchaseInvoiceHookInformation> map = list.stream().filter(hook -> !StrUtil.isBlank((CharSequence)hook.getSourceId())).collect(Collectors.toMap(PurchaseInvoiceHookInformation::getSourceId, hook -> hook));
        if (!CollectionUtils.isEmpty(vo.getPrePaymentWriteOffList())) {
            for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : vo.getPrePaymentWriteOffList()) {
                if (StrUtil.isBlank((CharSequence)prePaymentWriteOff.getId()) || (purchaseInvoiceHookInformation = map.get(prePaymentWriteOff.getId())) == null) continue;
                prePaymentWriteOff.setIsCheck(true);
            }
        }
        if (!CollectionUtils.isEmpty(vo.getRecChargeList())) {
            for (PurchaseRecCharge purchaseRecCharge : vo.getRecChargeList()) {
                if (StrUtil.isBlank((CharSequence)purchaseRecCharge.getId()) || (purchaseInvoiceHookInformation = map.get(purchaseRecCharge.getId())) == null) continue;
                purchaseRecCharge.setIsCheck(true);
            }
        }
        if (!CollectionUtils.isEmpty(vo.getRecContractAcceptanceList())) {
            for (PurchaseRecContractAcceptance purchaseRecContractAcceptance : vo.getRecContractAcceptanceList()) {
                if (StrUtil.isBlank((CharSequence)purchaseRecContractAcceptance.getId()) || (purchaseInvoiceHookInformation = map.get(purchaseRecContractAcceptance.getId())) == null) continue;
                purchaseRecContractAcceptance.setIsCheck(true);
            }
        }
        if (!CollectionUtils.isEmpty(vo.getRecContractPromiseList())) {
            for (PurchaseRecContractPromise purchaseRecContractPromise : vo.getRecContractPromiseList()) {
                if (StrUtil.isBlank((CharSequence)purchaseRecContractPromise.getId()) || (purchaseInvoiceHookInformation = map.get(purchaseRecContractPromise.getId())) == null) continue;
                purchaseRecContractPromise.setIsCheck(true);
            }
        }
        if (!CollectionUtils.isEmpty(vo.getRecAdditionalChargesList())) {
            for (PurchaseRecAdditionalCharges additionalCharges : vo.getRecAdditionalChargesList()) {
                if (StrUtil.isBlank((CharSequence)additionalCharges.getId()) || (purchaseInvoiceHookInformation = map.get(additionalCharges.getId())) == null) continue;
                additionalCharges.setIsCheck(true);
            }
        }
        if (!CollectionUtils.isEmpty(vo.getRecAcceptReturnList())) {
            for (PurchaseRecAcceptReturn purchaseRecAcceptReturn : vo.getRecAcceptReturnList()) {
                if (StrUtil.isBlank((CharSequence)purchaseRecAcceptReturn.getId()) || (purchaseInvoiceHookInformation = map.get(purchaseRecAcceptReturn.getId())) == null) continue;
                purchaseRecAcceptReturn.setIsCheck(true);
            }
        }
    }

    private void hookPurchaseRecContractAcceptance(PurchaseInvoiceHookVO invoiceHockVO, List<PurchaseInvoiceHookInformation> list) {
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = invoiceHockVO.getRecContractAcceptanceList();
        if (CollectionUtil.isEmpty(purchaseRecContractAcceptanceList)) {
            return;
        }
        for (PurchaseRecContractAcceptance contractAcceptance : purchaseRecContractAcceptanceList) {
            PurchaseInvoiceHookInformation hook = new PurchaseInvoiceHookInformation();
            BeanUtils.copyProperties((Object)((Object)invoiceHockVO), (Object)((Object)hook));
            hook.setId(null);
            hook.setSourceId(contractAcceptance.getId());
            hook.setInvoiceId(invoiceHockVO.getId());
            hook.setCheckTheDocumentCategory(ReconcilationItemTypeEmun.CONTRACT_ACCEPTANCE.getValue());
            hook.setCheckTheDocumentNumber(contractAcceptance.getAcceptanceNumbers());
            hook.setItemNumber(contractAcceptance.getItemNumber());
            BigDecimal taxAmount = contractAcceptance.getTaxAmount() == null ? BigDecimal.ZERO : contractAcceptance.getTaxAmount();
            BigDecimal netAmount = contractAcceptance.getNetAmount() == null ? BigDecimal.ZERO : contractAcceptance.getNetAmount();
            hook.setDocumentTaxAmount(taxAmount);
            hook.setDocumentNetAmount(netAmount);
            hook.setDocumentTax(taxAmount.subtract(netAmount));
            list.add(hook);
        }
    }

    private void hookPurchaseRecContractPromise(PurchaseInvoiceHookVO invoiceHockVO, List<PurchaseInvoiceHookInformation> list) {
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = invoiceHockVO.getRecContractPromiseList();
        if (CollectionUtil.isEmpty(purchaseRecContractPromiseList)) {
            return;
        }
        for (PurchaseRecContractPromise contractPromise : purchaseRecContractPromiseList) {
            PurchaseInvoiceHookInformation hook = new PurchaseInvoiceHookInformation();
            BeanUtils.copyProperties((Object)((Object)invoiceHockVO), (Object)((Object)hook));
            hook.setId(null);
            hook.setSourceId(contractPromise.getId());
            hook.setInvoiceId(invoiceHockVO.getId());
            hook.setCheckTheDocumentCategory(ReconcilationItemTypeEmun.CONTRACT_PROMISE.getValue());
            hook.setCheckTheDocumentNumber(contractPromise.getPromiseNumber());
            hook.setItemNumber(contractPromise.getItemNumber());
            BigDecimal totalTaxAmount = contractPromise.getTotalTaxAmount() == null ? BigDecimal.ZERO : contractPromise.getTotalTaxAmount();
            hook.setDocumentTaxAmount(totalTaxAmount);
            if (!StrUtil.isBlank((CharSequence)contractPromise.getTaxRate())) {
                BigDecimal tax = new BigDecimal(String.valueOf(contractPromise.getTaxRate())).divide(new BigDecimal(100), 6, 5).add(BigDecimal.ONE);
                BigDecimal netAmount = totalTaxAmount.divide(tax, 6, 5);
                hook.setDocumentNetAmount(netAmount);
                hook.setDocumentTax(totalTaxAmount.subtract(netAmount));
            }
            list.add(hook);
        }
    }

    private void hookPurchasePrePaymentWriteOff(PurchaseInvoiceHookVO invoiceHockVO, List<PurchaseInvoiceHookInformation> list) {
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList = invoiceHockVO.getPrePaymentWriteOffList();
        if (CollectionUtil.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            PurchaseInvoiceHookInformation hook = new PurchaseInvoiceHookInformation();
            BeanUtils.copyProperties((Object)((Object)invoiceHockVO), (Object)((Object)hook));
            hook.setId(null);
            hook.setSourceId(prePaymentWriteOff.getId());
            hook.setInvoiceId(invoiceHockVO.getId());
            hook.setCheckTheDocumentCategory(ReconcilationItemTypeEmun.PRE_PAYMENT.getValue());
            hook.setCheckTheDocumentNumber(prePaymentWriteOff.getPaymentApplyNumber());
            hook.setItemNumber(prePaymentWriteOff.getItemNumber());
            hook.setDocumentTaxAmount(prePaymentWriteOff.getSourceTaxAmount());
            hook.setDocumentNetAmount(prePaymentWriteOff.getSourceNetAmount());
            hook.setDocumentTax(prePaymentWriteOff.getSourceTax());
            list.add(hook);
        }
    }

    private void hookPurchaseRecCharge(PurchaseInvoiceHookVO invoiceHockVO, List<PurchaseInvoiceHookInformation> list) {
        List<PurchaseRecCharge> chargeList = invoiceHockVO.getRecChargeList();
        if (CollectionUtil.isEmpty(chargeList)) {
            return;
        }
        for (PurchaseRecCharge purchaseRecCharge : chargeList) {
            PurchaseInvoiceHookInformation hook = new PurchaseInvoiceHookInformation();
            BeanUtils.copyProperties((Object)((Object)invoiceHockVO), (Object)((Object)hook));
            hook.setId(null);
            hook.setSourceId(purchaseRecCharge.getId());
            hook.setInvoiceId(invoiceHockVO.getId());
            hook.setCheckTheDocumentCategory(ReconcilationItemTypeEmun.CHARGE.getValue());
            hook.setCheckTheDocumentNumber(purchaseRecCharge.getDeductNumber());
            hook.setItemNumber(purchaseRecCharge.getItemNumber());
            BigDecimal totalAmount = purchaseRecCharge.getTotalAmount() == null ? BigDecimal.ZERO : purchaseRecCharge.getTotalAmount();
            BigDecimal totalNonTaxAmount = purchaseRecCharge.getTotalNonTaxAmount() == null ? BigDecimal.ZERO : purchaseRecCharge.getTotalNonTaxAmount();
            hook.setDocumentTaxAmount(totalAmount);
            hook.setDocumentNetAmount(totalNonTaxAmount);
            hook.setDocumentTax(totalAmount.subtract(totalNonTaxAmount));
            list.add(hook);
        }
    }

    private void hookPurchaseRecAdditionalCharges(PurchaseInvoiceHookVO invoiceHockVO, List<PurchaseInvoiceHookInformation> list) {
        List<PurchaseRecAdditionalCharges> additionalChargesList = invoiceHockVO.getRecAdditionalChargesList();
        if (CollectionUtil.isEmpty(additionalChargesList)) {
            return;
        }
        for (PurchaseRecAdditionalCharges additionalCharges : additionalChargesList) {
            PurchaseInvoiceHookInformation hook = new PurchaseInvoiceHookInformation();
            BeanUtils.copyProperties((Object)((Object)invoiceHockVO), (Object)((Object)hook));
            hook.setId(null);
            hook.setSourceId(additionalCharges.getId());
            hook.setInvoiceId(invoiceHockVO.getId());
            hook.setCheckTheDocumentCategory(ReconcilationItemTypeEmun.ADDITIONAL_CHARGES.getValue());
            hook.setCheckTheDocumentNumber(additionalCharges.getCostNumber());
            hook.setItemNumber(additionalCharges.getItemNumber());
            BigDecimal totalAmount = additionalCharges.getTotalAmount() == null ? BigDecimal.ZERO : additionalCharges.getTotalAmount();
            BigDecimal totalNonTaxAmount = additionalCharges.getTotalNonTaxAmount() == null ? BigDecimal.ZERO : additionalCharges.getTotalNonTaxAmount();
            hook.setDocumentTaxAmount(totalAmount);
            hook.setDocumentNetAmount(totalNonTaxAmount);
            hook.setDocumentTax(totalAmount.subtract(totalNonTaxAmount));
            list.add(hook);
        }
    }

    private void hookPurchaseRecAcceptReturn(PurchaseInvoiceHookVO invoiceHockVO, List<PurchaseInvoiceHookInformation> list) {
        List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList = invoiceHockVO.getRecAcceptReturnList();
        if (CollectionUtil.isEmpty(purchaseRecAcceptReturnList)) {
            return;
        }
        for (PurchaseRecAcceptReturn acceptReturn : purchaseRecAcceptReturnList) {
            PurchaseInvoiceHookInformation hook = new PurchaseInvoiceHookInformation();
            BeanUtils.copyProperties((Object)((Object)invoiceHockVO), (Object)((Object)hook));
            hook.setId(null);
            hook.setSourceId(acceptReturn.getId());
            hook.setInvoiceId(invoiceHockVO.getId());
            hook.setCheckTheDocumentCategory(ReconcilationItemTypeEmun.RECEIVING_REFUND.getValue());
            hook.setCheckTheDocumentNumber(acceptReturn.getVoucherNumber());
            hook.setItemNumber(acceptReturn.getItemNumber());
            BigDecimal totalAmount = acceptReturn.getTotalAmount() == null ? BigDecimal.ZERO : acceptReturn.getTotalAmount();
            BigDecimal totalNonTaxAmount = acceptReturn.getTotalNonTaxAmount() == null ? BigDecimal.ZERO : acceptReturn.getTotalNonTaxAmount();
            hook.setDocumentTaxAmount(totalAmount);
            hook.setDocumentNetAmount(totalNonTaxAmount);
            hook.setDocumentTax(totalAmount.subtract(totalNonTaxAmount));
            list.add(hook);
        }
    }
}

