/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.rebate.entity.PurchaseRebateRule;
import com.els.modules.rebate.entity.PurchaseRebateRuleItem;
import com.els.modules.rebate.entity.PurchaseRebateRuleSupplement;
import com.els.modules.rebate.entity.PurchaseRebateRuleThreshold;
import com.els.modules.rebate.mapper.PurchaseRebateRuleMapper;
import com.els.modules.rebate.service.PurchaseRebateRuleItemService;
import com.els.modules.rebate.service.PurchaseRebateRuleService;
import com.els.modules.rebate.service.PurchaseRebateRuleSupplementService;
import com.els.modules.rebate.service.PurchaseRebateRuleThresholdService;
import com.els.modules.rebate.vo.PurchaseRebateRuleVO;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseRebateRuleAuditDubboAdapter")
public class PurchaseRebateRuleAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Resource
    private PurchaseRebateRuleMapper purchaseRebateRuleMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private PurchaseRebateRuleService purchaseRebateRuleService;
    @Autowired
    private PurchaseRebateRuleItemService purchaseRebateRuleItemService;
    @Autowired
    private PurchaseRebateRuleThresholdService purchaseRebateRuleThresholdService;
    @Autowired
    private PurchaseRebateRuleSupplementService purchaseRebateRuleSupplementService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        PurchaseRebateRuleVO vo = new PurchaseRebateRuleVO();
        PurchaseRebateRule purchaseRebateRule = (PurchaseRebateRule)((Object)this.purchaseRebateRuleService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        BeanUtils.copyProperties((Object)((Object)purchaseRebateRule), (Object)((Object)vo));
        List<PurchaseRebateRuleItem> ruleItems = this.purchaseRebateRuleItemService.selectByMainId(flowCallbackDTO.getBusinessId());
        vo.setRebateRuleItems(ruleItems);
        List<PurchaseRebateRuleThreshold> thresholds = this.purchaseRebateRuleThresholdService.selectByMainId(flowCallbackDTO.getBusinessId());
        vo.setRebateRuleThresholds(thresholds);
        List<PurchaseRebateRuleSupplement> supplements = this.purchaseRebateRuleSupplementService.selectByMainId(flowCallbackDTO.getBusinessId());
        vo.setRebateRuleSupplements(supplements);
        this.purchaseRebateRuleService.publish(purchaseRebateRule, vo);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseRebateRule head = (PurchaseRebateRule)((Object)this.purchaseRebateRuleMapper.selectById((Serializable)((Object)id)));
        if (head != null) {
            return SrmUtil.toJSONObject((Object)((Object)head));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseRebateRule head = new PurchaseRebateRule();
        head.setId(flowCallbackDTO.getBusinessId());
        head.setAuditStatus(auditStatus);
        head.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchaseRebateRuleMapper.updateById((Object)head);
    }
}

