/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ai.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.ai.dto.AiOrderCreationDto;
import com.els.modules.ai.service.AiInvokeSrmRpcService;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.finance.service.PurchaseAddCostService;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.reconciliation.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.PurchaseRecAcceptReturn;
import com.els.modules.reconciliation.entity.PurchaseRecAdditionalCharges;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.rpc.AiOrderCreationPurchaseVoucherItemLocalRpcService;
import com.els.modules.reconciliation.service.PurchaseReconciliationService;
import com.els.modules.reconciliation.vo.PurchaseReconciliationVO;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@RpcService(value="reconciliationAiOrderCreationRpcServiceImpl")
public class ReconciliationAiOrderCreationRpcServiceImpl
implements AiInvokeSrmRpcService<AiOrderCreationDto> {
    @Autowired
    private AiOrderCreationPurchaseVoucherItemLocalRpcService voucherItemLocalRpcService;
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;
    @Autowired
    private PurchaseAddCostService purchaseAddCostService;
    @Autowired
    private PurchaseReconciliationService purchaseReconciliationService;
    @Autowired
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public AiOrderCreationDto invoke(JSONObject inputParam) {
        String type = inputParam.getString("type");
        AiOrderCreationDto creationPojo = (AiOrderCreationDto)inputParam.getObject("creationPojo", AiOrderCreationDto.class, new JSONReader.Feature[0]);
        if ("run".equals(type)) {
            return this.run(creationPojo);
        }
        return this.check(creationPojo);
    }

    public List<PurchaseRecAcceptReturn> getByPurchaseVoucherItemDTO(PurchaseReconciliationVO vo, List<PurchaseVoucherItemDTO> voucherItems) {
        ArrayList<PurchaseRecAcceptReturn> acceptReturns = new ArrayList<PurchaseRecAcceptReturn>();
        for (PurchaseVoucherItemDTO purchaseVoucherItem : voucherItems) {
            PurchaseRecAcceptReturn acceptReturn = new PurchaseRecAcceptReturn();
            BeanUtils.copyProperties((Object)purchaseVoucherItem, (Object)((Object)acceptReturn));
            if (StringUtils.isNotBlank((CharSequence)purchaseVoucherItem.getPriceUnit())) {
                acceptReturn.setPriceUnit(Integer.parseInt(purchaseVoucherItem.getPriceUnit()));
            } else {
                acceptReturn.setPriceUnit(1);
            }
            BigDecimal exchangeRate = vo.getExchangeRate();
            if (exchangeRate == null) {
                exchangeRate = BigDecimal.ONE;
            }
            acceptReturn.setItemType(ReconcilationItemTypeEmun.RECEIVING_REFUND.getValue());
            acceptReturn.setVoucherItemNumber(purchaseVoucherItem.getItemNumber());
            acceptReturn.setVoucherTime(purchaseVoucherItem.getVoucherDate());
            acceptReturn.setMobileType(purchaseVoucherItem.getMoveType());
            acceptReturn.setDirectionBorrowing(purchaseVoucherItem.getLoanDirection());
            acceptReturn.setPurchaseFactory(purchaseVoucherItem.getFactory());
            acceptReturn.setStorageLocation(purchaseVoucherItem.getStorageLocation());
            acceptReturn.setStorageLocationName(purchaseVoucherItem.getStorageLocationName());
            acceptReturn.setUnitQuantity(purchaseVoucherItem.getQuantityUnit());
            acceptReturn.setNoTaxUnitPrice(purchaseVoucherItem.getNetPrice());
            acceptReturn.setTaxRate(StringUtils.isNotBlank((CharSequence)purchaseVoucherItem.getTaxRate()) ? new BigDecimal(purchaseVoucherItem.getTaxRate()) : null);
            if (purchaseVoucherItem.getPrice() != null && purchaseVoucherItem.getVoucherQuantity() != null) {
                acceptReturn.setTotalAmount(purchaseVoucherItem.getPrice().divide(BigDecimal.valueOf(acceptReturn.getPriceUnit().intValue()), 8, RoundingMode.HALF_UP).multiply(purchaseVoucherItem.getVoucherQuantity()).multiply(exchangeRate));
            }
            if (purchaseVoucherItem.getNetPrice() != null && purchaseVoucherItem.getVoucherQuantity() != null) {
                acceptReturn.setTotalNonTaxAmount(purchaseVoucherItem.getNetPrice().divide(BigDecimal.valueOf(acceptReturn.getPriceUnit().intValue()), 8, RoundingMode.HALF_UP).multiply(purchaseVoucherItem.getVoucherQuantity()).multiply(exchangeRate));
            }
            if (acceptReturn.getTotalAmount() != null && acceptReturn.getTotalNonTaxAmount() != null) {
                acceptReturn.setTaxAmount(acceptReturn.getTotalAmount().subtract(acceptReturn.getTotalNonTaxAmount()));
            }
            acceptReturn.setCanReconciliationQuantity(purchaseVoucherItem.getVoucherQuantity().subtract(purchaseVoucherItem.getReconciliationQuantity()));
            acceptReturn.setThisReconciliationQuantity(acceptReturn.getCanReconciliationQuantity());
            BigDecimal thisReconciliationNetAmount = purchaseVoucherItem.getNetPrice().divide(BigDecimal.valueOf(acceptReturn.getPriceUnit().intValue()), 6, RoundingMode.HALF_UP).multiply(acceptReturn.getThisReconciliationQuantity());
            acceptReturn.setThisReconciliationNetAmount(thisReconciliationNetAmount);
            BigDecimal thisReconciliationTaxAmount = purchaseVoucherItem.getPrice().divide(BigDecimal.valueOf(acceptReturn.getPriceUnit().intValue()), 6, RoundingMode.HALF_UP).multiply(acceptReturn.getThisReconciliationQuantity());
            acceptReturn.setThisReconciliationTaxAmount(thisReconciliationTaxAmount);
            acceptReturn.setBusinessId(purchaseVoucherItem.getId());
            acceptReturn.setId(null);
            acceptReturns.add(acceptReturn);
        }
        return acceptReturns;
    }

    public AiOrderCreationDto run(AiOrderCreationDto creationPojo) {
        String businessType = creationPojo.getBusinessType();
        List templateList = this.invokeBaseRpcService.getDefaultTemplateByType(businessType);
        Assert.notEmpty((Collection)templateList, (String)I18nUtil.translate((String)"", (String)"\u8bf7\u5148\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f\u3002"));
        String elsAccount = creationPojo.getElsAccount();
        List conditionList = creationPojo.getFinalSplitConditionList();
        AiOrderCreationDto result = new AiOrderCreationDto();
        ArrayList<String> numberList = new ArrayList<String>();
        ArrayList<PurchaseReconciliationVO> dataList = new ArrayList<PurchaseReconciliationVO>();
        result.setNumberList(numberList);
        result.setDataList(dataList);
        for (JSONObject condition : conditionList) {
            PurchaseVoucherItemDTO purchaseVoucherItemDTO = (PurchaseVoucherItemDTO)condition.toJavaObject(PurchaseVoucherItemDTO.class, new JSONReader.Feature[0]);
            purchaseVoucherItemDTO.setElsAccount(elsAccount);
            PurchaseReconciliationVO vo = (PurchaseReconciliationVO)((Object)condition.toJavaObject(PurchaseReconciliationVO.class, new JSONReader.Feature[0]));
            if (CharSequenceUtil.isEmpty((CharSequence)vo.getToElsAccount()) || CharSequenceUtil.isEmpty((CharSequence)vo.getCompany()) || null == vo.getBeginDate() || null == vo.getEndDate()) {
                throw new ELSBootException("[\u4f9b\u5e94\u5546\u3001\u516c\u53f8\u3001\u5bf9\u8d26\u5f00\u59cb\u65e5\u671f\u3001\u5bf9\u8d26\u7ed3\u675f\u65e5\u671f]\u662f\u521b\u5efa\u5bf9\u8d26\u5355\u7684\u5fc5\u8981\u6761\u4ef6");
            }
            List<PurchaseVoucherItemDTO> voucherItems = this.voucherItemLocalRpcService.selectReconciliationVoucherToAiOrderCreation(purchaseVoucherItemDTO);
            Map<String, List<PurchaseVoucherItemDTO>> groupVoucherItemMap = voucherItems.stream().collect(Collectors.groupingBy(PurchaseVoucherItemDTO::getToElsAccount));
            List<String> toElsAccountList = Arrays.stream(vo.getToElsAccount().split(",")).toList();
            for (String toElsAccount : toElsAccountList) {
                PurchaseReconciliationVO temVo = (PurchaseReconciliationVO)((Object)condition.toJavaObject(PurchaseReconciliationVO.class, new JSONReader.Feature[0]));
                temVo.setElsAccount(elsAccount);
                temVo.setToElsAccount(toElsAccount);
                temVo.setCreateAccount(elsAccount);
                temVo.setPurchasePrincipal(SysUtil.getLoginUser().getSubAccount() + "_" + SysUtil.getLoginUser().getRealname());
                List<PurchaseVoucherItemDTO> purchaseVoucherItemDTOS = groupVoucherItemMap.get(toElsAccount);
                if (CollectionUtils.isEmpty(purchaseVoucherItemDTOS)) {
                    temVo.setRecAcceptReturnList(null);
                } else {
                    List<PurchaseRecAcceptReturn> acceptReturns = this.getByPurchaseVoucherItemDTO(temVo, purchaseVoucherItemDTOS);
                    temVo.setRecAcceptReturnList(acceptReturns);
                }
                ReconciliationVO targetReconciliationVO = new ReconciliationVO();
                BeanUtils.copyProperties((Object)((Object)temVo), (Object)targetReconciliationVO);
                List<PurchaseRecCharge> charges = this.purchaseDeductCostService.getByPurchaseDeductCost(targetReconciliationVO, elsAccount);
                temVo.setRecChargeList(charges);
                List<PurchaseRecAdditionalCharges> additionalCharges = this.purchaseAddCostService.getByPurchaseAddCost(targetReconciliationVO, elsAccount);
                temVo.setRecAdditionalChargesList(additionalCharges);
                List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOff = this.purchasePaymentApplyItemService.getPurchasePrePaymentWriteOffReconciliations(targetReconciliationVO, elsAccount);
                temVo.setPrePaymentWriteOffList(prePaymentWriteOff);
                TemplateHeadDTO templateHeadDTO = (TemplateHeadDTO)templateList.get(0);
                temVo.setTemplateAccount(templateHeadDTO.getElsAccount());
                temVo.setTemplateNumber(templateHeadDTO.getTemplateNumber());
                temVo.setTemplateName(templateHeadDTO.getTemplateName());
                temVo.setTemplateVersion("" + templateHeadDTO.getTemplateVersion());
                PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
                if (creationPojo.isPreView()) {
                    dataList.add(temVo);
                    continue;
                }
                BeanUtils.copyProperties((Object)((Object)temVo), (Object)((Object)purchaseReconciliation));
                this.purchaseReconciliationService.saveMain(purchaseReconciliation, temVo);
                numberList.add(purchaseReconciliation.getReconciliationNumber());
            }
        }
        return result;
    }

    public AiOrderCreationDto check(AiOrderCreationDto creationPojo) {
        String elsAccount = creationPojo.getElsAccount();
        List conditionList = creationPojo.getFinalSplitConditionList();
        AiOrderCreationDto result = new AiOrderCreationDto();
        ArrayList<PurchaseVoucherItemDTO> allVoucherItemsList = new ArrayList<PurchaseVoucherItemDTO>();
        for (JSONObject condition : conditionList) {
            PurchaseVoucherItemDTO purchaseVoucherItemDTO = (PurchaseVoucherItemDTO)condition.toJavaObject(PurchaseVoucherItemDTO.class, new JSONReader.Feature[0]);
            purchaseVoucherItemDTO.setElsAccount(elsAccount);
            if (CharSequenceUtil.isEmpty((CharSequence)purchaseVoucherItemDTO.getToElsAccount()) || CharSequenceUtil.isEmpty((CharSequence)purchaseVoucherItemDTO.getCompany()) || null == purchaseVoucherItemDTO.getBeginDate() || null == purchaseVoucherItemDTO.getEndDate()) {
                result.setCheckMessage("[\u4f9b\u5e94\u5546\u3001\u516c\u53f8\u3001\u5bf9\u8d26\u5f00\u59cb\u65e5\u671f\u3001\u5bf9\u8d26\u7ed3\u675f\u65e5\u671f]\u662f\u521b\u5efa\u5bf9\u8d26\u5355\u7684\u5fc5\u8981\u6761\u4ef6!");
                result.setCheckPass(false);
                return result;
            }
            List<PurchaseVoucherItemDTO> voucherItems = this.voucherItemLocalRpcService.selectReconciliationVoucherToAiOrderCreation(purchaseVoucherItemDTO);
            if (!CollectionUtil.isNotEmpty(allVoucherItemsList)) continue;
            allVoucherItemsList.addAll(voucherItems);
        }
        if (CollectionUtils.isEmpty(allVoucherItemsList)) {
            result.setCheckMessage("\u6682\u65f6\u672a\u5339\u914d\u5230\u7b26\u5408\u6761\u4ef6\u7684\u51ed\u8bc1\u6570\u636e\uff0c\u9884\u8ba1\u53ea\u4f1a\u751f\u6210" + conditionList.size() + "\u6761\u65e0\u51ed\u8bc1\u5bf9\u8d26\u5355!");
            result.setCheckPass(true);
            result.setCount(conditionList.size());
            return result;
        }
        result.setCheckMessage("\u6210\u529f\u5339\u914d" + allVoucherItemsList.size() + "\u6761\u51ed\u8bc1\u6570\u636e\uff0c\u9884\u8ba1\u751f\u6210" + conditionList.size() + "\u6761\u5bf9\u8d26\u5355\u6570\u636e\uff01");
        result.setCheckPass(true);
        result.setCount(conditionList.size());
        return result;
    }
}

