/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.adapter;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.entity.PurchasePaymentApplyItem;
import com.els.modules.finance.mapper.PurchasePaymentApplyHeadMapper;
import com.els.modules.finance.mapper.PurchasePaymentApplyItemMapper;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import com.els.modules.finance.service.PurchasePaymentPlanHeadService;
import com.els.modules.finance.vo.PurchasePaymentApplyHeadVO;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.Assert;

@RpcService(value="purchasePaymentAuditDubboAdapter")
public class PurchasePaymentAdapter
implements WorkflowAuditOptCallBackService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchasePaymentAdapter.class);
    @Resource
    private PurchasePaymentApplyHeadMapper purchasePaymentApplyHeadMapper;
    @Resource
    private PurchasePaymentApplyItemMapper purchasePaymentApplyItemMapper;
    @Autowired
    private PurchasePaymentApplyHeadService purchasePaymentApplyHeadService;
    @Autowired
    @Lazy
    private PurchasePaymentPlanHeadService purchasePaymentPlanHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private InterfaceUtil interfaceUtil;

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        String sourceType;
        PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO = (PurchasePaymentApplyHeadVO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString(this.getById(flowCallbackDTO.getBusinessId())), PurchasePaymentApplyHeadVO.class));
        List<PurchasePaymentApplyItem> purchasePaymentApplyItemList = purchasePaymentApplyHeadVO.getPaymentApplyItemList();
        if (!CollectionUtil.isEmpty(purchasePaymentApplyItemList) && ((sourceType = purchasePaymentApplyItemList.get(0).getSourceType()).equals("reconciliation") || sourceType.equals("performanceReconciliation")) && purchasePaymentApplyHeadVO.getPaymentApplyType().equals("0")) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xRuIethAUB_627d1a63", (String)"\u4e0d\u652f\u6301\u5bf9\u8d26\u5355\u53d1\u8d77\u9884\u4ed8"));
        }
        PurchasePaymentApplyHead headVO = (PurchasePaymentApplyHead)((Object)JSON.parseObject((String)JSONObject.toJSONString(this.getById(flowCallbackDTO.getBusinessId())), PurchasePaymentApplyHead.class));
        this.checkParams(headVO);
        this.purchasePaymentApplyHeadService.checkAmount(headVO.getId());
        this.purchasePaymentPlanHeadService.checkReconciliationNumberAndUpdatePaymentApply(purchasePaymentApplyItemList);
        this.purchasePaymentApplyHeadService.doUpdateReconciliationPaymentApply(headVO, "1");
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    private void checkParams(PurchasePaymentApplyHead deductCost) {
        Assert.hasText((String)deductCost.getCompany(), (String)I18nUtil.translate((String)"i18n_alert_empty_selectCompany", (String)"\u8bf7\u586b\u5199\u516c\u53f8"));
        Assert.hasText((String)deductCost.getToElsAccount(), (String)I18nUtil.translate((String)"i18n_alert_empty_selectSupplier", (String)"\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546"));
        Assert.hasText((String)deductCost.getCurrency(), (String)I18nUtil.translate((String)"i18n_alert_ViFls_f7546863", (String)"\u8bf7\u9009\u62e9\u5e01\u79cd"));
        List<PurchasePaymentApplyItem> purchasePaymentApplyItems = this.purchasePaymentApplyItemMapper.selectByMainId(deductCost.getId());
        Assert.isTrue((boolean)CollectionUtil.isNotEmpty(purchasePaymentApplyItems), (String)I18nUtil.translate((String)"i18n_alert_VWRRsMImBVUVctH_7ed1abb3", (String)"\u8bf7\u5148\u81f3\u5c11\u4fdd\u5b58\u4e00\u4e2a\u4ed8\u6b3e\u7533\u8bf7\u884c\u8bb0\u5f55"));
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        this.interfaceUtil.callInterface(TenantContext.getTenant(), "pushUnConfirmPaymentApply", this.purchasePaymentApplyHeadMapper.selectById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.purchasePaymentApplyHeadService.cancelReleaseAmount(flowCallbackDTO.getBusinessId());
        this.purchasePaymentApplyHeadService.releaseWriteOffStatus(flowCallbackDTO.getBusinessId());
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchasePaymentApplyHead head = (PurchasePaymentApplyHead)((Object)this.purchasePaymentApplyHeadMapper.selectById((Serializable)((Object)id)));
        if (head != null) {
            return ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)head, new DictTranslateAspectParam());
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchasePaymentApplyHead head = new PurchasePaymentApplyHead();
        head.setId(flowCallbackDTO.getBusinessId());
        head.setAuditStatus(auditStatus);
        head.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchasePaymentApplyHeadMapper.updateById((Object)head);
        try {
            PurchasePaymentApplyHead applyHead = (PurchasePaymentApplyHead)((Object)JSON.parseObject((String)JSONObject.toJSONString(this.getById(flowCallbackDTO.getBusinessId())), PurchasePaymentApplyHead.class));
            if ("1".equals(applyHead.getSendStatus())) {
                PurchasePaymentApplyHeadVO vo = new PurchasePaymentApplyHeadVO();
                BeanUtils.copyProperties((Object)((Object)applyHead), (Object)((Object)vo));
                this.purchasePaymentApplyHeadService.synchr(vo);
            }
        }
        catch (Exception e) {
            log.error("updateStatus: {} ", (Object)e.getMessage());
        }
    }
}

