/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.reconciliation.entity.PurchaseRecAcceptReturn;
import com.els.modules.reconciliation.mapper.PurchaseRecAcceptReturnMapper;
import com.els.modules.reconciliation.service.PurchaseRecAcceptReturnService;
import com.els.modules.reconciliation.vo.PurchaseReconciliationVO;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class PurchaseRecAcceptReturnServiceImpl
extends ServiceImpl<PurchaseRecAcceptReturnMapper, PurchaseRecAcceptReturn>
implements PurchaseRecAcceptReturnService {
    @Resource
    private PurchaseRecAcceptReturnMapper purchaseRecAcceptReturnMapper;

    @Override
    public List<PurchaseRecAcceptReturn> selectByMainId(String mainId) {
        return this.purchaseRecAcceptReturnMapper.selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        this.purchaseRecAcceptReturnMapper.deleteByMainId(mainId);
    }

    @Override
    public void checkAcceptReturn(PurchaseReconciliationVO purchaseReconciliationVO) {
        List<PurchaseRecAcceptReturn> recAcceptReturnList = purchaseReconciliationVO.getRecAcceptReturnList();
        if (CollectionUtil.isEmpty(recAcceptReturnList)) {
            return;
        }
        Set<String> voucherNumbers = recAcceptReturnList.stream().map(PurchaseRecAcceptReturn::getVoucherNumber).collect(Collectors.toSet());
        List<PurchaseRecAcceptReturn> items = this.purchaseRecAcceptReturnMapper.checkHasReconciliation(voucherNumbers);
        if (CollectionUtil.isEmpty(items)) {
            return;
        }
        List<PurchaseRecAcceptReturn> resultList = this.getIntersection(recAcceptReturnList, items);
        if (CollectionUtil.isEmpty(resultList)) {
            return;
        }
        String reconciliationNumber = purchaseReconciliationVO.getReconciliationNumber();
        if (CollectionUtil.isEmpty(resultList = resultList.stream().filter(item -> !item.getReconciliationNumber().contains(reconciliationNumber)).collect(Collectors.toList()))) {
            return;
        }
        List<PurchaseRecAcceptReturn> sourceList = this.getIntersection(resultList, recAcceptReturnList);
        Optional optional = sourceList.stream().findFirst();
        if (optional.isPresent()) {
            PurchaseRecAcceptReturn purchaseRecAcceptReturn = (PurchaseRecAcceptReturn)((Object)optional.get());
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_lYSRHTy0IhxIeVQG_4282aeb7", (String)"\u6536\u9000\u8d27\u660e\u7ec6 \u5e8f\u53f7${0} \u5df2\u53d1\u5e03\u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{purchaseRecAcceptReturn.getItemNumber()}));
        }
    }

    private List<PurchaseRecAcceptReturn> getIntersection(List<PurchaseRecAcceptReturn> targetList, List<PurchaseRecAcceptReturn> sourceList) {
        return sourceList.stream().filter(item -> targetList.stream().map(e -> e.getVoucherNumber() + "&" + e.getVoucherItemNumber()).collect(Collectors.toList()).contains(item.getVoucherNumber() + "&" + item.getVoucherItemNumber())).collect(Collectors.toList());
    }
}

