/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.finance.api.enumerate.DeductCostConfirmStatusEnum;
import com.els.modules.finance.api.enumerate.DeductCostSourceEnum;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.PurchaseDeductCostItem;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.entity.SaleDeductCostItem;
import com.els.modules.finance.mapper.PurchaseDeductCostMapper;
import com.els.modules.finance.service.PurchaseDeductCostItemService;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.PurchaseDeliveryWaterService;
import com.els.modules.finance.service.SaleDeductCostItemService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.finance.vo.PurchaseDeductCostVO;
import com.els.modules.integrated.api.dto.IntegratedDocumentDTO;
import com.els.modules.reconciliation.api.dto.PurchaseDeliveryWaterDTO;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseDeductCostServiceImpl
extends BaseServiceImpl<PurchaseDeductCostMapper, PurchaseDeductCost>
implements PurchaseDeductCostService {
    @Autowired
    private SaleDeductCostService saleDeductCostService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseDeductCostItemService purchaseDeductCostItemService;
    @Autowired
    private SaleDeductCostItemService saleDeductCostItemService;
    @Autowired
    private PurchaseDeliveryWaterService purchaseDeliveryWaterService;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void savePurchaseDeductCost(PurchaseDeductCost purchaseDeductCost, List<PurchaseDeductCostItem> purchaseDeductCostItemList) {
        if (StrUtil.isBlank((CharSequence)purchaseDeductCost.getDeductNumber())) {
            purchaseDeductCost.setDeductNumber(this.invokeBaseRpcService.getNextCode("srmDeductCostNumber", (Object)purchaseDeductCost));
        }
        this.calculatePrice(purchaseDeductCost, purchaseDeductCostItemList);
        ((PurchaseDeductCostMapper)this.baseMapper).insert((Object)purchaseDeductCost);
        this.insertPurchaseDeductCostItemList(purchaseDeductCost, purchaseDeductCostItemList);
        this.handleDocument(purchaseDeductCost);
    }

    private void insertPurchaseDeductCostItemList(PurchaseDeductCost purchaseDeductCost, List<PurchaseDeductCostItem> purchaseDeductCostItemList) {
        if (CollectionUtil.isEmpty(purchaseDeductCostItemList)) {
            return;
        }
        for (PurchaseDeductCostItem purchaseDeductCostItem : purchaseDeductCostItemList) {
            purchaseDeductCostItem.setId(null);
            purchaseDeductCostItem.setHeadId(purchaseDeductCost.getId());
            purchaseDeductCostItem.setToElsAccount(purchaseDeductCost.getToElsAccount());
            SysUtil.setSysParam((BaseEntity)purchaseDeductCostItem, (BaseEntity)purchaseDeductCost);
        }
        this.purchaseDeductCostItemService.saveBatch(purchaseDeductCostItemList);
    }

    private void handleDocument(PurchaseDeductCost purchaseDeductCost) {
        String idStr = IdWorker.getIdStr();
        purchaseDeductCost.setDocumentId(idStr);
        ((PurchaseDeductCostMapper)this.baseMapper).updateById((Object)purchaseDeductCost);
        IntegratedDocumentDTO integratedDocument = new IntegratedDocumentDTO();
        integratedDocument.setId(idStr);
        integratedDocument.setDeductCostId(purchaseDeductCost.getId());
        this.invokeBaseRpcService.saveIntegratedDocument(integratedDocument);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void updatePurchaseDeductCost(PurchaseDeductCost purchaseDeductCost, List<PurchaseDeductCostItem> purchaseDeductCostItemList) {
        this.calculatePrice(purchaseDeductCost, purchaseDeductCostItemList);
        ((PurchaseDeductCostMapper)this.baseMapper).updateById((Object)purchaseDeductCost);
        if (CollectionUtil.isEmpty(purchaseDeductCostItemList)) {
            return;
        }
        this.purchaseDeductCostItemService.deleteByMainId(purchaseDeductCost.getId());
        this.insertPurchaseDeductCostItemList(purchaseDeductCost, purchaseDeductCostItemList);
    }

    private void calculatePrice(PurchaseDeductCost deductCost, List<PurchaseDeductCostItem> purchaseDeductCostItemList) {
        BigDecimal taxRate = deductCost.getTaxRate() == null ? BigDecimal.ZERO : deductCost.getTaxRate().divide(BigDecimal.valueOf(100L));
        BigDecimal taxAmount = deductCost.getTaxAmount() == null ? BigDecimal.ZERO : deductCost.getTaxAmount();
        BigDecimal netAmount = taxAmount.divide(BigDecimal.ONE.add(taxRate), 6, 4);
        deductCost.setNetAmount(netAmount);
        BigDecimal headTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtil.isEmpty(purchaseDeductCostItemList)) {
            for (PurchaseDeductCostItem purchaseDeductCostItem : purchaseDeductCostItemList) {
                BigDecimal itemTaxAmount = purchaseDeductCostItem.getTaxAmount() == null ? BigDecimal.ZERO : purchaseDeductCostItem.getTaxAmount();
                headTaxAmount = headTaxAmount.add(itemTaxAmount);
            }
            deductCost.setTaxAmount(headTaxAmount);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void sendDeductCost(PurchaseDeductCost purchaseDeductCost, List<PurchaseDeductCostItem> deductCostItemList) {
        PurchaseDeductCost dbDeductCost = (PurchaseDeductCost)((Object)this.getById((Serializable)((Object)purchaseDeductCost.getId())));
        if (dbDeductCost != null) {
            boolean flag;
            boolean bl = flag = DeductCostConfirmStatusEnum.WAIT_CONFIRM.getValue().equals(dbDeductCost.getConfirmStatus()) || DeductCostConfirmStatusEnum.ALREADY_CONFIRM.getValue().equals(dbDeductCost.getConfirmStatus()) && "0".equals(dbDeductCost.getRequiredConfirmation());
            if (flag) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APzExqhxVXVtFzE_64c0f41", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u53d1\u5e03\uff0c\u8bf7\u5237\u65b0\u5355\u636e\u72b6\u6001"));
            }
        }
        boolean firstSend = true;
        String id = purchaseDeductCost.getId();
        String relationId = purchaseDeductCost.getRelationId();
        String elsAccount = purchaseDeductCost.getElsAccount();
        String toElsAccount = purchaseDeductCost.getToElsAccount();
        if (purchaseDeductCost.getTaxAmount() == null || BigDecimal.ZERO.compareTo(purchaseDeductCost.getTaxAmount()) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VVHflTfUW_5f864aac", (String)"\u6263\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0"));
        }
        if (StrUtil.isBlank((CharSequence)relationId)) {
            relationId = IdWorker.getIdStr();
            purchaseDeductCost.setRelationId(relationId);
        } else {
            firstSend = false;
        }
        if ("0".equals(purchaseDeductCost.getRequiredConfirmation())) {
            purchaseDeductCost.setConfirmStatus(DeductCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
        } else {
            purchaseDeductCost.setConfirmStatus(DeductCostConfirmStatusEnum.WAIT_CONFIRM.getValue());
        }
        if ("0".equals(purchaseDeductCost.getRequiredConfirmation()) && !StrUtil.isBlank((CharSequence)purchaseDeductCost.getRequiredAudit()) && !"1".equals(purchaseDeductCost.getRequiredAudit())) {
            purchaseDeductCost.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.updatePurchaseDeductCost(purchaseDeductCost, deductCostItemList);
        SaleDeductCost saleDeductCost = new SaleDeductCost();
        BeanUtils.copyProperties((Object)((Object)purchaseDeductCost), (Object)((Object)saleDeductCost));
        saleDeductCost.setId(relationId);
        saleDeductCost.setRelationId(id);
        saleDeductCost.setElsAccount(toElsAccount);
        saleDeductCost.setToElsAccount(elsAccount);
        if (firstSend) {
            this.saleDeductCostService.saveSaleDeductCost(saleDeductCost);
        } else {
            this.saleDeductCostService.updateSaleDeductCost(saleDeductCost);
            this.saleDeductCostItemService.deleteByMainId(saleDeductCost.getId());
        }
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        if (CollectionUtil.isNotEmpty((Collection)purchaseAttachmentList)) {
            AttachmentSendDTO sendVO = new AttachmentSendDTO();
            sendVO.setElsAccount(elsAccount);
            sendVO.setHeadId(id);
            HashMap toSend = new HashMap();
            toSend.put(relationId, toElsAccount);
            sendVO.setToSend((Map)toSend);
            this.invokeBaseRpcService.sendPurchaseFile(sendVO, false);
        }
        ArrayList<SaleDeductCostItem> saleDeductCostItemList = new ArrayList<SaleDeductCostItem>();
        if (!CollectionUtil.isEmpty(deductCostItemList)) {
            for (PurchaseDeductCostItem purchaseDeductCostItem : deductCostItemList) {
                SaleDeductCostItem saleDeductCostItem = new SaleDeductCostItem();
                BeanUtils.copyProperties((Object)((Object)purchaseDeductCostItem), (Object)((Object)saleDeductCostItem));
                saleDeductCostItem.setId(null);
                saleDeductCostItem.setElsAccount(saleDeductCost.getElsAccount());
                saleDeductCostItem.setToElsAccount(saleDeductCost.getToElsAccount());
                saleDeductCostItem.setBusAccount(saleDeductCost.getBusAccount());
                saleDeductCostItem.setHeadId(saleDeductCost.getId());
                saleDeductCostItem.setRelationId(purchaseDeductCostItem.getId());
                saleDeductCostItemList.add(saleDeductCostItem);
            }
        }
        if (!CollectionUtil.isEmpty(saleDeductCostItemList)) {
            this.saleDeductCostItemService.saveBatch(saleDeductCostItemList);
        }
        if (purchaseDeductCost.getRequiredConfirmation().equals("0")) {
            PurchaseDeliveryWaterDTO purchaseDeliveryWater = new PurchaseDeliveryWaterDTO();
            BeanUtils.copyProperties((Object)((Object)purchaseDeductCost), (Object)purchaseDeliveryWater);
            if (!ObjectUtils.isEmpty((Object)purchaseDeliveryWater)) {
                purchaseDeliveryWater.setDocumentNumber(purchaseDeductCost.getDeductNumber());
                purchaseDeliveryWater.setTotalAmount(purchaseDeductCost.getTaxAmount());
                purchaseDeliveryWater.setTotalNonTaxAmount(purchaseDeductCost.getNetAmount());
                purchaseDeliveryWater.setDocumentCategory("1");
                purchaseDeliveryWater.setDocumentStatus("\u5df2\u786e\u8ba4");
                purchaseDeliveryWater.setDocumentType("1");
                purchaseDeliveryWater.setReconciliationNumber(purchaseDeductCost.getReconciliationNumber());
                this.purchaseDeliveryWaterService.insert(purchaseDeliveryWater);
            }
        }
        super.sendMessage(purchaseDeductCost.getElsAccount(), "deductCost", "publish", purchaseDeductCost.getId(), "deductCostBusDataServiceImpl", Arrays.asList(purchaseDeductCost.getToElsAccount()));
    }

    @Override
    public void delPurchaseDeductCost(String id) {
        ((PurchaseDeductCostMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.purchaseDeductCostItemService.deleteByMainId(id);
    }

    @Override
    public void delBatchPurchaseDeductCost(List<String> idList) {
        ((PurchaseDeductCostMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void invalidPurchaseDeductCost(PurchaseDeductCost purchaseDeductCost) {
        PurchaseDeductCost deductCost = new PurchaseDeductCost();
        deductCost.setId(purchaseDeductCost.getId());
        deductCost.setConfirmStatus(DeductCostConfirmStatusEnum.INVALID.getValue());
        this.updateById((Object)deductCost);
        if (StrUtil.isNotBlank((CharSequence)purchaseDeductCost.getRelationId())) {
            SaleDeductCost saleDeductCost = new SaleDeductCost();
            saleDeductCost.setId(purchaseDeductCost.getRelationId());
            saleDeductCost.setConfirmStatus(DeductCostConfirmStatusEnum.INVALID.getValue());
            this.saleDeductCostService.updateById((Object)saleDeductCost);
            super.sendMessage(purchaseDeductCost.getElsAccount(), "deductCost", "cancel", purchaseDeductCost.getId(), "deductCostBusDataServiceImpl", Arrays.asList(purchaseDeductCost.getToElsAccount()));
        }
    }

    @Override
    public List<PurchaseDeductCost> listPurchaseDeductCost(ReconciliationVO reconciliationVO, String elsAccount) {
        QueryWrapper deDuctWapper = new QueryWrapper();
        deDuctWapper.eq((Object)"els_account", (Object)elsAccount);
        deDuctWapper.eq((Object)"to_els_account", (Object)reconciliationVO.getToElsAccount());
        deDuctWapper.eq((Object)"company", (Object)reconciliationVO.getCompany());
        deDuctWapper.ge((Object)"deduct_time", (Object)reconciliationVO.getBeginDate());
        deDuctWapper.le((Object)"deduct_time", (Object)reconciliationVO.getEndDate());
        deDuctWapper.eq((Object)"confirm_status", (Object)DeductCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
        deDuctWapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"deduct_status")).or()).eq((Object)"deduct_status", (Object)"0"));
        if (StrUtil.isNotBlank((CharSequence)reconciliationVO.getTaxCode())) {
            deDuctWapper.eq((Object)"tax_code", (Object)reconciliationVO.getTaxCode());
        }
        if (StrUtil.isNotBlank((CharSequence)reconciliationVO.getCurrency())) {
            deDuctWapper.eq((Object)"currency", (Object)reconciliationVO.getCurrency());
        }
        return this.list((Wrapper)deDuctWapper);
    }

    @Override
    public List<PurchaseRecCharge> getByPurchaseDeductCost(ReconciliationVO reconciliationVO, String elsAccount) {
        List<PurchaseDeductCost> purchaseDeductCosts = this.listPurchaseDeductCost(reconciliationVO, elsAccount);
        ArrayList<PurchaseRecCharge> charges = new ArrayList<PurchaseRecCharge>();
        if (CollectionUtil.isEmpty(purchaseDeductCosts)) {
            return null;
        }
        for (PurchaseDeductCost purchaseDeductCost : purchaseDeductCosts) {
            PurchaseRecCharge charge = new PurchaseRecCharge();
            BeanUtils.copyProperties((Object)((Object)purchaseDeductCost), (Object)((Object)charge));
            charge.setItemType(ReconcilationItemTypeEmun.CHARGE.getValue());
            charge.setVoucherNumber(purchaseDeductCost.getDeductNumber());
            charge.setVoucherTime(purchaseDeductCost.getDeductTime());
            charge.setDeductionType(purchaseDeductCost.getDeductType());
            charge.setTotalAmount(purchaseDeductCost.getTaxAmount());
            charge.setTotalNonTaxAmount(purchaseDeductCost.getNetAmount());
            charge.setDeductionsReason(purchaseDeductCost.getDeductReason());
            charge.setDeductionsInstructions(purchaseDeductCost.getDeductInstruction());
            charge.setSource(purchaseDeductCost.getSourceType());
            charge.setBusinessType(purchaseDeductCost.getRelationType());
            charge.setBusinessId(purchaseDeductCost.getId());
            charge.setDocumentParentId(purchaseDeductCost.getId());
            charge.setId(null);
            charges.add(charge);
        }
        return charges;
    }

    @Override
    public void copyData(String id) {
        PurchaseDeductCost purchaseDeductCost = (PurchaseDeductCost)((Object)((PurchaseDeductCostMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (purchaseDeductCost == null) {
            return;
        }
        PurchaseDeductCost newDeductCost = new PurchaseDeductCost();
        newDeductCost.setTemplateNumber(purchaseDeductCost.getTemplateNumber());
        newDeductCost.setTemplateName(purchaseDeductCost.getTemplateName());
        newDeductCost.setTemplateVersion(purchaseDeductCost.getTemplateVersion());
        newDeductCost.setTemplateAccount(purchaseDeductCost.getTemplateAccount());
        newDeductCost.setPurchaseOrg(purchaseDeductCost.getPurchaseOrg());
        newDeductCost.setCompany(purchaseDeductCost.getCompany());
        newDeductCost.setToElsAccount(purchaseDeductCost.getToElsAccount());
        newDeductCost.setSupplierName(purchaseDeductCost.getSupplierName());
        newDeductCost.setDeductTime(purchaseDeductCost.getDeductTime());
        newDeductCost.setDeductType(purchaseDeductCost.getDeductType());
        newDeductCost.setTaxCode(purchaseDeductCost.getTaxCode());
        newDeductCost.setTaxRate(purchaseDeductCost.getTaxRate());
        newDeductCost.setCurrency(purchaseDeductCost.getCurrency());
        newDeductCost.setLocalCurrency(purchaseDeductCost.getLocalCurrency());
        newDeductCost.setExchangeRate(purchaseDeductCost.getExchangeRate());
        newDeductCost.setDeductReason(purchaseDeductCost.getDeductReason());
        newDeductCost.setDeductInstruction(purchaseDeductCost.getDeductInstruction());
        newDeductCost.setRelationType(purchaseDeductCost.getRelationType());
        newDeductCost.setRelationNumber(purchaseDeductCost.getRelationNumber());
        newDeductCost.setRelationItemNumber(purchaseDeductCost.getRelationItemNumber());
        newDeductCost.setRequiredConfirmation(purchaseDeductCost.getRequiredConfirmation());
        newDeductCost.setRequiredAudit(purchaseDeductCost.getRequiredAudit());
        newDeductCost.setAuditStrategy(purchaseDeductCost.getAuditStrategy());
        newDeductCost.setWorkFlowType(purchaseDeductCost.getWorkFlowType());
        newDeductCost.setBusAccount(purchaseDeductCost.getBusAccount());
        newDeductCost.setSourceType(DeductCostSourceEnum.SRM.getValue());
        newDeductCost.setConfirmStatus(DeductCostConfirmStatusEnum.NEW.getValue());
        newDeductCost.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        newDeductCost.setDeductStatus("0");
        newDeductCost.setReconciliationNumber(null);
        this.savePurchaseDeductCost(newDeductCost, new ArrayList<PurchaseDeductCostItem>());
    }

    @Override
    public JSONObject getDataById(String id) {
        PurchaseDeductCost purchaseDeductCost = (PurchaseDeductCost)((Object)this.getById((Serializable)((Object)id)));
        PurchaseDeductCostVO headVO = (PurchaseDeductCostVO)((Object)BeanUtil.copyProperties((Object)((Object)purchaseDeductCost), PurchaseDeductCostVO.class, (String[])new String[0]));
        return ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)headVO, new DictTranslateAspectParam());
    }

    @Override
    public List<PurchaseDeductCost> checkHasReconciliation(Set<String> voucherNumbers) {
        if (CollectionUtil.isEmpty(voucherNumbers)) {
            return new ArrayList<PurchaseDeductCost>();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(PurchaseDeductCost::getDeductNumber, voucherNumbers);
        return this.list((Wrapper)queryWrapper);
    }
}

