/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.ParentEntityDTO;
import com.els.aspect.param.DictTranslateAspectParam;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.service.DictTranslateService;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseOpenServiceImpl;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.finance.api.enumerate.PaymentApplyEnum;
import com.els.modules.finance.api.enumerate.PaymentApplyOtherEnum;
import com.els.modules.finance.api.enumerate.PaymentApplySourceTypeEnum;
import com.els.modules.finance.api.enumerate.PaymentApplyStatusEnum;
import com.els.modules.finance.api.enumerate.ReconciliationPaymentStatusEnum;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.entity.PurchasePaymentApplyItem;
import com.els.modules.finance.entity.PurchasePaymentApplyOther;
import com.els.modules.finance.entity.PurchasePaymentApplyWriteOff;
import com.els.modules.finance.entity.PurchasePaymentPlanItem;
import com.els.modules.finance.entity.PurchaseWriteOffRecord;
import com.els.modules.finance.entity.SalePaymentApplyHead;
import com.els.modules.finance.entity.SalePaymentApplyItem;
import com.els.modules.finance.entity.SalePaymentApplyOther;
import com.els.modules.finance.entity.SalePaymentApplyWriteOff;
import com.els.modules.finance.enumerate.PaymentPlanStatusEnum;
import com.els.modules.finance.enumerate.WriteOffStatusEnum;
import com.els.modules.finance.enumerate.WriteOffTypeEnum;
import com.els.modules.finance.mapper.PurchasePaymentApplyHeadMapper;
import com.els.modules.finance.mapper.PurchasePaymentApplyItemMapper;
import com.els.modules.finance.mapper.PurchasePaymentApplyOtherMapper;
import com.els.modules.finance.mapper.PurchasePaymentApplyWriteOffMapper;
import com.els.modules.finance.mapper.SalePaymentApplyHeadMapper;
import com.els.modules.finance.mapper.SalePaymentApplyItemMapper;
import com.els.modules.finance.mapper.SalePaymentApplyOtherMapper;
import com.els.modules.finance.mapper.SalePaymentApplyWriteOffMapper;
import com.els.modules.finance.rpc.ElsEnterpriseInfoLocalRpcService;
import com.els.modules.finance.rpc.FinanceInvokeContractRpcService;
import com.els.modules.finance.rpc.FinanceInvokeOrderRpcService;
import com.els.modules.finance.service.PurchaseDeliveryWaterService;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.finance.service.PurchasePaymentApplyOtherService;
import com.els.modules.finance.service.PurchasePaymentApplyWriteOffService;
import com.els.modules.finance.service.PurchasePaymentPlanHeadService;
import com.els.modules.finance.service.PurchasePaymentPlanItemService;
import com.els.modules.finance.service.PurchaseWriteOffRecordService;
import com.els.modules.finance.service.SalePaymentApplyHeadService;
import com.els.modules.finance.service.SalePaymentApplyItemService;
import com.els.modules.finance.service.SalePaymentApplyOtherService;
import com.els.modules.finance.service.SalePaymentApplyWriteOffService;
import com.els.modules.finance.vo.PurchasePaymentApplyHeadVO;
import com.els.modules.finance.vo.PurchasePaymentPlanItemVO;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.reconciliation.api.dto.PurchaseDeliveryWaterDTO;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsSourceCase;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsSourceCaseRecord;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsWriteOff;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchasePaymentCharge;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.entity.SalePaymentCharge;
import com.els.modules.reconciliation.mapper.PurchasePaymentChargeMapper;
import com.els.modules.reconciliation.mapper.SalePaymentChargeMapper;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsSourceCaseRecordService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsSourceCaseService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.PurchaseInvoiceService;
import com.els.modules.reconciliation.service.PurchasePaymentChargeService;
import com.els.modules.reconciliation.service.PurchasePerformanceReconciliationService;
import com.els.modules.reconciliation.service.PurchasePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.service.PurchaseReconciliationService;
import com.els.modules.reconciliation.service.SalePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchasePaymentApplyHeadServiceImpl
extends BaseOpenServiceImpl<PurchasePaymentApplyHeadMapper, PurchasePaymentApplyHead, PurchasePaymentApplyHeadVO>
implements PurchasePaymentApplyHeadService {
    @Resource
    private PurchasePaymentApplyHeadMapper purchasePaymentApplyHeadMapper;
    @Resource
    private PurchasePaymentApplyItemMapper purchasePaymentApplyItemMapper;
    @Resource
    private PurchasePaymentApplyOtherMapper purchasePaymentApplyOtherMapper;
    @Resource
    private PurchasePaymentApplyOtherService purchasePaymentApplyOtherService;
    @Resource
    private PurchasePaymentApplyWriteOffMapper purchasePaymentApplyWriteOffMapper;
    @Resource
    private SalePaymentApplyWriteOffMapper salePaymentApplyWriteOffMapper;
    @Autowired
    private SalePaymentApplyHeadService salePaymentApplyHeadService;
    @Autowired
    private SalePaymentApplyItemService salePaymentApplyItemService;
    @Autowired
    private SalePaymentApplyOtherService salePaymentApplyOtherService;
    @Autowired
    private SalePaymentApplyWriteOffService salePaymentApplyWriteOffService;
    @Resource
    private PurchasePaymentChargeMapper purchasePaymentChargeMapper;
    @Resource
    private PurchasePaymentChargeService purchasePaymentChargeService;
    @Resource
    private SalePaymentChargeMapper salePaymentChargeMapper;
    @Resource
    private SalePaymentApplyItemMapper salePaymentApplyItemMapper;
    @Resource
    private SalePaymentApplyOtherMapper salePaymentApplyOtherMapper;
    @Resource
    private FinanceInvokeOrderRpcService financeInvokeOrderRpcService;
    @Resource
    private FinanceInvokeContractRpcService financeInvokeContractRpcService;
    @Autowired
    private PurchaseReconciliationService purchaseReconciliationService;
    @Autowired
    private PurchaseInvoiceService purchaseInvoiceService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private ElsEnterpriseInfoLocalRpcService elsEnterpriseInfoRpcService;
    @Autowired
    private ElsPurchaseStatisticsSourceCaseService elsPurchaseStatisticsSourceCaseService;
    @Autowired
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;
    @Resource
    private PurchasePerformanceReconciliationService purchasePerformanceReconciliationService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Autowired
    private PurchaseWriteOffRecordService purchaseWriteOffRecordService;
    @Resource
    private SalePaymentApplyHeadMapper salePaymentApplyHeadMapper;
    @Autowired
    private PurchaseDeliveryWaterService purchaseDeliveryWaterService;
    @Autowired
    private ElsPurchaseStatisticsSourceCaseRecordService elsPurchaseStatisticsSourceCaseRecordService;
    @Autowired
    private PurchasePaymentApplyWriteOffService purchasePaymentApplyWriteOffService;
    @Autowired
    private PurchasePrePaymentWriteOffReconciliationService purchasePrePaymentWriteOffReconciliationService;
    @Autowired
    private SalePrePaymentWriteOffReconciliationService salePrePaymentWriteOffReconciliationService;
    @Lazy
    @Autowired
    private PurchasePaymentPlanHeadService purchasePaymentPlanHeadService;
    @Lazy
    @Resource
    private PurchasePaymentPlanItemService purchasePaymentPlanItemService;
    @Autowired
    private InterfaceUtil interfaceUtil;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePaymentApplyHead purchasePaymentApplyHead, PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO) {
        ElsEnterpriseInfoDTO enterpriseInfo;
        List<PurchasePaymentApplyItem> purchasePaymentApplyItemList = purchasePaymentApplyHeadVO.getPaymentApplyItemList();
        List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList = purchasePaymentApplyHeadVO.getPaymentApplyWriteOffList();
        if (StrUtil.isBlank((CharSequence)purchasePaymentApplyHead.getPaymentApplyNumber())) {
            purchasePaymentApplyHead.setPaymentApplyNumber(this.invokeBaseRpcService.getNextCode("srmApplyNumber", (Object)purchasePaymentApplyHead));
        }
        if ((enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(TenantContext.getTenant())) != null) {
            purchasePaymentApplyHead.setPurchaseName(enterpriseInfo.getName());
        }
        purchasePaymentApplyHead.setPaymentApplyStatus(PaymentApplyStatusEnum.OUTSTANDING.getValue());
        purchasePaymentApplyHead.setPush("0");
        purchasePaymentApplyHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        this.calculateAmount(purchasePaymentApplyHead, purchasePaymentApplyHeadVO);
        this.purchasePaymentApplyHeadMapper.insert((Object)purchasePaymentApplyHead);
        this.insertPaymentApplyItem(purchasePaymentApplyHead, purchasePaymentApplyItemList);
        this.insertPaymentWriteOffList(purchasePaymentApplyHead, purchasePaymentApplyWriteOffList);
        this.insertPurchasePaymentCharge(purchasePaymentApplyHead, purchasePaymentApplyHeadVO.getPaymentChargeList());
        purchasePaymentApplyHeadVO.setPaymentApplyNumber(purchasePaymentApplyHead.getPaymentApplyNumber());
        this.updateWriteOffStatus(purchasePaymentApplyHeadVO);
        this.doUpdatePaymentPlanItem("0", purchasePaymentApplyHead.getId(), this.purchasePaymentApplyItemMapper.selectByMainId(purchasePaymentApplyHead.getId()));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePaymentApplyHead purchasePaymentApplyHead, PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO) {
        List<PurchasePaymentApplyItem> delPaymentPlanItemList = this.findDelPaymentPlanItemList(purchasePaymentApplyHead, purchasePaymentApplyHeadVO.getPaymentApplyItemList());
        this.checkOverAmount(purchasePaymentApplyHeadVO);
        this.calculateAmount(purchasePaymentApplyHead, purchasePaymentApplyHeadVO);
        this.purchasePaymentApplyHeadMapper.updateById((Object)purchasePaymentApplyHead);
        this.purchasePaymentApplyItemMapper.deleteByMainId(purchasePaymentApplyHead.getId());
        this.purchasePaymentApplyOtherMapper.deleteByMainId(purchasePaymentApplyHead.getId());
        this.purchasePaymentApplyWriteOffMapper.deleteByMainId(purchasePaymentApplyHead.getId());
        this.purchasePaymentChargeMapper.deleteByMainId(purchasePaymentApplyHead.getId());
        this.insertPaymentApplyItem(purchasePaymentApplyHead, purchasePaymentApplyHeadVO.getPaymentApplyItemList());
        this.insertPaymentApplyOtherList(purchasePaymentApplyHead, purchasePaymentApplyHeadVO.getPaymentApplyOtherList());
        this.insertPaymentWriteOffList(purchasePaymentApplyHead, purchasePaymentApplyHeadVO.getPaymentApplyWriteOffList());
        this.insertPurchasePaymentCharge(purchasePaymentApplyHead, purchasePaymentApplyHeadVO.getPaymentChargeList());
        this.updateWriteOffStatus(purchasePaymentApplyHeadVO);
        if ("1".equals(purchasePaymentApplyHead.getSendStatus())) {
            this.synchr(purchasePaymentApplyHeadVO);
        }
        this.delAndUpdatePaymentPlanItem(purchasePaymentApplyHead, delPaymentPlanItemList);
    }

    private void updateWriteOffStatus(PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO) {
        List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList = purchasePaymentApplyHeadVO.getPaymentApplyWriteOffList();
        Set<String> reconciliationNumberSet = this.getReconciliationNumberSet(purchasePaymentApplyWriteOffList, WriteOffStatusEnum.UN_WRITE_OFF.getValue());
        this.updateWriteOffStatus(reconciliationNumberSet, WriteOffStatusEnum.WRITE_OFFING.getValue(), purchasePaymentApplyHeadVO.getPaymentApplyNumber());
        if (CollectionUtils.isEmpty(purchasePaymentApplyWriteOffList)) {
            return;
        }
        for (PurchasePaymentApplyWriteOff writeOff : purchasePaymentApplyWriteOffList) {
            if (StrUtil.isBlank((CharSequence)writeOff.getReconciliationNumber()) || !reconciliationNumberSet.contains(writeOff.getReconciliationNumber())) continue;
            writeOff.setWriteOffStatus(WriteOffStatusEnum.WRITE_OFFING.getValue());
            writeOff.setWriteOffPaymentNumber(purchasePaymentApplyHeadVO.getPaymentApplyNumber());
            this.purchasePaymentApplyWriteOffMapper.updateById((Object)writeOff);
        }
    }

    private void updateWriteOffStatus(Set<String> reconciliationNumberSet, String writeOffStatus, String paymentNumber) {
        if (!CollectionUtils.isEmpty(reconciliationNumberSet)) {
            List<PurchaseReconciliation> purchaseReconciliationList = this.getPurchaseReconciliations(reconciliationNumberSet);
            List<PurchasePerformanceReconciliation> purchasePerformanceReconciliationList = this.getPurchasePerformanceReconciliations(reconciliationNumberSet);
            if (!CollectionUtils.isEmpty(purchaseReconciliationList)) {
                Set<String> prIds = purchaseReconciliationList.stream().map(ParentEntity::getId).collect(Collectors.toSet());
                this.purchasePrePaymentWriteOffReconciliationService.updateWriteOffStatus(prIds, writeOffStatus, paymentNumber);
                this.salePrePaymentWriteOffReconciliationService.updateWriteOffStatus(prIds, WriteOffStatusEnum.WRITE_OFFING.getValue(), paymentNumber);
            }
            if (!CollectionUtils.isEmpty(purchasePerformanceReconciliationList)) {
                Set<String> pprIds = purchasePerformanceReconciliationList.stream().map(ParentEntity::getId).collect(Collectors.toSet());
                this.purchasePrePaymentWriteOffReconciliationService.updateWriteOffStatus(pprIds, writeOffStatus, paymentNumber);
                this.salePrePaymentWriteOffReconciliationService.updateWriteOffStatus(pprIds, WriteOffStatusEnum.WRITE_OFFING.getValue(), paymentNumber);
            }
        }
    }

    private Set<String> getReconciliationNumberSet(List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList, String status) {
        HashSet<String> reconciliationNumberSet = new HashSet<String>();
        if (CollectionUtils.isEmpty(purchasePaymentApplyWriteOffList)) {
            return reconciliationNumberSet;
        }
        for (PurchasePaymentApplyWriteOff entity : purchasePaymentApplyWriteOffList) {
            String writeOffStatus = entity.getWriteOffStatus();
            String reconciliationNumber = entity.getReconciliationNumber();
            if (StrUtil.isBlank((CharSequence)reconciliationNumber) || !status.equals(writeOffStatus)) continue;
            reconciliationNumberSet.add(reconciliationNumber);
        }
        return reconciliationNumberSet;
    }

    public void doUpdatePaymentPlanItem(String isDel, String id, List<PurchasePaymentApplyItem> paymentPlanItemList) {
        PurchasePaymentApplyHead applyHead = (PurchasePaymentApplyHead)((Object)this.purchasePaymentApplyHeadMapper.selectById((Serializable)((Object)id)));
        if (CollUtil.isNotEmpty(paymentPlanItemList) && CollUtil.isNotEmpty(paymentPlanItemList = paymentPlanItemList.stream().filter(x -> "paymentPlan".equals(x.getSourceType())).collect(Collectors.toList())) && "1".equals(isDel)) {
            paymentPlanItemList.forEach(x -> x.setDeleted(CommonConstant.DEL_FLAG_1));
        }
        this.purchasePaymentPlanHeadService.updatePaymentPlanItem(applyHead, paymentPlanItemList);
    }

    public void doUpdateReconciliationPaymentPlan(PurchasePaymentApplyHead purchasePaymentApplyHead, String paymentApply) {
        List<PurchasePaymentApplyItem> applyItemList = this.purchasePaymentApplyItemMapper.selectByMainId(purchasePaymentApplyHead.getId());
        if (CollUtil.isEmpty(applyItemList)) {
            return;
        }
        List paymentPlanApplyItemList = applyItemList.stream().filter(x -> PaymentApplySourceTypeEnum.PAYMENTPLAN.getValue().equals(x.getSourceType())).collect(Collectors.toList());
        if (CollUtil.isEmpty(paymentPlanApplyItemList)) {
            return;
        }
        List paymentPlanItemIdList = paymentPlanApplyItemList.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getSourceId())).map(PurchasePaymentApplyItem::getSourceId).collect(Collectors.toList());
        if (CollUtil.isEmpty(paymentPlanItemIdList)) {
            return;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"id", paymentPlanItemIdList);
        List list = this.purchasePaymentPlanItemService.list((Wrapper)wrapper);
        if (CollUtil.isEmpty((Collection)list)) {
            return;
        }
        ArrayList sourceNumberList = new ArrayList();
        list.forEach(item -> {
            String sourceNumber = item.getSourceNumber();
            if (StrUtil.isNotBlank((CharSequence)sourceNumber)) {
                String[] arr;
                for (String s : arr = sourceNumber.split(",")) {
                    sourceNumberList.add(s);
                }
            }
        });
        if (CollUtil.isNotEmpty(sourceNumberList) && sourceNumberList.size() > 0) {
            List promiseReconciliationList;
            List stockReconciliationList = this.purchaseReconciliationService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).in((Object)"reconciliation_number", sourceNumberList));
            if (CollUtil.isNotEmpty((Collection)stockReconciliationList)) {
                List idList = stockReconciliationList.stream().map(ParentEntity::getId).distinct().collect(Collectors.toList());
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseReconciliationService.lambdaUpdate().in(ParentEntity::getId, idList)).set(PurchaseReconciliation::getPaymentApply, (Object)paymentApply)).update();
            }
            if (CollUtil.isNotEmpty((Collection)(promiseReconciliationList = this.purchasePerformanceReconciliationService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).in((Object)"reconciliation_number", sourceNumberList))))) {
                List idList = promiseReconciliationList.stream().map(ParentEntity::getId).distinct().collect(Collectors.toList());
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchasePerformanceReconciliationService.lambdaUpdate().in(ParentEntity::getId, idList)).set(PurchasePerformanceReconciliation::getPaymentApply, (Object)paymentApply)).update();
            }
        }
    }

    public void delAndUpdatePaymentPlanItem(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyItem> delPaymentPlanItemList) {
        ArrayList<PurchasePaymentApplyItem> paymentPlanItemList = new ArrayList<PurchasePaymentApplyItem>();
        paymentPlanItemList.addAll(delPaymentPlanItemList);
        List<PurchasePaymentApplyItem> applyItemList = this.purchasePaymentApplyItemMapper.selectByMainId(purchasePaymentApplyHead.getId());
        if (CollUtil.isNotEmpty(applyItemList)) {
            List paymentPlanList = applyItemList.stream().filter(x -> "paymentPlan".equals(x.getSourceType())).collect(Collectors.toList());
            paymentPlanItemList.addAll(paymentPlanList);
        }
        this.purchasePaymentPlanHeadService.updatePaymentPlanItem(purchasePaymentApplyHead, paymentPlanItemList);
    }

    private List<PurchasePaymentApplyItem> findDelPaymentPlanItemList(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyItem> paymentApplyItemList) {
        List<PurchasePaymentApplyItem> oldApplyItemList = this.purchasePaymentApplyItemMapper.selectByMainId(purchasePaymentApplyHead.getId());
        if (CollUtil.isEmpty(oldApplyItemList)) {
            return Collections.emptyList();
        }
        List<PurchasePaymentApplyItem> oldPaymentPlanItemList = oldApplyItemList.stream().filter(x -> "paymentPlan".equals(x.getSourceType())).collect(Collectors.toList());
        if (CollUtil.isEmpty(oldPaymentPlanItemList)) {
            return Collections.emptyList();
        }
        List newPaymentPlanItemList = paymentApplyItemList.stream().filter(x -> "paymentPlan".equals(x.getSourceType())).collect(Collectors.toList());
        if (CollUtil.isEmpty(newPaymentPlanItemList)) {
            oldPaymentPlanItemList.forEach(x -> x.setDeleted(CommonConstant.DEL_FLAG_1));
            return oldPaymentPlanItemList;
        }
        List<PurchasePaymentApplyItem> delExistPaymentPlanItemList = oldPaymentPlanItemList.stream().filter(vo -> !newPaymentPlanItemList.stream().map(my -> my.getSourceId()).collect(Collectors.toList()).contains(vo.getSourceId())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(delExistPaymentPlanItemList)) {
            delExistPaymentPlanItemList.forEach(x -> x.setDeleted(CommonConstant.DEL_FLAG_1));
        }
        return delExistPaymentPlanItemList;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateWriteOff(PurchasePaymentApplyHead purchasePaymentApplyHead, PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO) {
        List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffDbList = this.purchasePaymentApplyWriteOffMapper.selectByMainId(purchasePaymentApplyHeadVO.getId());
        List<PurchasePaymentApplyWriteOff> paymentApplyWriteOffList = purchasePaymentApplyHeadVO.getPaymentApplyWriteOffList();
        int itemNumber = 1;
        for (PurchasePaymentApplyWriteOff writeOff2 : paymentApplyWriteOffList) {
            writeOff2.setSerialNumber("" + itemNumber);
            ++itemNumber;
        }
        List ids = paymentApplyWriteOffList.stream().filter(writeOff -> WriteOffTypeEnum.PAYMENT.getValue().equals(writeOff.getWriteOffType()) && !WriteOffStatusEnum.WRITE_OFFED.getValue().equals(writeOff.getWriteOffStatus())).map(ParentEntity::getId).collect(Collectors.toList());
        List dbIds = purchasePaymentApplyWriteOffDbList.stream().filter(writeOff -> WriteOffTypeEnum.PAYMENT.getValue().equals(writeOff.getWriteOffType()) && !WriteOffStatusEnum.WRITE_OFFED.getValue().equals(writeOff.getWriteOffStatus())).map(ParentEntity::getId).collect(Collectors.toList());
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object writeOff3 : paymentApplyWriteOffList) {
            if (StrUtil.isBlank((CharSequence)writeOff3.getId())) continue;
            map.put(writeOff3.getId(), writeOff3);
        }
        HashMap<String, PurchasePaymentApplyWriteOff> dbMap = new HashMap<String, PurchasePaymentApplyWriteOff>();
        for (PurchasePaymentApplyWriteOff writeOff4 : purchasePaymentApplyWriteOffDbList) {
            dbMap.put(writeOff4.getId(), writeOff4);
        }
        List<PurchasePaymentApplyWriteOff> addList = paymentApplyWriteOffList.stream().filter(writeOff -> WriteOffTypeEnum.PAYMENT.getValue().equals(writeOff.getWriteOffType()) && StrUtil.isBlank((CharSequence)writeOff.getId())).collect(Collectors.toList());
        ArrayList removed = new ArrayList(dbIds);
        removed.removeAll(ids);
        ArrayList updated = new ArrayList(dbIds);
        updated.retainAll(ids);
        ArrayList<PurchasePaymentApplyWriteOff> removedList = new ArrayList<PurchasePaymentApplyWriteOff>();
        ArrayList<PurchasePaymentApplyWriteOff> updateList = new ArrayList<PurchasePaymentApplyWriteOff>();
        ArrayList<PurchasePaymentApplyWriteOff> updateDbList = new ArrayList<PurchasePaymentApplyWriteOff>();
        if (!CollectionUtils.isEmpty(removed)) {
            for (String id : removed) {
                removedList.add((PurchasePaymentApplyWriteOff)((Object)dbMap.get(id)));
            }
        }
        if (!CollectionUtils.isEmpty(updated)) {
            for (String id : updated) {
                updateList.add((PurchasePaymentApplyWriteOff)((Object)map.get(id)));
                updateDbList.add((PurchasePaymentApplyWriteOff)((Object)dbMap.get(id)));
            }
        }
        if (!CollectionUtils.isEmpty(removed)) {
            this.purchasePaymentApplyWriteOffMapper.deleteBatchIds(removed);
        }
        if (!CollectionUtils.isEmpty(updated)) {
            this.purchasePaymentApplyWriteOffMapper.deleteBatchIds(updated);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.insertPaymentWriteOffList(purchasePaymentApplyHead, updateList);
        }
        if (!CollectionUtils.isEmpty(addList)) {
            this.insertPaymentWriteOffList(purchasePaymentApplyHead, addList);
        }
        if (!CollectionUtils.isEmpty(updateDbList)) {
            this.elsPurchaseStatisticsWriteOffService.releaseWriteOffAmount(updateDbList);
        }
        if (!CollectionUtils.isEmpty(removedList)) {
            this.elsPurchaseStatisticsWriteOffService.releaseWriteOffAmount(removedList);
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.elsPurchaseStatisticsWriteOffService.writeOffAmountOccupy(updateList);
        }
        if (!CollectionUtils.isEmpty(addList)) {
            this.elsPurchaseStatisticsWriteOffService.writeOffAmountOccupy(addList);
        }
        if ("1".equals(purchasePaymentApplyHead.getSendStatus())) {
            List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList = this.purchasePaymentApplyWriteOffMapper.selectByMainId(purchasePaymentApplyHeadVO.getId());
            purchasePaymentApplyHeadVO.setPaymentApplyWriteOffList(purchasePaymentApplyWriteOffList);
            this.synchr(purchasePaymentApplyHeadVO);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmWriteOff(PurchasePaymentApplyHead purchasePaymentApplyHead, PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO) {
        List<PurchasePaymentApplyWriteOff> writeOffList = purchasePaymentApplyHeadVO.getPaymentApplyWriteOffList();
        writeOffList = writeOffList.stream().filter(writeOff -> WriteOffTypeEnum.PAYMENT.getValue().equals(writeOff.getWriteOffType()) && !WriteOffStatusEnum.WRITE_OFFED.getValue().equals(writeOff.getWriteOffStatus())).collect(Collectors.toList());
        this.handleWriteOff(writeOffList);
        this.createPurchaseWriteOffRecord(writeOffList, purchasePaymentApplyHead);
        for (PurchasePaymentApplyWriteOff writeOff2 : writeOffList) {
            writeOff2.setWriteOffStatus(WriteOffStatusEnum.WRITE_OFFED.getValue());
        }
        this.purchasePaymentApplyWriteOffService.updateBatchById(writeOffList);
        BigDecimal writtenOffAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(writeOffList)) {
            writtenOffAmount = writeOffList.parallelStream().filter(item -> item.getThisWriteOffAmount() != null).map(PurchasePaymentApplyWriteOff::getThisWriteOffAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        BigDecimal prePayWriteOffAmount = purchasePaymentApplyHead.getPrePayWriteOffAmount() == null ? BigDecimal.ZERO : purchasePaymentApplyHead.getPrePayWriteOffAmount();
        prePayWriteOffAmount = prePayWriteOffAmount.add(writtenOffAmount);
        purchasePaymentApplyHead.setPrePayWriteOffAmount(prePayWriteOffAmount);
        this.purchasePaymentApplyHeadMapper.updateById((Object)purchasePaymentApplyHead);
        if ("1".equals(purchasePaymentApplyHead.getSendStatus())) {
            List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList = this.purchasePaymentApplyWriteOffService.selectByMainId(purchasePaymentApplyHead.getId());
            purchasePaymentApplyHeadVO.setPaymentApplyWriteOffList(purchasePaymentApplyWriteOffList);
            this.synchr(purchasePaymentApplyHeadVO);
        }
    }

    private void checkOverAmount(PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO) {
        List<PurchasePaymentApplyItem> purchasePaymentApplyItemList = purchasePaymentApplyHeadVO.getPaymentApplyItemList();
        if (CollectionUtils.isEmpty(purchasePaymentApplyItemList)) {
            return;
        }
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItemList) {
            BigDecimal applyAmount = purchasePaymentApplyItem.getApplyAmount();
            BigDecimal shouldTaxAmount = purchasePaymentApplyItem.getShouldTaxAmount();
            if (applyAmount == null || shouldTaxAmount == null || shouldTaxAmount.compareTo(applyAmount) >= 0) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_UVBVHfxjfUxfHf_a16c3dd6", (String)"\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d\u4e0d\u5f97\u5927\u4e8e\u542b\u7a0e\u91d1\u989d"));
        }
    }

    private void insertPaymentApplyOtherList(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyOther> purchasePaymentApplyOtherList) {
        if (CollectionUtils.isEmpty(purchasePaymentApplyOtherList)) {
            return;
        }
        int index = 1;
        for (PurchasePaymentApplyOther entity : purchasePaymentApplyOtherList) {
            entity.setHeadId(purchasePaymentApplyHead.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchasePaymentApplyHead);
            if (PaymentApplyOtherEnum.CHARGE.getValue().equals(entity.getSourceType())) {
                this.calculationCharge(entity);
            }
            entity.setPaymentApplyNumber(purchasePaymentApplyHead.getPaymentApplyNumber());
            entity.setItemNumber("" + index);
            ++index;
        }
        if (!purchasePaymentApplyOtherList.isEmpty()) {
            this.purchasePaymentApplyOtherService.saveBatch(purchasePaymentApplyOtherList);
        }
    }

    private void calculationCharge(PurchasePaymentApplyOther purchasePaymentApplyOther) {
        PurchaseReconciliationService bean = (PurchaseReconciliationService)SpringContextUtils.getBean(PurchaseReconciliationService.class);
        PurchaseReconciliation byId = (PurchaseReconciliation)((Object)bean.getById((Serializable)((Object)purchasePaymentApplyOther.getSourceId())));
        if (byId != null) {
            PurchasePaymentApplyOtherService bean1 = (PurchasePaymentApplyOtherService)SpringContextUtils.getBean(PurchasePaymentApplyOtherService.class);
            if (bean1 != null) {
                List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)bean1.lambdaQuery().eq(PurchasePaymentApplyOther::getSourceId, (Object)purchasePaymentApplyOther.getSourceId())).eq(BaseEntity::getDeleted, (Object)"0")).list();
                BigDecimal reduce = list.parallelStream().map(PurchasePaymentApplyOther::getApplyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (reduce.add(purchasePaymentApplyOther.getApplyAmount()).compareTo(byId.getChargeAmount()) > 0) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IeteVHfBBWIetyLWWWWWWVXVSVVsM_2a9b43c", (String)("\u5bf9\u8d26\u5355\u8d26\u6263\u91d1\u989d\u8d85\u6807,\u5bf9\u8d26\u5355\u53f7\u4e3a:" + purchasePaymentApplyOther.getSourceNumber() + ",\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u4fdd\u5b58"), (String[])new String[]{purchasePaymentApplyOther.getSourceNumber()}));
                }
                byId.setAlreadyChargeAmount(reduce.add(purchasePaymentApplyOther.getApplyAmount()));
                bean.updateById((Object)byId);
            }
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_YxuIetWIetyLWWWWWW_8c15af30", (String)("\u627e\u4e0d\u5230\u5bf9\u8d26\u5355,\u5bf9\u8d26\u5355\u53f7\u4e3a:" + purchasePaymentApplyOther.getSourceNumber()), (String[])new String[]{purchasePaymentApplyOther.getSourceNumber()}));
        }
    }

    private void handleDocumentInfo(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyItem> purchasePaymentApplyItemList, List<SalePaymentApplyItem> salePaymentApplyItemList) {
        List<String> strings;
        PurchaseInvoice purchaseInvoice;
        PurchaseOrderItemDTO dto;
        Iterator<BaseEntity> purchaseOrderItemDTOList;
        HashSet<String> reconciliationNumberSet = new HashSet<String>();
        HashSet<String> orderNumberSet = new HashSet<String>();
        HashSet<String> invoiceNumberSet = new HashSet<String>();
        HashSet parentIdSet = new HashSet();
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItemList) {
            if (PaymentApplySourceTypeEnum.ORDER.getValue().equals(purchasePaymentApplyItem.getSourceType())) {
                if (StrUtil.isBlank((CharSequence)purchasePaymentApplyItem.getSourceNumber())) continue;
                orderNumberSet.add(purchasePaymentApplyItem.getSourceNumber());
                continue;
            }
            if (!PaymentApplySourceTypeEnum.INVOICE.getValue().equals(purchasePaymentApplyItem.getSourceType())) continue;
            if (!StrUtil.isBlank((CharSequence)purchasePaymentApplyItem.getInvoiceNumber())) {
                invoiceNumberSet.add(purchasePaymentApplyItem.getInvoiceNumber());
            }
            if (StrUtil.isBlank((CharSequence)purchasePaymentApplyItem.getSourceNumber())) continue;
            reconciliationNumberSet.add(purchasePaymentApplyItem.getSourceNumber());
        }
        List purchaseInvoiceList = new ArrayList();
        HashMap<String, Object> purchaseInvoiceMap = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(invoiceNumberSet)) {
            LambdaQueryWrapper purchaseInvoiceLambdaQueryWrapper = new LambdaQueryWrapper();
            purchaseInvoiceLambdaQueryWrapper.in(PurchaseInvoice::getInvoiceNumber, invoiceNumberSet);
            purchaseInvoiceList = this.purchaseInvoiceService.list((Wrapper)purchaseInvoiceLambdaQueryWrapper);
            if (!CollectionUtils.isEmpty(purchaseInvoiceList)) {
                for (Object purchaseInvoice2 : purchaseInvoiceList) {
                    purchaseInvoiceMap.put(((PurchaseInvoice)((Object)purchaseInvoice2)).getInvoiceNumber(), purchaseInvoice2);
                }
            }
        }
        HashMap<String, PurchaseOrderItemDTO> purchaseOrderHeadMap = new HashMap<String, PurchaseOrderItemDTO>();
        if (!CollectionUtils.isEmpty(orderNumberSet) && !CollectionUtils.isEmpty(purchaseOrderItemDTOList = this.financeInvokeOrderRpcService.listPurchaseOrderItemByOrderNumber(new ArrayList<String>(orderNumberSet)))) {
            Object purchaseInvoice2;
            purchaseInvoice2 = purchaseOrderItemDTOList.iterator();
            while (purchaseInvoice2.hasNext()) {
                dto = (PurchaseOrderItemDTO)purchaseInvoice2.next();
                purchaseOrderHeadMap.put(dto.getOrderNumber(), dto);
            }
        }
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItemList) {
            if (PaymentApplySourceTypeEnum.ORDER.getValue().equals(purchasePaymentApplyItem.getSourceType())) {
                if (StrUtil.isBlank((CharSequence)purchasePaymentApplyItem.getSourceNumber()) || (dto = (PurchaseOrderItemDTO)purchaseOrderHeadMap.get(purchasePaymentApplyItem.getSourceNumber())) == null) continue;
                purchasePaymentApplyItem.setDocumentId(dto.getDocumentId());
                purchasePaymentApplyItem.setDocumentParentId(purchasePaymentApplyItem.getId());
                continue;
            }
            if (!PaymentApplySourceTypeEnum.INVOICE.getValue().equals(purchasePaymentApplyItem.getSourceType()) || StrUtil.isBlank((CharSequence)purchasePaymentApplyItem.getInvoiceNumber()) || (purchaseInvoice = (PurchaseInvoice)((Object)purchaseInvoiceMap.get(purchasePaymentApplyItem.getInvoiceNumber()))) == null) continue;
            purchasePaymentApplyItem.setDocumentId(purchaseInvoice.getDocumentId());
            purchasePaymentApplyItem.setDocumentParentId(purchaseInvoice.getId());
        }
        for (SalePaymentApplyItem salePaymentApplyItem : salePaymentApplyItemList) {
            if (PaymentApplySourceTypeEnum.ORDER.getValue().equals(salePaymentApplyItem.getSourceType())) {
                if (StrUtil.isBlank((CharSequence)salePaymentApplyItem.getSourceNumber()) || (dto = (PurchaseOrderItemDTO)purchaseOrderHeadMap.get(salePaymentApplyItem.getSourceNumber())) == null) continue;
                salePaymentApplyItem.setDocumentId(dto.getDocumentId());
                salePaymentApplyItem.setDocumentParentId(salePaymentApplyItem.getRelationId());
                continue;
            }
            if (!PaymentApplySourceTypeEnum.INVOICE.getValue().equals(salePaymentApplyItem.getSourceType()) || StrUtil.isBlank((CharSequence)salePaymentApplyItem.getInvoiceNumber()) || (purchaseInvoice = (PurchaseInvoice)((Object)purchaseInvoiceMap.get(salePaymentApplyItem.getInvoiceNumber()))) == null) continue;
            salePaymentApplyItem.setDocumentId(purchaseInvoice.getDocumentId());
            salePaymentApplyItem.setDocumentParentId(purchaseInvoice.getId());
        }
        if (!CollectionUtils.isEmpty(purchasePaymentApplyItemList)) {
            for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItemList) {
                this.purchasePaymentApplyItemMapper.updateById((Object)purchasePaymentApplyItem);
            }
        }
        HashSet<String> headDocumentIds = new HashSet<String>();
        List<PurchaseOrderHeadDTO> purchaseOrderHeadDTOList = this.financeInvokeOrderRpcService.listPurchaseOrderHeadByOrderNumber(new ArrayList<String>(orderNumberSet));
        if (!CollectionUtils.isEmpty(purchaseOrderHeadDTOList)) {
            List purchaseOrderHeadDocumentIds = purchaseOrderHeadDTOList.stream().map(PurchaseOrderHeadDTO::getDocumentId).collect(Collectors.toList());
            parentIdSet.addAll(purchaseOrderHeadDTOList.stream().map(ParentEntityDTO::getId).collect(Collectors.toSet()));
            for (String purchaseOrderHeadDocumentId : purchaseOrderHeadDocumentIds) {
                if (StrUtil.isBlank((CharSequence)purchaseOrderHeadDocumentId)) continue;
                if (purchaseOrderHeadDocumentId.contains(",")) {
                    strings = Arrays.asList(purchaseOrderHeadDocumentId.split(","));
                    headDocumentIds.addAll(strings);
                    continue;
                }
                headDocumentIds.add(purchaseOrderHeadDocumentId);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseInvoiceList)) {
            List purchaseInvoiceDocumentIds = purchaseInvoiceList.stream().map(PurchaseInvoice::getDocumentId).collect(Collectors.toList());
            parentIdSet.addAll(purchaseInvoiceList.stream().map(ParentEntity::getId).collect(Collectors.toSet()));
            for (String purchaseInvoiceDocumentId : purchaseInvoiceDocumentIds) {
                if (StrUtil.isBlank((CharSequence)purchaseInvoiceDocumentId)) continue;
                if (purchaseInvoiceDocumentId.contains(",")) {
                    strings = Arrays.asList(purchaseInvoiceDocumentId.split(","));
                    headDocumentIds.addAll(strings);
                    continue;
                }
                headDocumentIds.add(purchaseInvoiceDocumentId);
            }
        }
        String headDocumentId = StrUtil.join((CharSequence)",", headDocumentIds);
        String parentId = StrUtil.join((CharSequence)",", parentIdSet);
        purchasePaymentApplyHead.setDocumentId(headDocumentId);
        purchasePaymentApplyHead.setDocumentParentId(parentId);
        this.purchasePaymentApplyHeadMapper.updateById((Object)purchasePaymentApplyHead);
        for (String documentId : headDocumentIds) {
            this.invokeBaseRpcService.updateIntegratedDocumentMain("paymentApplyHeadId", documentId, parentId, purchasePaymentApplyHead.getId());
        }
    }

    private void calculateAmount(PurchasePaymentApplyHead purchasePaymentApplyHead, PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO) {
        List<PurchasePaymentApplyItem> purchasePaymentApplyItemList = purchasePaymentApplyHeadVO.getPaymentApplyItemList();
        List<PurchasePaymentApplyOther> purchasePaymentApplyOtherList = purchasePaymentApplyHeadVO.getPaymentApplyOtherList();
        List<PurchasePaymentApplyWriteOff> purchasePrePaymentWriteOffReconciliationList = purchasePaymentApplyHeadVO.getPaymentApplyWriteOffList();
        BigDecimal shouldTaxAmount = BigDecimal.ZERO;
        BigDecimal shouldNoTaxAmount = BigDecimal.ZERO;
        BigDecimal applyAmount = BigDecimal.ZERO;
        BigDecimal applyNoAmount = BigDecimal.ZERO;
        BigDecimal closingAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(purchasePaymentApplyItemList)) {
            shouldTaxAmount = purchasePaymentApplyItemList.parallelStream().filter(item -> item.getShouldTaxAmount() != null).map(PurchasePaymentApplyItem::getShouldTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            shouldNoTaxAmount = purchasePaymentApplyItemList.parallelStream().filter(item -> item.getShouldNoTaxAmount() != null).map(PurchasePaymentApplyItem::getShouldNoTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            applyAmount = purchasePaymentApplyItemList.parallelStream().filter(item -> item.getApplyAmount() != null).map(PurchasePaymentApplyItem::getApplyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            applyNoAmount = purchasePaymentApplyItemList.parallelStream().filter(item -> item.getApplyNoTaxAmount() != null).map(PurchasePaymentApplyItem::getApplyNoTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            closingAmount = purchasePaymentApplyItemList.parallelStream().filter(a -> a.getClosingAmount() != null).map(PurchasePaymentApplyItem::getClosingAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (!CollectionUtils.isEmpty(purchasePaymentApplyOtherList)) {
            BigDecimal bigDecimalCharge = purchasePaymentApplyOtherList.parallelStream().filter(item -> PaymentApplyOtherEnum.CHARGE.getValue().equals(item.getSourceType())).map(PurchasePaymentApplyOther::getShouldTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal reduceCharge = purchasePaymentApplyItemList.parallelStream().filter(item -> PaymentApplyOtherEnum.CHARGE.getValue().equals(item.getSourceType())).map(PurchasePaymentApplyItem::getApplyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            shouldTaxAmount = shouldTaxAmount.subtract(bigDecimalCharge);
            shouldNoTaxAmount = shouldNoTaxAmount.subtract(bigDecimalCharge);
            applyAmount = applyAmount.subtract(reduceCharge);
            applyNoAmount = applyNoAmount.subtract(reduceCharge);
        }
        BigDecimal writtenOffAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(purchasePrePaymentWriteOffReconciliationList)) {
            writtenOffAmount = purchasePrePaymentWriteOffReconciliationList.parallelStream().filter(item -> item.getThisWriteOffAmount() != null && WriteOffStatusEnum.UN_WRITE_OFF.getValue().equals(item.getWriteOffStatus())).map(PurchasePaymentApplyWriteOff::getThisWriteOffAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        purchasePaymentApplyHead.setPrePayWriteOffAmount(writtenOffAmount);
        purchasePaymentApplyHead.setTaxTotalAmount(shouldTaxAmount);
        purchasePaymentApplyHead.setNoTaxtPaymentAmount(shouldNoTaxAmount);
        purchasePaymentApplyHead.setPaymentAmount(applyAmount);
        purchasePaymentApplyHead.setNoTaxtPaymentAmount(applyNoAmount);
        purchasePaymentApplyHead.setClosingAmount(closingAmount);
    }

    private void calculateClosingAmount(List<PurchasePaymentApplyItem> purchasePaymentApplyItemList) {
        Map<String, ElsPurchaseStatisticsSourceCase> map = this.getStatisticsSourceMap(purchasePaymentApplyItemList);
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItemList) {
            ElsPurchaseStatisticsSourceCase statisticsSourceCase;
            String sourceId = purchasePaymentApplyItem.getSourceId();
            if (StrUtil.isBlank((CharSequence)sourceId) || (statisticsSourceCase = map.get(sourceId)) == null) continue;
            BigDecimal sourceShouldTaxAmount = purchasePaymentApplyItem.getShouldTaxAmount() == null ? BigDecimal.ZERO : purchasePaymentApplyItem.getShouldTaxAmount();
            BigDecimal sourcePaidAmount = statisticsSourceCase.getSourcePaidAmount() == null ? BigDecimal.ZERO : statisticsSourceCase.getSourcePaidAmount();
            BigDecimal sourcePaymentAmount = statisticsSourceCase.getSourcePaymentAmount() == null ? BigDecimal.ZERO : statisticsSourceCase.getSourcePaymentAmount();
            BigDecimal sourceClosingAmount = sourceShouldTaxAmount.subtract(sourcePaidAmount).subtract(sourcePaymentAmount);
            purchasePaymentApplyItem.setClosingAmount(sourceClosingAmount);
        }
    }

    @Override
    public Map<String, ElsPurchaseStatisticsSourceCase> getStatisticsSourceMap(List<PurchasePaymentApplyItem> purchasePaymentApplyItemList) {
        HashMap<String, ElsPurchaseStatisticsSourceCase> map = new HashMap<String, ElsPurchaseStatisticsSourceCase>();
        Set sourceIds = purchasePaymentApplyItemList.stream().map(PurchasePaymentApplyItem::getSourceId).collect(Collectors.toSet());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", sourceIds);
        List list = this.elsPurchaseStatisticsSourceCaseService.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (ElsPurchaseStatisticsSourceCase elsPurchaseStatisticsSourceCase : list) {
                map.put(elsPurchaseStatisticsSourceCase.getSourceId(), elsPurchaseStatisticsSourceCase);
            }
        }
        return map;
    }

    private void insertPaymentApplyItem(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyItem> purchasePaymentApplyItemList) {
        if (CollectionUtils.isEmpty(purchasePaymentApplyItemList)) {
            return;
        }
        int index = 1;
        for (PurchasePaymentApplyItem entity : purchasePaymentApplyItemList) {
            entity.setHeadId(purchasePaymentApplyHead.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchasePaymentApplyHead);
            entity.setCurrency(purchasePaymentApplyHead.getCurrency());
            entity.setPaymentApplyNumber(purchasePaymentApplyHead.getPaymentApplyNumber());
            if (StrUtil.isBlank((CharSequence)entity.getItemNumber())) {
                entity.setItemNumber("" + index);
            }
            ++index;
        }
        if (!purchasePaymentApplyItemList.isEmpty()) {
            this.purchasePaymentApplyItemService.saveBatch(purchasePaymentApplyItemList);
        }
    }

    private void insertPurchasePaymentCharge(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentCharge> purchasePaymentChargeList) {
        if (CollectionUtils.isEmpty(purchasePaymentChargeList)) {
            return;
        }
        int index = 1;
        for (PurchasePaymentCharge entity : purchasePaymentChargeList) {
            entity.setId(null);
            entity.setHeadId(purchasePaymentApplyHead.getId());
            entity.setPaymentApplyNumber(purchasePaymentApplyHead.getPaymentApplyNumber());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchasePaymentApplyHead);
            entity.setItemNumber("" + index);
            ++index;
        }
        if (!purchasePaymentChargeList.isEmpty()) {
            this.purchasePaymentChargeService.saveBatch(purchasePaymentChargeList);
        }
    }

    private void insertPaymentWriteOffList(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList) {
        if (CollectionUtils.isEmpty(purchasePaymentApplyWriteOffList)) {
            return;
        }
        int index = 1;
        for (PurchasePaymentApplyWriteOff entity : purchasePaymentApplyWriteOffList) {
            entity.setId(null);
            entity.setHeadId(purchasePaymentApplyHead.getId());
            entity.setToElsAccount(purchasePaymentApplyHead.getToElsAccount());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchasePaymentApplyHead);
            ++index;
        }
        if (!purchasePaymentApplyWriteOffList.isEmpty()) {
            this.purchasePaymentApplyWriteOffService.saveBatch(purchasePaymentApplyWriteOffList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.doUpdatePaymentPlanItem("1", id, this.purchasePaymentApplyItemMapper.selectByMainId(id));
        this.cancelReleaseAmount(id);
        this.purchasePaymentApplyOtherMapper.deleteByMainId(id);
        this.purchasePaymentApplyItemMapper.deleteByMainId(id);
        this.purchasePaymentApplyWriteOffMapper.deleteByMainId(id);
        this.purchasePaymentChargeMapper.deleteByMainId(id);
        this.purchasePaymentApplyHeadMapper.deleteById((Serializable)((Object)id));
        this.releaseWriteOffStatus(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void releaseWriteOffStatus(String id) {
        List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList = this.purchasePaymentApplyWriteOffMapper.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchasePaymentApplyWriteOffList)) {
            return;
        }
        Set<String> reconciliationNumberSet = this.getReconciliationNumberSet(purchasePaymentApplyWriteOffList, WriteOffStatusEnum.WRITE_OFFING.getValue());
        this.updateWriteOffStatus(reconciliationNumberSet, WriteOffStatusEnum.UN_WRITE_OFF.getValue(), null);
        for (PurchasePaymentApplyWriteOff writeOff : purchasePaymentApplyWriteOffList) {
            if (StrUtil.isBlank((CharSequence)writeOff.getReconciliationNumber()) || !reconciliationNumberSet.contains(writeOff.getReconciliationNumber())) continue;
            writeOff.setWriteOffStatus(WriteOffStatusEnum.UN_WRITE_OFF.getValue());
            writeOff.setPaymentApplyNumber(null);
            this.purchasePaymentApplyWriteOffMapper.updateById((Object)writeOff);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void synchr(PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO) {
        boolean firstSynchrFlag = true;
        PurchasePaymentApplyHead purchasePaymentApplyHead = (PurchasePaymentApplyHead)((Object)this.getById((Serializable)((Object)purchasePaymentApplyHeadVO.getId())));
        if (!purchasePaymentApplyHead.getPaymentApplyStatus().equals(purchasePaymentApplyHeadVO.getPaymentApplyStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFzEhbHrWVXVSsK_2a0afd21", (String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u53d1\u751f\u66f4\u6539,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5"));
        }
        List<PurchasePaymentApplyItem> purchasePaymentApplyItems = this.purchasePaymentApplyItemMapper.selectByMainId(purchasePaymentApplyHeadVO.getId());
        List<PurchasePaymentApplyOther> purchasePaymentApplyOtherList = this.purchasePaymentApplyOtherMapper.selectByMainId(purchasePaymentApplyHeadVO.getId());
        List<PurchasePaymentCharge> purchasePaymentChargeList = this.purchasePaymentChargeMapper.selectByMainId(purchasePaymentApplyHeadVO.getId());
        List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList = this.purchasePaymentApplyWriteOffMapper.selectByMainId(purchasePaymentApplyHeadVO.getId());
        if ("1".equals(purchasePaymentApplyHead.getSendStatus())) {
            firstSynchrFlag = false;
            String relationId = purchasePaymentApplyHead.getRelationId();
            this.salePaymentApplyHeadService.delMain(relationId);
            this.salePaymentApplyItemService.deleteByMainId(relationId);
            this.salePaymentApplyOtherService.deleteByMainId(relationId);
            this.salePaymentApplyWriteOffService.deleteByMainId(relationId);
        }
        purchasePaymentApplyHead.setSendStatus("1");
        SalePaymentApplyHead saleHead = new SalePaymentApplyHead();
        BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyHead), (Object)((Object)saleHead));
        saleHead.setId(IdWorker.getIdStr());
        purchasePaymentApplyHead.setRelationId(saleHead.getId());
        saleHead.setRelationId(purchasePaymentApplyHead.getId());
        saleHead.setElsAccount(purchasePaymentApplyHead.getToElsAccount());
        saleHead.setToElsAccount(purchasePaymentApplyHead.getElsAccount());
        saleHead.setBusAccount(purchasePaymentApplyHead.getElsAccount());
        this.salePaymentApplyHeadService.save((Object)saleHead);
        List<SalePaymentApplyItem> saleItemList = this.insertSalePaymentApplyItem(purchasePaymentApplyHead, purchasePaymentApplyItems, saleHead);
        this.insertSalePaymentApplyOther(purchasePaymentApplyHead, purchasePaymentApplyOtherList, saleHead);
        this.insertSalePaymentCharge(purchasePaymentApplyHead, purchasePaymentChargeList, saleHead);
        this.insertSalePaymentApplyWriteOff(purchasePaymentApplyHead, purchasePaymentApplyWriteOffList, saleHead);
        this.insertSaleAttachment(purchasePaymentApplyHeadVO, saleHead);
        this.updateById((Object)purchasePaymentApplyHead);
        if (firstSynchrFlag) {
            this.sendMessage(purchasePaymentApplyHead, saleHead);
            this.handleDocumentInfo(purchasePaymentApplyHead, purchasePaymentApplyItems, saleItemList);
            saleHead.setDocumentId(purchasePaymentApplyHead.getDocumentId());
            saleHead.setDocumentParentId(purchasePaymentApplyHead.getDocumentParentId());
            this.salePaymentApplyHeadService.updateById((Object)saleHead);
            this.updateById((Object)purchasePaymentApplyHead);
        }
    }

    @Override
    public void checkAmount(String id) {
        if (StrUtil.isBlank((CharSequence)id)) {
            return;
        }
        PurchasePaymentApplyHead purchasePaymentApplyHead = (PurchasePaymentApplyHead)((Object)this.purchasePaymentApplyHeadMapper.selectById((Serializable)((Object)id)));
        List<PurchasePaymentApplyItem> purchasePaymentApplyItems = this.purchasePaymentApplyItemMapper.selectByMainId(id);
        if (purchasePaymentApplyHead == null || CollectionUtils.isEmpty(purchasePaymentApplyItems)) {
            return;
        }
        ArrayList<ElsPurchaseStatisticsSourceCase> list = new ArrayList<ElsPurchaseStatisticsSourceCase>();
        Map<String, ElsPurchaseStatisticsSourceCase> map = this.getStatisticsSourceMap(purchasePaymentApplyItems);
        Map<String, BigDecimal> reconciliationMap = this.getReconciliationMap(purchasePaymentApplyItems);
        this.saveStatisticsSourceCase(purchasePaymentApplyItems, list, map);
        this.calculatePaymentApplyHead(purchasePaymentApplyHead, purchasePaymentApplyItems);
        String tips = this.checkOverAmount(purchasePaymentApplyItems, map);
        if (!StrUtil.isBlank((CharSequence)tips)) {
            throw new ELSBootException("\u4ed8\u6b3e\u7533\u8bf7\u884c \u7b2c" + tips + " \u884c \u4ed8\u6b3e\u7533\u8bf7\u542b\u7a0e\u91d1\u989d\u4e0d\u5f97\u5927\u4e8e\u6765\u6e90\u5355\u7684\u53ef\u7ed3\u7b97\u91d1\u989d");
        }
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            BigDecimal shouldTaxAmount;
            BigDecimal settlementAmount;
            BigDecimal ret;
            BigDecimal applyAmount;
            BigDecimal closingAmount = purchasePaymentApplyItem.getClosingAmount() == null ? BigDecimal.ZERO : purchasePaymentApplyItem.getClosingAmount();
            BigDecimal bigDecimal = applyAmount = purchasePaymentApplyItem.getApplyAmount() == null ? BigDecimal.ZERO : purchasePaymentApplyItem.getApplyAmount();
            if (closingAmount.compareTo(applyAmount) < 0) {
                throw new ELSBootException("\u4ed8\u6b3e\u7533\u8bf7\u542b\u7a0e\u91d1\u989d \u4e0d\u80fd\u5927\u4e8e \u7ed3\u7b97\u91d1\u989d");
            }
            ElsPurchaseStatisticsSourceCase sourceCase = map.get(purchasePaymentApplyItem.getSourceId());
            if (sourceCase == null) continue;
            BigDecimal sourcePaymentAmount = sourceCase.getSourcePaymentAmount();
            sourcePaymentAmount = sourcePaymentAmount == null ? BigDecimal.ZERO : sourcePaymentAmount;
            BigDecimal sourcePaidAmount = sourceCase.getSourcePaidAmount();
            BigDecimal bigDecimal2 = sourcePaidAmount = sourcePaidAmount == null ? BigDecimal.ZERO : sourcePaidAmount;
            if (!(PaymentApplySourceTypeEnum.RECONCILIATION.getValue().equals(purchasePaymentApplyItem.getSourceType()) || PaymentApplySourceTypeEnum.PERFORMANCE_RECONCILIATION.getValue().equals(purchasePaymentApplyItem.getSourceType()) ? BigDecimal.ZERO.compareTo(ret = (settlementAmount = (settlementAmount = reconciliationMap.get(purchasePaymentApplyItem.getSourceId())) == null ? BigDecimal.ZERO : settlementAmount).subtract(sourcePaymentAmount).subtract(sourcePaidAmount)) > 0 : (PaymentApplySourceTypeEnum.ORDER.getValue().equals(purchasePaymentApplyItem.getSourceType()) || PaymentApplySourceTypeEnum.CONTACT.getValue().equals(purchasePaymentApplyItem.getSourceType())) && BigDecimal.ZERO.compareTo(ret = (shouldTaxAmount = (shouldTaxAmount = purchasePaymentApplyItem.getShouldTaxAmount()) == null ? BigDecimal.ZERO : shouldTaxAmount).subtract(sourcePaymentAmount).subtract(sourcePaidAmount)) > 0)) continue;
            throw new ELSBootException("\u7b2c" + purchasePaymentApplyItem.getItemNumber() + "\u884c\u4ed8\u6b3e\u7533\u8bf7\u542b\u7a0e\u91d1\u989d\u4e0d\u5f97\u5927\u4e8e\u6765\u6e90\u5355\u53ef\u7ed3\u7b97\u91d1\u989d");
        }
        this.purchasePaymentApplyHeadMapper.updateById((Object)purchasePaymentApplyHead);
    }

    private Map<String, BigDecimal> getReconciliationMap(List<PurchasePaymentApplyItem> purchasePaymentApplyItems) {
        HashMap<String, BigDecimal> reconciliationMap = new HashMap<String, BigDecimal>();
        HashSet<String> reconciliationSet = new HashSet<String>();
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            if (!PaymentApplySourceTypeEnum.RECONCILIATION.getValue().equals(purchasePaymentApplyItem.getSourceType()) && !PaymentApplySourceTypeEnum.PERFORMANCE_RECONCILIATION.getValue().equals(purchasePaymentApplyItem.getSourceType()) || StrUtil.isBlank((CharSequence)purchasePaymentApplyItem.getSourceId())) continue;
            reconciliationSet.add(purchasePaymentApplyItem.getSourceId());
        }
        if (!CollectionUtils.isEmpty(reconciliationSet)) {
            LambdaQueryWrapper reconciliationWrapper = new LambdaQueryWrapper();
            reconciliationWrapper.in(ParentEntity::getId, reconciliationSet);
            List reconciliationList = this.purchaseReconciliationService.list((Wrapper)reconciliationWrapper);
            if (!CollectionUtils.isEmpty((Collection)reconciliationList)) {
                for (PurchaseReconciliation reconciliation : reconciliationList) {
                    reconciliationMap.put(reconciliation.getId(), reconciliation.getSettlementAmount());
                }
            }
            LambdaQueryWrapper performanceReconciliationWrapper = new LambdaQueryWrapper();
            performanceReconciliationWrapper.in(ParentEntity::getId, reconciliationSet);
            List performanceReconciliationList = this.purchasePerformanceReconciliationService.list((Wrapper)performanceReconciliationWrapper);
            if (!CollectionUtils.isEmpty((Collection)performanceReconciliationList)) {
                for (PurchasePerformanceReconciliation reconciliation : performanceReconciliationList) {
                    reconciliationMap.put(reconciliation.getId(), reconciliation.getSettlementAmount());
                }
            }
        }
        return reconciliationMap;
    }

    private void saveStatisticsSourceCase(List<PurchasePaymentApplyItem> purchasePaymentApplyItems, List<ElsPurchaseStatisticsSourceCase> list, Map<String, ElsPurchaseStatisticsSourceCase> map) {
        ArrayList<ElsPurchaseStatisticsSourceCaseRecord> recordList = new ArrayList<ElsPurchaseStatisticsSourceCaseRecord>();
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            if (purchasePaymentApplyItem.getApplyAmount() == null || StrUtil.isBlank((CharSequence)purchasePaymentApplyItem.getSourceId())) continue;
            ElsPurchaseStatisticsSourceCase statisticsSourceCase = map.get(purchasePaymentApplyItem.getSourceId());
            if (statisticsSourceCase == null) {
                statisticsSourceCase = new ElsPurchaseStatisticsSourceCase();
                statisticsSourceCase.setId(IdWorker.getIdStr());
                statisticsSourceCase.setSourceId(purchasePaymentApplyItem.getSourceId());
            }
            BigDecimal sourcePaymentAmount = statisticsSourceCase.getSourcePaymentAmount() == null ? BigDecimal.ZERO : statisticsSourceCase.getSourcePaymentAmount();
            sourcePaymentAmount = sourcePaymentAmount.add(purchasePaymentApplyItem.getApplyAmount());
            statisticsSourceCase.setSourcePaymentAmount(sourcePaymentAmount);
            statisticsSourceCase.setSourceClosingAmount(purchasePaymentApplyItem.getClosingAmount());
            ElsPurchaseStatisticsSourceCaseRecord record = new ElsPurchaseStatisticsSourceCaseRecord();
            record.setHeadId(statisticsSourceCase.getId());
            record.setAmount(purchasePaymentApplyItem.getApplyAmount());
            record.setSourceId(purchasePaymentApplyItem.getSourceId());
            recordList.add(record);
            list.add(statisticsSourceCase);
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.elsPurchaseStatisticsSourceCaseService.saveOrUpdateBatch(list);
        }
        if (!CollectionUtils.isEmpty(recordList)) {
            this.elsPurchaseStatisticsSourceCaseRecordService.saveBatch(recordList);
        }
    }

    private String checkOverAmount(List<PurchasePaymentApplyItem> purchasePaymentApplyItems, Map<String, ElsPurchaseStatisticsSourceCase> map) {
        StringJoiner tips = new StringJoiner(",");
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            BigDecimal closingAmount = purchasePaymentApplyItem.getClosingAmount();
            BigDecimal applyAmount = purchasePaymentApplyItem.getApplyAmount();
            if (closingAmount == null || applyAmount == null || closingAmount.compareTo(applyAmount) >= 0 || StrUtil.isBlank((CharSequence)purchasePaymentApplyItem.getItemNumber())) continue;
            tips.add(purchasePaymentApplyItem.getItemNumber());
        }
        return tips.toString();
    }

    private void calculatePaymentApplyHead(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyItem> purchasePaymentApplyItems) {
        BigDecimal applyAmount = BigDecimal.ZERO;
        BigDecimal preWrittenOffAmount = BigDecimal.ZERO;
        BigDecimal closingAmount = BigDecimal.ZERO;
        BigDecimal payAmount = BigDecimal.ZERO;
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            if (purchasePaymentApplyItem.getApplyAmount() != null) {
                applyAmount = applyAmount.add(purchasePaymentApplyItem.getApplyAmount());
            }
            if (purchasePaymentApplyItem.getPreWrittenOffAmount() != null) {
                preWrittenOffAmount = preWrittenOffAmount.add(purchasePaymentApplyItem.getPreWrittenOffAmount());
            }
            if (purchasePaymentApplyItem.getClosingAmount() != null) {
                closingAmount = closingAmount.add(purchasePaymentApplyItem.getClosingAmount());
            }
            if (purchasePaymentApplyItem.getPayAmount() == null) continue;
            payAmount = payAmount.add(purchasePaymentApplyItem.getPayAmount());
        }
        purchasePaymentApplyHead.setPaymentAmount(applyAmount);
        purchasePaymentApplyHead.setPrePayWriteOffAmount(preWrittenOffAmount);
        purchasePaymentApplyHead.setClosingAmount(closingAmount);
        purchasePaymentApplyHead.setPayAmount(payAmount);
    }

    private void insertSaleAttachment(PurchasePaymentApplyHeadVO id, SalePaymentApplyHead saleHead) {
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id.getId());
        if (CollectionUtils.isEmpty((Collection)purchaseAttachmentList)) {
            return;
        }
        ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
        for (PurchaseAttachmentDTO purchaseAttachment : purchaseAttachmentList) {
            purchaseAttachment.setSendStatus("1");
            SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
            saleAttachment.setId(null);
            saleAttachment.setElsAccount(saleHead.getElsAccount());
            saleAttachment.setHeadId(saleHead.getId());
            saleAttachment.setRelationId(purchaseAttachment.getId());
            saleAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            saleAttachments.add(saleAttachment);
        }
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachments);
    }

    private void insertSalePaymentApplyOther(PurchasePaymentApplyHead byId, List<PurchasePaymentApplyOther> purchasePaymentApplyOtherList, SalePaymentApplyHead saleHead) {
        ArrayList<SalePaymentApplyOther> salePaymentApplyOthers = new ArrayList<SalePaymentApplyOther>();
        for (PurchasePaymentApplyOther purchasePaymentApplyOther : purchasePaymentApplyOtherList) {
            SalePaymentApplyOther saleItem = new SalePaymentApplyOther();
            BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyOther), (Object)((Object)saleItem));
            saleItem.setId(IdWorker.getIdStr());
            purchasePaymentApplyOther.setRelationId(saleItem.getId());
            saleItem.setHeadId(saleHead.getId());
            saleItem.setRelationId(purchasePaymentApplyOther.getId());
            saleItem.setElsAccount(byId.getToElsAccount());
            SysUtil.setSysParam((BaseEntity)saleItem, (BaseEntity)saleHead);
            salePaymentApplyOthers.add(saleItem);
        }
        if (CollectionUtil.isNotEmpty(salePaymentApplyOthers)) {
            salePaymentApplyOthers.forEach(item -> this.salePaymentApplyOtherMapper.insert(item));
        }
    }

    private void insertSalePaymentCharge(PurchasePaymentApplyHead byId, List<PurchasePaymentCharge> purchasePaymentChargeList, SalePaymentApplyHead saleHead) {
        ArrayList<SalePaymentCharge> salePaymentChargeList = new ArrayList<SalePaymentCharge>();
        for (PurchasePaymentCharge purchasePaymentCharge : purchasePaymentChargeList) {
            SalePaymentCharge salePaymentCharge = new SalePaymentCharge();
            BeanUtils.copyProperties((Object)((Object)purchasePaymentCharge), (Object)((Object)salePaymentCharge));
            salePaymentCharge.setId(IdWorker.getIdStr());
            purchasePaymentCharge.setRelationId(salePaymentCharge.getId());
            salePaymentCharge.setHeadId(saleHead.getId());
            salePaymentCharge.setRelationId(salePaymentCharge.getId());
            salePaymentCharge.setElsAccount(byId.getToElsAccount());
            salePaymentCharge.setBusAccount(byId.getToElsAccount());
            SysUtil.setSysParam((BaseEntity)salePaymentCharge, (BaseEntity)saleHead);
            salePaymentChargeList.add(salePaymentCharge);
        }
        if (CollectionUtil.isNotEmpty(salePaymentChargeList)) {
            salePaymentChargeList.forEach(item -> this.salePaymentChargeMapper.insert(item));
        }
    }

    private void insertSalePaymentApplyWriteOff(PurchasePaymentApplyHead byId, List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList, SalePaymentApplyHead saleHead) {
        ArrayList<SalePaymentApplyWriteOff> salePaymentApplyWriteOffList = new ArrayList<SalePaymentApplyWriteOff>();
        for (PurchasePaymentApplyWriteOff purchasePaymentApplyWriteOff : purchasePaymentApplyWriteOffList) {
            SalePaymentApplyWriteOff salePaymentApplyWriteOff = new SalePaymentApplyWriteOff();
            BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyWriteOff), (Object)((Object)salePaymentApplyWriteOff));
            salePaymentApplyWriteOff.setId(IdWorker.getIdStr());
            purchasePaymentApplyWriteOff.setRelationId(salePaymentApplyWriteOff.getId());
            salePaymentApplyWriteOff.setHeadId(saleHead.getId());
            salePaymentApplyWriteOff.setRelationId(salePaymentApplyWriteOff.getId());
            salePaymentApplyWriteOff.setElsAccount(byId.getToElsAccount());
            salePaymentApplyWriteOff.setBusAccount(byId.getToElsAccount());
            SysUtil.setSysParam((BaseEntity)salePaymentApplyWriteOff, (BaseEntity)saleHead);
            salePaymentApplyWriteOffList.add(salePaymentApplyWriteOff);
        }
        if (CollectionUtil.isNotEmpty(salePaymentApplyWriteOffList)) {
            salePaymentApplyWriteOffList.forEach(item -> this.salePaymentApplyWriteOffMapper.insert(item));
        }
    }

    private List<SalePaymentApplyItem> insertSalePaymentApplyItem(PurchasePaymentApplyHead byId, List<PurchasePaymentApplyItem> purchasePaymentApplyItems, SalePaymentApplyHead saleHead) {
        ArrayList<SalePaymentApplyItem> saleItemList = new ArrayList<SalePaymentApplyItem>();
        for (PurchasePaymentApplyItem purchaseOrderItem : purchasePaymentApplyItems) {
            SalePaymentApplyItem saleItem = new SalePaymentApplyItem();
            BeanUtils.copyProperties((Object)((Object)purchaseOrderItem), (Object)((Object)saleItem));
            saleItem.setId(IdWorker.getIdStr());
            purchaseOrderItem.setRelationId(saleItem.getId());
            saleItem.setHeadId(saleHead.getId());
            saleItem.setRelationId(purchaseOrderItem.getId());
            saleItem.setElsAccount(byId.getToElsAccount());
            saleItem.setBusAccount(byId.getElsAccount());
            SysUtil.setSysParam((BaseEntity)saleItem, (BaseEntity)saleHead);
            saleItemList.add(saleItem);
        }
        if (CollectionUtil.isNotEmpty(saleItemList)) {
            saleItemList.forEach(item -> this.salePaymentApplyItemMapper.insert(item));
        }
        return saleItemList;
    }

    private void sendMessage(PurchasePaymentApplyHead byId, SalePaymentApplyHead saleHead) {
        super.sendMessage(byId.getElsAccount(), "paymentApply", "publish", byId.getId(), "paymentApplyHeadBusDataServiceImpl", Arrays.asList(byId.getToElsAccount()));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancel(PurchasePaymentApplyHeadVO paymentApplyHeadVO) {
        PurchasePaymentApplyHead paymentApplyHead = (PurchasePaymentApplyHead)((Object)this.getById((Serializable)((Object)paymentApplyHeadVO.getId())));
        if (paymentApplyHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_mxuAPtF_d6b9bdfb", (String)"\u67e5\u4e0d\u5230\u5f53\u524d\u5355\u636e"));
        }
        if (!paymentApplyHead.getPaymentApplyStatus().equals(paymentApplyHeadVO.getPaymentApplyStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFzEhbHrWVXVSsK_2a0afd21", (String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u53d1\u751f\u66f4\u6539,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5"));
        }
        this.doUpdatePaymentPlanItem("1", paymentApplyHead.getId(), this.purchasePaymentApplyItemMapper.selectByMainId(paymentApplyHead.getId()));
        this.doUpdateReconciliationPaymentApply(paymentApplyHead, "0");
        this.doUpdateReconciliationPaymentPlan(paymentApplyHead, "0");
        this.cancelReleaseAmount(paymentApplyHeadVO.getId());
        this.releaseWriteOffStatus(paymentApplyHeadVO.getId());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ParentEntity::getId, (Object)paymentApplyHeadVO.getId())).set(PurchasePaymentApplyHead::getPaymentApplyStatus, (Object)PaymentApplyStatusEnum.CANCELLATION.getValue())).update((Object)new PurchasePaymentApplyHead());
        if ("1".equals(paymentApplyHead.getSendStatus())) {
            paymentApplyHeadVO.setPaymentApplyStatus(PaymentApplyStatusEnum.CANCELLATION.getValue());
            this.synchr(paymentApplyHeadVO);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancelReleaseAmount(String id) {
        if (StrUtil.isBlank((CharSequence)id)) {
            return;
        }
        List<PurchasePaymentApplyItem> purchasePaymentApplyItems = this.purchasePaymentApplyItemService.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchasePaymentApplyItems)) {
            return;
        }
        Map<String, ElsPurchaseStatisticsSourceCase> map = this.getStatisticsSourceMap(purchasePaymentApplyItems);
        ArrayList<ElsPurchaseStatisticsSourceCase> statisticsSourceCaseList = new ArrayList<ElsPurchaseStatisticsSourceCase>();
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            Set recordAmount;
            BigDecimal applyAmount = purchasePaymentApplyItem.getApplyAmount() == null ? BigDecimal.ZERO : purchasePaymentApplyItem.getApplyAmount();
            String sourceId = purchasePaymentApplyItem.getSourceId();
            ElsPurchaseStatisticsSourceCase sourceCase = map.get(sourceId);
            if (sourceCase == null) continue;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"used", (Object)0);
            queryWrapper.eq((Object)"source_id", (Object)sourceId);
            queryWrapper.eq((Object)"head_id", (Object)sourceCase.getId());
            List recordList = this.elsPurchaseStatisticsSourceCaseRecordService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)recordList) || CollectionUtils.isEmpty(recordAmount = recordList.stream().filter(record -> record.getAmount() != null).map(ElsPurchaseStatisticsSourceCaseRecord::getAmount).collect(Collectors.toSet())) || !recordAmount.contains(applyAmount)) continue;
            ElsPurchaseStatisticsSourceCaseRecord target = new ElsPurchaseStatisticsSourceCaseRecord();
            for (ElsPurchaseStatisticsSourceCaseRecord record2 : recordList) {
                if (!applyAmount.equals(record2.getAmount())) continue;
                target = record2;
            }
            target.setUsed("1");
            this.elsPurchaseStatisticsSourceCaseRecordService.updateById((Object)target);
            BigDecimal sourcePaymentAmount = sourceCase.getSourcePaymentAmount() == null ? BigDecimal.ZERO : sourceCase.getSourcePaymentAmount();
            sourcePaymentAmount = sourcePaymentAmount.subtract(applyAmount);
            sourceCase.setSourcePaymentAmount(sourcePaymentAmount);
            statisticsSourceCaseList.add(sourceCase);
        }
        if (!CollectionUtils.isEmpty(statisticsSourceCaseList)) {
            this.elsPurchaseStatisticsSourceCaseService.updateBatchById(statisticsSourceCaseList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void doUpdateReconciliationPaymentApply(PurchasePaymentApplyHead purchasePaymentApplyHead, String paymentApply) {
        List promiseReconciliationList;
        List<PurchasePaymentApplyItem> applyItemList = this.purchasePaymentApplyItemMapper.selectByMainId(purchasePaymentApplyHead.getId());
        if (CollUtil.isEmpty(applyItemList)) {
            return;
        }
        List reconciliationApplyItemList = applyItemList.stream().filter(x -> PaymentApplySourceTypeEnum.RECONCILIATION.getValue().equals(x.getSourceType()) || PaymentApplySourceTypeEnum.PERFORMANCE_RECONCILIATION.getValue().equals(x.getSourceType())).collect(Collectors.toList());
        if (CollUtil.isEmpty(reconciliationApplyItemList)) {
            return;
        }
        List<Object> sourceIdList = new ArrayList();
        if ("1".equals(paymentApply)) {
            sourceIdList = reconciliationApplyItemList.stream().filter(x -> x.getApplyAmount() != null && x.getClosingAmount() != null && x.getApplyAmount().compareTo(x.getClosingAmount()) >= 0 && StrUtil.isNotBlank((CharSequence)x.getSourceId())).map(PurchasePaymentApplyItem::getSourceId).collect(Collectors.toList());
        }
        if ("0".equals(paymentApply)) {
            sourceIdList = reconciliationApplyItemList.stream().filter(x -> StrUtil.isNotBlank((CharSequence)x.getSourceId())).map(PurchasePaymentApplyItem::getSourceId).collect(Collectors.toList());
        }
        if (CollUtil.isEmpty(sourceIdList)) {
            return;
        }
        List stockReconciliationList = this.purchaseReconciliationService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).in((Object)"id", sourceIdList));
        if (CollUtil.isNotEmpty((Collection)stockReconciliationList)) {
            if ("1".equals(paymentApply)) {
                List list = stockReconciliationList.stream().filter(x -> "1".equals(x.getPaymentApply())).map(PurchaseReconciliation::getReconciliationNumber).distinct().collect(Collectors.toList());
                Assert.isTrue((CollUtil.isEmpty(list) || list.size() == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_BVUVcIdjIet0IcIBVUVxiTVBUV_59fe8eb0", (String)"\u4ed8\u6b3e\u7533\u8bf7\u884c\u5bf9\u5e94\u7684\u5bf9\u8d26\u5355\u3010${0}\u3011,\u5df2\u521b\u5efa\u4ed8\u6b3e\u7533\u8bf7\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u7533\u8bf7", (String[])new String[]{list.stream().collect(Collectors.joining(","))}));
            }
            List idList = stockReconciliationList.stream().map(ParentEntity::getId).distinct().collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseReconciliationService.lambdaUpdate().in(ParentEntity::getId, idList)).set(PurchaseReconciliation::getPaymentApply, (Object)paymentApply)).update();
        }
        if (CollUtil.isNotEmpty((Collection)(promiseReconciliationList = this.purchasePerformanceReconciliationService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).in((Object)"id", sourceIdList))))) {
            if ("1".equals(paymentApply)) {
                List list = promiseReconciliationList.stream().filter(x -> "1".equals(x.getPaymentApply())).map(PurchasePerformanceReconciliation::getReconciliationNumber).distinct().collect(Collectors.toList());
                Assert.isTrue((CollUtil.isEmpty(list) || list.size() == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_BVUVcIdjIet0IcIBVUVxiTVBUV_59fe8eb0", (String)"\u4ed8\u6b3e\u7533\u8bf7\u884c\u5bf9\u5e94\u7684\u5bf9\u8d26\u5355\u3010${0}\u3011,\u5df2\u521b\u5efa\u4ed8\u6b3e\u7533\u8bf7\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u7533\u8bf7", (String[])new String[]{list.stream().collect(Collectors.joining(","))}));
            }
            List idList = promiseReconciliationList.stream().map(ParentEntity::getId).distinct().collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchasePerformanceReconciliationService.lambdaUpdate().in(ParentEntity::getId, idList)).set(PurchasePerformanceReconciliation::getPaymentApply, (Object)paymentApply)).update();
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (String id : idList) {
            this.purchasePaymentApplyItemMapper.deleteByMainId(id);
            this.purchasePaymentApplyOtherMapper.deleteByMainId(id);
            this.purchasePaymentApplyWriteOffMapper.deleteByMainId(id);
            this.purchasePaymentChargeMapper.deleteByMainId(id);
            this.purchasePaymentApplyHeadMapper.deleteById((Serializable)((Object)id));
        }
    }

    @Override
    public Result<?> getBusinessDocuments(PurchasePaymentApplyHead head, Integer pageNo, Integer pageSize) {
        String elsAccount = TenantContext.getTenant();
        head.setElsAccount(elsAccount);
        if (PaymentApplySourceTypeEnum.CONTACT.getValue().equals(head.getSourceType())) {
            IPage<PurchaseContractHeadDTO> contractPage = this.getContact(pageNo, pageSize, head);
            return Result.ok(contractPage);
        }
        if (PaymentApplySourceTypeEnum.ORDER.getValue().equals(head.getSourceType())) {
            IPage<PurchaseOrderHeadDTO> orderPage = this.getOrder(pageNo, pageSize, head);
            return Result.ok(orderPage);
        }
        if (PaymentApplySourceTypeEnum.RECONCILIATION.getValue().equals(head.getSourceType())) {
            return this.getReconciliation(pageNo, pageSize, head);
        }
        if (PaymentApplySourceTypeEnum.PERFORMANCE_RECONCILIATION.getValue().equals(head.getSourceType())) {
            return this.getPerformanceReconciliation(pageNo, pageSize, head);
        }
        if (PaymentApplySourceTypeEnum.PAYMENTPLAN.getValue().equals(head.getSourceType())) {
            return this.getPurchasePaymentPlanItem(pageNo, pageSize, head);
        }
        return null;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void paymentConfirmation(String id) {
        PurchasePaymentApplyHead purchasePaymentApplyHead = (PurchasePaymentApplyHead)((Object)this.purchasePaymentApplyHeadMapper.selectById((Serializable)((Object)id)));
        if (purchasePaymentApplyHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_mxuAPtF_d6b9bdfb", (String)"\u67e5\u4e0d\u5230\u5f53\u524d\u5355\u636e"));
        }
        String paymentApplyStatus = purchasePaymentApplyHead.getPaymentApplyStatus();
        if (!PaymentApplyStatusEnum.OUTSTANDING.getValue().equals(paymentApplyStatus) && !PaymentApplyStatusEnum.PARTIAL_PAYMENT.getValue().equals(paymentApplyStatus)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APzExqRLRB_abeb34a6", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u786e\u8ba4\u652f\u4ed8"));
        }
        purchasePaymentApplyHead.setPaymentApplyStatus(PaymentApplyStatusEnum.HAS_BEEN_PAID.getValue());
        purchasePaymentApplyHead.setPaymentActualDate(new Date());
        this.purchasePaymentApplyHeadMapper.updateById((Object)purchasePaymentApplyHead);
        List<PurchasePaymentApplyItem> purchasePaymentApplyItems = this.purchasePaymentApplyItemMapper.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchasePaymentApplyItems)) {
            return;
        }
        this.handlePrepayments(purchasePaymentApplyItems, purchasePaymentApplyHead);
        if (!PaymentApplyEnum.PREPAYMENTS.getValue().equals(purchasePaymentApplyHead.getPaymentApplyType())) {
            List<PurchasePaymentApplyWriteOff> writeOffList = this.purchasePaymentApplyWriteOffMapper.selectByMainId(id);
            writeOffList = writeOffList.stream().filter(writeOff -> WriteOffStatusEnum.WRITE_OFFING.getValue().equals(writeOff.getWriteOffStatus()) && purchasePaymentApplyHead.getPaymentApplyNumber().equals(writeOff.getWriteOffPaymentNumber())).collect(Collectors.toList());
            this.handleWriteOff(writeOffList);
            this.createPurchaseWriteOffRecord(writeOffList, purchasePaymentApplyHead);
            Set<String> reconciliationNumberSet = this.getReconciliationNumberSet(writeOffList, WriteOffStatusEnum.WRITE_OFFING.getValue());
            this.updateWriteOffStatus(reconciliationNumberSet, WriteOffStatusEnum.WRITE_OFFED.getValue(), purchasePaymentApplyHead.getPaymentApplyNumber());
            for (PurchasePaymentApplyWriteOff writeOff2 : writeOffList) {
                if (StrUtil.isBlank((CharSequence)writeOff2.getReconciliationNumber()) || !reconciliationNumberSet.contains(writeOff2.getReconciliationNumber())) continue;
                writeOff2.setWriteOffStatus(WriteOffStatusEnum.WRITE_OFFING.getValue());
                this.purchasePaymentApplyWriteOffMapper.updateById((Object)writeOff2);
            }
        } else {
            this.initWriteOff(purchasePaymentApplyItems);
            this.createWaterRecord(id);
        }
        if ("1".equals(purchasePaymentApplyHead.getSendStatus())) {
            PurchasePaymentApplyHeadVO vo = new PurchasePaymentApplyHeadVO();
            BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyHead), (Object)((Object)vo));
            this.synchr(vo);
        }
        this.doUpdatePaymentPlanItem("0", purchasePaymentApplyHead.getId(), this.purchasePaymentApplyItemMapper.selectByMainId(purchasePaymentApplyHead.getId()));
        this.interfaceUtil.callInterface(TenantContext.getTenant(), "pushConfirmPaymentApply", (Object)purchasePaymentApplyHead);
    }

    private void createWaterRecord(String id) {
        PurchaseDeliveryWaterDTO purchaseDeliveryWater = new PurchaseDeliveryWaterDTO();
        PurchasePaymentApplyHead newPurchasePaymentApplyHead = (PurchasePaymentApplyHead)((Object)this.purchasePaymentApplyHeadMapper.selectById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)newPurchasePaymentApplyHead), (Object)purchaseDeliveryWater);
        if (!ObjectUtils.isEmpty((Object)purchaseDeliveryWater)) {
            purchaseDeliveryWater.setDocumentNumber(newPurchasePaymentApplyHead.getPaymentApplyNumber());
            purchaseDeliveryWater.setTotalAmount(newPurchasePaymentApplyHead.getPayAmount());
            purchaseDeliveryWater.setCompany(newPurchasePaymentApplyHead.getCompany());
            purchaseDeliveryWater.setToElsAccount(newPurchasePaymentApplyHead.getToElsAccount());
            purchaseDeliveryWater.setDocumentCategory("3");
            purchaseDeliveryWater.setDocumentStatus("\u5df2\u4ed8\u6e05");
            purchaseDeliveryWater.setDocumentType("2");
            this.purchaseDeliveryWaterService.insert(purchaseDeliveryWater);
        }
    }

    private void createPurchaseWriteOffRecord(List<PurchasePaymentApplyWriteOff> writeOffList, PurchasePaymentApplyHead purchasePaymentApplyHead) {
        List purchasePaymentApplyHeadList;
        if (CollectionUtils.isEmpty(writeOffList)) {
            return;
        }
        Set preHeadIds = writeOffList.stream().filter(writeOff -> !StrUtil.isBlank((CharSequence)writeOff.getPreHeadId())).map(PurchasePaymentApplyWriteOff::getPreHeadId).collect(Collectors.toSet());
        HashMap<String, PurchasePaymentApplyHead> preHeadMap = new HashMap<String, PurchasePaymentApplyHead>();
        if (!CollectionUtils.isEmpty(preHeadIds) && !CollectionUtils.isEmpty((Collection)(purchasePaymentApplyHeadList = this.listByIds(preHeadIds)))) {
            for (PurchasePaymentApplyHead prePaymentApplyHead : purchasePaymentApplyHeadList) {
                preHeadMap.put(prePaymentApplyHead.getId(), prePaymentApplyHead);
            }
        }
        HashMap<String, ReconciliationVO> map = new HashMap<String, ReconciliationVO>();
        this.listPurchaseReconciliation(writeOffList, map);
        this.listPurchasePerformanceReconciliation(writeOffList, map);
        ArrayList<PurchaseWriteOffRecord> recordList = new ArrayList<PurchaseWriteOffRecord>();
        for (PurchasePaymentApplyWriteOff writeOff2 : writeOffList) {
            PurchaseWriteOffRecord record = new PurchaseWriteOffRecord();
            if (!StrUtil.isBlank((CharSequence)writeOff2.getReconciliationNumber())) {
                record.setReconciliationNumber(writeOff2.getReconciliationNumber());
                ReconciliationVO vo = (ReconciliationVO)map.get(writeOff2.getReconciliationNumber());
                if (vo != null) {
                    record.setBeginDate(vo.getBeginDate());
                    record.setEndDate(vo.getEndDate());
                }
            }
            record.setPaymentApplyNumber(purchasePaymentApplyHead.getPaymentApplyNumber());
            record.setHeadId(writeOff2.getHeadId());
            String preHeadId = writeOff2.getPreHeadId();
            if (!StrUtil.isBlank((CharSequence)preHeadId) && preHeadMap.get(preHeadId) != null) {
                PurchasePaymentApplyHead paymentApplyHead = (PurchasePaymentApplyHead)((Object)preHeadMap.get(preHeadId));
                record.setHeadId(paymentApplyHead.getId());
            }
            record.setElsAccount(writeOff2.getElsAccount());
            record.setToElsAccount(writeOff2.getToElsAccount());
            record.setThisWriteOffAmount(writeOff2.getThisWriteOffAmount());
            record.setWriteOffTime(new Date());
            recordList.add(record);
        }
        this.purchaseWriteOffRecordService.saveBatch(recordList);
    }

    private void listPurchaseReconciliation(List<PurchasePaymentApplyWriteOff> writeOffList, Map<String, ReconciliationVO> map) {
        Set<String> reconciliationSourceNumberSet = writeOffList.stream().filter(writeOff -> !StrUtil.isBlank((CharSequence)writeOff.getReconciliationNumber())).map(PurchasePaymentApplyWriteOff::getReconciliationNumber).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(reconciliationSourceNumberSet)) {
            return;
        }
        List<PurchaseReconciliation> list = this.getPurchaseReconciliations(reconciliationSourceNumberSet);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (PurchaseReconciliation purchaseReconciliation : list) {
            ReconciliationVO vo = new ReconciliationVO();
            BeanUtils.copyProperties((Object)((Object)purchaseReconciliation), (Object)vo);
            map.put(purchaseReconciliation.getReconciliationNumber(), vo);
        }
    }

    private List<PurchaseReconciliation> getPurchaseReconciliations(Set<String> reconciliationSourceNumberSet) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"reconciliation_number", reconciliationSourceNumberSet);
        wrapper.eq((Object)"is_deleted", (Object)"0");
        return this.purchaseReconciliationService.list((Wrapper)wrapper);
    }

    private void listPurchasePerformanceReconciliation(List<PurchasePaymentApplyWriteOff> writeOffList, Map<String, ReconciliationVO> map) {
        Set<String> performanceReconciliationSourceNumberSet = writeOffList.stream().filter(writeOff -> !StrUtil.isBlank((CharSequence)writeOff.getReconciliationNumber())).map(PurchasePaymentApplyWriteOff::getReconciliationNumber).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(performanceReconciliationSourceNumberSet)) {
            return;
        }
        List<PurchasePerformanceReconciliation> list = this.getPurchasePerformanceReconciliations(performanceReconciliationSourceNumberSet);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (PurchasePerformanceReconciliation purchasePerformanceReconciliation : list) {
            ReconciliationVO vo = new ReconciliationVO();
            BeanUtils.copyProperties((Object)((Object)purchasePerformanceReconciliation), (Object)vo);
            map.put(purchasePerformanceReconciliation.getReconciliationNumber(), vo);
        }
    }

    private List<PurchasePerformanceReconciliation> getPurchasePerformanceReconciliations(Set<String> performanceReconciliationSourceNumberSet) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"reconciliation_number", performanceReconciliationSourceNumberSet);
        wrapper.eq((Object)"is_deleted", (Object)"0");
        return this.purchasePerformanceReconciliationService.list((Wrapper)wrapper);
    }

    private void initWriteOff(List<PurchasePaymentApplyItem> purchasePaymentApplyItems) {
        ArrayList<ElsPurchaseStatisticsWriteOff> writeOffList = new ArrayList<ElsPurchaseStatisticsWriteOff>();
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            ElsPurchaseStatisticsWriteOff writeOff = new ElsPurchaseStatisticsWriteOff();
            writeOff.setSourceId(purchasePaymentApplyItem.getId());
            BigDecimal applyAmount = purchasePaymentApplyItem.getApplyAmount() == null ? BigDecimal.ZERO : purchasePaymentApplyItem.getApplyAmount();
            writeOff.setSourceUnWrittenOffAmount(applyAmount);
            writeOff.setSourcePayAmount(applyAmount);
            writeOff.setSourceWrittenOffAmount(BigDecimal.ZERO);
            writeOffList.add(writeOff);
        }
        if (!CollectionUtils.isEmpty(writeOffList)) {
            this.elsPurchaseStatisticsWriteOffService.saveBatch(writeOffList);
        }
    }

    private void handleWriteOff(List<PurchasePaymentApplyWriteOff> writeOffList) {
        if (CollectionUtils.isEmpty(writeOffList)) {
            return;
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        Map<String, String> purchaseSaleIdsMap = this.salePaymentApplyItemService.exchangePurchaseSaleIds(writeOffList);
        for (PurchasePaymentApplyWriteOff writeOff : writeOffList) {
            BigDecimal thisWriteOffAmount = writeOff.getThisWriteOffAmount() == null ? BigDecimal.ZERO : writeOff.getThisWriteOffAmount();
            String businessId = writeOff.getBusinessId();
            if (!StrUtil.isBlank((CharSequence)writeOff.getReconciliationNumber()) && (writeOff.getReconciliationNumber().contains("SR") || writeOff.getReconciliationNumber().contains("SPR")) && StrUtil.isBlank((CharSequence)(businessId = purchaseSaleIdsMap.get(businessId))) || StrUtil.isBlank((CharSequence)businessId)) continue;
            BigDecimal amount = map.computeIfAbsent(businessId, applyWriteOff -> BigDecimal.ZERO);
            amount = amount.add(thisWriteOffAmount);
            map.put(businessId, amount);
        }
        this.updateApplyWriteOffInfo(writeOffList, map);
    }

    private void updateApplyWriteOffInfo(List<PurchasePaymentApplyWriteOff> writeOffList, Map<String, BigDecimal> map) {
        HashSet<String> businessId = new HashSet<String>();
        for (PurchasePaymentApplyWriteOff writeOff : writeOffList) {
            businessId.add(writeOff.getBusinessId());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", businessId);
        List list = this.elsPurchaseStatisticsWriteOffService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ElsPurchaseStatisticsWriteOff writeOff : list) {
            BigDecimal thisWriteOffAmount = map.get(writeOff.getSourceId()) == null ? BigDecimal.ZERO : map.get(writeOff.getSourceId());
            BigDecimal applyAmount = writeOff.getSourceApplyAmount() == null ? BigDecimal.ZERO : writeOff.getSourceApplyAmount();
            applyAmount = applyAmount.subtract(thisWriteOffAmount);
            writeOff.setSourceApplyAmount(applyAmount);
            BigDecimal writtenOffAmount = writeOff.getSourceWrittenOffAmount() == null ? BigDecimal.ZERO : writeOff.getSourceWrittenOffAmount();
            writtenOffAmount = writtenOffAmount.add(thisWriteOffAmount);
            writeOff.setSourceWrittenOffAmount(writtenOffAmount);
            BigDecimal sourcePayAmount = writeOff.getSourcePayAmount() == null ? BigDecimal.ZERO : writeOff.getSourcePayAmount();
            BigDecimal unWrittenOffAmount = sourcePayAmount.subtract(writtenOffAmount);
            writeOff.setSourceUnWrittenOffAmount(unWrittenOffAmount);
        }
        this.elsPurchaseStatisticsWriteOffService.updateBatchById(list);
    }

    private void handlePrepayments(List<PurchasePaymentApplyItem> purchasePaymentApplyItems, PurchasePaymentApplyHead purchasePaymentApplyHead) {
        Map<String, ElsPurchaseStatisticsSourceCase> map = this.getStatisticsSourceMap(purchasePaymentApplyItems);
        ArrayList<ElsPurchaseStatisticsSourceCase> statisticsSourceCaseList = new ArrayList<ElsPurchaseStatisticsSourceCase>();
        HashSet<String> reconciliationSet = new HashSet<String>();
        HashSet<String> performanceReconciliationSet = new HashSet<String>();
        SalePaymentApplyHead salePaymentApplyHead = null;
        ArrayList<SalePaymentApplyItem> salePaymentApplyItemList = new ArrayList();
        if (!StrUtil.isBlank((CharSequence)purchasePaymentApplyHead.getRelationId())) {
            salePaymentApplyHead = (SalePaymentApplyHead)((Object)this.salePaymentApplyHeadMapper.selectById((Serializable)((Object)purchasePaymentApplyHead.getRelationId())));
            salePaymentApplyItemList = this.salePaymentApplyItemService.selectByMainId(purchasePaymentApplyHead.getRelationId());
        }
        BigDecimal payAmount = BigDecimal.ZERO;
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            String sourceId;
            ElsPurchaseStatisticsSourceCase sourceCase;
            BigDecimal applyAmount = purchasePaymentApplyItem.getApplyAmount() == null ? BigDecimal.ZERO : purchasePaymentApplyItem.getApplyAmount();
            purchasePaymentApplyItem.setPayAmount(applyAmount);
            if (applyAmount != null && purchasePaymentApplyItem.getPayAmount() != null) {
                BigDecimal unPayIncludeTaxAmount = applyAmount.subtract(purchasePaymentApplyItem.getPayAmount());
                purchasePaymentApplyItem.setUnPayIncludeTaxAmount(unPayIncludeTaxAmount);
            }
            if ((sourceCase = map.get(sourceId = purchasePaymentApplyItem.getSourceId())) == null) continue;
            BigDecimal sourcePaymentAmount = sourceCase.getSourcePaymentAmount() == null ? BigDecimal.ZERO : sourceCase.getSourcePaymentAmount();
            sourcePaymentAmount = sourcePaymentAmount.subtract(applyAmount);
            sourceCase.setSourcePaymentAmount(sourcePaymentAmount);
            BigDecimal sourcePaidAmount = sourceCase.getSourcePaidAmount() == null ? BigDecimal.ZERO : sourceCase.getSourcePaidAmount();
            sourcePaidAmount = sourcePaidAmount.add(applyAmount);
            sourceCase.setSourcePaidAmount(sourcePaidAmount);
            purchasePaymentApplyItem.setPayAmount(applyAmount);
            purchasePaymentApplyItem.setUnPayIncludeTaxAmount(applyAmount.subtract(purchasePaymentApplyItem.getPayAmount()));
            payAmount = payAmount.add(applyAmount);
            if (PaymentApplySourceTypeEnum.RECONCILIATION.getValue().equals(purchasePaymentApplyItem.getSourceType())) {
                reconciliationSet.add(sourceId);
            } else if (PaymentApplySourceTypeEnum.PERFORMANCE_RECONCILIATION.getValue().equals(purchasePaymentApplyItem.getSourceType())) {
                performanceReconciliationSet.add(sourceId);
            }
            statisticsSourceCaseList.add(sourceCase);
        }
        this.updateReconciliationInfo(map, reconciliationSet);
        this.updatePerformanceReconciliationInfo(map, performanceReconciliationSet);
        HashMap<String, PurchasePaymentApplyItem> itemMap = new HashMap<String, PurchasePaymentApplyItem>();
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            itemMap.put(purchasePaymentApplyItem.getId(), purchasePaymentApplyItem);
        }
        if (!CollectionUtils.isEmpty(purchasePaymentApplyItems)) {
            this.purchasePaymentApplyItemService.updateBatchById(purchasePaymentApplyItems);
        }
        if (!CollectionUtils.isEmpty(statisticsSourceCaseList)) {
            this.elsPurchaseStatisticsSourceCaseService.updateBatchById(statisticsSourceCaseList);
        }
        purchasePaymentApplyHead.setPayAmount(payAmount);
        this.updateById((Object)purchasePaymentApplyHead);
        if (salePaymentApplyHead != null) {
            salePaymentApplyHead.setPayAmount(payAmount);
            this.salePaymentApplyHeadService.updateById((Object)salePaymentApplyHead);
        }
        this.handleSalePaymentApplyItemList(salePaymentApplyItemList, itemMap);
    }

    private void handleSalePaymentApplyItemList(List<SalePaymentApplyItem> salePaymentApplyItemList, Map<String, PurchasePaymentApplyItem> itemMap) {
        if (CollectionUtils.isEmpty(salePaymentApplyItemList)) {
            return;
        }
        for (SalePaymentApplyItem salePaymentApplyItem : salePaymentApplyItemList) {
            PurchasePaymentApplyItem purchasePaymentApplyItem;
            String relationId = salePaymentApplyItem.getRelationId();
            if (StrUtil.isBlank((CharSequence)relationId) || (purchasePaymentApplyItem = itemMap.get(relationId)) == null) continue;
            salePaymentApplyItem.setPayAmount(purchasePaymentApplyItem.getPayAmount());
            salePaymentApplyItem.setUnPayIncludeTaxAmount(purchasePaymentApplyItem.getUnPayIncludeTaxAmount());
            salePaymentApplyItem.setPayAmount(purchasePaymentApplyItem.getPayAmount());
            salePaymentApplyItem.setUnPayIncludeTaxAmount(purchasePaymentApplyItem.getUnPayIncludeTaxAmount());
        }
        this.salePaymentApplyItemService.updateBatchById(salePaymentApplyItemList);
    }

    private void updatePerformanceReconciliationInfo(Map<String, ElsPurchaseStatisticsSourceCase> map, Set<String> reconciliationSet) {
        if (CollectionUtils.isEmpty(reconciliationSet)) {
            return;
        }
        List purchasePerformanceReconciliationList = this.purchasePerformanceReconciliationService.listByIds(reconciliationSet);
        if (CollectionUtils.isEmpty((Collection)purchasePerformanceReconciliationList)) {
            return;
        }
        for (PurchasePerformanceReconciliation purchaseReconciliation : purchasePerformanceReconciliationList) {
            ElsPurchaseStatisticsSourceCase statisticsSourceCase = map.get(purchaseReconciliation.getId());
            if (statisticsSourceCase == null) continue;
            purchaseReconciliation.setPaidAmount(statisticsSourceCase.getSourcePaidAmount());
            BigDecimal settlementAmount = purchaseReconciliation.getSettlementAmount() == null ? BigDecimal.ZERO : purchaseReconciliation.getSettlementAmount();
            purchaseReconciliation.setRemainingUnPaidAmount(settlementAmount.subtract(purchaseReconciliation.getPaidAmount()));
            if (BigDecimal.ZERO.equals(purchaseReconciliation.getPaymentRequestedAmount())) {
                purchaseReconciliation.setPaymentStatus(ReconciliationPaymentStatusEnum.PAID.getValue());
            }
            if (!BigDecimal.ZERO.equals(purchaseReconciliation.getSettlementAmount())) continue;
            purchaseReconciliation.setPaymentStatus(ReconciliationPaymentStatusEnum.NO_PAY.getValue());
        }
        this.purchasePerformanceReconciliationService.updateBatchById(purchasePerformanceReconciliationList);
    }

    private void updateReconciliationInfo(Map<String, ElsPurchaseStatisticsSourceCase> map, Set<String> reconciliationSet) {
        if (CollectionUtils.isEmpty(reconciliationSet)) {
            return;
        }
        List purchaseReconciliations = this.purchaseReconciliationService.listByIds(reconciliationSet);
        if (CollectionUtils.isEmpty((Collection)purchaseReconciliations)) {
            return;
        }
        for (PurchaseReconciliation purchaseReconciliation : purchaseReconciliations) {
            ElsPurchaseStatisticsSourceCase statisticsSourceCase = map.get(purchaseReconciliation.getId());
            if (statisticsSourceCase == null) continue;
            purchaseReconciliation.setPaidAmount(statisticsSourceCase.getSourcePaidAmount());
            BigDecimal settlementAmount = purchaseReconciliation.getSettlementAmount() == null ? BigDecimal.ZERO : purchaseReconciliation.getSettlementAmount();
            purchaseReconciliation.setRemainingUnPaidAmount(settlementAmount.subtract(purchaseReconciliation.getPaidAmount()));
            if (BigDecimal.ZERO.equals(purchaseReconciliation.getRemainingUnPaidAmount())) {
                purchaseReconciliation.setPaymentStatus(ReconciliationPaymentStatusEnum.PAID.getValue());
            }
            if (!BigDecimal.ZERO.equals(purchaseReconciliation.getSettlementAmount())) continue;
            purchaseReconciliation.setPaymentStatus(ReconciliationPaymentStatusEnum.NO_PAY.getValue());
        }
        this.purchaseReconciliationService.updateBatchById(purchaseReconciliations);
    }

    private Result<?> getReconciliation(Integer pageNo, Integer pageSize, PurchasePaymentApplyHead head) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        wrapper.eq((Object)"to_els_account", (Object)head.getToElsAccount());
        if (!StrUtil.isBlank((CharSequence)head.getPayWay())) {
            wrapper.eq((Object)"pay_way", (Object)head.getPayWay());
        }
        if (!StrUtil.isBlank((CharSequence)head.getPaymentClause())) {
            wrapper.eq((Object)"payment_clause", (Object)head.getPaymentClause());
        }
        if (!StrUtil.isBlank((CharSequence)head.getCompany())) {
            wrapper.eq((Object)"company", (Object)head.getCompany());
        }
        if (!StrUtil.isBlank((CharSequence)head.getPurchaseOrg())) {
            wrapper.eq((Object)"purchase_org", (Object)head.getPurchaseOrg());
        }
        if (!StrUtil.isBlank((CharSequence)head.getKeyWord())) {
            wrapper.eq((Object)"reconciliation_number", (Object)head.getKeyWord());
        }
        if (!StrUtil.isBlank((CharSequence)head.getCurrency())) {
            wrapper.eq((Object)"currency", (Object)head.getCurrency());
        }
        wrapper.eq((Object)"is_deleted", (Object)"0");
        wrapper.gt((Object)"settlement_amount", (Object)0);
        wrapper.gt((Object)"remaining_un_paid_amount", (Object)0);
        wrapper.and(q -> ((QueryWrapper)((QueryWrapper)q.eq((Object)"sale_rec_affirm_status", (Object)"2")).or()).eq((Object)"reconciliation_status", (Object)"2"));
        wrapper.ne((Object)"is_payment_apply", (Object)"1");
        Page page1 = (Page)this.purchaseReconciliationService.page((IPage)page, (Wrapper)wrapper);
        List records = page1.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            Result.ok((Object)page1);
        }
        this.elsPurchaseStatisticsSourceCaseService.handleReconciliationStatisticsInfo(records);
        return Result.ok((Object)page1);
    }

    private Result<?> getPerformanceReconciliation(Integer pageNo, Integer pageSize, PurchasePaymentApplyHead head) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        wrapper.eq((Object)"to_els_account", (Object)head.getToElsAccount());
        if (!StrUtil.isBlank((CharSequence)head.getPayWay())) {
            wrapper.eq((Object)"pay_way", (Object)head.getPayWay());
        }
        if (!StrUtil.isBlank((CharSequence)head.getPaymentClause())) {
            wrapper.eq((Object)"payment_clause", (Object)head.getPaymentClause());
        }
        if (!StrUtil.isBlank((CharSequence)head.getCompany())) {
            wrapper.eq((Object)"company", (Object)head.getCompany());
        }
        if (!StrUtil.isBlank((CharSequence)head.getPurchaseOrg())) {
            wrapper.eq((Object)"purchase_org", (Object)head.getPurchaseOrg());
        }
        if (!StrUtil.isBlank((CharSequence)head.getKeyWord())) {
            wrapper.eq((Object)"reconciliation_number", (Object)head.getKeyWord());
        }
        if (!StrUtil.isBlank((CharSequence)head.getCurrency())) {
            wrapper.eq((Object)"currency", (Object)head.getCurrency());
        }
        wrapper.eq((Object)"is_deleted", (Object)"0");
        wrapper.gt((Object)"settlement_amount", (Object)0);
        wrapper.gt((Object)"remaining_un_paid_amount", (Object)0);
        wrapper.and(q -> ((QueryWrapper)((QueryWrapper)q.eq((Object)"sale_rec_affirm_status", (Object)"2")).or()).eq((Object)"reconciliation_status", (Object)"2"));
        wrapper.ne((Object)"is_payment_apply", (Object)"1");
        page = (Page)this.purchasePerformanceReconciliationService.page((IPage)page, (Wrapper)wrapper);
        List records = page.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            Result.ok((Object)page);
        }
        this.elsPurchaseStatisticsSourceCaseService.handlePurchasePerformanceReconciliationStatisticsInfo(records);
        return Result.ok((Object)page);
    }

    private Result<?> getPurchasePaymentPlanItem(Integer pageNo, Integer pageSize, PurchasePaymentApplyHead head) {
        head.setSourceType(null);
        PurchasePaymentPlanItemVO itemVO = new PurchasePaymentPlanItemVO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)itemVO));
        QueryWrapper wrapper = QueryGenerator.initQueryWrapper((Object)((Object)itemVO), this.convertEntityToMap((Object)itemVO));
        wrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        wrapper.eq((Object)"payment_status", (Object)"0");
        wrapper.in((Object)"payment_plan_status", PaymentPlanStatusEnum.publishedAndExecuting());
        wrapper.le((Object)"payment_expiredate", (Object)DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"));
        wrapper.lambda().and(wra -> wra.and(wrapper1 -> wrapper1.and(wrapper2 -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.isNull(PurchasePaymentPlanItem::getPaymentDelay)).or()).eq(PurchasePaymentPlanItem::getPaymentDelay, (Object)"")).or()).eq(PurchasePaymentPlanItem::getPaymentDelay, (Object)"0")).or()).or(wrapper3 -> ((LambdaQueryWrapper)wrapper3.eq(PurchasePaymentPlanItem::getPaymentDelay, (Object)"1")).le(PurchasePaymentPlanItem::getPaymentDelayDate, (Object)DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"))))));
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<PurchasePaymentPlanItemVO> pageList = this.purchasePaymentPlanHeadService.selectPlanReconciliationPage((Page<PurchasePaymentPlanItemVO>)page, (QueryWrapper<PurchasePaymentPlanItemVO>)wrapper);
        return Result.ok(pageList);
    }

    private Map<String, String[]> convertEntityToMap(Object entity) {
        try {
            HashMap<String, String[]> result = new HashMap<String, String[]>();
            Class<?> clazz = entity.getClass();
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                String name = field.getName();
                Object value = field.get(entity);
                if (value == null) continue;
                result.put(name, new String[]{value.toString()});
            }
            return result;
        }
        catch (Exception e) {
            log.error("convertEntityToMap-error\uff1a", (Throwable)e);
            return new HashMap<String, String[]>();
        }
    }

    public IPage<PurchaseContractHeadDTO> getContact(Integer pageNo, Integer pageSize, PurchasePaymentApplyHead head) {
        IPage<PurchaseContractHeadDTO> purchaseContractHeadDTOIPage = this.financeInvokeContractRpcService.listContractItem(pageNo, pageSize, head.getElsAccount(), head.getToElsAccount(), head.getCompany(), head.getPurchaseOrg(), head.getPayWay(), head.getPaymentClause(), head.getKeyWord(), head.getCurrency());
        List records = purchaseContractHeadDTOIPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return purchaseContractHeadDTOIPage;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (PurchaseContractHeadDTO record : records) {
            idSet.add(record.getId());
        }
        Map<String, ElsPurchaseStatisticsSourceCase> map = this.getElsPurchaseStatisticsSourceCaseMap(idSet);
        for (PurchaseContractHeadDTO record : records) {
            ElsPurchaseStatisticsSourceCase sourceCase = map.get(record.getId());
            if (sourceCase == null) continue;
            record.setSourcePaidAmount(sourceCase.getSourcePaidAmount());
            record.setSourcePaymentAmount(sourceCase.getSourcePaymentAmount());
        }
        return purchaseContractHeadDTOIPage;
    }

    public IPage<PurchaseOrderHeadDTO> getOrder(Integer pageNo, Integer pageSize, PurchasePaymentApplyHead head) {
        PurchaseOrderHeadDTO queryDto = new PurchaseOrderHeadDTO();
        BeanUtils.copyProperties((Object)((Object)head), (Object)queryDto);
        queryDto.setPaymentWay(head.getPayWay());
        IPage<PurchaseOrderHeadDTO> purchaseOrderHeadDTOIPage = this.financeInvokeOrderRpcService.listOrderHead(queryDto, pageNo, pageSize);
        List records = purchaseOrderHeadDTOIPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return purchaseOrderHeadDTOIPage;
        }
        Set<String> idSet = records.stream().map(ParentEntityDTO::getId).collect(Collectors.toSet());
        Map<String, ElsPurchaseStatisticsSourceCase> map = this.getElsPurchaseStatisticsSourceCaseMap(idSet);
        for (PurchaseOrderHeadDTO record : records) {
            ElsPurchaseStatisticsSourceCase sourceCase = map.get(record.getId());
            if (sourceCase == null) continue;
            record.setSourcePaidAmount(sourceCase.getSourcePaidAmount());
            record.setSourcePaymentAmount(sourceCase.getSourcePaymentAmount());
        }
        return purchaseOrderHeadDTOIPage;
    }

    private Map<String, ElsPurchaseStatisticsSourceCase> getElsPurchaseStatisticsSourceCaseMap(Set<String> idSet) {
        HashMap<String, ElsPurchaseStatisticsSourceCase> map = new HashMap<String, ElsPurchaseStatisticsSourceCase>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", idSet);
        List list = this.elsPurchaseStatisticsSourceCaseService.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (ElsPurchaseStatisticsSourceCase sourceCase : list) {
                map.put(sourceCase.getSourceId(), sourceCase);
            }
        }
        return map;
    }

    @Override
    public void copyData(String id) {
        PurchasePaymentApplyHead purchasePaymentApplyHead = (PurchasePaymentApplyHead)((Object)this.purchasePaymentApplyHeadMapper.selectById((Serializable)((Object)id)));
        if (purchasePaymentApplyHead == null) {
            return;
        }
        PurchasePaymentApplyHead newPaymentApplyHead = new PurchasePaymentApplyHead();
        newPaymentApplyHead.setToElsAccount(purchasePaymentApplyHead.getToElsAccount());
        newPaymentApplyHead.setSupplierName(purchasePaymentApplyHead.getSupplierName());
        newPaymentApplyHead.setPurchaseName(purchasePaymentApplyHead.getPurchaseName());
        newPaymentApplyHead.setPaymentApplyType(purchasePaymentApplyHead.getPaymentApplyType());
        newPaymentApplyHead.setPaymentApplyDate(purchasePaymentApplyHead.getPaymentApplyDate());
        newPaymentApplyHead.setCompany(purchasePaymentApplyHead.getCompany());
        newPaymentApplyHead.setPurchaseOrg(purchasePaymentApplyHead.getPurchaseOrg());
        newPaymentApplyHead.setReceiverBankAccount(purchasePaymentApplyHead.getReceiverBankAccount());
        newPaymentApplyHead.setReceiverBank(purchasePaymentApplyHead.getReceiverBank());
        newPaymentApplyHead.setReceiverBankBccountName(purchasePaymentApplyHead.getReceiverBankBccountName());
        newPaymentApplyHead.setCurrency(purchasePaymentApplyHead.getCurrency());
        newPaymentApplyHead.setStandardCoin(purchasePaymentApplyHead.getStandardCoin());
        newPaymentApplyHead.setExchangeRate(purchasePaymentApplyHead.getExchangeRate());
        newPaymentApplyHead.setPayWay(purchasePaymentApplyHead.getPayWay());
        newPaymentApplyHead.setPaymentClause(purchasePaymentApplyHead.getPaymentClause());
        newPaymentApplyHead.setPaymentBenchmarkDate(purchasePaymentApplyHead.getPaymentBenchmarkDate());
        newPaymentApplyHead.setStretegyCode(purchasePaymentApplyHead.getStretegyCode());
        newPaymentApplyHead.setPurchasePrincipal(purchasePaymentApplyHead.getPurchasePrincipal());
        newPaymentApplyHead.setSalePrincipal(purchasePaymentApplyHead.getSalePrincipal());
        newPaymentApplyHead.setApplyExplain(purchasePaymentApplyHead.getApplyExplain());
        newPaymentApplyHead.setTemplateNumber(purchasePaymentApplyHead.getTemplateNumber());
        newPaymentApplyHead.setTemplateVersion(purchasePaymentApplyHead.getTemplateVersion());
        newPaymentApplyHead.setTemplateAccount(purchasePaymentApplyHead.getTemplateAccount());
        newPaymentApplyHead.setTemplateName(purchasePaymentApplyHead.getTemplateName());
        this.saveMain(newPaymentApplyHead, new PurchasePaymentApplyHeadVO());
    }

    @Override
    public PurchasePaymentApplyHeadVO extractAdvanceCharge(PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO) {
        String elsAccount = !StrUtil.isBlank((CharSequence)purchasePaymentApplyHeadVO.getElsAccount()) ? purchasePaymentApplyHeadVO.getElsAccount() : TenantContext.getTenant();
        PurchasePaymentApplyHead purchasePaymentApplyHead = new PurchasePaymentApplyHead();
        BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyHeadVO), (Object)((Object)purchasePaymentApplyHead));
        List<PurchasePaymentApplyWriteOff> prePaymentWriteOff = this.purchasePaymentApplyItemService.getPurchasePrePaymentWriteOffReconciliations(purchasePaymentApplyHead, elsAccount);
        purchasePaymentApplyHeadVO.setPaymentApplyWriteOffList(prePaymentWriteOff);
        return purchasePaymentApplyHeadVO;
    }

    @Override
    public JSONObject getRequestDataById(String id) {
        PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO = this.getMessageById(id);
        return ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)purchasePaymentApplyHeadVO, new DictTranslateAspectParam());
    }

    @Override
    public JSONArray getRequestDataById(List<String> ids) {
        DictTranslateAspectParam aspectParam = new DictTranslateAspectParam();
        JSONArray array = new JSONArray();
        ids.forEach(id -> {
            JSONObject obj = ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)this.getMessageById((String)id), aspectParam);
            array.add((Object)obj);
        });
        return array;
    }

    @Override
    public JSONObject getDataById(String id) {
        PurchasePaymentApplyHead purchasePaymentApplyHead = (PurchasePaymentApplyHead)((Object)this.getById((Serializable)((Object)id)));
        PurchasePaymentApplyHeadVO headVO = (PurchasePaymentApplyHeadVO)((Object)BeanUtil.copyProperties((Object)((Object)purchasePaymentApplyHead), PurchasePaymentApplyHeadVO.class, (String[])new String[0]));
        return ((DictTranslateService)SpringContextUtils.getBean(DictTranslateService.class)).parseJson((Object)headVO, new DictTranslateAspectParam());
    }

    private PurchasePaymentApplyHeadVO getMessageById(String id) {
        PurchasePaymentApplyHead purchasePaymentApplyHead = (PurchasePaymentApplyHead)((Object)this.getById((Serializable)((Object)id)));
        PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO = new PurchasePaymentApplyHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyHead), (Object)((Object)purchasePaymentApplyHeadVO));
        List<PurchasePaymentApplyItem> purchasePaymentApplyItemList = this.purchasePaymentApplyItemMapper.selectByMainId(id);
        purchasePaymentApplyHeadVO.setPaymentApplyItemList(purchasePaymentApplyItemList);
        return purchasePaymentApplyHeadVO;
    }
}

