/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheet;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetCalculateDetail;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetCertificate;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRegister;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleDetail;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleSupplement;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleThreshold;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetCalculateDetailService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetCertificateService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRegisterService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRuleDetailService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRuleSupplementService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRuleThresholdService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetService;
import com.els.modules.rebate.vo.CalculationSheetLadderVO;
import com.els.modules.rebate.vo.PurchaseRebateCalculationSheetVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u91c7\u8d2d\u8fd4\u5229\u8ba1\u7b97\u5355")
@RestController
@RequestMapping(value={"/finance/purchaseRebateCalculationSheet"})
public class PurchaseRebateCalculationSheetController
extends BaseController<PurchaseRebateCalculationSheet, PurchaseRebateCalculationSheetService> {
    @Autowired
    private PurchaseRebateCalculationSheetService purchaseRebateCalculationSheetService;
    @Autowired
    private PurchaseRebateCalculationSheetCalculateDetailService purchaseRebateCalculationSheetCalculateDetailService;
    @Autowired
    private PurchaseRebateCalculationSheetCertificateService purchaseRebateCalculationSheetCertificateService;
    @Autowired
    private PurchaseRebateCalculationSheetRegisterService purchaseRebateCalculationSheetRegisterService;
    @Autowired
    private PurchaseRebateCalculationSheetRuleDetailService purchaseRebateCalculationSheetRuleDetailService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchaseRebateCalculationSheetRuleThresholdService purchaseRebateCalculationSheetRuleThresholdService;
    @Autowired
    private PurchaseRebateCalculationSheetRuleSupplementService purchaseRebateCalculationSheetRuleSupplementService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_purchaseRebateCalculationSheet_";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"finance#purchaseRebateCalculationSheet:list"})
    @PermissionDataView(businessType="purchaseRebateCalculationSheet")
    public Result<?> queryPageList(PurchaseRebateCalculationSheet purchaseRebateCalculationSheet, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRebateCalculationSheet), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRebateCalculationSheetService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u8fd4\u5229\u8ba1\u7b97\u5355\u8868-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"finance#purchaseRebateCalculationSheet:add"})
    @FormCommit
    public Result<?> add(@RequestBody PurchaseRebateCalculationSheetVO vo) {
        PurchaseRebateCalculationSheet purchaseRebateCalculationSheet = new PurchaseRebateCalculationSheet();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseRebateCalculationSheet));
        this.checkData(vo);
        this.purchaseRebateCalculationSheetService.saveMain(vo, purchaseRebateCalculationSheet);
        return Result.ok((Object)((Object)purchaseRebateCalculationSheet));
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u8fd4\u5229\u8ba1\u7b97\u5355\u8868-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"finance#purchaseRebateCalculationSheet:edit"})
    public Result<?> edit(@RequestBody PurchaseRebateCalculationSheetVO vo) {
        PurchaseRebateCalculationSheet purchaseRebateCalculationSheet = new PurchaseRebateCalculationSheet();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseRebateCalculationSheet));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtdtiKRcsSTVBtk_8f177ea4", (String)"\u5f53\u524d\u8ba1\u7b97\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.checkData(vo);
            this.purchaseRebateCalculationSheetService.updateMain(vo, purchaseRebateCalculationSheet);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        String id = purchaseRebateCalculationSheet.getId();
        return this.queryById(id);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u8fd4\u5229\u8ba1\u7b97\u5355\u8868-\u8fd4\u5229\u767b\u8bb0")
    @Operation(summary="\u8fd4\u5229\u767b\u8bb0", description="\u8fd4\u5229\u767b\u8bb0")
    @PostMapping(value={"/rebateRegistration"})
    @RequiresPermissions(value={"finance#purchaseRebateCalculationSheet:rebateRegistration"})
    public Result<?> rebateRegistration(@RequestBody PurchaseRebateCalculationSheetVO vo) {
        PurchaseRebateCalculationSheet purchaseRebateCalculationSheet = new PurchaseRebateCalculationSheet();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseRebateCalculationSheet));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtdtiKRcsSTVBtk_8f177ea4", (String)"\u5f53\u524d\u8ba1\u7b97\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchaseRebateCalculationSheetService.rebateRegistration(vo, purchaseRebateCalculationSheet);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return this.commonSuccessResult(3);
    }

    private void checkData(PurchaseRebateCalculationSheetVO vo) {
        String rebateLadder;
        boolean rebateMethodFlag;
        boolean rebateConditionFlag;
        String rebateProduct;
        List<PurchaseRebateCalculationSheetRuleThreshold> thresholdList = vo.getRebateCalculationSheetRuleThresholds();
        List<PurchaseRebateCalculationSheetRuleDetail> detailList = vo.getRebateCalculationSheetRuleDetails();
        List<PurchaseRebateCalculationSheetRuleSupplement> supplementList = vo.getRebateCalculationSheetRuleSupplements();
        for (PurchaseRebateCalculationSheetRuleThreshold threshold : thresholdList) {
            boolean allTrueFlag;
            rebateProduct = threshold.getRebateProduct();
            String rebateType = threshold.getRebateType();
            String rebateCondition = threshold.getRebateCondition();
            String rebateMethod = threshold.getRebateMethod();
            BigDecimal thresholdValue = threshold.getThresholdValue();
            boolean rebateProductFlag = StrUtil.isBlank((CharSequence)rebateProduct);
            boolean rebateTypetFlag = StrUtil.isBlank((CharSequence)rebateType);
            rebateConditionFlag = StrUtil.isBlank((CharSequence)rebateCondition);
            rebateMethodFlag = StrUtil.isBlank((CharSequence)rebateMethod);
            boolean thresholdValueFlag = thresholdValue == null;
            boolean allFlag = rebateProductFlag || rebateTypetFlag || rebateConditionFlag || rebateMethodFlag || thresholdValueFlag;
            boolean bl = allTrueFlag = rebateProductFlag && rebateTypetFlag && rebateConditionFlag && rebateMethodFlag && thresholdValueFlag;
            if (!allFlag || allTrueFlag) continue;
            throw new ELSBootException("\u5df2\u8bbe\u7f6e\u90e8\u5206\u8fd4\u5229\u95e8\u69db\uff0c\u8bf7\u6309\u9700\u5b8c\u5584\u6216\u6e05\u7a7a");
        }
        for (PurchaseRebateCalculationSheetRuleDetail ruleDetail : detailList) {
            String rebateSettlementCycle = ruleDetail.getRebateSettlementCycle();
            if (StrUtil.isBlank((CharSequence)rebateSettlementCycle)) {
                throw new ELSBootException("\u8fd4\u5229\u7ed3\u7b97\u5468\u671f\u5fc5\u586b");
            }
            String progressiveApproach = ruleDetail.getProgressiveApproach();
            if (StrUtil.isBlank((CharSequence)progressiveApproach)) {
                throw new ELSBootException("\u7d2f\u8fdb\u65b9\u5f0f \u5fc5\u586b");
            }
            String pricingBasis = ruleDetail.getPricingBasis();
            if (StrUtil.isBlank((CharSequence)pricingBasis)) {
                throw new ELSBootException("\u8ba1\u4ef7\u57fa\u7840 \u5fc5\u586b");
            }
            String rebateCondition = ruleDetail.getRebateCondition();
            if (StrUtil.isBlank((CharSequence)rebateCondition)) {
                throw new ELSBootException("\u8fd4\u5229\u6761\u4ef6 \u5fc5\u586b");
            }
            rebateLadder = ruleDetail.getRebateLadder();
            if (StrUtil.isBlank((CharSequence)rebateLadder)) {
                throw new ELSBootException("\u8fd4\u5229\u9636\u68af \u5fc5\u586b");
            }
            try {
                JSON.parseArray((String)rebateLadder, CalculationSheetLadderVO.class);
            }
            catch (Exception e) {
                throw new ELSBootException("\u8fd4\u5229\u9636\u68af \u8f93\u5165\u4e0d\u6b63\u786e");
            }
        }
        for (PurchaseRebateCalculationSheetRuleSupplement supplement : supplementList) {
            boolean allTrueFlag;
            rebateProduct = supplement.getRebateProduct();
            String rebateCondition = supplement.getRebateCondition();
            String rebateMethod = supplement.getRebateMethod();
            BigDecimal thresholdValue = supplement.getThresholdValue();
            rebateLadder = supplement.getRebateLadder();
            String progressiveApproach = supplement.getProgressiveApproach();
            boolean rebateProductFlag = StrUtil.isBlank((CharSequence)rebateProduct);
            rebateConditionFlag = StrUtil.isBlank((CharSequence)rebateCondition);
            rebateMethodFlag = StrUtil.isBlank((CharSequence)rebateMethod);
            boolean rebateLadderFlag = StrUtil.isBlank((CharSequence)rebateLadder);
            boolean progressiveApproachFlag = StrUtil.isBlank((CharSequence)progressiveApproach);
            boolean thresholdValueFlag = thresholdValue == null;
            boolean allFlag = rebateProductFlag || rebateConditionFlag || rebateMethodFlag || rebateLadderFlag || progressiveApproachFlag || thresholdValueFlag;
            boolean bl = allTrueFlag = rebateProductFlag || rebateConditionFlag && rebateMethodFlag && rebateLadderFlag && progressiveApproachFlag && thresholdValueFlag;
            if (allFlag && !allTrueFlag) {
                throw new ELSBootException("\u5df2\u8bbe\u7f6e\u90e8\u5206\u8ffd\u52a0\u8fd4\u5229\u89c4\u5219\uff0c\u8bf7\u6309\u9700\u5b8c\u5584\u6216\u6e05\u7a7a");
            }
            try {
                JSON.parseArray((String)rebateLadder, CalculationSheetLadderVO.class);
            }
            catch (Exception e) {
                throw new ELSBootException("\u8ffd\u52a0\u8fd4\u5229\u9636\u68af \u8f93\u5165\u4e0d\u6b63\u786e");
            }
        }
    }

    @AutoLog(value="\u91c7\u8d2d\u8fd4\u5229\u8ba1\u7b97\u5355\u8868-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"finance#purchaseRebateCalculationSheet:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseRebateCalculationSheetService.delete(id);
        return this.commonSuccessResult(4);
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u8fd4\u5229\u89c4\u5219-\u53d1\u5e03", logType=2)
    @Operation(summary="\u53d1\u5e03", description="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"finance#purchaseRebateCalculationSheet:publish"})
    public Result<?> publish(@RequestBody PurchaseRebateCalculationSheetVO vo) {
        Result result = new Result();
        PurchaseRebateCalculationSheet purchaseRebateCalculationSheet = new PurchaseRebateCalculationSheet();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseRebateCalculationSheet));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtdtiKRcsSTVBtk_8f177ea4", (String)"\u5f53\u524d\u8ba1\u7b97\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            result = this.purchaseRebateCalculationSheetService.publish(purchaseRebateCalculationSheet, vo);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return result;
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"finance#purchaseRebateCalculationSheet:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseRebateCalculationSheetVO vo = new PurchaseRebateCalculationSheetVO();
        PurchaseRebateCalculationSheet purchaseRebateCalculationSheet = (PurchaseRebateCalculationSheet)((Object)this.purchaseRebateCalculationSheetService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        List<PurchaseRebateCalculationSheetCalculateDetail> calculateDetails = this.purchaseRebateCalculationSheetCalculateDetailService.selectByMainId(id);
        List<PurchaseRebateCalculationSheetCertificate> certificates = this.purchaseRebateCalculationSheetCertificateService.selectByMainId(id);
        List<PurchaseRebateCalculationSheetRegister> registers = this.purchaseRebateCalculationSheetRegisterService.selectByMainId(id);
        List<PurchaseRebateCalculationSheetRuleDetail> ruleDetails = this.purchaseRebateCalculationSheetRuleDetailService.selectByMainId(id);
        List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        List<PurchaseRebateCalculationSheetRuleThreshold> thresholds = this.purchaseRebateCalculationSheetRuleThresholdService.selectByMainId(id);
        List<PurchaseRebateCalculationSheetRuleSupplement> supplements = this.purchaseRebateCalculationSheetRuleSupplementService.selectByMainId(id);
        vo.setRebateCalculationSheetCalculateDetails(calculateDetails);
        vo.setRebateCalculationSheetCertificates(certificates);
        vo.setRebateCalculationSheetRegisters(registers);
        vo.setRebateCalculationSheetRuleDetails(ruleDetails);
        vo.setAttachments(attachments);
        vo.setRebateCalculationSheetRuleThresholds(thresholds);
        vo.setRebateCalculationSheetRuleSupplements(supplements);
        BeanUtils.copyProperties((Object)((Object)purchaseRebateCalculationSheet), (Object)((Object)vo));
        return Result.ok((Object)((Object)vo));
    }

    @AutoLog(value="\u8ba1\u7b97\u5355-\u63d0\u53d6\u89c4\u5219", logType=2)
    @Operation(summary="\u63d0\u53d6\u89c4\u5219", description="\u63d0\u53d6\u89c4\u5219")
    @PostMapping(value={"/extractRule"})
    @RequiresPermissions(value={"finance#purchaseRebateCalculationSheet:extractRule"})
    public Result<?> extractRule(@RequestBody PurchaseRebateCalculationSheetVO vo) {
        Date beginDate = vo.getBeginDate();
        Date endDate = vo.getEndDate();
        if (beginDate == null) {
            throw new ELSBootException("\u5355\u636e\u5f00\u59cb\u65e5\u671f \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (endDate == null) {
            throw new ELSBootException("\u5355\u636e\u7ed3\u675f\u65e5\u671f \u4e0d\u80fd\u4e3a\u7a7a");
        }
        PurchaseRebateCalculationSheetVO resultVO = this.purchaseRebateCalculationSheetService.extractRule(vo);
        return Result.ok((Object)((Object)resultVO));
    }

    @Operation(summary="SRM\u63a8\u9001\u5230ERP", description="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"finance#purchaseRebateCalculationSheet:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.purchaseRebateCalculationSheetService.pushDataToErp(ids);
        return Result.ok();
    }

    @Operation(summary="\u83b7\u53d6ERP\u6570\u636e", description="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"finance#purchaseRebateCalculationSheet:getDataByErp"})
    public Result<?> getDataByErp() {
        this.purchaseRebateCalculationSheetService.getDataByErp();
        return Result.ok();
    }

    @AutoLog(value="\u8ba1\u7b97\u5355-\u901a\u8fc7id\u4f5c\u5e9f")
    @Operation(summary="\u901a\u8fc7id\u4f5c\u5e9f", description="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/cancellation"})
    @RequiresPermissions(value={"finance#purchaseRebateCalculationSheet:cancellation"})
    public Result<?> cancellation(@RequestParam(name="id", required=true) String id) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, id, LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtdtiKRcsSTVBtk_8f177ea4", (String)"\u5f53\u524d\u8ba1\u7b97\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchaseRebateCalculationSheetService.cancellation(id);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, id);
        }
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u8ba1\u7b97\u5355-\u5f52\u6863")
    @Operation(summary="\u5f52\u6863", description="\u5f52\u6863")
    @GetMapping(value={"/archive"})
    @RequiresPermissions(value={"finance#purchaseRebateCalculationSheet:archive"})
    public Result<?> archive(@RequestParam(name="id", required=true) String id) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, id, LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtdtiKRcsSTVBtk_8f177ea4", (String)"\u5f53\u524d\u8ba1\u7b97\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchaseRebateCalculationSheetService.archive(id);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, id);
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u91c7\u8d2d\u8fd4\u5229\u8ba1\u7b97\u5355\u8868", value="\u590d\u5236")
    @Operation(summary="\u590d\u5236", description="\u590d\u5236")
    @GetMapping(value={"/copyData"})
    @RequiresPermissions(value={"finance#purchaseRebateCalculationSheet:copy"})
    public Result<?> copyData(@RequestParam(value="id") String id) {
        this.purchaseRebateCalculationSheetService.copyData(id);
        return Result.ok();
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"finance#purchaseRebateCalculationSheet:list"})
    @PermissionDataView(businessType="purchaseRebateCalculationSheet")
    public Result<?> counts(PurchaseRebateCalculationSheet purchaseRebateCalculationSheet, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRebateCalculationSheet), (Map)req.getParameterMap());
        queryWrapper.select((Object[])new String[]{"rebate_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"rebate_status");
        List list = ((PurchaseRebateCalculationSheetService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseRebateCalculationSheet::getRebateStatus, PurchaseRebateCalculationSheet::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "rebateStatus", null, (long)all.intValue()));
        List srmCalculationSheetStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmCalculationSheetStatus", TenantContext.getTenant());
        for (DictDTO status : srmCalculationSheetStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "rebateStatus", status.getValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }
}

