/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.rebate.entity.PurchaseRebateProgress;
import com.els.modules.rebate.entity.PurchaseRebateProgressRuleDetail;
import com.els.modules.rebate.entity.PurchaseRebateProgressSupplement;
import com.els.modules.rebate.entity.PurchaseRebateProgressThreshold;
import com.els.modules.rebate.entity.PurchaseRebateRuleItem;
import com.els.modules.rebate.entity.PurchaseRebateRuleSupplement;
import com.els.modules.rebate.entity.PurchaseRebateRuleThreshold;
import com.els.modules.rebate.enumerate.CalculationRebateFormEnum;
import com.els.modules.rebate.enumerate.CalculationRebateMethodEnum;
import com.els.modules.rebate.enumerate.CalculationRebatePayTypeEnum;
import com.els.modules.rebate.enumerate.CalculationRebateTypeEnum;
import com.els.modules.rebate.enumerate.CalculationSheetLadderEnum;
import com.els.modules.rebate.enumerate.RebateConditionEnum;
import com.els.modules.rebate.enumerate.RebateRuleProgressiveApproachEnum;
import com.els.modules.rebate.enumerate.RebateRuleSettlementCycleEnum;
import com.els.modules.rebate.service.PurchaseRebateProgressRuleDetailService;
import com.els.modules.rebate.service.PurchaseRebateProgressSupplementService;
import com.els.modules.rebate.service.PurchaseRebateProgressThresholdService;
import com.els.modules.rebate.utils.DateUtils;
import com.els.modules.rebate.vo.CalculationResultDTO;
import com.els.modules.rebate.vo.CalculationSheetLadderVO;
import com.els.modules.rebate.vo.PurchaseRebateProcessVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public abstract class PurchaseRebateProcessService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseRebateProcessService.class);
    @Autowired
    private PurchaseRebateProgressThresholdService thresholdService;
    @Autowired
    private PurchaseRebateProgressRuleDetailService ruleDetailService;
    @Autowired
    private PurchaseRebateProgressSupplementService supplementService;

    protected abstract CalculationResultDTO beforeCalculate(PurchaseRebateProgress var1, PurchaseRebateRuleItem var2);

    protected abstract CalculationResultDTO beforeCalculateThreshold(PurchaseRebateProgress var1, PurchaseRebateRuleThreshold var2);

    protected abstract CalculationResultDTO beforeCalculateSupplement(PurchaseRebateProgress var1, PurchaseRebateRuleSupplement var2);

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void calculateAll(PurchaseRebateProgress progress, PurchaseRebateProcessVO vo) {
        this.calculateThresholds(progress, vo.getThresholdList());
        BigDecimal totalRuleDetail = this.calculateDetail(progress, vo.getRuleItemList());
        BigDecimal totalSupplement = this.calculateSupplement(progress, vo.getSupplementList());
        BigDecimal totalRebate = BigDecimal.ZERO;
        totalRebate = totalRebate.add(totalRuleDetail).add(totalSupplement);
        String rebateForm = progress.getRebateForm();
        if (CalculationRebateFormEnum.PHYSICAL.getValue().equals(rebateForm)) {
            progress.setRebateQuantity(totalRebate);
        } else if (CalculationRebateFormEnum.OFFSET_PAYMENT.getValue().equals(rebateForm) || CalculationRebateFormEnum.COLLECTION.getValue().equals(rebateForm)) {
            progress.setRebateAmount(totalRebate);
        }
    }

    private BigDecimal calculateThresholds(PurchaseRebateProgress progress, List<PurchaseRebateRuleThreshold> thresholds) {
        BigDecimal totalRebate = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(thresholds)) {
            return totalRebate;
        }
        ArrayList<PurchaseRebateProgressThreshold> thresholdList = new ArrayList<PurchaseRebateProgressThreshold>();
        for (PurchaseRebateRuleThreshold threshold : thresholds) {
            CalculationResultDTO resultDTO = this.beforeCalculateThreshold(progress, threshold);
            if (BigDecimal.ZERO.compareTo(resultDTO.getTotalAmount()) == 0 && BigDecimal.ZERO.compareTo(resultDTO.getTotalNumber()) == 0) continue;
            totalRebate = this.calculateThresholds(totalRebate, threshold, resultDTO);
            PurchaseRebateProgressThreshold progressThreshold = new PurchaseRebateProgressThreshold();
            BeanUtils.copyProperties((Object)((Object)threshold), (Object)((Object)progressThreshold));
            progressThreshold.setId(null);
            progressThreshold.setCompletionRate(resultDTO.getCompletionRate());
            progressThreshold.setRuleNumber(progress.getRuleNumber());
            progressThreshold.setRuleName(progress.getRuleName());
            progressThreshold.setRuleItemNumber(threshold.getItemNumber());
            String beginDate = DateUtil.format((Date)progress.getBeginDate(), (String)"yyyy-MM-dd");
            String endDate = DateUtil.format((Date)progress.getEndDate(), (String)"yyyy-MM-dd");
            progressThreshold.setSpecificTaskPeriod(beginDate + " - " + endDate);
            progressThreshold.setCompletionNumberLastYear(resultDTO.getCompletionNumberLastYear());
            progressThreshold.setCompletionNumber(resultDTO.getCompletionNumber());
            progressThreshold.setTargetNumber(resultDTO.getTargetNumber());
            progressThreshold.setBusinessId(threshold.getId());
            String payType = StrUtil.isBlank((CharSequence)threshold.getPayType()) ? "" : threshold.getPayType();
            String rebateType = StrUtil.isBlank((CharSequence)threshold.getRebateType()) ? "" : threshold.getRebateType();
            String rebateCondition = StrUtil.isBlank((CharSequence)threshold.getRebateCondition()) ? "" : threshold.getRebateCondition();
            StringBuilder rebateTask = new StringBuilder();
            rebateTask.append("\u95e8\u69db\u5546\u54c1");
            if (CalculationRebateTypeEnum.MONEY_RETURN.getValue().equals(rebateType)) {
                rebateTask.append(CalculationRebatePayTypeEnum.parse(payType).getDesc());
            }
            if (!StrUtil.isBlank((CharSequence)rebateType)) {
                rebateTask.append(CalculationRebateTypeEnum.parse(rebateType).getDesc());
            }
            if (!StrUtil.isBlank((CharSequence)rebateCondition)) {
                rebateTask.append(RebateConditionEnum.parse(rebateCondition).getDesc());
                if (RebateConditionEnum.NUMBER.getValue().equals(rebateCondition)) {
                    rebateTask.append(progressThreshold.getTargetNumber().setScale(6, 1));
                } else if (RebateConditionEnum.AMOUNT.getValue().equals(rebateCondition)) {
                    rebateTask.append(progressThreshold.getTargetNumber().setScale(2, 1));
                }
            }
            progressThreshold.setRebateThresholdTask(rebateTask.toString());
            thresholdList.add(progressThreshold);
        }
        this.saveProgressThreshold(progress, thresholdList);
        return totalRebate;
    }

    private BigDecimal calculateSupplement(PurchaseRebateProgress progress, List<PurchaseRebateRuleSupplement> supplements) {
        BigDecimal totalRebate = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(supplements)) {
            return totalRebate;
        }
        ArrayList<PurchaseRebateProgressSupplement> supplementList = new ArrayList<PurchaseRebateProgressSupplement>();
        for (PurchaseRebateRuleSupplement supplement : supplements) {
            supplement.setRebateForm(progress.getRebateForm());
            CalculationResultDTO resultDTO = this.beforeCalculateSupplement(progress, supplement);
            if (BigDecimal.ZERO.compareTo(resultDTO.getTotalAmount()) == 0 && BigDecimal.ZERO.compareTo(resultDTO.getTotalNumber()) == 0) continue;
            totalRebate = this.calculateSupplement(totalRebate, supplement, resultDTO);
            PurchaseRebateProgressSupplement progressSupplement = new PurchaseRebateProgressSupplement();
            BeanUtils.copyProperties((Object)((Object)supplement), (Object)((Object)progressSupplement));
            progressSupplement.setId(null);
            progressSupplement.setCompletionRate(resultDTO.getCompletionRate());
            progressSupplement.setRuleNumber(progress.getRuleNumber());
            progressSupplement.setRuleName(progress.getRuleName());
            progressSupplement.setRuleItemNumber(supplement.getItemNumber());
            String beginDate = DateUtil.format((Date)progress.getBeginDate(), (String)"yyyy-MM-dd");
            String endDate = DateUtil.format((Date)progress.getEndDate(), (String)"yyyy-MM-dd");
            progressSupplement.setSpecificTaskPeriod(beginDate + " - " + endDate);
            String rebateCondition = supplement.getRebateCondition();
            if (RebateConditionEnum.AMOUNT.getValue().equals(rebateCondition)) {
                progressSupplement.setRebateAmount(resultDTO.getRebateAmount());
            } else if (RebateConditionEnum.NUMBER.getValue().equals(rebateCondition)) {
                progressSupplement.setRebateQuantity(resultDTO.getRebateNumber());
            }
            progressSupplement.setCompletionNumber(resultDTO.getCompletionNumber());
            progressSupplement.setTargetNumber(resultDTO.getTargetNumber());
            progressSupplement.setBusinessId(supplement.getId());
            String rebateType = supplement.getRebateType();
            StringBuilder rebateTask = new StringBuilder();
            rebateTask.append("\u8ffd\u52a0\u8fd4\u5229\u5546\u54c1");
            if (StrUtil.isBlank((CharSequence)rebateType)) {
                rebateTask.append(CalculationRebateTypeEnum.parse(rebateType).getDesc());
            }
            if (!StrUtil.isBlank((CharSequence)rebateCondition)) {
                rebateTask.append(RebateConditionEnum.parse(rebateCondition).getDesc());
                if (RebateConditionEnum.NUMBER.getValue().equals(rebateCondition)) {
                    rebateTask.append(progressSupplement.getTargetNumber().setScale(6, 1));
                } else if (RebateConditionEnum.AMOUNT.getValue().equals(rebateCondition)) {
                    rebateTask.append(progressSupplement.getTargetNumber().setScale(2, 1));
                }
            }
            progressSupplement.setRebateThresholdTask(rebateTask.toString());
            supplementList.add(progressSupplement);
        }
        this.saveProgressSupplement(progress, supplementList);
        return totalRebate;
    }

    private BigDecimal calculateDetail(PurchaseRebateProgress progress, List<PurchaseRebateRuleItem> details) {
        BigDecimal totalRebate = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(details)) {
            return totalRebate;
        }
        ArrayList<PurchaseRebateProgressRuleDetail> ruleDetailList = new ArrayList<PurchaseRebateProgressRuleDetail>();
        for (PurchaseRebateRuleItem rule : details) {
            rule.setRebateForm(progress.getRebateForm());
            CalculationResultDTO resultDTO = this.beforeCalculate(progress, rule);
            if (BigDecimal.ZERO.compareTo(resultDTO.getTotalAmount()) == 0 && BigDecimal.ZERO.compareTo(resultDTO.getTotalNumber()) == 0) continue;
            totalRebate = this.calculate(totalRebate, rule, resultDTO);
            PurchaseRebateProgressRuleDetail ruleDetail = new PurchaseRebateProgressRuleDetail();
            BeanUtils.copyProperties((Object)((Object)rule), (Object)((Object)ruleDetail));
            ruleDetail.setId(null);
            ruleDetail.setCompletionRate(resultDTO.getCompletionRate());
            ruleDetail.setRuleNumber(progress.getRuleNumber());
            ruleDetail.setRuleName(progress.getRuleName());
            ruleDetail.setRuleItemNumber(rule.getItemNumber());
            String beginDate = DateUtil.format((Date)progress.getBeginDate(), (String)"yyyy-MM-dd");
            String endDate = DateUtil.format((Date)progress.getEndDate(), (String)"yyyy-MM-dd");
            ruleDetail.setSpecificTaskPeriod(beginDate + " - " + endDate);
            String rebateCondition = rule.getRebateCondition();
            ruleDetail.setBusinessId(rule.getId());
            if (RebateConditionEnum.AMOUNT.getValue().equals(rebateCondition)) {
                ruleDetail.setRebateAmount(resultDTO.getRebateAmount());
            } else if (RebateConditionEnum.NUMBER.getValue().equals(rebateCondition)) {
                ruleDetail.setRebateQuantity(resultDTO.getRebateNumber());
            }
            ruleDetail.setCompletionNumber(resultDTO.getCompletionNumber());
            ruleDetail.setTargetNumber(resultDTO.getTargetNumber());
            ruleDetail.setTotalCompletionRate(resultDTO.getTotalCompletionRate());
            String rebateType = rule.getRebateType();
            StringBuilder rebateTask = new StringBuilder();
            rebateTask.append("\u8fd4\u5229\u5546\u54c1");
            if (!StrUtil.isBlank((CharSequence)rebateType)) {
                rebateTask.append(CalculationRebateTypeEnum.parse(rebateType).getDesc());
            }
            if (!StrUtil.isBlank((CharSequence)rebateCondition)) {
                rebateTask.append(RebateConditionEnum.parse(rebateCondition).getDesc());
            }
            if (RebateConditionEnum.NUMBER.getValue().equals(rebateCondition)) {
                totalNumber = resultDTO.getTotalNumber().setScale(6, 1);
                rebateTask.append(totalNumber);
            } else if (RebateConditionEnum.AMOUNT.getValue().equals(rebateCondition)) {
                totalNumber = resultDTO.getTotalNumber().setScale(2, 1);
                rebateTask.append(totalNumber);
            }
            if (!StrUtil.isBlank((CharSequence)rule.getProgressiveApproach())) {
                rebateTask.append(", ").append(RebateRuleProgressiveApproachEnum.parse(rule.getProgressiveApproach()).getDesc());
            }
            rebateTask.append("\u8fd4\u5229");
            CalculationSheetLadderVO currentLadder = resultDTO.getCurrentLadder();
            if (currentLadder != null) {
                if (!StrUtil.isBlank((CharSequence)currentLadder.getType())) {
                    rebateTask.append(CalculationSheetLadderEnum.parse(currentLadder.getType()).getDesc());
                    if (CalculationSheetLadderEnum.RATE.getValue().equals("" + currentLadder.getRate())) {
                        rebateTask.append(currentLadder.getRate()).append("%");
                    } else {
                        rebateTask.append(currentLadder.getRate());
                    }
                } else {
                    if (currentLadder.getUnion() != null) {
                        rebateTask.append(CalculationSheetLadderEnum.UNION.getDesc()).append(currentLadder.getUnion()).append("  ");
                    }
                    if (currentLadder.getRate() != null) {
                        rebateTask.append(CalculationSheetLadderEnum.RATE.getDesc()).append(currentLadder.getRate()).append("  ");
                    }
                    if (currentLadder.getFix() != null) {
                        rebateTask.append(CalculationSheetLadderEnum.FIX.getDesc()).append(currentLadder.getFix()).append("  ");
                    }
                }
            }
            ruleDetail.setRebateLadderTask(rebateTask.toString());
            ruleDetail.setCompletedLadderTask(rebateTask.toString());
            ruleDetailList.add(ruleDetail);
        }
        this.saveProgressRuleDetail(progress, ruleDetailList);
        return totalRebate;
    }

    private BigDecimal calculateSupplement(BigDecimal rebateAmount, PurchaseRebateRuleSupplement supplement, CalculationResultDTO resultDTO) {
        BigDecimal totalAmount = resultDTO.getTotalAmount();
        BigDecimal totalNumber = resultDTO.getTotalNumber();
        BigDecimal rebate = BigDecimal.ZERO;
        if (RebateConditionEnum.AMOUNT.getValue().equals(supplement.getRebateCondition())) {
            rebate = totalAmount;
        } else if (RebateConditionEnum.NUMBER.getValue().equals(supplement.getRebateCondition())) {
            rebate = totalNumber;
        }
        resultDTO.setCompletionNumber(rebate);
        resultDTO.setCompletionNumber(rebate);
        BigDecimal thresholdValue = supplement.getThresholdValue();
        this.handleRebateMethod(resultDTO, rebate, thresholdValue, supplement.getRebateMethod());
        if (BigDecimal.ONE.compareTo(resultDTO.getCompletionRate()) != 0) {
            return rebateAmount;
        }
        String rebateLadder = supplement.getRebateLadder();
        List sheetLadderVOList = JSON.parseArray((String)rebateLadder, CalculationSheetLadderVO.class);
        String progressiveApproach = supplement.getProgressiveApproach();
        BigDecimal current = BigDecimal.ZERO;
        if (RebateRuleProgressiveApproachEnum.FULLY_PROGRESSIVE.getValue().equals(progressiveApproach)) {
            current = this.fullyProgressiveCalculation(sheetLadderVOList, totalAmount, totalNumber, supplement.getRebateForm());
        } else if (RebateRuleProgressiveApproachEnum.OVER_PROGRESSIVE.getValue().equals(progressiveApproach)) {
            current = this.overProgressiveCalculation(sheetLadderVOList, totalAmount, totalNumber, supplement.getRebateForm());
        }
        resultDTO.setRebateAmount(current);
        rebateAmount = rebateAmount.add(current);
        return rebateAmount;
    }

    private BigDecimal calculateThresholds(BigDecimal rebateAmount, PurchaseRebateRuleThreshold threshold, CalculationResultDTO resultDTO) {
        BigDecimal totalAmount = resultDTO.getTotalAmount();
        BigDecimal totalNumber = resultDTO.getTotalNumber();
        BigDecimal rebate = BigDecimal.ZERO;
        if (RebateConditionEnum.AMOUNT.getValue().equals(threshold.getRebateCondition())) {
            rebate = totalAmount;
        } else if (RebateConditionEnum.NUMBER.getValue().equals(threshold.getRebateCondition())) {
            rebate = totalNumber;
        }
        resultDTO.setCompletionNumber(rebate);
        BigDecimal thresholdValue = threshold.getThresholdValue();
        this.handleRebateMethod(resultDTO, rebate, thresholdValue, threshold.getRebateMethod());
        return rebateAmount;
    }

    private void handleRebateMethod(CalculationResultDTO resultDTO, BigDecimal rebate, BigDecimal thresholdValue, String rebateMethod) {
        if (CalculationRebateMethodEnum.FIX.getValue().equals(rebateMethod)) {
            BigDecimal temp = rebate.subtract(thresholdValue);
            temp = this.handleScientificNotation(temp);
            resultDTO.setTargetNumber(thresholdValue);
            if (BigDecimal.ZERO.compareTo(temp) <= 0) {
                resultDTO.setCompletionRate(BigDecimal.ONE);
            } else {
                BigDecimal completionRate = rebate.divide(thresholdValue, 4, 4);
                resultDTO.setCompletionRate(completionRate);
            }
        } else if (CalculationRebateMethodEnum.RATE.getValue().equals(rebateMethod)) {
            BigDecimal temp = rebate.multiply(thresholdValue);
            BigDecimal result = rebate.subtract(temp);
            result = this.handleScientificNotation(result);
            resultDTO.setTargetNumber(temp);
            if (BigDecimal.ZERO.compareTo(result) <= 0) {
                resultDTO.setCompletionRate(BigDecimal.ONE);
            } else {
                BigDecimal completionRate = rebate.divide(temp, 4, 4);
                resultDTO.setCompletionRate(completionRate);
            }
        }
    }

    private BigDecimal calculate(BigDecimal rebateAmount, PurchaseRebateRuleItem rule, CalculationResultDTO resultDTO) {
        BigDecimal totalAmount = resultDTO.getTotalAmount();
        BigDecimal totalNumber = resultDTO.getTotalNumber();
        String rebateLadder = rule.getRebateLadder();
        List sheetLadderVOList = JSON.parseArray((String)rebateLadder, CalculationSheetLadderVO.class);
        BigDecimal completionCount = BigDecimal.ZERO;
        if (RebateConditionEnum.AMOUNT.getValue().equals(rule.getRebateCondition())) {
            completionCount = totalAmount;
        } else if (RebateConditionEnum.NUMBER.getValue().equals(rule.getRebateCondition())) {
            completionCount = totalNumber;
        }
        resultDTO.setCompletionNumber(completionCount);
        this.calculateCompletionRate(sheetLadderVOList, resultDTO, completionCount);
        String progressiveApproach = rule.getProgressiveApproach();
        BigDecimal current = BigDecimal.ZERO;
        if (RebateRuleProgressiveApproachEnum.FULLY_PROGRESSIVE.getValue().equals(progressiveApproach)) {
            current = this.fullyProgressiveCalculation(sheetLadderVOList, totalAmount, totalNumber, rule.getRebateForm());
        } else if (RebateRuleProgressiveApproachEnum.OVER_PROGRESSIVE.getValue().equals(progressiveApproach)) {
            current = this.overProgressiveCalculation(sheetLadderVOList, totalAmount, totalNumber, rule.getRebateForm());
        }
        resultDTO.setRebateAmount(current);
        rebateAmount = rebateAmount.add(current);
        return rebateAmount;
    }

    private BigDecimal fullyProgressiveCalculation(List<CalculationSheetLadderVO> sheetLadderVOList, BigDecimal amount, BigDecimal number, String rebateForm) {
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal maxValue = BigDecimal.ZERO;
        if (CalculationRebateFormEnum.PHYSICAL.getValue().equals(rebateForm)) {
            maxValue = number;
        } else if (CalculationRebateFormEnum.OFFSET_PAYMENT.getValue().equals(rebateForm) || CalculationRebateFormEnum.COLLECTION.getValue().equals(rebateForm)) {
            maxValue = amount;
        }
        Collections.reverse(sheetLadderVOList);
        CalculationSheetLadderVO fullVo = null;
        for (CalculationSheetLadderVO vo : sheetLadderVOList) {
            BigDecimal max;
            BigDecimal min = vo.getMin() == null ? BigDecimal.ZERO : vo.getMin();
            BigDecimal bigDecimal = max = vo.getMax() == null ? BigDecimal.ZERO : vo.getMax();
            if (maxValue.compareTo(min) < 0) {
                log.info("rebate:  \u8fd4\u5229\u503c: " + maxValue + ",\u4f4e\u4e8e\u8303\u56f4, min: " + min + "max: " + max);
                continue;
            }
            fullVo = vo;
            break;
        }
        if (fullVo == null) {
            return total;
        }
        if (CalculationSheetLadderEnum.FIX.getValue().equals(fullVo.getType())) {
            BigDecimal fix = fullVo.getFix() == null ? BigDecimal.ZERO : fullVo.getFix();
            total = total.add(fix);
        } else if (CalculationSheetLadderEnum.RATE.getValue().equals(fullVo.getType())) {
            BigDecimal rate = fullVo.getRate();
            if (rate == null || BigDecimal.ZERO.compareTo(rate) == 0) {
                throw new ELSBootException("\u6bd4\u4f8b\u503c\u4e0d\u80fd\u4e3a0 ");
            }
            currency = maxValue.multiply(rate).multiply(new BigDecimal("0.01"));
            total = total.add(currency);
        } else if (CalculationSheetLadderEnum.UNION.getValue().equals(fullVo.getType())) {
            maxValue = number;
            BigDecimal union = fullVo.getUnion();
            if (BigDecimal.ZERO.compareTo(union) == 0) {
                throw new ELSBootException("\u6bcf\u5355\u4f4d\u4e0d\u80fd\u4e3a0");
            }
            currency = maxValue.multiply(union);
            total = total.add(currency);
        } else {
            BigDecimal fixRebate = fullVo.getFix() == null ? BigDecimal.ZERO : fullVo.getFix();
            BigDecimal rateRebate = BigDecimal.ZERO;
            BigDecimal rate = fullVo.getRate();
            if (rate != null && BigDecimal.ZERO.compareTo(rate) != 0) {
                rateRebate = maxValue.multiply(rate).multiply(new BigDecimal("0.01"));
            }
            BigDecimal unionRebate = BigDecimal.ZERO;
            maxValue = number;
            BigDecimal union = fullVo.getUnion();
            if (union != null && BigDecimal.ZERO.compareTo(union) != 0) {
                unionRebate = maxValue.multiply(union);
            }
            total = total.add(fixRebate);
            total = total.add(rateRebate);
            total = total.add(unionRebate);
        }
        if (CalculationRebateFormEnum.PHYSICAL.getValue().equals(rebateForm)) {
            total = total.setScale(6, 4);
        } else if (CalculationRebateFormEnum.OFFSET_PAYMENT.getValue().equals(rebateForm) || CalculationRebateFormEnum.COLLECTION.getValue().equals(rebateForm)) {
            total = total.setScale(2, 4);
        }
        log.info("rebate:  final total : " + total);
        return total;
    }

    private BigDecimal overProgressiveCalculation(List<CalculationSheetLadderVO> sheetLadderVOList, BigDecimal amount, BigDecimal number, String rebateForm) {
        BigDecimal difference = BigDecimal.ZERO;
        BigDecimal differenceTotal = BigDecimal.ZERO;
        BigDecimal total = BigDecimal.ZERO;
        Collections.reverse(sheetLadderVOList);
        for (CalculationSheetLadderVO vo : sheetLadderVOList) {
            BigDecimal currency;
            BigDecimal union;
            BigDecimal max = vo.getMax() == null ? BigDecimal.ZERO : vo.getMax();
            BigDecimal min = vo.getMin() == null ? BigDecimal.ZERO : vo.getMin();
            BigDecimal rate = vo.getRate() == null ? BigDecimal.ZERO : vo.getRate();
            BigDecimal fix = vo.getFix() == null ? BigDecimal.ZERO : vo.getFix();
            BigDecimal bigDecimal = union = vo.getUnion() == null ? BigDecimal.ZERO : vo.getUnion();
            if (CalculationRebateFormEnum.PHYSICAL.getValue().equals(rebateForm)) {
                if (number.compareTo(min) < 0) {
                    log.info("rebate: \u8fd4\u5229\u503c: " + number + ",\u4f4e\u4e8e\u8303\u56f4, min: " + min + "max: " + max);
                    continue;
                }
                difference = number.subtract(min).subtract(differenceTotal);
                difference = this.handleScientificNotation(difference);
            } else if (CalculationRebateFormEnum.OFFSET_PAYMENT.getValue().equals(rebateForm) || CalculationRebateFormEnum.COLLECTION.getValue().equals(rebateForm)) {
                if (amount.compareTo(min) < 0) {
                    log.info("rebate: \u8fd4\u5229\u503c: " + amount + ",\u4f4e\u4e8e\u8303\u56f4, min: " + min + "max: " + max);
                    continue;
                }
                difference = amount.subtract(min).subtract(differenceTotal);
                difference = this.handleScientificNotation(difference);
            }
            differenceTotal = differenceTotal.add(difference);
            if (BigDecimal.ZERO.compareTo(difference) == 0) continue;
            if (CalculationSheetLadderEnum.FIX.getValue().equals(vo.getType())) {
                total = total.add(fix);
                log.info("rebate: \u6309\u56fa\u5b9a\u503c\u8fdb\u884c\u8fd4\u5229,  fix: " + fix);
                continue;
            }
            if (CalculationSheetLadderEnum.RATE.getValue().equals(vo.getType())) {
                if (BigDecimal.ZERO.compareTo(rate) == 0) continue;
                currency = difference.multiply(rate).multiply(new BigDecimal("0.01"));
                total = total.add(currency);
                log.info("rebate: \u6309\u6bd4\u4f8b\u8fdb\u884c\u8fd4\u5229,  difference: " + difference + "  differenceTotal: " + differenceTotal + "   currency: " + currency + "rate: " + rate);
                continue;
            }
            if (CalculationSheetLadderEnum.UNION.getValue().equals(vo.getType())) {
                if (BigDecimal.ZERO.compareTo(union) == 0) continue;
                currency = difference.multiply(union);
                total = total.add(currency);
                log.info("rebate: \u6309\u6bcf\u5355\u4f4d\u8fdb\u884c\u8fd4\u5229,  difference: " + difference + "  differenceTotal: " + differenceTotal + "   currency: " + currency + "  union: " + union);
                continue;
            }
            BigDecimal fixRebate = vo.getFix() == null ? BigDecimal.ZERO : vo.getFix();
            BigDecimal rateRebate = BigDecimal.ZERO;
            if (rate != null && BigDecimal.ZERO.compareTo(rate) != 0) {
                rateRebate = difference.multiply(rate).multiply(new BigDecimal("0.01"));
            }
            BigDecimal unionRebate = BigDecimal.ZERO;
            if (union != null && BigDecimal.ZERO.compareTo(union) != 0) {
                unionRebate = difference.multiply(union);
            }
            total = total.add(fixRebate);
            total = total.add(rateRebate);
            total = total.add(unionRebate);
        }
        if (CalculationRebateFormEnum.PHYSICAL.getValue().equals(rebateForm)) {
            total = total.setScale(6, 4);
        } else if (CalculationRebateFormEnum.OFFSET_PAYMENT.getValue().equals(rebateForm) || CalculationRebateFormEnum.COLLECTION.getValue().equals(rebateForm)) {
            total = total.setScale(2, 4);
        }
        log.info("rebate: final total : " + total);
        return total;
    }

    public void calculateCompletionRate(List<CalculationSheetLadderVO> sheetLadderVOList, CalculationResultDTO resultDTO, BigDecimal completionCount) {
        BigDecimal totalCompletionRate = BigDecimal.ZERO;
        for (CalculationSheetLadderVO ladderVO : sheetLadderVOList) {
            BigDecimal min = ladderVO.getMin() == null ? BigDecimal.ZERO : ladderVO.getMin();
            BigDecimal temp = completionCount.subtract(min);
            temp = this.handleScientificNotation(temp);
            resultDTO.setCurrentLadder(ladderVO);
            if (BigDecimal.ZERO.compareTo(temp) <= 0) {
                totalCompletionRate = totalCompletionRate.add(BigDecimal.ONE);
                resultDTO.setCompletionRate(totalCompletionRate);
                continue;
            }
            BigDecimal currentCompletionRate = completionCount.divide(min, 4, 4);
            totalCompletionRate = totalCompletionRate.add(currentCompletionRate);
            resultDTO.setCompletionRate(currentCompletionRate);
            resultDTO.setTargetNumber(min);
            break;
        }
        resultDTO.setTotalCompletionRate(totalCompletionRate);
    }

    protected BigDecimal handleScientificNotation(BigDecimal number) {
        return number.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : number;
    }

    protected Date handleCalculationSheetEndDate(String rebateSettlementCycle, Date endDate) {
        Date calculationSheetEndDate = null;
        if (RebateRuleSettlementCycleEnum.RANDOM.getValue().equals(rebateSettlementCycle)) {
            return null;
        }
        if (RebateRuleSettlementCycleEnum.MONTH.getValue().equals(rebateSettlementCycle)) {
            calculationSheetEndDate = DateUtils.getMonth(endDate);
        } else if (RebateRuleSettlementCycleEnum.QUARTER.getValue().equals(rebateSettlementCycle)) {
            calculationSheetEndDate = DateUtils.getQuarter(endDate);
        } else if (RebateRuleSettlementCycleEnum.HALF_YEAR.getValue().equals(rebateSettlementCycle)) {
            calculationSheetEndDate = DateUtils.getHalfYear(endDate);
        } else if (RebateRuleSettlementCycleEnum.YEAR.getValue().equals(rebateSettlementCycle)) {
            calculationSheetEndDate = DateUtils.getYear(endDate);
        }
        return calculationSheetEndDate;
    }

    private void saveProgressSupplement(PurchaseRebateProgress purchaseRebateProgress, List<PurchaseRebateProgressSupplement> rebateProgressSupplements) {
        if (CollectionUtils.isEmpty(rebateProgressSupplements)) {
            return;
        }
        for (PurchaseRebateProgressSupplement entity : rebateProgressSupplements) {
            entity.setHeadId(purchaseRebateProgress.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseRebateProgress);
        }
        this.supplementService.saveBatch(rebateProgressSupplements, 2000);
    }

    private void saveProgressRuleDetail(PurchaseRebateProgress purchaseRebateProgress, List<PurchaseRebateProgressRuleDetail> rebateProgressRuleDetails) {
        if (CollectionUtils.isEmpty(rebateProgressRuleDetails)) {
            return;
        }
        for (PurchaseRebateProgressRuleDetail entity : rebateProgressRuleDetails) {
            entity.setHeadId(purchaseRebateProgress.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseRebateProgress);
        }
        this.ruleDetailService.saveBatch(rebateProgressRuleDetails, 2000);
    }

    private void saveProgressThreshold(PurchaseRebateProgress purchaseRebateProgress, List<PurchaseRebateProgressThreshold> rebateProgressThresholds) {
        if (CollectionUtils.isEmpty(rebateProgressThresholds)) {
            return;
        }
        for (PurchaseRebateProgressThreshold entity : rebateProgressThresholds) {
            entity.setHeadId(purchaseRebateProgress.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseRebateProgress);
        }
        this.thresholdService.saveBatch(rebateProgressThresholds, 2000);
    }
}

