/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.controller;

import com.els.common.api.vo.Result;
import com.els.common.system.vo.LoginUser;
import com.els.modules.im.core.tio.StartTioRunner;
import com.els.modules.im.entity.ImGroup;
import com.els.modules.im.service.IImChatGroupService;
import com.els.modules.im.service.IImChatGroupUserService;
import com.els.modules.im.service.IImGroupService;
import com.els.modules.im.service.IImMessageService;
import com.els.modules.im.service.IImUserFriendService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/im/userGroup"})
@Api(tags={"IM\u7528\u6237"})
public class ImUserGroupController {
    private static final Logger log = LoggerFactory.getLogger(ImUserGroupController.class);
    @Resource
    private StartTioRunner startTioRunner;
    @Resource(name="imUserFriendServiceImpl")
    private IImUserFriendService imUserFriendService;
    @Resource(name="imChatGroupUserServiceImpl")
    private IImChatGroupUserService imChatGroupUserService;
    @Resource(name="imMessageServiceImpl")
    private IImMessageService iImMessageService;
    @Resource(name="imChatGroupServiceImpl")
    private IImChatGroupService imChatGroupService;
    @Resource(name="imGroupServiceImpl")
    private IImGroupService iImGroupService;

    @PostMapping(value={"/add"})
    @ApiOperation(value="IM-\u6dfb\u52a0\u5206\u7ec4", notes="IM-\u6dfb\u52a0\u5206\u7ec4")
    public Result<?> add(@RequestParam(name="groupName") String groupName) {
        log.debug("\u6dfb\u52a0\u597d\u53cb\u5206\u7ec4:{}", (Object)groupName);
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        ImGroup imGroup = this.iImGroupService.addGroup(sysUser.getId(), groupName);
        return Result.ok((Object)imGroup);
    }

    @PostMapping(value={"/rename"})
    @ApiOperation(value="IM-\u5206\u7ec4\u91cd\u547d\u540d", notes="IM-\u5206\u7ec4\u91cd\u547d\u540d")
    public Result<?> rename(@RequestParam(name="groupId") String groupId, @RequestParam(name="groupName") String groupName) {
        log.debug("\u91cd\u547d\u540d\u597d\u53cb\u5206\u7ec4:{},{}", (Object)groupId, (Object)groupName);
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.iImGroupService.rename(groupId, sysUser.getId(), groupName);
        return Result.ok();
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="IM-\u597d\u53cb\u5206\u7ec4\u5220\u9664", notes="IM-\u597d\u53cb\u5206\u7ec4\u5220\u9664")
    public Result<?> deleteGroup(@RequestParam(name="groupId") String groupId) {
        log.debug("\u5220\u9664\u540d\u597d\u53cb\u5206\u7ec4:{}", (Object)groupId);
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.iImGroupService.deleteGroup(sysUser.getId(), groupId);
        return Result.ok();
    }

    @PostMapping(value={"/moveFriendToGroup"})
    @ApiOperation(value="IM-\u79fb\u52a8\u7528\u6237\u5230\u5206\u7ec4", notes="IM-\u79fb\u52a8\u7528\u6237\u5230\u5206\u7ec4")
    public Result<?> moveFriendToGroup(@RequestParam(name="friendId") String friendId, @RequestParam(name="groupId") String groupId) {
        log.debug("\u79fb\u52a8\u597d\u53cb\u5230\u5206\u7ec4:friendId:{},groupId:{}", (Object)friendId, (Object)groupId);
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.imUserFriendService.moveFriendToGroup(sysUser.getId(), friendId, groupId);
        return Result.ok();
    }

    @PostMapping(value={"/groupUpAndDown"})
    @ApiOperation(value="IM-\u5206\u7ec4\u4e0a\u4e0b\u79fb\u52a8", notes="IM-\u5206\u7ec4\u4e0a\u4e0b\u79fb\u52a8")
    public Result<?> groupUpAndDown(@RequestParam(name="moveGroupId") String moveGroupId, @RequestParam(name="targetGroupId") String targetGroupId) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.iImGroupService.groupUpAndDown(sysUser.getId(), moveGroupId, targetGroupId);
        return Result.ok();
    }

    @PostMapping(value={"/groupDrag"})
    @ApiOperation(value="IM-\u5206\u7ec4\u62d6\u62fd", notes="IM-\u5206\u7ec4\u62d6\u62fd")
    public Result<?> groupDrag(@RequestBody List<String> imGroups) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.iImGroupService.groupDrag(sysUser.getId(), imGroups);
        return Result.ok();
    }
}

