/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.controller;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.im.core.ImMessageInfo;
import com.els.modules.im.entity.ImMessage;
import com.els.modules.im.rpc.service.InvokeImAccountRpcService;
import com.els.modules.im.service.IImMessageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/im/message"})
@Api(tags={"IM\u6d88\u606f"})
public class ImMessageController {
    public static final int PAGE_SIZE = 20;
    public static final String FRIEND = "friend";
    @Resource(name="imMessageServiceImpl")
    private IImMessageService iImMessageService;
    @Resource
    private InvokeImAccountRpcService imAccountRpcService;

    @ResponseBody
    @GetMapping(value={"list"})
    @ApiOperation(value="IM-\u83b7\u53d6\u804a\u5929\u8bb0\u5f55", notes="IM-\u83b7\u53d6\u804a\u5929\u8bb0\u5f55")
    public Map<String, Object> list(@RequestParam(name="chatId") String chatId, @RequestParam(name="fromId") String fromId, @RequestParam(name="chatType") String chatType, @RequestParam(name="pageNo") Long pageNo) {
        if (CharSequenceUtil.isEmpty((CharSequence)chatId) || CharSequenceUtil.isEmpty((CharSequence)fromId)) {
            return new HashMap<String, Object>();
        }
        Page page = new Page();
        page.setSize(20L);
        if (pageNo == null) {
            pageNo = 0L;
        }
        page.setCurrent(pageNo.longValue());
        page.setDesc(new String[]{"send_time"});
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (FRIEND.equals(chatType) || "customer".equals(chatType)) {
            wrapper.and(wrapper1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(ImMessage::getToId, (Object)chatId)).eq(ImMessage::getFromId, (Object)fromId);
            });
            wrapper.or(wrapper2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(ImMessage::getFromId, (Object)chatId)).eq(ImMessage::getToId, (Object)fromId);
            });
        } else {
            wrapper.eq(ImMessage::getToId, (Object)chatId);
        }
        wrapper.eq(ImMessage::getType, (Object)chatType);
        IPage messagePage = this.iImMessageService.page((IPage)page, (Wrapper)wrapper);
        List imMessageList = messagePage.getRecords();
        ArrayList<ImMessageInfo> messageList = new ArrayList<ImMessageInfo>();
        for (ImMessage imMessage : imMessageList) {
            ImMessageInfo message = new ImMessageInfo();
            message.setId(imMessage.getToId());
            message.setMine(fromId.equals(imMessage.getFromId()));
            message.setType("customer".equals(message.getType()) ? FRIEND : message.getType());
            ImUserDTO imUser = this.imAccountRpcService.getImUserById(imMessage.getFromId());
            if (imUser != null) {
                message.setAvatar(imUser.getAvatar());
                message.setUsername(imUser.getUsername());
            }
            message.setFromid(imMessage.getFromId());
            if ("customer".equals(chatType)) {
                message.setCid("kefu");
            } else {
                message.setCid(String.valueOf(imMessage.getId()));
            }
            message.setContent(imMessage.getContent());
            message.setTimestamp(imMessage.getSendTime());
            messageList.add(message);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("messageList", messageList);
        map.put("pageNo", pageNo);
        map.put("count", messagePage.getTotal());
        map.put("pageSize", messagePage.getSize());
        return map;
    }
}

