/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.modules.im.entity.ImMessage;
import com.els.modules.im.mapper.ImMessageMapper;
import com.els.modules.im.service.IImMessageService;
import java.util.List;
import org.springframework.stereotype.Service;

@Service(value="imMessageServiceImpl")
public class ImMessageServiceImpl
extends ServiceImpl<ImMessageMapper, ImMessage>
implements IImMessageService {
    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveMessage(ImMessage imMessage) {
        new SaveChatMessageThread(imMessage).run();
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public List<ImMessage> getUnReadMessage(String toId, String type) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.eq(ImMessage::getToId, (Object)toId)).eq(ImMessage::getReadStatus, (Object)"1");
        if ("customer".equals(type)) {
            queryWrapper.eq(ImMessage::getType, (Object)"customer");
        } else {
            queryWrapper.ne(ImMessage::getType, (Object)"customer");
        }
        List messageList = ((ImMessageMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        for (ImMessage message : messageList) {
            message.setReadStatus("0");
            this.updateById(message);
        }
        return messageList;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public List<ImMessage> getChatLog(String toId, String type) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.eq(ImMessage::getToId, (Object)toId)).eq(ImMessage::getType, (Object)type);
        return ((ImMessageMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    class SaveChatMessageThread
    implements Runnable {
        private ImMessage imMessage;

        public SaveChatMessageThread(ImMessage imMessage) {
            this.imMessage = imMessage;
        }

        @Override
        public void run() {
            ImMessageServiceImpl.this.save(this.imMessage);
        }
    }
}

