/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.im.core.tio.WsOnlineContext;
import com.els.modules.im.entity.ImChatGroup;
import com.els.modules.im.entity.ImChatGroupUser;
import com.els.modules.im.mapper.ImChatGroupMapper;
import com.els.modules.im.mapper.ImChatGroupUserMapper;
import com.els.modules.im.service.IImChatGroupService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;

@Service(value="imChatGroupServiceImpl")
public class ImChatGroupServiceImpl
extends ServiceImpl<ImChatGroupMapper, ImChatGroup>
implements IImChatGroupService {
    @Autowired
    private ImChatGroupUserMapper imChatGroupUserMapper;

    @Override
    public List<ImChatGroup> getChatGroups(String userId) {
        return ((ImChatGroupMapper)this.baseMapper).getUserGroups(userId);
    }

    @Override
    public ImChatGroup createChatGroup(String chatGroupId, String chatGroupName, String remark, boolean binding) {
        LoginUser sysUser = SysUtil.getLoginUser();
        ImChatGroup imChatGroup = new ImChatGroup();
        imChatGroup.setGroupname(chatGroupName);
        imChatGroup.setMaster(sysUser.getId());
        imChatGroup.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
        imChatGroup.setRemarks(remark);
        if (StrUtil.isNotBlank((CharSequence)chatGroupId)) {
            imChatGroup.setId(chatGroupId);
        }
        ((ImChatGroupMapper)this.baseMapper).insert(imChatGroup);
        ImChatGroupUser chatGroupUser = new ImChatGroupUser();
        chatGroupUser.setChatGroupId(imChatGroup.getId());
        chatGroupUser.setUserId(sysUser.getId());
        chatGroupUser.setCreateDate(new Date());
        this.imChatGroupUserMapper.insert(chatGroupUser);
        ChannelContext channelContext = WsOnlineContext.getChannelContextByUser(sysUser.getId());
        if (binding && null != channelContext) {
            Tio.bindGroup((ChannelContext)channelContext, (String)chatGroupId);
        }
        return imChatGroup;
    }
}

