/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.util.SqlInjectionUtil;
import com.els.common.util.SysUtil;
import com.els.modules.im.dto.ImMessageDto;
import com.els.modules.im.entity.ImMessage;
import com.els.modules.im.mapper.ImChatGroupMapper;
import com.els.modules.im.mapper.ImMessageMapper;
import com.els.modules.im.service.IImMessageService;
import com.els.modules.im.vo.ImChatGroupVo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="imMessageServiceImpl")
public class ImMessageServiceImpl
extends ServiceImpl<ImMessageMapper, ImMessage>
implements IImMessageService {
    @Autowired
    private ImChatGroupMapper imChatGroupMapper;

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveMessage(ImMessage imMessage) {
        imMessage.setId(IdWorker.getIdStr());
        new SaveChatMessageThread(imMessage).run();
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void batchSaveMessage(List<ImMessage> imMessages) {
        this.saveBatch(imMessages);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public List<ImMessage> getUnReadMessage(String toId, String type) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ImMessage::getToId, (Object)toId)).eq(ImMessage::getUndoStatus, (Object)0)).eq(ImMessage::getReadStatus, (Object)"1");
        if ("customer".equals(type)) {
            queryWrapper.eq(ImMessage::getType, (Object)"customer");
        } else {
            queryWrapper.ne(ImMessage::getType, (Object)"customer");
        }
        List messageList = ((ImMessageMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        for (ImMessage message : messageList) {
            message.setReadStatus("0");
            this.updateById(message);
        }
        return messageList;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public List<ImMessage> getChatLog(String toId, String type) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ImMessage::getToId, (Object)toId)).eq(ImMessage::getUndoStatus, (Object)0)).eq(ImMessage::getType, (Object)type);
        return ((ImMessageMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public Page<ImMessage> pageMessage(Page<ImMessage> page, String type, String userId) {
        return ((ImMessageMapper)this.baseMapper).pageMessage(page, type, userId);
    }

    @Override
    public IPage<ImChatGroupVo> groupPage(ImMessageDto imMessageDto, Integer pageNo, Integer pageSize) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        imMessageDto.setUserId(SysUtil.getLoginUser().getId());
        SqlInjectionUtil.filterContent((String)(imMessageDto.getColumn() + " " + imMessageDto.getOrder()));
        return this.imChatGroupMapper.groupPage((IPage<ImChatGroupVo>)page, imMessageDto);
    }

    @Override
    public void asyncUndoMessage(String messageId, String fromId) {
        LambdaUpdateWrapper wrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)wrapper.eq(ImMessage::getId, (Object)messageId)).eq(ImMessage::getFromId, (Object)fromId);
        wrapper.set(ImMessage::getUndoStatus, (Object)1);
        ((ImMessageMapper)this.baseMapper).update(null, (Wrapper)wrapper);
    }

    class SaveChatMessageThread
    implements Runnable {
        private ImMessage imMessage;

        public SaveChatMessageThread(ImMessage imMessage) {
            this.imMessage = imMessage;
        }

        @Override
        public void run() {
            ImMessageServiceImpl.this.save(this.imMessage);
        }
    }
}

