/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.controller;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.Sign;
import cn.hutool.crypto.asymmetric.SignAlgorithm;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.PanshiProperties;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.im.core.ImMessageInfo;
import com.els.modules.im.core.common.utils.ChatUtils;
import com.els.modules.im.core.tio.TioWsMsgHandler;
import com.els.modules.im.dto.ImMessageCallbackDto;
import com.els.modules.im.dto.ImMessageDto;
import com.els.modules.im.entity.ImChatGroup;
import com.els.modules.im.entity.ImChatGroupUser;
import com.els.modules.im.entity.ImMessage;
import com.els.modules.im.rpc.service.InvokeImAccountRpcService;
import com.els.modules.im.service.IImChatGroupService;
import com.els.modules.im.service.IImChatGroupUserService;
import com.els.modules.im.service.IImMessageService;
import com.els.modules.im.utils.ImUtils;
import com.els.modules.im.vo.ImChatGroupVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/im/message"})
@Api(tags={"IM\u6d88\u606f"})
public class ImMessageController {
    private static final Logger log = LoggerFactory.getLogger(ImMessageController.class);
    public static final int PAGE_SIZE = 20;
    public static final String FRIEND = "friend";
    @Resource(name="imMessageServiceImpl")
    private IImMessageService iImMessageService;
    @Resource(name="imChatGroupServiceImpl")
    private IImChatGroupService imChatGroupService;
    @Resource(name="imChatGroupUserServiceImpl")
    private IImChatGroupUserService imChatGroupUserServiceImpl;
    @Resource
    private TioWsMsgHandler tioWsMsgHandler;
    boolean msgViewingSwitch = true;
    @Resource
    private InvokeImAccountRpcService imAccountRpcService;
    @Autowired
    private PanshiProperties panshiProperties;

    @GetMapping(value={"getFilterMsgSwitch"})
    public Result<?> getMsgViewingSwitch() {
        return Result.ok((Object)this.msgViewingSwitch);
    }

    @RequiresPermissions(value={"im#im:im"})
    @ResponseBody
    @GetMapping(value={"group-page"})
    @ApiOperation(value="IM-\u5206\u9875\u83b7\u53d6\u804a\u5929\u8bb0\u5f55", notes="IM-\u5206\u9875\u83b7\u53d6\u804a\u5929\u8bb0\u5f55")
    public Result<?> groupPage(ImMessageDto imMessageDto, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        IPage<ImChatGroupVo> pageList = this.iImMessageService.groupPage(imMessageDto, pageNo, pageSize);
        if (CollUtil.isNotEmpty((Collection)pageList.getRecords())) {
            List<ImUserDTO> userList = this.imAccountRpcService.getUsersByUserIdList(pageList.getRecords().stream().map(ImChatGroupVo::getMaster).distinct().collect(Collectors.toList()));
            Map<String, String> map = userList.stream().collect(Collectors.toMap(ImUserDTO::getId, x -> x.getUsername() + "_" + x.getElsAccount() + "_" + x.getSubAccount()));
            pageList.getRecords().forEach(m -> {
                String recordI18Value = ImUtils.getRecordI18Value(m.getRecordType());
                if (CharSequenceUtil.isNotEmpty((CharSequence)recordI18Value)) {
                    String groupName = m.getName().replace(m.getRecordType(), recordI18Value);
                    m.setName(groupName);
                }
                if (map.containsKey(m.getMaster())) {
                    m.setMaster((String)map.get(m.getMaster()));
                }
            });
        }
        return Result.ok(pageList);
    }

    @RequiresPermissions(value={"im#im:im"})
    @ResponseBody
    @GetMapping(value={"list"})
    @ApiOperation(value="IM-\u83b7\u53d6\u804a\u5929\u8bb0\u5f55", notes="IM-\u83b7\u53d6\u804a\u5929\u8bb0\u5f55")
    public Map<String, Object> list(@RequestParam(name="chatId") String chatId, @RequestParam(name="fromId") String fromId, @RequestParam(name="chatType") String chatType, @RequestParam(name="pageNo") Long pageNo, Integer pageSize) {
        if (CharSequenceUtil.isEmpty((CharSequence)chatId) || CharSequenceUtil.isEmpty((CharSequence)fromId)) {
            return new HashMap<String, Object>();
        }
        Page page = new Page();
        page.setSize(null == pageSize ? 2000L : (long)pageSize.intValue());
        if (pageNo == null) {
            pageNo = 0L;
        }
        page.setCurrent(pageNo.longValue());
        page.setDesc(new String[]{"send_time"});
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if (FRIEND.equals(chatType) || "customer".equals(chatType)) {
            wrapper.and(wrapper1 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper1.eq(ImMessage::getToId, (Object)chatId)).eq(ImMessage::getFromId, (Object)fromId);
            });
            wrapper.or(wrapper2 -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper2.eq(ImMessage::getFromId, (Object)chatId)).eq(ImMessage::getToId, (Object)fromId);
            });
        } else {
            wrapper.eq(ImMessage::getToId, (Object)chatId);
            if (this.msgViewingSwitch) {
                ImChatGroup chatGroup = (ImChatGroup)this.imChatGroupService.getById((Serializable)((Object)chatId));
                ImUserDTO master = this.imAccountRpcService.getImUserById(chatGroup.getMaster());
                if (!SysUtil.getLoginUser().getId().equals(chatGroup.getMaster()) && !this.imAccountRpcService.checkIfSameElsAccount(master.getElsAccount(), SysUtil.getLoginUser().getId()) && CharSequenceUtil.isNotBlank((CharSequence)chatGroup.getRecordType())) {
                    List<String> subAccountId = this.imAccountRpcService.loadElsAccountId(Lists.newArrayList((Object[])new String[]{master.getElsAccount(), SysUtil.getLoginUser().getElsAccount()}));
                    List<ImChatGroupUser> groupUserList = this.imChatGroupUserServiceImpl.getChatUserByChatId(chatId);
                    List groupUserIds = groupUserList.stream().map(ImChatGroupUser::getUserId).collect(Collectors.toList());
                    subAccountId = subAccountId.stream().filter(groupUserIds::contains).collect(Collectors.toList());
                    wrapper.in(ImMessage::getFromId, subAccountId);
                }
            }
        }
        wrapper.eq(ImMessage::getType, (Object)chatType);
        IPage messagePage = this.iImMessageService.page((IPage)page, (Wrapper)wrapper);
        List imMessageList = messagePage.getRecords();
        ArrayList<ImMessageInfo> messageList = new ArrayList<ImMessageInfo>();
        List<String> userIds = imMessageList.stream().map(ImMessage::getFromId).distinct().collect(Collectors.toList());
        List<ImUserDTO> imUserDTOList = this.imAccountRpcService.getUsersByUserIdList(userIds);
        Map userMap = imUserDTOList.stream().collect(Collectors.toMap(ImUserDTO::getId, Function.identity(), (v1, v2) -> v1));
        for (ImMessage imMessage : imMessageList) {
            ImMessageInfo message = new ImMessageInfo();
            message.setId(imMessage.getToId());
            message.setMine(fromId.equals(imMessage.getFromId()));
            message.setType("customer".equals(message.getType()) ? FRIEND : message.getType());
            ImUserDTO imUser = (ImUserDTO)userMap.get(imMessage.getFromId());
            if ("1".equals(imMessage.getReplyByRobot())) {
                message.setUsername("\u673a\u667a\u7684\u5c0f\u4f01");
                message.setAvatar("/kefu/static/robot.png");
            } else if (imUser != null) {
                message.setAvatar(imUser.getAvatar());
                message.setUsername(imUser.getUsername());
            }
            message.setFromid(imMessage.getFromId());
            if ("customer".equals(chatType)) {
                message.setCid("kefu");
            } else {
                message.setCid(String.valueOf(imMessage.getId()));
            }
            message.setContent(imMessage.getContent());
            message.setTimestamp(imMessage.getSendTime());
            message.setMessageType(imMessage.getMessageType());
            message.setAudioText(imMessage.getAudioText());
            message.setIfTranslate(imMessage.getIfTranslate());
            message.setUndoStatus(imMessage.getUndoStatus());
            messageList.add(message);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("messageList", messageList);
        map.put("pageNo", pageNo);
        map.put("count", messagePage.getTotal());
        map.put("pageSize", messagePage.getSize());
        return map;
    }

    public Result<?> deleteAudioFile(@RequestBody List<String> messageIds) {
        LoginUser loginUser = SysUtil.getLoginUser();
        if (null == loginUser) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_jDxMKW_782540b3", (String)"\u7528\u6237\u4e0d\u5b58\u5728"));
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{ImMessage::getContent});
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ImMessage::getMessageType, (Object)ChatUtils.MessageType.AUDIO.getValue())).eq(ImMessage::getReadStatus, (Object)"0")).eq(ImMessage::getFromId, (Object)loginUser.getId());
        List list = this.iImMessageService.list((Wrapper)wrapper);
        return Result.ok((Object)true);
    }

    @ResponseBody
    @PostMapping(value={"noToken/message-callback"})
    @SrmValidated
    public Result<?> messageCallback(@RequestBody ImMessageCallbackDto dto) {
        ImMessage imMessage = (ImMessage)this.iImMessageService.getById((Serializable)((Object)dto.getSrmNewsId()));
        if (null == imMessage || !"customer".equals(imMessage.getType())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_XHxMK_3484e456", (String)"\u6d88\u606f\u4e0d\u5b58\u5728"));
        }
        this.tioWsMsgHandler.messageCallback(imMessage, dto);
        return Result.ok();
    }

    @PostMapping(value={"/noToken/callback"})
    public Result<?> callback(@RequestBody JSONObject param) {
        this.checkParam(param);
        JSONObject bodyObj = param.getJSONObject("body");
        String msgId = bodyObj.getString("msgId");
        String content = bodyObj.getJSONObject("record").getString("content");
        ImMessage imMessage = (ImMessage)this.iImMessageService.getById((Serializable)((Object)msgId));
        if (null == imMessage || !"customer".equals(imMessage.getType())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_XHxMK_3484e456", (String)"\u6d88\u606f\u4e0d\u5b58\u5728"));
        }
        ImMessageCallbackDto callbackDto = new ImMessageCallbackDto();
        callbackDto.setSrmNewsId(msgId);
        callbackDto.setSendNews(content);
        callbackDto.setSendNewsType("0");
        this.tioWsMsgHandler.messageCallback(imMessage, callbackDto);
        return Result.ok();
    }

    private void checkParam(JSONObject param) {
        String signStr = param.getString("sign");
        String body = param.getJSONObject("body").toJSONString();
        if (!this.checkSign(body, signStr, this.panshiProperties.getPublicKey())) {
            throw new ELSBootException("\u975e\u6cd5\u53c2\u6570\uff01");
        }
    }

    private boolean checkSign(String data, String signStr, String publicKey) {
        if (StrUtil.isBlank((CharSequence)data) || StrUtil.isBlank((CharSequence)signStr)) {
            return false;
        }
        byte[] bData = data.getBytes();
        byte[] signed = Base64.decode((CharSequence)signStr);
        Sign sign = SecureUtil.sign((SignAlgorithm)SignAlgorithm.MD5withRSA, null, (String)publicKey);
        return sign.verify(bData, signed);
    }

    public Result<?> pageUserOrderMessage(String userId) {
        return null;
    }

    public Result<?> pageUserGroupOrderMessage(String userId) {
        return null;
    }
}

