/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.PanshiProperties;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PanshiUtil {
    private static final Logger log = LoggerFactory.getLogger(PanshiUtil.class);
    private static final String REDIS_KEY = "sys:thirdAuth:panshiToken:";
    private static final String GET_TOKEN_URL = "/els/openApi/getToken";
    private static final String INVOKE_URL = "/els/openApi/invoke";
    @Autowired
    private PanshiProperties panshiProperties;
    @Resource
    private RedisUtil redisUtil;

    private JSONObject getAuthObj() {
        JSONObject authObj = (JSONObject)this.redisUtil.get(REDIS_KEY);
        if (authObj != null) {
            return authObj;
        }
        try {
            StringBuilder urlBuilder = new StringBuilder(this.panshiProperties.getUrl());
            urlBuilder.append(GET_TOKEN_URL).append("?key=").append(this.panshiProperties.getKey()).append("&secret=").append(this.panshiProperties.getSecret());
            String result = HttpUtil.get((String)urlBuilder.toString());
            JSONObject resultObj = JSONObject.parseObject((String)result);
            int code = resultObj.getIntValue("code");
            if (code == 200) {
                authObj = new JSONObject();
                String token = resultObj.getJSONObject("result").getString("token");
                long expiresIn = resultObj.getJSONObject("result").getLongValue("expiresIn");
                authObj.put("token", (Object)token);
                authObj.put("appUrl", (Object)this.panshiProperties.getUrl());
                this.redisUtil.set(REDIS_KEY, (Object)authObj, expiresIn - 200L);
                return authObj;
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_SMyVUEWWWWWKm_4471fbd3", (String)"\u83b7\u53d6\u63a5\u53e3\u5e73\u53f0token\u5931\u8d25\uff01"));
        }
        catch (Exception e) {
            log.error("PanshiUtil_getToken_failed:", (Throwable)e);
            throw e;
        }
    }

    public JSONObject callPanshi(String interfaceCode, JSONObject body) {
        JSONObject param = new JSONObject();
        param.put("interface_code", (Object)interfaceCode);
        param.put("body", (Object)body);
        JSONObject authObj = this.getAuthObj();
        StringBuilder urlBuilder = new StringBuilder(this.panshiProperties.getUrl());
        urlBuilder.append(INVOKE_URL);
        String result = ((HttpRequest)HttpRequest.post((String)urlBuilder.toString()).header("token", authObj.getString("token"))).body(param.toJSONString()).execute().body();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        return resultObj;
    }
}

