/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.im.core.tio.WsOnlineContext;
import com.els.modules.im.dto.ImGroupCreateDto;
import com.els.modules.im.entity.ImChatGroup;
import com.els.modules.im.entity.ImChatGroupUser;
import com.els.modules.im.mapper.ImChatGroupMapper;
import com.els.modules.im.mapper.ImChatGroupUserMapper;
import com.els.modules.im.service.IImChatGroupService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;

@Service(value="imChatGroupServiceImpl")
public class ImChatGroupServiceImpl
extends ServiceImpl<ImChatGroupMapper, ImChatGroup>
implements IImChatGroupService {
    @Autowired
    private ImChatGroupUserMapper imChatGroupUserMapper;

    @Override
    public List<ImChatGroup> getChatGroups(String userId) {
        return ((ImChatGroupMapper)this.baseMapper).getUserGroups(userId);
    }

    @Override
    public ImChatGroup createChatGroup(ImGroupCreateDto imGroupCreateDto, boolean binding) {
        LoginUser sysUser = SysUtil.getLoginUser();
        ImChatGroup imChatGroup = new ImChatGroup();
        imChatGroup.setGroupname(imGroupCreateDto.getChatGroupName());
        imChatGroup.setMaster(sysUser.getId());
        imChatGroup.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
        imChatGroup.setRemarks(imGroupCreateDto.getRemark());
        imChatGroup.setCreateDate(new Date());
        imChatGroup.setUpdateDate(new Date());
        imChatGroup.setRecordNumber(imGroupCreateDto.getRecordNumber());
        imChatGroup.setAvatar("/im/layim-v3.9.6/dist/css/modules/layim/skin/group.jpg");
        if (StrUtil.isNotBlank((CharSequence)imGroupCreateDto.getId())) {
            imChatGroup.setId(imGroupCreateDto.getId());
            imChatGroup.setRecordType(imGroupCreateDto.getRecordType());
        } else {
            imChatGroup.setRecordType(null);
            imChatGroup.setRecordNumber(null);
            imGroupCreateDto.setId(IdWorker.getTimeId());
        }
        ((ImChatGroupMapper)this.baseMapper).insert(imChatGroup);
        ImChatGroupUser chatGroupUser = new ImChatGroupUser();
        chatGroupUser.setChatGroupId(imChatGroup.getId());
        chatGroupUser.setUserId(sysUser.getId());
        chatGroupUser.setCreateDate(new Date());
        this.imChatGroupUserMapper.insert(chatGroupUser);
        ChannelContext channelContext = WsOnlineContext.getChannelContextByUser(sysUser.getId());
        if (binding && null != channelContext) {
            Tio.bindGroup((ChannelContext)channelContext, (String)imChatGroup.getId());
        }
        return imChatGroup;
    }
}

