/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.controller;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.im.entity.ImChatGroup;
import com.els.modules.im.entity.ImChatGroupLink;
import com.els.modules.im.rpc.service.InvokeImAccountRpcService;
import com.els.modules.im.service.IImChatGroupLinkService;
import com.els.modules.im.service.IImChatGroupService;
import com.els.modules.im.vo.ImChatGroupLinkVo;
import java.io.Serializable;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/im/chatGroupLink"})
public class ImChatGroupLinkController {
    private static final Logger log = LoggerFactory.getLogger(ImChatGroupLinkController.class);
    @Resource(name="imChatGroupLinkServiceImpl")
    private IImChatGroupLinkService imChatGroupLinkServiceImpl;
    @Resource(name="imChatGroupServiceImpl")
    private IImChatGroupService imChatGroupServiceImpl;
    @Resource
    private InvokeImAccountRpcService imAccountRpcService;

    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody ImChatGroupLink imChatGroupLink) {
        this.imChatGroupLinkServiceImpl.save(imChatGroupLink);
        return Result.ok((Object)imChatGroupLink);
    }

    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody ImChatGroupLink imChatGroupLink) {
        this.imChatGroupLinkServiceImpl.updateById(imChatGroupLink);
        return Result.ok((Object)imChatGroupLink);
    }

    @GetMapping(value={"/configLink/{groupId}"})
    public Result<?> loadRouteLink(@PathVariable(value="groupId") String groupId) {
        String actionPath;
        ImChatGroup chatGroup = (ImChatGroup)this.imChatGroupServiceImpl.getById((Serializable)((Object)groupId));
        if (null == chatGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKra_76bee2bc", (String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
        }
        if (CharSequenceUtil.isBlank((CharSequence)chatGroup.getRecordType()) || CharSequenceUtil.isBlank((CharSequence)chatGroup.getRecordNumber())) {
            return Result.ok(null);
        }
        ImChatGroupLink configLink = this.imChatGroupLinkServiceImpl.loadLink(chatGroup.getRecordType());
        if (null == configLink) {
            return Result.ok(null);
        }
        ImChatGroupLinkVo result = new ImChatGroupLinkVo();
        result.setRecordNumber(chatGroup.getRecordNumber());
        result.setLinkConfig(configLink.getLinkConfig());
        boolean flag = this.imAccountRpcService.checkIfSameElsAccount(SysUtil.getLoginUser().getElsAccount(), chatGroup.getMaster());
        String string = actionPath = flag ? configLink.getPurchaseRoutePath() : configLink.getSaleRoutePath();
        if (CharSequenceUtil.isBlank((CharSequence)actionPath)) {
            return Result.ok(null);
        }
        result.setActionPath(actionPath);
        return Result.ok((Object)result);
    }
}

