/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.im.api.dto.ImRecordDto;
import com.els.modules.im.api.enumerate.ImRecordTypeEnum;
import com.els.modules.im.core.common.BaseEntity;
import com.els.modules.im.core.tio.StartTioRunner;
import com.els.modules.im.core.tio.WsOnlineContext;
import com.els.modules.im.dto.GroupMessageUserVo;
import com.els.modules.im.dto.ImGroupCreateDto;
import com.els.modules.im.entity.ImChatGroup;
import com.els.modules.im.entity.ImChatGroupUser;
import com.els.modules.im.entity.ImMessage;
import com.els.modules.im.entity.ImUserFriend;
import com.els.modules.im.rpc.service.InvokeImAccountRpcService;
import com.els.modules.im.rpc.service.InvokeImUserRecordRpcService;
import com.els.modules.im.service.IImChatGroupService;
import com.els.modules.im.service.IImChatGroupUserService;
import com.els.modules.im.service.IImGroupService;
import com.els.modules.im.service.IImMessageService;
import com.els.modules.im.service.IImUserFriendService;
import com.els.modules.im.service.ImGroupMessageUserService;
import com.els.modules.im.utils.ImUtils;
import com.els.modules.im.vo.ImGroupVO;
import com.els.modules.im.vo.ImMessageVo;
import com.els.modules.im.vo.ImUserListVO;
import com.els.modules.im.vo.ImUserVO;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.websocket.common.WsResponse;

@RestController
@RequestMapping(value={"/im/user"})
@Api(tags={"IM\u7528\u6237"})
public class ImUserController {
    private static final Logger log = LoggerFactory.getLogger(ImUserController.class);
    static final String STR_FORMAT = "yyyyMMdd";
    @Value(value="${els.path.upload}")
    private String uploadpath;
    @Value(value="${els.path.im.imFileReplacePath}")
    private String imFileReplacePath;
    static final String STR_DOT = ".";
    static final String STR_SPLIT = "_";
    static final String NGINX_FILE_PATH = "/opt/upFiles";
    @Value(value="${els.config.service.address}")
    private String serverPath;
    @Resource
    private StartTioRunner startTioRunner;
    @Resource(name="imUserFriendServiceImpl")
    private IImUserFriendService imUserFriendService;
    @Resource(name="imChatGroupUserServiceImpl")
    private IImChatGroupUserService imChatGroupUserService;
    @Resource(name="imMessageServiceImpl")
    private IImMessageService iImMessageService;
    @Resource(name="imChatGroupServiceImpl")
    private IImChatGroupService imChatGroupService;
    @Resource(name="imGroupServiceImpl")
    private IImGroupService iImGroupService;
    @Resource(name="imChatGroupServiceImpl")
    private IImChatGroupService iImChatGroupService;
    @Resource
    private InvokeImUserRecordRpcService imUserRecordRpcService;
    @Resource
    private InvokeImAccountRpcService imAccountRpcService;
    @Resource
    private ImGroupMessageUserService imGroupMessageUserServiceImpl;

    @GetMapping(value={"/init"})
    @ApiOperation(value="IM-\u7528\u6237\u4fe1\u606f\u521d\u59cb\u5316", notes="IM-\u7528\u6237\u4fe1\u606f\u521d\u59cb\u5316")
    public Map<String, Object> init(HttpServletRequest request) {
        log.info("Enter into method ImUserController.init");
        HashMap<String, List<BaseEntity>> objectMap = new HashMap<String, List<BaseEntity>>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        LoginUser sysUser = SysUtil.getLoginUser();
        ImUserDTO user = this.imAccountRpcService.getImUserByLoginName(sysUser.getElsAccount(), sysUser.getSubAccount());
        user.setEnterpriseName(sysUser.getEnterpriseName());
        user.setEnterpriseLogo(sysUser.getEnterpriseLogo());
        if (null == user) {
            throw new ELSBootException("IM" + I18nUtil.translate((String)"i18n_alert_jDxMKW_782540b3", (String)"\u7528\u6237\u4e0d\u5b58\u5728"));
        }
        List<ImGroupVO> friend = this.imAccountRpcService.getUserFriends(user.getId());
        if (friend.isEmpty()) {
            this.iImGroupService.initGroup(user.getId());
            friend = this.imAccountRpcService.getUserFriends(user.getId());
        }
        for (ImGroupVO group : friend) {
            List<ImUserVO> userList = group.getList();
            for (ImUserVO imUser : userList) {
                imUser.setGroupId(group.getId());
                ChannelContext cc = WsOnlineContext.getChannelContextByUser(imUser.getId());
                if (cc != null && !cc.isClosed) {
                    imUser.setStatus("online");
                    continue;
                }
                imUser.setStatus("offline");
            }
        }
        objectMap.put("friend", friend);
        ChannelContext cc = WsOnlineContext.getChannelContextByUser(user.getId());
        if (cc != null && !cc.isClosed) {
            user.setStatus("online");
        } else {
            user.setStatus("offline");
        }
        objectMap.put("mine", (List<BaseEntity>)user);
        List<ImUserDTO> friendsRequest = this.imAccountRpcService.getUserFriendsRequest(user.getId());
        objectMap.put("frendsRequest", friendsRequest);
        List<ImChatGroup> chatGroups = this.imChatGroupService.getChatGroups(user.getId());
        List groupIds = chatGroups.stream().map(ImChatGroup::getId).collect(Collectors.toList());
        List<GroupMessageUserVo> messageUserVos = this.imGroupMessageUserServiceImpl.listCountUnReadMessage(user.getId());
        Map<String, Integer> msgCountMap = messageUserVos.stream().collect(Collectors.toMap(GroupMessageUserVo::getGroupId, GroupMessageUserVo::getMsgCount));
        for (ImChatGroup group : chatGroups) {
            String recordI18Value;
            if (CharSequenceUtil.isNotEmpty((CharSequence)group.getRecordType()) && CharSequenceUtil.isNotEmpty((CharSequence)group.getGroupname()) && CharSequenceUtil.isNotEmpty((CharSequence)(recordI18Value = ImUtils.getRecordI18Value(group.getRecordType())))) {
                String groupName = group.getGroupname().replace(group.getRecordType(), recordI18Value);
                log.info(":::\u7528\u6237\u7fa4\u7ec4\u7684\u540d\u79f0:{}", (Object)groupName);
                group.setGroupname(groupName);
            }
            group.setIsMaster(SysUtil.getLoginUser().getId().equals(group.getMaster()));
            Integer count = (Integer)ObjectUtil.defaultIfNull((Object)msgCountMap.get(group.getId()), (Object)0);
            if (count == 0) {
                groupIds.remove(group.getId());
            }
            group.setNewMsgCount(count);
        }
        chatGroups.sort(Comparator.comparing(ImChatGroup::getNewMsgCount).reversed());
        objectMap.put("group", chatGroups);
        resultMap.put("code", "0");
        resultMap.put("msg", "");
        resultMap.put("data", objectMap);
        log.debug("Leave the method ImUserController.init, parameters: " + ((Object)resultMap).toString());
        return resultMap;
    }

    @PostMapping(value={"/removeGroupChatMessage/{groupId}"})
    @ApiOperation(value="IM-\u6807\u8bb0\u7fa4\u804a\u6d88\u606f\u5df2\u8bfb", notes="IM-\u6807\u8bb0\u7fa4\u804a\u6d88\u606f\u5df2\u8bfb")
    public Result<?> removeGroupChatMessage(@PathVariable(value="groupId") String groupId) {
        LoginUser sysUser = SysUtil.getLoginUser();
        this.imGroupMessageUserServiceImpl.removeMsgLogByUserId(sysUser.getId(), Lists.newArrayList((Object[])new String[]{groupId}));
        return Result.ok();
    }

    @GetMapping(value={"/customer-init"})
    @ApiOperation(value="IM-\u5ba2\u670d\u4fe1\u606f\u521d\u59cb\u5316", notes="IM-\u5ba2\u670d\u4fe1\u606f\u521d\u59cb\u5316")
    public Map<String, Object> customerInit(@RequestParam(name="pageNo") Long pageNo, Integer pageSize) {
        HashMap<String, ArrayList> objectMap = new HashMap<String, ArrayList>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        LoginUser sysUser = SysUtil.getLoginUser();
        ImUserDTO user = this.imAccountRpcService.getImUserByLoginName(sysUser.getElsAccount(), sysUser.getSubAccount());
        if (null == user) {
            throw new ELSBootException("IM" + I18nUtil.translate((String)"i18n_alert_jDxMKW_782540b3", (String)"\u7528\u6237\u4e0d\u5b58\u5728"));
        }
        Page page = new Page();
        page.setSize(null == pageSize ? 2000L : (long)pageSize.intValue());
        page.setCurrent(pageNo == null ? 0L : pageNo);
        Page<ImMessage> messageList = this.iImMessageService.pageMessage((Page<ImMessage>)page, "customer", SysUtil.getLoginUser().getId());
        List messageVos = Lists.newArrayList();
        if (CollUtil.isNotEmpty((Collection)messageList.getRecords())) {
            List<String> userIdList = messageList.getRecords().stream().map(ImMessage::getFromId).collect(Collectors.toList());
            List<ImUserDTO> userList = this.imAccountRpcService.getUsersByUserIdList(userIdList);
            Map stringImUserMap = userList.stream().collect(Collectors.toMap(ImUserDTO::getId, Function.identity()));
            messageVos = Convert.toList(ImMessageVo.class, (Object)messageList.getRecords());
            for (ImMessageVo vo : messageVos) {
                ImUserDTO imUser = (ImUserDTO)stringImUserMap.get(vo.getFromId());
                if (null == imUser) continue;
                vo.setAvatar(imUser.getAvatar());
                vo.setId(vo.getFromId());
                vo.setUsername(imUser.getUsername());
                vo.setElsAccount(imUser.getElsAccount());
                vo.setSubAccount(imUser.getSubAccount());
                vo.setType("friend");
            }
        }
        objectMap.put("chatList", (ArrayList)messageVos);
        ChannelContext cc = WsOnlineContext.getChannelContextByUser(user.getId());
        if (cc != null && !cc.isClosed) {
            user.setStatus("online");
        } else {
            user.setStatus("offline");
        }
        objectMap.put("mine", (ArrayList)user);
        objectMap.put("group", Lists.newArrayList());
        resultMap.put("code", "0");
        resultMap.put("msg", "");
        resultMap.put("data", objectMap);
        return resultMap;
    }

    @GetMapping(value={"chatUserList"})
    public List<ImUserDTO> chatUserList(@RequestParam(name="id") String chatId) {
        ImChatGroup chatGroup = (ImChatGroup)this.imChatGroupService.getById((Serializable)((Object)chatId));
        if (null == chatGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKra_76bee2bc", (String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
        }
        List<ImUserDTO> chatUserList = this.imAccountRpcService.getChatUserList(chatId);
        for (ImUserDTO dto : chatUserList) {
            dto.setIsMaster(Boolean.valueOf(dto.getId().equals(chatGroup.getMaster())));
        }
        chatUserList.sort(Comparator.comparing(ImUserDTO::getIsMaster));
        return chatUserList;
    }

    @GetMapping(value={"/getMembers"})
    @ApiOperation(value="IM-\u83b7\u53d6\u7fa4\u7ec4\u7684\u7528\u6237", notes="IM-\u83b7\u53d6\u7fa4\u7ec4\u7684\u7528\u6237")
    public Map<String, Object> getMembers(@RequestParam(name="id") String chatId) {
        HashMap<String, List<ImUserDTO>> objectMap = new HashMap<String, List<ImUserDTO>>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ImChatGroup chatGroup = (ImChatGroup)this.imChatGroupService.getById((Serializable)((Object)chatId));
        if (null == chatGroup) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKra_76bee2bc", (String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
        }
        List<ImUserDTO> chatUserList = null;
        ImUserDTO master = this.imAccountRpcService.getImUserById(chatGroup.getMaster());
        if (!SysUtil.getLoginUser().getId().equals(chatGroup.getMaster()) && !this.imAccountRpcService.checkIfSameElsAccount(master.getElsAccount(), SysUtil.getLoginUser().getId())) {
            List<String> subAccountId = this.imAccountRpcService.loadElsAccountId(Lists.newArrayList((Object[])new String[]{master.getElsAccount(), SysUtil.getLoginUser().getElsAccount()}));
            List<ImChatGroupUser> groupUserList = this.imChatGroupUserService.getChatUserByChatId(chatId);
            List groupUserIds = groupUserList.stream().map(ImChatGroupUser::getUserId).collect(Collectors.toList());
            subAccountId = subAccountId.stream().filter(groupUserIds::contains).collect(Collectors.toList());
            chatUserList = this.imAccountRpcService.getUsersByUserIdList(subAccountId);
        } else {
            chatUserList = this.imAccountRpcService.getChatUserList(chatId);
        }
        for (ImUserDTO dto : chatUserList) {
            dto.setIsMaster(Boolean.valueOf(dto.getId().equals(chatGroup.getMaster())));
            dto.setRealname(dto.getRealname() + STR_SPLIT + dto.getElsAccount());
        }
        chatUserList.sort(Comparator.comparing(ImUserDTO::getIsMaster));
        objectMap.put("list", chatUserList);
        resultMap.put("code", "0");
        resultMap.put("msg", "");
        resultMap.put("data", objectMap);
        return resultMap;
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6", notes="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/uploadFiles"})
    public Map<String, Object> uploadFiles(HttpServletRequest request) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String bizPath = "files";
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(STR_FORMAT);
        String nowday = dtf.format(time);
        File file = new File(this.uploadpath + File.separator + bizPath + File.separator + nowday + File.separator + "ImFiles");
        if (!file.exists()) {
            file.mkdirs();
        }
        log.debug("\u6587\u4ef6\u5b58\u653e\u76ee\u5f55\u4f4d\u7f6e-------->>>>>>>>>>>>" + file.getPath());
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        try {
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile uploadFile = (MultipartFile)entity.getValue();
                String documentName = uploadFile.getOriginalFilename();
                if (StrUtil.isEmpty((CharSequence)documentName)) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_XVQIRxOLVW_20dd1989", (String)"\u4e0a\u4f20\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a!"));
                }
                int suffixLocation = documentName.lastIndexOf(STR_DOT);
                String documentType = "";
                StringBuffer fileName = new StringBuffer("");
                if (suffixLocation > 0) {
                    documentType = documentName.substring(suffixLocation + 1);
                    fileName.append(documentName, 0, documentName.lastIndexOf(STR_DOT)).append(STR_SPLIT).append(System.currentTimeMillis()).append(STR_DOT).append(documentType);
                } else {
                    fileName.append(documentName).append(STR_SPLIT).append(System.currentTimeMillis());
                }
                StringBuffer savePath = new StringBuffer(file.getPath());
                savePath.append(File.separator);
                if (StrUtil.isNotBlank((CharSequence)documentType)) {
                    savePath.append(documentType);
                    File dir = new File(savePath.toString());
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    savePath.append(File.separator);
                }
                savePath.append(fileName);
                File saveFile = new File(savePath.toString());
                log.debug("::: \u6587\u4ef6\u5b9e\u4f8b\u8def\u5f84==>{}", (Object)savePath.toString());
                FileCopyUtils.copy((byte[])uploadFile.getBytes(), (File)saveFile);
                String replacePath = savePath.toString().replace(this.imFileReplacePath, "");
                if (!replacePath.startsWith(NGINX_FILE_PATH)) {
                    replacePath = replacePath.replace(this.uploadpath, NGINX_FILE_PATH);
                }
                if (replacePath.contains(":")) {
                    replacePath = replacePath.substring(replacePath.indexOf(":") + 1);
                }
                replacePath = replacePath.replace("\\", "/");
                HashMap<String, CharSequence> objectMap = new HashMap<String, CharSequence>();
                objectMap.put("src", this.serverPath + replacePath);
                objectMap.put("name", fileName);
                resultMap.put("code", "0");
                resultMap.put("msg", "");
                resultMap.put("data", objectMap);
            }
        }
        catch (Exception e) {
            log.error(":::\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25==>{}", (Object)e.getMessage());
            resultMap.put("code", "-1");
            resultMap.put("msg", e.getMessage());
        }
        return resultMap;
    }

    @GetMapping(value={"/addFriend"})
    @ApiOperation(value="IM-\u6dfb\u52a0\u597d\u53cb", notes="IM-\u6dfb\u52a0\u597d\u53cb")
    public Result<?> addFriend(@RequestParam(name="friendId") String friendId, @RequestParam(name="groupId") String groupId) {
        log.info("Enter into method ImUserController.addFriend. friendId = " + friendId + ", groupId = " + groupId);
        groupId = "null".equals(groupId) ? "" : groupId;
        this.iImGroupService.addFriend(friendId, groupId);
        LoginUser loginSysUser = SysUtil.getLoginUser();
        ImUserDTO sysUser = this.imAccountRpcService.getImUserByLoginName(loginSysUser.getElsAccount(), loginSysUser.getSubAccount());
        JSONObject toMap = new JSONObject();
        if (null != WsOnlineContext.getChannelContextByUser(friendId)) {
            ImUserVO user = new ImUserVO();
            user.setId(sysUser.getId());
            user.setUsername(sysUser.getRealname());
            user.setAvatar(sysUser.getAvatar());
            user.setElsAccount(sysUser.getElsAccount());
            user.setSubAccount(sysUser.getSubAccount());
            user.setCreateTime(new Date());
            toMap.put("msg_type", (Object)"addUser");
            toMap.put("data", (Object)user);
            WsResponse toWsResponse = WsResponse.fromText((String)toMap.toString(), (String)"utf-8");
            Tio.send((ChannelContext)WsOnlineContext.getChannelContextByUser(friendId), (Packet)toWsResponse);
        }
        log.info("Leave the method ImUserController.addFriend.");
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_IhdyjVV_c34b745b", (String)"\u5df2\u53d1\u9001\u597d\u53cb\u8bf7\u6c42"));
    }

    @GetMapping(value={"/agreeFriendRequest"})
    @ApiOperation(value="IM-\u540c\u610f\u597d\u53cb\u8bf7\u6c42", notes="IM-\u540c\u610f\u597d\u53cb\u8bf7\u6c42")
    public Result<?> agreeFriendRequest(@RequestParam(name="friendId") String friendId, @RequestParam(name="groupId") String groupId) {
        groupId = "null".equals(groupId) ? "" : groupId;
        ImUserFriend friend = this.iImGroupService.agreeFriendRequest(friendId, groupId);
        JSONObject toMap = new JSONObject();
        LoginUser loginSysUser = SysUtil.getLoginUser();
        ImUserDTO sysUser = this.imAccountRpcService.getImUserByLoginName(loginSysUser.getElsAccount(), loginSysUser.getSubAccount());
        if (null != WsOnlineContext.getChannelContextByUser(friendId)) {
            ImUserVO user = new ImUserVO();
            user.setId(sysUser.getId());
            user.setUsername(sysUser.getRealname());
            user.setAvatar(sysUser.getAvatar());
            user.setElsAccount(sysUser.getElsAccount());
            user.setSubAccount(sysUser.getSubAccount());
            user.setStatus(friend.getUserGroupId());
            user.setGroupId(friend.getUserGroupId());
            user.setCreateTime(new Date());
            toMap.put("msg_type", (Object)"agree");
            toMap.put("data", (Object)user);
            WsResponse toWsResponse = WsResponse.fromText((String)toMap.toString(), (String)"utf-8");
            Tio.send((ChannelContext)WsOnlineContext.getChannelContextByUser(friendId), (Packet)toWsResponse);
        }
        return Result.ok();
    }

    @GetMapping(value={"/deleteFriend"})
    @ApiOperation(value="IM-\u5220\u9664\u597d\u53cb", notes="IM-\u5220\u9664\u597d\u53cb")
    public Result<?> deleteFriend(@RequestParam(name="friendId") String friendId) {
        JSONObject toMap = new JSONObject();
        LoginUser loginSysUser = SysUtil.getLoginUser();
        ImUserDTO sysUser = this.imAccountRpcService.getImUserByLoginName(loginSysUser.getElsAccount(), loginSysUser.getSubAccount());
        this.imUserFriendService.deleteFriend(sysUser.getId(), friendId);
        if (null != WsOnlineContext.getChannelContextByUser(friendId)) {
            ImUserVO user = new ImUserVO();
            user.setId(sysUser.getId());
            user.setUsername(sysUser.getRealname());
            user.setAvatar(sysUser.getAvatar());
            user.setElsAccount(sysUser.getElsAccount());
            user.setSubAccount(sysUser.getSubAccount());
            user.setCreateTime(new Date());
            toMap.put("msg_type", (Object)"delUser");
            toMap.put("data", (Object)user);
            WsResponse toWsResponse = WsResponse.fromText((String)toMap.toString(), (String)"utf-8");
            Tio.send((ChannelContext)WsOnlineContext.getChannelContextByUser(friendId), (Packet)toWsResponse);
        }
        return Result.ok();
    }

    @PostMapping(value={"/createChatGroup"})
    @ApiOperation(value="IM-\u521b\u5efa\u7fa4\u804a", notes="IM-\u521b\u5efa\u7fa4\u804a")
    public Result<?> createChatGroup(ImGroupCreateDto imGroupCreateDto) {
        if (StrUtil.isNotEmpty((CharSequence)imGroupCreateDto.getChatGroupName())) {
            throw new ELSBootException("GroupName is Required.");
        }
        this.imChatGroupService.createChatGroup(imGroupCreateDto, false);
        return Result.ok();
    }

    @GetMapping(value={"/getAllUsers"})
    @ApiOperation(value="IM-\u83b7\u53d6\u6240\u6709\u7528\u6237\u4fe1\u606f", notes="IM-\u83b7\u53d6\u6240\u6709\u7528\u6237\u4fe1\u606f")
    public Result<?> getAllUsers(@RequestParam(name="name") String name) {
        List<ImUserVO> userList = this.imAccountRpcService.getAllUsers(name);
        return Result.ok(userList);
    }

    @GetMapping(value={"/refuseFriendRequest"})
    @ApiOperation(value="IM-\u62d2\u7edd\u597d\u53cb\u8bf7\u6c42", notes="IM-\u62d2\u7edd\u597d\u53cb\u8bf7\u6c42")
    public Result<?> refuseFriendRequest(@RequestParam(name="requestId") String requestId) {
        this.imUserFriendService.delFriendRequest(requestId);
        return Result.ok();
    }

    @PostMapping(value={"/createChatGroupById"})
    @ApiOperation(value="IM-\u6839\u636e\u5355\u636e\u521b\u5efa\u7fa4\u804a", notes="IM-\u6839\u636e\u5355\u636e\u521b\u5efa\u7fa4\u804a")
    @SrmValidated
    public Result<?> createChatGroupById(@RequestBody ImGroupCreateDto imGroupCreateDto) {
        ImChatGroup imChatGroup = (ImChatGroup)this.imChatGroupService.getById((Serializable)((Object)imGroupCreateDto.getId()));
        Assert.isNull((Object)imChatGroup, (String)I18nUtil.translate((String)"i18n_alert_rtFIOcIaL_7e08dd20", (String)"\u8be5\u5355\u636e\u5df2\u7ecf\u521b\u5efa\u7fa4\u804a"));
        String groupName = StrUtil.isEmpty((CharSequence)imGroupCreateDto.getChatGroupName()) ? imGroupCreateDto.getRecordType() + "-" + imGroupCreateDto.getRecordNumber() : imGroupCreateDto.getChatGroupName() + "-" + imGroupCreateDto.getRecordType() + "-" + imGroupCreateDto.getRecordNumber();
        imGroupCreateDto.setChatGroupName(groupName);
        imChatGroup = this.iImChatGroupService.createChatGroup(imGroupCreateDto, true);
        List chatGroupMembers = Arrays.stream(imGroupCreateDto.getMembers().split(",")).distinct().collect(Collectors.toList());
        JSONObject resultMap = new JSONObject();
        resultMap.put("msg_type", (Object)"addChatGroup");
        resultMap.put("data", (Object)imChatGroup);
        if (!chatGroupMembers.isEmpty()) {
            ArrayList chatGroupUserList = Lists.newArrayList();
            for (String memberId : chatGroupMembers) {
                ImChatGroupUser chatGroupUser = new ImChatGroupUser();
                chatGroupUser.setChatGroupId(imGroupCreateDto.getId());
                chatGroupUser.setUserId(memberId);
                chatGroupUser.setCreateDate(new Date());
                chatGroupUserList.add(chatGroupUser);
            }
            this.imChatGroupUserService.saveBatch(chatGroupUserList);
            for (String memberId : chatGroupMembers) {
                ChannelContext channelContext = WsOnlineContext.getChannelContextByUser(memberId);
                if (null == channelContext) continue;
                Tio.bindGroup((ChannelContext)channelContext, (String)imChatGroup.getId());
                WsResponse toWsResponse = WsResponse.fromText((String)resultMap.toString(), (String)"utf-8");
                Tio.send((ChannelContext)channelContext, (Packet)toWsResponse);
            }
        }
        return Result.ok((String)imChatGroup.getGroupname().replace(imChatGroup.getRecordType(), ImUtils.getRecordI18Value(imChatGroup.getRecordType())));
    }

    @GetMapping(value={"/getRecordPerson"})
    @ApiOperation(value="IM-\u6839\u636e\u5355\u636e\u83b7\u53d6\u5bf9\u5e94\u8d1f\u8d23\u4eba", notes="IM-\u6839\u636e\u5355\u636e\u83b7\u53d6\u5bf9\u5e94\u8d1f\u8d23\u4eba")
    public Result<?> getRecordPerson(@RequestParam(name="id") String recordId, @RequestParam(name="type") String type) {
        ImRecordTypeEnum imRecordTypeEnum = ImRecordTypeEnum.getImRecordTypeEnum((String)type);
        if (null == imRecordTypeEnum) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKtFAc_a8806a06", (String)"\u4e0d\u5b58\u5728\u5355\u636e\u7c7b\u578b"));
        }
        ImRecordDto recordDto = new ImRecordDto(recordId, type);
        List<ImUserDTO> recordUserList = this.imUserRecordRpcService.getRecordPersonInCharge(recordDto);
        List recordUserListVo = Convert.toList(ImUserVO.class, recordUserList);
        String userId = SysUtil.getLoginUser().getId();
        recordUserListVo = recordUserListVo.stream().filter(x -> !CharSequenceUtil.equals((CharSequence)userId, (CharSequence)x.getId())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ImUserVO>(Comparator.comparing(ImUserVO::getId))), ArrayList::new));
        return Result.ok((Object)ImUserListVO.buildImResultList(recordUserListVo, imRecordTypeEnum.isGroupChat()));
    }

    @GetMapping(value={"/loadUserList/{groupId}"})
    @ApiOperation(value="IM-\u7fa4\u7ec4\u6dfb\u52a0\u7fa4\u5458", notes="IM-\u7fa4\u7ec4\u6dfb\u52a0\u7fa4\u5458")
    public Result<?> loadUserList(@PathVariable(value="groupId") String groupId) {
        ImChatGroup group = (ImChatGroup)this.imChatGroupService.getById((Serializable)((Object)groupId));
        if (null == group) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKra_76bee2bc", (String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
        }
        String[] idStr = groupId.split(STR_SPLIT);
        String userId = SysUtil.getLoginUser().getId();
        ArrayList<ImUserVO> allUserList = new ArrayList();
        if (CharSequenceUtil.isNotBlank((CharSequence)group.getRecordType()) && idStr.length > 1) {
            ImRecordTypeEnum imRecordTypeEnum = ImRecordTypeEnum.getImRecordTypeEnum((String)group.getRecordType());
            if (null == imRecordTypeEnum) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_xMKra_76bee2bc", (String)"\u4e0d\u5b58\u5728\u8be5\u7fa4"));
            }
            ImRecordDto recordDto = new ImRecordDto(idStr[0], group.getRecordType());
            List<ImUserDTO> recordUserList = this.imUserRecordRpcService.getRecordPersonInCharge(recordDto);
            allUserList.addAll(Convert.toList(ImUserVO.class, (Object)recordUserList));
        }
        List recordIds = allUserList.stream().map(ImUserVO::getId).distinct().collect(Collectors.toList());
        List<ImGroupVO> friend = this.imAccountRpcService.getUserFriends(userId);
        for (ImGroupVO groupVO : friend) {
            List<ImUserVO> groupVOList = groupVO.getList();
            if (!CollUtil.isNotEmpty(groupVOList)) continue;
            List temList = groupVOList.stream().filter(x -> !recordIds.contains(x.getId())).map(x -> x.setUsername(groupVO.getGroupname() + "-" + x.getUsername())).collect(Collectors.toList());
            allUserList.addAll(temList);
        }
        List<ImChatGroupUser> chatUserByChatId = this.imChatGroupUserService.getChatUserByChatId(groupId);
        List charGroupUserIds = chatUserByChatId.stream().map(ImChatGroupUser::getUserId).distinct().collect(Collectors.toList());
        allUserList = allUserList.stream().filter(x -> !charGroupUserIds.contains(x.getId())).collect(Collectors.toList());
        return Result.ok((Object)ImUserListVO.buildImResultList(allUserList, true));
    }
}

