/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.tio.handler.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.I18nUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.im.core.ImMessageInfo;
import com.els.modules.im.core.SendInfo;
import com.els.modules.im.core.tio.handler.AbstractConnHandler;
import com.els.modules.im.core.tio.handler.HandlerDbService;
import com.els.modules.im.core.tio.handler.Opt;
import com.els.modules.im.entity.ImChatGroupUser;
import com.els.modules.im.entity.ImMessage;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.utils.lock.SetWithLock;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsResponse;

@Service
public class UndoMessageHandler
extends AbstractConnHandler {
    private static final Logger log = LoggerFactory.getLogger(UndoMessageHandler.class);
    @Autowired
    private HandlerDbService handlerDbService;
    private static final String UNDO_MESSAGE_REQUEST = "undo_message_request";
    private static final String UNDO_MESSAGE_REPLY_ACCEPT = "undo_message_reply_accept";
    private static final String UNDO_MESSAGE_REPLY_REJECT = "undo_message_reply_reject";
    private static final int UNDO_TIME_OUT = 120000;

    @Override
    public Opt opt() {
        return Opt.UNDO_MESSAGE_CONN;
    }

    private void reject(JSONObject outputResultMap, ImMessage dbMessage, ImMessageInfo message, long now, ChannelContext channelContext) {
        outputResultMap.put("msg_type", (Object)UNDO_MESSAGE_REPLY_REJECT);
        ImMessageInfo mime = new ImMessageInfo();
        mime.setFromid(dbMessage.getFromId());
        mime.setId(dbMessage.getToId());
        mime.setTimestamp(now);
        mime.setUndoMessageId(message.getUndoMessageId());
        mime.setContent(I18nUtil.translate((String)"i18n_alert_APXHhGIBRWWWWzsWShqM_7863f854", (String)"\u5f53\u524d\u6d88\u606f\u53d1\u51fa\u5df2\u8d85\u8fc7${0}\u5206\u949f\uff0c\u65e0\u6cd5\u64a4\u56de", (String[])new String[]{"2"}));
        outputResultMap.put("data", (Object)mime);
        SetWithLock mimeChannelContextSetWithLock = Tio.getChannelContextsByUserid((GroupContext)channelContext.groupContext, (String)dbMessage.getFromId());
        if (mimeChannelContextSetWithLock != null && mimeChannelContextSetWithLock.size() != 0) {
            WsResponse wsResponse = WsResponse.fromText((String)outputResultMap.toString(), (String)"utf-8");
            Tio.sendToUser((GroupContext)channelContext.groupContext, (String)dbMessage.getFromId(), (Packet)wsResponse);
        }
    }

    @Override
    public Object doHandler(JSONObject outputResultMap, SendInfo sendInfo, WsRequest wsRequest, ChannelContext channelContext) {
        ImMessageInfo message = sendInfo.getMessage();
        String type = message.getType();
        if (CharSequenceUtil.isEmpty((CharSequence)message.getUndoMessageId())) {
            log.warn("# UndoMessageHandler \u6d88\u606f\u64a4\u56de\u5904\u7406\u5668\u63a5\u6536\u5230\u64a4\u56de\u8bf7\u6c42\u6570\u636e\u4e0d\u89c4\u8303\uff0c\u7f3a\u5c11\u8981\u64a4\u56de\u7684\u6d88\u606fundoMessageId");
            return null;
        }
        if (UNDO_MESSAGE_REQUEST.equals(type)) {
            ImMessage dbMessage = (ImMessage)this.handlerDbService.getIImMessageService().getById((Serializable)((Object)message.getUndoMessageId()));
            if (null == dbMessage) {
                log.error("# UndoMessageHandler \u5f53\u524d\u6d88\u606f\u4e0d\u5b58\u5728undoMessageId:{}", (Object)message.getUndoMessageId());
                return null;
            }
            if (!dbMessage.getFromId().equals(channelContext.userid)) {
                return null;
            }
            long now = DateUtil.current();
            long diff = now - dbMessage.getSendTime();
            if (diff - 120000L < 0L) {
                if ("group".equals(dbMessage.getType())) {
                    List<ImChatGroupUser> chatUserList;
                    String groupId = dbMessage.getToId();
                    outputResultMap.put("msg_type", (Object)UNDO_MESSAGE_REPLY_ACCEPT);
                    ImMessageInfo mime = new ImMessageInfo();
                    mime.setFromid(dbMessage.getFromId());
                    mime.setId(dbMessage.getToId());
                    mime.setTimestamp(now);
                    mime.setUndoMessageId(message.getUndoMessageId());
                    mime.setContent(I18nUtil.translate((String)"i18n_alert_qMrITXH_85cce214", (String)"\u64a4\u56de\u4e86\u4e00\u6761\u6d88\u606f"));
                    outputResultMap.put("data", (Object)mime);
                    SetWithLock mimeChannelContextSetWithLock = Tio.getChannelContextsByUserid((GroupContext)channelContext.groupContext, (String)dbMessage.getFromId());
                    if (mimeChannelContextSetWithLock != null && mimeChannelContextSetWithLock.size() != 0) {
                        WsResponse wsResponse = WsResponse.fromText((String)outputResultMap.toString(), (String)"utf-8");
                        Tio.sendToUser((GroupContext)channelContext.groupContext, (String)dbMessage.getFromId(), (Packet)wsResponse);
                    }
                    if (CollectionUtil.isEmpty(chatUserList = this.handlerDbService.getImChatGroupUserServiceImpl().getChatUserByChatId(groupId))) {
                        this.handlerDbService.getIImMessageService().asyncUndoMessage(dbMessage.getId().toString(), channelContext.userid);
                        return null;
                    }
                    ImUserDTO userDTO = this.getImUserById(channelContext.userid);
                    mime.setContent(I18nUtil.translate((String)"i18n_alert_qMrITXH_85cce214", (String)"\u64a4\u56de\u4e86\u4e00\u6761\u6d88\u606f"));
                    outputResultMap.put("data", (Object)mime);
                    boolean inGroup = Tio.isInGroup((String)message.getId(), (ChannelContext)channelContext);
                    if (!inGroup) {
                        Tio.bindGroup((ChannelContext)channelContext, (String)message.getId());
                    }
                    WsResponse wsResponse = WsResponse.fromText((String)outputResultMap.toString(), (String)"utf-8");
                    Tio.sendToGroup((GroupContext)channelContext.groupContext, (String)groupId, (Packet)wsResponse);
                    this.handlerDbService.getIImMessageService().asyncUndoMessage(dbMessage.getId().toString(), channelContext.userid);
                } else if ("friend".equals(dbMessage.getType())) {
                    outputResultMap.put("msg_type", (Object)UNDO_MESSAGE_REPLY_ACCEPT);
                    ImMessageInfo mime = new ImMessageInfo();
                    mime.setFromid(dbMessage.getFromId());
                    mime.setId(dbMessage.getToId());
                    mime.setTimestamp(now);
                    mime.setUndoMessageId(message.getUndoMessageId());
                    mime.setContent(I18nUtil.translate((String)"i18n_alert_LqMrITXH_2265f46c", (String)"\u60a8\u64a4\u56de\u4e86\u4e00\u6761\u6d88\u606f"));
                    outputResultMap.put("data", (Object)mime);
                    SetWithLock mimeChannelContextSetWithLock = Tio.getChannelContextsByUserid((GroupContext)channelContext.groupContext, (String)dbMessage.getFromId());
                    if (mimeChannelContextSetWithLock != null && mimeChannelContextSetWithLock.size() != 0) {
                        WsResponse wsResponse = WsResponse.fromText((String)outputResultMap.toString(), (String)"utf-8");
                        Tio.sendToUser((GroupContext)channelContext.groupContext, (String)dbMessage.getFromId(), (Packet)wsResponse);
                    }
                    ImUserDTO userDTO = this.getImUserById(channelContext.userid);
                    mime.setContent(I18nUtil.translate((String)"i18n_alert_WWWWqMrITXH_5b071830", (String)"${0}\u64a4\u56de\u4e86\u4e00\u6761\u6d88\u606f", (String[])new String[]{userDTO.getElsAccount() + "_" + userDTO.getSubAccount()}));
                    outputResultMap.put("data", (Object)mime);
                    SetWithLock channelContextSetWithLock = Tio.getChannelContextsByUserid((GroupContext)channelContext.groupContext, (String)dbMessage.getToId());
                    if (channelContextSetWithLock != null && channelContextSetWithLock.size() != 0) {
                        WsResponse wsResponse = WsResponse.fromText((String)outputResultMap.toString(), (String)"utf-8");
                        Tio.sendToUser((GroupContext)channelContext.groupContext, (String)dbMessage.getToId(), (Packet)wsResponse);
                    }
                    this.handlerDbService.getIImMessageService().asyncUndoMessage(dbMessage.getId().toString(), channelContext.userid);
                }
            } else {
                log.warn("UndoMessageHandler \u6d88\u606f\u64a4\u56de\u8d85\u8fc7\u5141\u8bb8\u64a4\u56de\u7684\u65f6\u95f4\uff0c\u5f53\u524d\u6d88\u606f\u5df2\u53d1\u9001:{}\u5206", (Object)(diff / 60000L));
                this.reject(outputResultMap, dbMessage, message, now, channelContext);
            }
        }
        return null;
    }
}

