/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.tio.handler.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.modules.im.core.ImMessageInfo;
import com.els.modules.im.core.SendInfo;
import com.els.modules.im.core.tio.handler.AbstractConnHandler;
import com.els.modules.im.core.tio.handler.Opt;
import org.springframework.stereotype.Service;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.utils.lock.SetWithLock;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsResponse;

@Service
public class VideoConnHandler
extends AbstractConnHandler {
    private static final String VIDEO_REQUEST = "video_request";
    private static final String VIDEO_ACCEPT = "video_accept";
    private static final String VIDEO_REJECT = "video_reject";

    @Override
    public Opt opt() {
        return Opt.MSG_VIDEO_CONN;
    }

    @Override
    public Object doHandler(JSONObject outputResultMap, SendInfo sendInfo, WsRequest wsRequest, ChannelContext channelContext) {
        ImMessageInfo message = sendInfo.getMessage();
        String type = message.getType();
        if (type.startsWith("group")) {
            if (type.contains(VIDEO_REQUEST)) {
                outputResultMap.put("msg_type", (Object)"msg_video_request");
                outputResultMap.put("data", (Object)sendInfo.getMessage());
            } else if (type.contains(VIDEO_ACCEPT)) {
                outputResultMap.put("msg_type", (Object)"msg_video_accept");
                outputResultMap.put("data", (Object)sendInfo.getMessage());
            } else {
                outputResultMap.put("msg_type", (Object)"msg_video_reject");
                outputResultMap.put("data", (Object)sendInfo.getMessage());
            }
            boolean inGroup = Tio.isInGroup((String)message.getId(), (ChannelContext)channelContext);
            if (!inGroup) {
                Tio.bindGroup((ChannelContext)channelContext, (String)message.getId());
            }
            WsResponse wsResponse = WsResponse.fromText((String)outputResultMap.toString(), (String)"utf-8");
            Tio.sendToGroup((GroupContext)channelContext.groupContext, (String)message.getId(), (Packet)wsResponse);
        } else {
            if (type.contains(VIDEO_REQUEST)) {
                outputResultMap.put("msg_type", (Object)"msg_video_request");
                outputResultMap.put("data", (Object)sendInfo.getMessage());
            } else if (type.contains(VIDEO_ACCEPT)) {
                outputResultMap.put("msg_type", (Object)"msg_video_accept");
                outputResultMap.put("data", (Object)sendInfo.getMessage());
            } else {
                outputResultMap.put("msg_type", (Object)"msg_video_reject");
                outputResultMap.put("data", (Object)sendInfo.getMessage());
            }
            SetWithLock channelContextSetWithLock = Tio.getChannelContextsByUserid((GroupContext)channelContext.groupContext, (String)message.getId());
            if (channelContextSetWithLock != null && channelContextSetWithLock.size() != 0) {
                WsResponse wsResponse = WsResponse.fromText((String)outputResultMap.toString(), (String)"utf-8");
                Tio.sendToUser((GroupContext)channelContext.groupContext, (String)message.getId(), (Packet)wsResponse);
            }
        }
        return null;
    }
}

