/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.kefu.core;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class CircularQueue<E>
implements Iterable<E> {
    private int size;
    private Node<E> node;
    private Node<E> first;
    private Node<E> last;

    public boolean add(E e) {
        if (e == null) {
            return false;
        }
        if (this.existItem(e)) {
            return false;
        }
        this.insertLast(e);
        ++this.size;
        return true;
    }

    private boolean existItem(E e) {
        int len = 0;
        Node<E> x = this.first;
        while (x != null && len++ < this.size()) {
            if (Objects.equals(e, x.item)) {
                return true;
            }
            x = x.next;
        }
        return false;
    }

    private void insertCurrent(E e) {
        Node l = this.node.next;
        Node<E> newNode = new Node<E>(this.node, e, l);
        l.prev = newNode;
        this.node.next = newNode;
    }

    private void insertLast(E e) {
        Node<E> l = this.last;
        Node<E> newNode = new Node<E>(l, e, this.first);
        this.last = newNode;
        if (this.node == null) {
            this.node = newNode;
        }
        if (l == null) {
            this.first = newNode;
            this.first.prev = this.first;
            this.first.next = this.first;
        } else {
            l.next = newNode;
            this.first.prev = l.next;
        }
    }

    public E next() {
        if (this.node == null) {
            return null;
        }
        Object e = this.node.item;
        this.node = this.node.next;
        return e;
    }

    public E prev() {
        if (this.node == null) {
            return null;
        }
        Object e = this.node.item;
        this.node = this.node.prev;
        return e;
    }

    public E remove(E e) {
        if (e == null) {
            int len = 0;
            Node<E> x = this.first;
            while (x != null && len++ < this.size()) {
                if (x.item == null) {
                    return this.unlink(x);
                }
                x = x.next;
            }
        } else {
            int len = 0;
            Node<E> x = this.first;
            while (x != null && len++ < this.size()) {
                if (Objects.equals(e, x.item) || x.item == null) {
                    return this.unlink(x);
                }
                x = x.next;
            }
        }
        return null;
    }

    public E peek() {
        return this.node.item;
    }

    E unlink(Node<E> x) {
        Object element = x.item;
        Node next = x.next;
        Node prev = x.prev;
        if (this.first == x) {
            this.first = next;
        }
        if (this.last == x) {
            this.last = prev;
        }
        if (prev == x || next == x) {
            this.first = null;
            this.last = null;
            this.node = null;
        } else {
            next.prev = prev;
            prev.next = next;
            this.node = next;
        }
        x.item = null;
        x = null;
        --this.size;
        return element;
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return new ListIterator();
    }

    private static class Node<E> {
        private E item;
        private Node<E> next;
        private Node<E> prev;

        private Node(Node<E> prev, E element, Node<E> next) {
            this.item = element;
            this.next = next;
            this.prev = prev;
        }
    }

    private class ListIterator
    implements Iterator<E> {
        private Node<E> lastReturned;
        private Node<E> next;
        private int nextIndex;

        ListIterator() {
            this.next = CircularQueue.this.first;
            this.nextIndex = 0;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Node lastNext = this.lastReturned.next;
            CircularQueue.this.unlink(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = lastNext;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < CircularQueue.this.size;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.item;
        }
    }
}

