/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.rpc.base;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.account.api.service.ImAccountRpcService;
import com.els.modules.im.entity.ImChatGroupUser;
import com.els.modules.im.entity.ImUserFriend;
import com.els.modules.im.rpc.service.InvokeImAccountRpcService;
import com.els.modules.im.service.IImChatGroupUserService;
import com.els.modules.im.service.IImUserFriendService;
import com.els.modules.im.vo.ImGroupVO;
import com.els.modules.im.vo.ImUserVO;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AbstractInvokeImAccountRpcService
implements InvokeImAccountRpcService {
    protected ImAccountRpcService imAccountRpcService;
    protected IImUserFriendService iImUserFriendService;
    protected IImChatGroupUserService iImChatGroupUserService;

    @Override
    public ImUserDTO getImUserByLoginName(String elsAccount, String subAccount) {
        return this.imAccountRpcService.getImUserByLoginName(elsAccount, subAccount);
    }

    @Override
    public List<ImUserDTO> getGroupUsersByUserId(List<String> userList) {
        List accountList = this.imAccountRpcService.getUsersByUserId(userList);
        return null;
    }

    @Override
    public List<ImUserDTO> getUserFriendsRequest(String userId) {
        List<ImUserFriend> imUserFriendList = this.iImUserFriendService.listImUserFriendOfUid(userId);
        Map friendMap = imUserFriendList.stream().collect(Collectors.toMap(ImUserFriend::getUserId, Function.identity()));
        List imFriendUserList = this.imAccountRpcService.getUsersByUserId(imUserFriendList.stream().map(ImUserFriend::getUserId).collect(Collectors.toList()));
        int size = imFriendUserList.size();
        for (int i = size - 1; i >= 0; --i) {
            ImUserDTO imUserVO = (ImUserDTO)imFriendUserList.get(i);
            ImUserFriend imUserFriend = (ImUserFriend)friendMap.get(imUserVO.getId());
            if (null == imUserFriend) {
                imFriendUserList.remove(i);
                continue;
            }
            imUserVO.setCreateTime(imUserVO.getCreateTime());
        }
        return imFriendUserList;
    }

    @Override
    public List<ImUserDTO> getChatUserList(String chatId) {
        List<ImChatGroupUser> imChatGroupUserList = this.iImChatGroupUserService.getChatUserByChatId(chatId);
        return this.imAccountRpcService.getUsersByUserId(imChatGroupUserList.stream().map(ImChatGroupUser::getUserId).collect(Collectors.toList()));
    }

    @Override
    public ImUserDTO getImUserById(String userId) {
        return this.imAccountRpcService.getImUserById(userId);
    }

    @Override
    public List<ImUserDTO> getUsersByUserIdList(List<String> userIdList) {
        return this.imAccountRpcService.getUsersByUserId(userIdList);
    }

    @Override
    public List<ImGroupVO> getUserFriends(String userId) {
        List<ImGroupVO> userFriends = this.iImUserFriendService.getUserFriends(userId);
        List userIdList = userFriends.stream().flatMap(l -> l.getList().stream()).map(ImUserVO::getId).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        List usersLst = this.imAccountRpcService.getUsersByUserId(userIdList);
        List userVOList = Convert.toList(ImUserVO.class, (Object)usersLst);
        Map userMap = userVOList.stream().collect(Collectors.toMap(ImUserVO::getId, Function.identity(), (v1, v2) -> v2));
        for (ImGroupVO g : userFriends) {
            int size = g.getList().size();
            for (int i = size - 1; i >= 0; --i) {
                ImUserVO imUserVO = g.getList().get(i);
                ImUserVO vo = (ImUserVO)userMap.get(imUserVO.getId());
                if (null != vo) {
                    g.getList().remove(i);
                    g.getList().add(i, vo);
                    continue;
                }
                g.getList().remove(imUserVO);
            }
        }
        return userFriends;
    }

    @Override
    public List<ImUserVO> getAllUsers(String name) {
        List list = this.imAccountRpcService.getAllUsers(name);
        return Convert.toList(ImUserVO.class, (Object)list);
    }

    @Override
    public boolean checkIfKefu(String toUserId) {
        return this.imAccountRpcService.checkIfKefu(toUserId);
    }

    @Override
    public ImUserDTO getLoginUser(String userId) {
        return this.imAccountRpcService.getLoginUser(userId);
    }

    @Override
    public List<String> loadElsAccountId(List<String> elsAccount) {
        return this.imAccountRpcService.loadElsAccountId(elsAccount);
    }

    @Override
    public Map<String, List<String>> loadElsAccountIdToMap(List<String> elsAccount) {
        return this.imAccountRpcService.loadElsAccountIdToMap(elsAccount);
    }

    public List<ImUserDTO> loadElsAccount(List<String> userId) {
        if (CollectionUtil.isEmpty(userId)) {
            return Lists.newArrayList();
        }
        return this.imAccountRpcService.loadElsAccount(userId);
    }

    @Override
    public boolean checkIfSameElsAccount(String elsAccount, String userId) {
        return this.imAccountRpcService.checkIfSameElsAccount(elsAccount, userId);
    }

    @Override
    public List<ImUserDTO> listUser(List<String> userIds) {
        return this.imAccountRpcService.listUser(userIds);
    }

    @Override
    public List<ImUserVO> listSubAccountList(String elsAccount) {
        List list = this.imAccountRpcService.listSubAccountList(elsAccount);
        return Convert.toList(ImUserVO.class, (Object)list);
    }
}

