/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.tio.handler.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.glm.entity.GlmRecord;
import com.els.modules.glm.service.GlmRecordService;
import com.els.modules.im.core.ImMessageInfo;
import com.els.modules.im.core.SendInfo;
import com.els.modules.im.core.tio.ChatGroupChannelContextHolder;
import com.els.modules.im.core.tio.WsOnlineContext;
import com.els.modules.im.core.tio.handler.AbstractConnHandler;
import com.els.modules.im.core.tio.handler.HandlerDbService;
import com.els.modules.im.core.tio.handler.Opt;
import com.els.modules.im.dto.GroupMessageUserVo;
import com.els.modules.im.entity.ImChatGroup;
import com.els.modules.im.entity.ImChatGroupUser;
import com.els.modules.im.entity.ImGroupMessageUser;
import com.els.modules.im.entity.ImMessage;
import com.els.modules.im.service.ImGroupMessageUserService;
import com.els.modules.im.utils.ChatGptRobotUtil;
import com.els.modules.im.utils.ImMsgSendUtil;
import com.els.modules.im.utils.PanshiUtil;
import com.els.modules.im.utils.TuLingRobotUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.tio.core.ChannelContext;
import org.tio.core.ChannelContextFilter;
import org.tio.core.GroupContext;
import org.tio.core.Tio;
import org.tio.core.intf.Packet;
import org.tio.utils.lock.SetWithLock;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsResponse;

@Service
public class ChatHandler
extends AbstractConnHandler {
    private static final Logger log = LoggerFactory.getLogger(ChatHandler.class);
    @Autowired
    private HandlerDbService handlerDbService;
    @Autowired
    private ImMsgSendUtil imMsgSendUtil;
    private static final String CHAT_GPT_MODEL = "gpt-3.5-turbo";
    private static final String KNOWLEDGE_BASE_ID = "v5srm";
    private static final String ROBOT_ANSER = "im:tuling_robot:";
    private static final String CHAT_GPT_ANSER = "im:chat_gpt_robot:";
    private static final String CHAT_GLM_ANSER = "im:chat_glm_robot:";
    private static final String IM_KEFU = "im:kefu:";
    private static final String FUKE_QURRY_USER = "im:kefu:query_user";
    private boolean robotOn = true;
    private static final List<String> IGNORE = Lists.newArrayList((Object[])new String[]{"file"});

    @Override
    public Opt opt() {
        return Opt.MSG_MESSAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doHandler(JSONObject outputResultMap, SendInfo sendInfo, WsRequest wsRequest, ChannelContext channelContext) {
        ImMessageInfo message = sendInfo.getMessage();
        if (CharSequenceUtil.isEmpty((CharSequence)message.getMessageType())) {
            String content = message.getContent();
            if (content.startsWith(TuLingRobotUtil.ResultType.IMAGE.getStart())) {
                message.setMessageType(TuLingRobotUtil.ResultType.IMAGE.getType());
            } else if (content.startsWith(TuLingRobotUtil.ResultType.VOICE.getStart())) {
                message.setMessageType(TuLingRobotUtil.ResultType.VOICE.getType());
            } else if (content.startsWith(TuLingRobotUtil.ResultType.VIDEO.getStart())) {
                message.setMessageType(TuLingRobotUtil.ResultType.VIDEO.getType());
            } else {
                message.setMessageType(TuLingRobotUtil.ResultType.TEXT.getType());
            }
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)message.getCid())) {
            outputResultMap.put("msg_type", (Object)"msg_customer");
        } else {
            outputResultMap.put("msg_type", (Object)"msg_message");
        }
        outputResultMap.put("data", (Object)sendInfo.getMessage());
        message.setMine(false);
        WsResponse wsResponse = WsResponse.fromText((String)outputResultMap.toString(), (String)"utf-8");
        String addMessageId = null;
        String unSaveMessageId = message.getUnSaveMessageId();
        if ("friend".equals(message.getType()) && !"kefu".equals(message.getCid())) {
            ImMessage imMessage;
            SetWithLock channelContextSetWithLock = Tio.getChannelContextsByUserid((GroupContext)channelContext.groupContext, (String)message.getId());
            if (channelContextSetWithLock == null || channelContextSetWithLock.size() == 0) {
                imMessage = this.saveMessage(message, "1");
                this.imMsgSendUtil.sendMessage(message.getFromid(), "imChatFriend", "", imMessage, Lists.newArrayList((Object[])new String[]{imMessage.getToId()}));
            } else {
                Tio.sendToUser((GroupContext)channelContext.groupContext, (String)message.getId(), (Packet)wsResponse);
                imMessage = this.saveMessage(message, "0");
            }
            addMessageId = imMessage.getId();
        } else if ("customer".equals(message.getType()) || "kefu".equals(message.getCid())) {
            ImMessage imMessage;
            String toUserId = message.getId();
            log.info(":::\u5ba2\u670d\u804a\u5929\u4e2d\uff0c\u6536\u5230\u6d88\u606f\u7684\u7528\u6237id:{}", (Object)toUserId);
            Object o = this.handlerDbService.getRedisUtil().get(IM_KEFU + toUserId);
            boolean isKefu = false;
            if (null == o) {
                isKefu = this.imAccountRpcService.checkIfKefu(toUserId);
                this.handlerDbService.getRedisUtil().set(IM_KEFU + toUserId, (Object)isKefu, 86400L);
            } else {
                isKefu = (Boolean)o;
            }
            SetWithLock channelContextSetWithLock = Tio.getChannelContextsByUserid((GroupContext)channelContext.groupContext, (String)message.getId());
            if (channelContextSetWithLock == null || channelContextSetWithLock.size() == 0) {
                imMessage = this.saveMessage(message, "1");
                log.info(":::\u5373\u5c06\u8c03\u7528ChatGpt\u67e5\u627e\u6570\u636e:{}...", (Object)(BooleanUtil.isTrue((Boolean)this.robotOn) && isKefu ? 1 : 0));
                if (BooleanUtil.isTrue((Boolean)this.robotOn) && isKefu && !message.isManualServiceConn() && !"1".equals(message.getReplyByRobot())) {
                    this.chatGptReplay(message, wsRequest, message.getFromid(), CHAT_GPT_MODEL);
                }
                if (message.isManualServiceConn()) {
                    this.imMsgSendUtil.sendMessage(message.getFromid(), "imChatKeFu", "", imMessage, Lists.newArrayList((Object[])new String[]{imMessage.getToId()}));
                }
            } else {
                Tio.sendToUser((GroupContext)channelContext.groupContext, (String)message.getId(), (Packet)wsResponse);
                imMessage = this.saveMessage(message, "0");
                log.info(":::\u5373\u5c06\u8c03\u7528ChatGpt\u67e5\u627e\u6570\u636e:{}...", (Object)(BooleanUtil.isTrue((Boolean)this.robotOn) && isKefu ? 1 : 0));
                if (BooleanUtil.isTrue((Boolean)this.robotOn) && isKefu && !message.isManualServiceConn() && !"1".equals(message.getReplyByRobot())) {
                    this.chatGptReplay(message, wsRequest, message.getFromid(), CHAT_GPT_MODEL);
                }
            }
            if (isKefu && message.isManualServiceConn()) {
                this.sendMessageToPanshi(imMessage);
                this.sendMessageToIPass(imMessage);
                this.imMsgSendUtil.sendMessage(message.getFromid(), "imChatFriend", "", imMessage, Lists.newArrayList((Object[])new String[]{imMessage.getToId()}));
            }
            addMessageId = imMessage.getId();
        } else {
            boolean inGroup = Tio.isInGroup((String)message.getId(), (ChannelContext)channelContext);
            if (!inGroup) {
                Tio.bindGroup((ChannelContext)channelContext, (String)message.getId());
            }
            ImMessageInfo groupMsg = sendInfo.getMessage();
            List<ImChatGroupUser> chatGroupUser = this.handlerDbService.getImChatGroupUserServiceImpl().getChatUserByChatId(message.getId());
            ArrayList<GroupMessageUserVo> messageUserVoList = new ArrayList<GroupMessageUserVo>(chatGroupUser.size());
            for (ImChatGroupUser user : chatGroupUser) {
                if (message.getFromid().equals(user.getUserId()) || WsOnlineContext.contains(user.getUserId())) continue;
                GroupMessageUserVo vo = new GroupMessageUserVo();
                vo.setGroupId(message.getId());
                vo.setUserId(user.getUserId());
                vo.setRead(false);
                messageUserVoList.add(vo);
            }
            outputResultMap.put("data", (Object)groupMsg);
            message.setMine(false);
            wsResponse = WsResponse.fromText((String)outputResultMap.toString(), (String)"utf-8");
            try {
                addMessageId = this.inOrderToSendGroupMessage(channelContext, message, wsResponse, messageUserVoList);
            }
            finally {
                ChatGroupChannelContextHolder.remove();
                ChatGroupChannelContextHolder.removeFlag();
            }
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)addMessageId)) {
            JSONObject idResultMap = new JSONObject();
            idResultMap.put("msg_type", (Object)"send_message_id_return");
            ImMessageInfo returnMessage = new ImMessageInfo();
            returnMessage.setUnSaveMessageId(unSaveMessageId);
            returnMessage.setUndoMessageId(addMessageId);
            idResultMap.put("data", (Object)returnMessage);
            SetWithLock mimeChannelContextSetWithLock = Tio.getChannelContextsByUserid((GroupContext)channelContext.groupContext, (String)channelContext.userid);
            if (mimeChannelContextSetWithLock != null && mimeChannelContextSetWithLock.size() != 0) {
                wsResponse = WsResponse.fromText((String)idResultMap.toString(), (String)"utf-8");
                Tio.sendToUser((GroupContext)channelContext.groupContext, (String)channelContext.userid, (Packet)wsResponse);
            }
        }
        return null;
    }

    private void chatGptReplay(ImMessageInfo message, WsRequest wsRequest, String userid, String model) {
        if (IGNORE.contains(message.getMessageType())) {
            return;
        }
        log.info("chatGptReplay \u81ea\u52a8\u56de\u590d\u83b7\u53d6\u56de\u590d\u6570\u636e");
        Integer hashCode = message.getContent().hashCode();
        Object obj = this.handlerDbService.getRedisUtil().get(CHAT_GPT_ANSER + message.getId() + ":" + hashCode.toString());
        JSONObject chatGpt = null;
        if (obj != null) {
            chatGpt = JSONObject.parseObject((String)JSON.toJSONString((Object)obj));
        } else {
            JSONObject requestJSON = TuLingRobotUtil.buildChatGptJSONObject(message, SysUtil.getPurchaseAccount(), model);
            JSONObject result = this.handlerDbService.getImSrmToIPaasServiceImpl().callIPaasInterface(requestJSON, "valueAddedApplication", this.handlerDbService.getImInvokeBaseRpcService().getIpaasInterfaceCode("chat-gpt"));
            chatGpt = ChatGptRobotUtil.analysisResult(result);
            if (null != chatGpt) {
                this.handlerDbService.getRedisUtil().set(CHAT_GPT_ANSER + message.getId() + ":" + hashCode.toString(), (Object)chatGpt, 259200L);
            } else {
                this.sendNoPermission(message, wsRequest, userid, result.getString("message"));
                return;
            }
        }
        if (null == chatGpt) {
            return;
        }
        ImUserDTO imUser = this.imAccountRpcService.getImUserById(message.getId());
        if (null == imUser) {
            return;
        }
        if (chatGpt.containsKey((Object)"error")) {
            chatGpt = this.buildChatGptError(chatGpt.getString("error"));
        }
        log.info("chatGptReplay \u81ea\u52a8\u56de\u590d\u83b7\u53d6\u56de\u590d\u6570\u636e\u5373\u5c06\u56de\u590d");
        ChannelContext cc = WsOnlineContext.getChannelContextByUser(userid);
        List choices = chatGpt.getJSONArray("choices").toJavaList(JSONObject.class);
        for (JSONObject objects : choices) {
            JSONObject messageObj = objects.getJSONObject("message");
            if (null == messageObj) continue;
            String content = messageObj.getString("content");
            SendInfo sendInfo = new SendInfo();
            sendInfo.setCode("2");
            ImMessageInfo messageInfo = new ImMessageInfo();
            messageInfo.setId(message.getFromid());
            messageInfo.setFromid(message.getId());
            messageInfo.setCid("kefu");
            messageInfo.setUsername("\u673a\u667a\u7684\u5c0f\u4f01");
            messageInfo.setAvatar("/kefu/static/robot.png");
            messageInfo.setContent(content);
            messageInfo.setMine(false);
            messageInfo.setMessageType("text");
            messageInfo.setReplyByRobot("1");
            messageInfo.setTimestamp(System.currentTimeMillis());
            messageInfo.setType(message.getType());
            messageInfo.setIfTranslate("0");
            sendInfo.setMessage(messageInfo);
            log.info(":::\u6536\u5230\u7684\u6d88\u606f:{},chatGpt\u81ea\u52a8\u56de\u590d\u7684\u6d88\u606f:{}", (Object)message, (Object)sendInfo);
            if (cc == null || cc.isClosed) continue;
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                this.reCallOnText(wsRequest, objectMapper.writeValueAsString((Object)sendInfo), cc);
            }
            catch (JsonProcessingException e) {
                log.error("::: chatGpt\u81ea\u52a8\u56de\u590d\u67e5\u8be2\u7684\u5185\u5bb9\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
    }

    private void chatGlmReplay(ImMessageInfo message, WsRequest wsRequest, String userid, String knowledgeBaseId) {
        if (IGNORE.contains(message.getMessageType())) {
            return;
        }
        log.info("chatGlmReplay \u81ea\u52a8\u56de\u590d\u83b7\u53d6\u56de\u590d\u6570\u636e");
        Integer hashCode = message.getContent().hashCode();
        Object obj = this.handlerDbService.getRedisUtil().get(CHAT_GLM_ANSER + message.getId() + ":" + hashCode.toString());
        JSONObject chatGlm = null;
        if (obj != null) {
            chatGlm = JSONObject.parseObject((String)JSON.toJSONString((Object)obj));
        } else {
            JSONObject requestJSON = TuLingRobotUtil.buildChatGlmJSONObject(message, SysUtil.getPurchaseAccount(), knowledgeBaseId);
            JSONObject result = this.handlerDbService.getImSrmToIPaasServiceImpl().callIPaasInterface(requestJSON, "valueAddedApplication", this.handlerDbService.getImInvokeBaseRpcService().getIpaasInterfaceCode("chat-glm"));
            chatGlm = ChatGptRobotUtil.analysisResult(result);
            if (null != chatGlm) {
                this.handlerDbService.getRedisUtil().set(CHAT_GLM_ANSER + message.getId() + ":" + hashCode.toString(), (Object)chatGlm, 259200L);
            } else {
                this.sendNoPermission(message, wsRequest, userid, result.getString("message"));
                return;
            }
        }
        if (null == chatGlm) {
            return;
        }
        ImUserDTO imUser = this.imAccountRpcService.getImUserById(message.getFromid());
        if (null == imUser) {
            return;
        }
        GlmRecord record = new GlmRecord();
        record.setElsAccount(imUser.getElsAccount());
        record.setSubAccount(imUser.getSubAccount());
        record.setUserName(imUser.getRealname());
        record.setSendTime(new Date());
        record.setQuestion(chatGlm.getString("question"));
        record.setResponse(chatGlm.getString("response"));
        record.setSourceDocuments(chatGlm.getString("source_documents"));
        ((GlmRecordService)SpringContextUtils.getBean(GlmRecordService.class)).saveRecord(record);
        log.info("chatGlmReplay \u81ea\u52a8\u56de\u590d\u83b7\u53d6\u56de\u590d\u6570\u636e\u5373\u5c06\u56de\u590d");
        ChannelContext cc = WsOnlineContext.getChannelContextByUser(userid);
        String choices = chatGlm.getString("response");
        ArrayList sourceDocuments = Lists.newArrayList((Object[])new String[]{choices});
        for (String content : sourceDocuments) {
            SendInfo sendInfo = new SendInfo();
            sendInfo.setCode("2");
            ImMessageInfo messageInfo = new ImMessageInfo();
            messageInfo.setId(message.getFromid());
            messageInfo.setFromid(message.getId());
            messageInfo.setCid("kefu");
            messageInfo.setUsername("\u673a\u667a\u7684\u5c0f\u4f01");
            messageInfo.setAvatar("/kefu/static/robot.png");
            messageInfo.setContent(content);
            messageInfo.setMine(false);
            messageInfo.setMessageType("text");
            messageInfo.setReplyByRobot("1");
            messageInfo.setTimestamp(System.currentTimeMillis());
            messageInfo.setType(message.getType());
            messageInfo.setIfTranslate("0");
            sendInfo.setMessage(messageInfo);
            log.info(":::\u6536\u5230\u7684\u6d88\u606f:{},chatGlm\u81ea\u52a8\u56de\u590d\u7684\u6d88\u606f:{}", (Object)message, (Object)sendInfo);
            if (cc == null || cc.isClosed) continue;
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                this.reCallOnText(wsRequest, objectMapper.writeValueAsString((Object)sendInfo), cc);
            }
            catch (JsonProcessingException e) {
                log.error("::: chatGlm\u81ea\u52a8\u56de\u590d\u67e5\u8be2\u7684\u5185\u5bb9\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
    }

    private void sendNoPermission(ImMessageInfo message, WsRequest wsRequest, String userid, String content) {
        ChannelContext cc = WsOnlineContext.getChannelContextByUser(userid);
        SendInfo sendInfo = new SendInfo();
        sendInfo.setCode("2");
        ImMessageInfo messageInfo = new ImMessageInfo();
        messageInfo.setId(message.getFromid());
        messageInfo.setFromid(message.getId());
        messageInfo.setCid("kefu");
        messageInfo.setUsername("\u673a\u667a\u7684\u5c0f\u4f01");
        messageInfo.setAvatar("/kefu/static/robot.png");
        messageInfo.setContent(content);
        messageInfo.setMine(false);
        messageInfo.setMessageType("text");
        messageInfo.setReplyByRobot("1");
        messageInfo.setTimestamp(System.currentTimeMillis());
        messageInfo.setType(message.getType());
        messageInfo.setIfTranslate("0");
        sendInfo.setMessage(messageInfo);
        log.info(":::\u6536\u5230\u7684\u6d88\u606f:{},chatGpt\u81ea\u52a8\u56de\u590d\u7684\u6d88\u606f:{}", (Object)message, (Object)sendInfo);
        if (cc != null && !cc.isClosed) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                this.reCallOnText(wsRequest, objectMapper.writeValueAsString((Object)sendInfo), cc);
            }
            catch (JsonProcessingException e) {
                log.error("::: chatGpt\u81ea\u52a8\u56de\u590d\u67e5\u8be2\u7684\u5185\u5bb9\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
    }

    private JSONObject buildChatGptError(String errorMsg) {
        JSONObject param = new JSONObject();
        JSONObject choiceObj = new JSONObject();
        JSONObject message = new JSONObject();
        message.put("content", (Object)errorMsg);
        choiceObj.put("message", (Object)message);
        JSONArray choices = new JSONArray();
        choices.add((Object)choiceObj);
        param.put("choices", (Object)choices);
        return param;
    }

    @Deprecated
    private void robotReplay(ImMessageInfo message, WsRequest wsRequest, String userid) {
        if (IGNORE.contains(message.getMessageType())) {
            return;
        }
        Integer hashCode = message.getContent().hashCode();
        Object obj = this.handlerDbService.getRedisUtil().get(ROBOT_ANSER + message.getId() + ":" + hashCode.toString());
        List<Object> tuLingRobotResults = new ArrayList();
        if (obj != null) {
            log.info(":::\u81ea\u52a8\u56de\u590d\u4ece\u7f13\u5b58\u4e2d\u56de\u53bb\u7ed3\u679c:{}", obj);
            tuLingRobotResults = JSONArray.parseArray((String)JSON.toJSONString((Object)obj), TuLingRobotUtil.TuLingRobotResult.class);
        } else {
            JSONObject requestJSON = TuLingRobotUtil.buildJSONObject(message, (String)this.configMap.get("elsAccount"), this.handlerDbService.getServerPath());
            JSONObject result = this.handlerDbService.getImSrmToIPaasServiceImpl().callIPaasInterface(requestJSON, "valueAddedApplication", this.handlerDbService.getImInvokeBaseRpcService().getIpaasInterfaceCode("tuling-anser"));
            tuLingRobotResults = TuLingRobotUtil.analysisResult(result);
            if (!tuLingRobotResults.isEmpty()) {
                this.handlerDbService.getRedisUtil().set(ROBOT_ANSER + message.getId() + ":" + hashCode.toString(), tuLingRobotResults, 259200L);
            }
        }
        if (null == tuLingRobotResults || tuLingRobotResults.isEmpty()) {
            return;
        }
        ImUserDTO imUser = this.imAccountRpcService.getImUserById(message.getId());
        if (null == imUser) {
            return;
        }
        ChannelContext cc = WsOnlineContext.getChannelContextByUser(userid);
        for (TuLingRobotUtil.TuLingRobotResult tuLingRobotResult : tuLingRobotResults) {
            List<String> values = tuLingRobotResult.getValues();
            for (String v : values) {
                SendInfo sendInfo = new SendInfo();
                sendInfo.setCode("2");
                ImMessageInfo messageInfo = new ImMessageInfo();
                messageInfo.setId(message.getFromid());
                messageInfo.setFromid(message.getId());
                messageInfo.setCid("kefu");
                messageInfo.setUsername("\u4f01\u4f01\u901a\u5728\u7ebfRobot");
                messageInfo.setAvatar(imUser.getAvatar());
                JSONObject jsonObject = (JSONObject)JSON.parseObject((String)v, JSONObject.class);
                String value = jsonObject.getString(tuLingRobotResult.getResultType());
                messageInfo.setContent(value);
                messageInfo.setContent(TuLingRobotUtil.ResultType.buildText(tuLingRobotResult.getResultType(), value));
                messageInfo.setMine(false);
                messageInfo.setMessageType(TuLingRobotUtil.ResultType.buildType(tuLingRobotResult.getResultType()));
                messageInfo.setTimestamp(System.currentTimeMillis());
                messageInfo.setType(message.getType());
                messageInfo.setIfTranslate("0");
                sendInfo.setMessage(messageInfo);
                log.info(":::\u6536\u5230\u7684\u6d88\u606f:{},\u56fe\u7075\u673a\u5668\u4eba\u81ea\u52a8\u56de\u590d\u7684\u6d88\u606f:{}", (Object)message, (Object)sendInfo);
                if (cc == null || cc.isClosed) continue;
                try {
                    ObjectMapper objectMapper = new ObjectMapper();
                    this.reCallOnText(wsRequest, objectMapper.writeValueAsString((Object)sendInfo), cc);
                }
                catch (JsonProcessingException e) {
                    log.error("::: \u81ea\u52a8\u56de\u53bb\u56fe\u7075\u673a\u5668\u4eba\u67e5\u8be2\u7684\u5185\u5bb9\u5931\u8d25:{}", (Object)e.getMessage());
                }
            }
        }
    }

    private void sendMessageToIPass(ImMessage imMessage) {
        try {
            String key = "im:kefu:query_user:" + imMessage.getFromId();
            ImUserDTO user = (ImUserDTO)this.handlerDbService.getRedisUtil().get(key);
            if (null == user) {
                user = this.imAccountRpcService.getLoginUser(imMessage.getFromId());
            }
            if (null == user) {
                log.error(":::\u7528\u6237\u4e0d\u5b58\u5728 userId:{}", (Object)imMessage.getFromId());
                return;
            }
            this.handlerDbService.getRedisUtil().set("im:kefu:query_user:" + user.getId(), (Object)user, 259200L);
            JSONObject requestJSON = TuLingRobotUtil.buildJSONObject(imMessage, user, (String)this.configMap.get("elsAccount"), this.handlerDbService.getServerPath());
            JSONObject result = this.handlerDbService.getImSrmToIPaasServiceImpl().callIPaasInterface(requestJSON, "valueAddedApplication", this.handlerDbService.getImInvokeBaseRpcService().getIpaasInterfaceCode("ipass-kefu-anser"));
            log.info(":::\u5ba2\u670d\u53d1\u9001\u6570\u636e\u7ed9ipass\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)result));
        }
        catch (Exception e) {
            log.error(":::\u5ba2\u670d\u53d1\u9001\u6570\u636e\u7ed9ipass\u5931\u8d25:{}", (Object)e.getMessage());
        }
    }

    private String inOrderToSendGroupMessage(ChannelContext channelContext, ImMessageInfo message, WsResponse wsResponse, List<GroupMessageUserVo> messageUserVoList) {
        ImChatGroup group = (ImChatGroup)this.imChatGroupServiceImpl.getById((Serializable)((Object)message.getId()));
        List<Object> fromUserIds = new ArrayList();
        ChatGroupChannelContextHolder.setFlag(false);
        if (!group.getMaster().equals(message.getFromid())) {
            List<ImUserDTO> userList = this.imAccountRpcService.listUser(Lists.newArrayList((Object[])new String[]{message.getFromid(), group.getMaster()}));
            Map<String, String> userMap = userList.stream().collect(Collectors.toMap(ImUserDTO::getId, ImUserDTO::getElsAccount));
            List<String> elsAccountList = userList.stream().map(ImUserDTO::getElsAccount).collect(Collectors.toList());
            Map<String, List<String>> idMap = this.imAccountRpcService.loadElsAccountIdToMap(elsAccountList);
            List<String> masterIds = idMap.get(userMap.get(group.getMaster()));
            if (!masterIds.contains(message.getFromid())) {
                fromUserIds = idMap.get(userMap.get(message.getFromid()));
                fromUserIds.addAll(masterIds);
                ChatGroupChannelContextHolder.setFlag(true);
                ChatGroupChannelContextHolder.set(fromUserIds);
            }
        }
        Tio.sendToGroup((GroupContext)channelContext.groupContext, (String)message.getId(), (Packet)wsResponse, (ChannelContextFilter)this.handlerDbService.getChannelContextFilter());
        ImMessage imMessage = this.saveMessage(message, "0");
        ArrayList finalFromUserIds = fromUserIds;
        messageUserVoList = messageUserVoList.stream().filter(x -> CollectionUtils.isEmpty((Collection)finalFromUserIds) || finalFromUserIds.contains(x.getUserId())).collect(Collectors.toList());
        List collect = messageUserVoList.stream().filter(x -> !x.isRead()).map(x -> {
            ImGroupMessageUser tem = new ImGroupMessageUser();
            tem.setStatus(1);
            tem.setUserId(x.getUserId());
            tem.setGroupId(message.getId());
            tem.setMessageId(imMessage.getId().toString());
            return tem;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            ((ImGroupMessageUserService)SpringContextUtils.getBean(ImGroupMessageUserService.class)).saveBatch(collect);
        }
        if (CollectionUtils.isNotEmpty(messageUserVoList)) {
            this.imMsgSendUtil.sendMessage(message.getFromid(), "imChatGroup", message.getId(), imMessage, messageUserVoList.stream().map(GroupMessageUserVo::getUserId).collect(Collectors.toList()));
        }
        return imMessage.getId();
    }

    private void sendMessageToPanshi(ImMessage imMessage) {
        try {
            String key = "im:kefu:query_user:" + imMessage.getFromId();
            ImUserDTO user = (ImUserDTO)this.handlerDbService.getRedisUtil().get(key);
            if (null == user) {
                user = this.imAccountRpcService.getLoginUser(imMessage.getFromId());
            }
            if (null == user) {
                log.error(":::\u7528\u6237\u4e0d\u5b58\u5728 userId:{}", (Object)imMessage.getFromId());
                return;
            }
            this.handlerDbService.getRedisUtil().set("im:kefu:query_user:" + user.getId(), (Object)user, 259200L);
            JSONObject paramObj = this.buildPanshiParam(imMessage, user);
            PanshiUtil panshiUtil = (PanshiUtil)SpringContextUtils.getBean(PanshiUtil.class);
            JSONObject result = panshiUtil.callPanshi("sendKefuMessage", paramObj);
            log.info(":::\u5ba2\u670d\u53d1\u9001\u6570\u636e\u7ed9Panshi\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)result));
        }
        catch (Exception e) {
            log.error(":::\u5ba2\u670d\u53d1\u9001\u6570\u636e\u7ed9Panshi\u5931\u8d25:{}", (Throwable)e);
        }
    }

    private JSONObject buildPanshiParam(ImMessage imMessage, ImUserDTO user) {
        JSONObject bodyObj = new JSONObject();
        bodyObj.put("elsAccount", (Object)user.getElsAccount());
        bodyObj.put("subAccount", (Object)user.getSubAccount());
        bodyObj.put("companyName", (Object)user.getEnterpriseName());
        bodyObj.put("subAccountName", (Object)user.getRealname());
        bodyObj.put("msgId", (Object)imMessage.getId());
        JSONObject recordObj = new JSONObject();
        recordObj.put("content", (Object)imMessage.getContent());
        bodyObj.put("record", (Object)recordObj);
        return bodyObj;
    }
}

