/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.bidding.entity.PurchaseClarificationInfo;
import com.els.modules.bidding.service.PurchaseClarificationInfoService;
import com.els.modules.bidding.vo.PurchaseClarificationInfoVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u91c7\u8d2d\u6f84\u6e05\u4fe1\u606f")
@RestController
@RequestMapping(value={"/bidding/purchaseClarificationInfo"})
@BusinessModule(module="clarification")
public class PurchaseClarificationInfoController
extends BaseController<PurchaseClarificationInfo, PurchaseClarificationInfoService> {
    @Autowired
    private PurchaseClarificationInfoService purchaseClarificationInfoService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="purchaseClarificationInfo")
    @RequiresPermissions(value={"bidding#purchaseClarificationInfo:list"})
    public Result<?> queryPageList(PurchaseClarificationInfo purchaseClarificationInfo, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseClarificationInfo), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseClarificationInfoService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u91c7\u8d2d\u6f84\u6e05\u4fe1\u606f-\u6dfb\u52a0", operateType=2)
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"bidding#purchaseClarificationInfo:add"})
    public Result<?> add(@RequestBody PurchaseClarificationInfoVO purchaseClarificationInfoVO) {
        PurchaseClarificationInfo purchaseClarificationInfo = new PurchaseClarificationInfo();
        BeanUtils.copyProperties((Object)((Object)purchaseClarificationInfoVO), (Object)((Object)purchaseClarificationInfo));
        this.purchaseClarificationInfoService.savePurchaseClarificationInfo(purchaseClarificationInfo, purchaseClarificationInfoVO.getAttachments());
        return Result.ok((Object)((Object)purchaseClarificationInfo));
    }

    @AutoLog(value="\u91c7\u8d2d\u6f84\u6e05\u4fe1\u606f-\u7f16\u8f91", operateType=3)
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"bidding#purchaseClarificationInfo:edit"})
    @SrmValidated
    public Result<?> edit(@RequestBody PurchaseClarificationInfoVO purchaseClarificationInfoVO) {
        PurchaseClarificationInfo purchaseClarificationInfo = new PurchaseClarificationInfo();
        BeanUtils.copyProperties((Object)((Object)purchaseClarificationInfoVO), (Object)((Object)purchaseClarificationInfo));
        this.purchaseClarificationInfoService.updatePurchaseClarificationInfo(purchaseClarificationInfo, purchaseClarificationInfoVO.getAttachments());
        String id = purchaseClarificationInfo.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u91c7\u8d2d\u6f84\u6e05\u4fe1\u606f-\u901a\u8fc7id\u5220\u9664", operateType=4)
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"bidding#purchaseClarificationInfo:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseClarificationInfoService.delPurchaseClarificationInfo(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u6f84\u6e05\u4fe1\u606f-\u6279\u91cf\u5220\u9664", operateType=4)
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"bidding#purchaseClarificationInfo:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseClarificationInfoService.delBatchPurchaseClarificationInfo(idList);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"bidding#purchaseClarificationInfo:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseClarificationInfo purchaseClarificationInfo = (PurchaseClarificationInfo)((Object)this.purchaseClarificationInfoService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseClarificationInfoVO headVO = new PurchaseClarificationInfoVO();
        BeanUtils.copyProperties((Object)((Object)purchaseClarificationInfo), (Object)((Object)headVO));
        List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        headVO.setAttachments(attachments);
        return Result.ok((Object)((Object)headVO));
    }

    @Operation(summary="\u53d1\u5e03", description="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"bidding#purchaseClarificationInfo:publish"})
    @SrmValidated
    public Result<?> publish(@RequestBody PurchaseClarificationInfoVO clarificationInfoVO) {
        PurchaseClarificationInfo purchaseClarificationInfo = new PurchaseClarificationInfo();
        BeanUtils.copyProperties((Object)((Object)clarificationInfoVO), (Object)((Object)purchaseClarificationInfo));
        this.purchaseClarificationInfoService.publish(purchaseClarificationInfo, clarificationInfoVO.getAttachments());
        return this.commonSuccessResult(3);
    }
}

