/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.api.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.api.dto.PriceRecordsDTO;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.SysUtil;
import com.els.modules.demand.api.dto.PurchaseOrderRequestInformationDTO;
import com.els.modules.demand.api.dto.PurchaseRequestHeadDTO;
import com.els.modules.demand.api.dto.PurchaseRequestItemDTO;
import com.els.modules.demand.api.service.PurchaseRequestHeadRpcService;
import com.els.modules.demand.entity.PurchaseOrderRequestInformation;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.service.PurchaseOrderRequestInformationService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

@RpcService
public class PurchaseRequestHeadRpcDubboServiceImpl
implements PurchaseRequestHeadRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseRequestHeadRpcDubboServiceImpl.class);
    @Lazy
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Lazy
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Lazy
    @Autowired
    private PurchaseOrderRequestInformationService purchaseOrderRequestInformationService;

    public void syncRequestToOrderQuantity(List<PurchaseRequestItemDTO> purchaseRequestItemList) {
        this.purchaseRequestHeadService.syncRequestToOrderQuantity(SysUtil.copyProperties(purchaseRequestItemList, PurchaseRequestItem.class));
    }

    public void syncRequestatus(List<PurchaseRequestItemDTO> requestItemList) {
        this.purchaseRequestHeadService.syncRequestatus(SysUtil.copyProperties(requestItemList, PurchaseRequestItem.class));
    }

    public PurchaseRequestItemDTO selectPurchaseRequestItemById(String id) {
        return (PurchaseRequestItemDTO)SysUtil.copyProperties((Object)this.purchaseRequestItemService.getById((Serializable)((Object)id)), PurchaseRequestItemDTO.class);
    }

    public List<PurchaseRequestItemDTO> selectPurchaseRequestItemListByMainId(String mainId) {
        return SysUtil.copyProperties(this.purchaseRequestItemService.selectByMainId(mainId), PurchaseRequestItemDTO.class);
    }

    public List<PurchaseRequestItemDTO> selectPurchaseRequestItemListByMainIds(List<String> mainIds) {
        List list = ((LambdaQueryChainWrapper)this.purchaseRequestItemService.lambdaQuery().in(PurchaseRequestItem::getHeadId, mainIds)).list();
        return SysUtil.copyProperties((List)list, PurchaseRequestItemDTO.class);
    }

    public PurchaseRequestHeadDTO selectPurchaseRequestHeadById(String id) {
        return (PurchaseRequestHeadDTO)SysUtil.copyProperties((Object)this.purchaseRequestHeadService.getById((Serializable)((Object)id)), PurchaseRequestHeadDTO.class);
    }

    public List<PurchaseRequestHeadDTO> selectPurchaseRequestHeadByDocmentId(String id) {
        List list = ((LambdaQueryChainWrapper)this.purchaseRequestHeadService.lambdaQuery().eq(PurchaseRequestHead::getDocumentId, (Object)id)).list();
        return SysUtil.copyProperties((List)list, PurchaseRequestHeadDTO.class);
    }

    public void updateItemStatus(List<PurchaseRequestItemDTO> purchaseRequestItemList, String status) {
        ArrayList purchaseRequestItems = SysUtil.copyProperties(purchaseRequestItemList, PurchaseRequestItem.class);
        this.purchaseRequestItemService.updateStatus(purchaseRequestItems, status);
    }

    public void updatePurchaseRequestHeadById(PurchaseRequestHeadDTO id) {
        PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)SysUtil.copyProperties((Object)id, PurchaseRequestHead.class));
        this.purchaseRequestHeadService.updateById((Object)purchaseRequestHead);
    }

    public List<PurchaseRequestItemDTO> selectPurchaseRequestItemByItemIds(List<String> itemIds) {
        return this.purchaseRequestHeadService.selectPurchaseRequestItemByItemIds(itemIds);
    }

    public List<PurchaseOrderRequestInformationDTO> selectOrderRequstListByOrderItemIds(List<String> orderItemIds) {
        List<PurchaseOrderRequestInformation> orderRequestInformationList = this.purchaseOrderRequestInformationService.selectOrderRequstListByOrderItemIds(orderItemIds);
        return SysUtil.copyProperties(orderRequestInformationList, PurchaseOrderRequestInformationDTO.class);
    }

    public void updateOrderRequstListByIds(List<PurchaseOrderRequestInformationDTO> paramOrderRequestList) {
        this.purchaseOrderRequestInformationService.updateBatchById(SysUtil.copyProperties(paramOrderRequestList, PurchaseOrderRequestInformation.class));
    }

    public List<PurchaseRequestItemDTO> selectRequestItemByIds(List<String> requestItemIds) {
        return SysUtil.copyProperties((List)this.purchaseRequestItemService.listByIds(requestItemIds), PurchaseRequestItemDTO.class);
    }

    public List<PurchaseRequestHeadDTO> generateRequest(List<PurchaseRequestHeadDTO> purchaseRequestHeadDTOList) {
        ArrayList<String> list = new ArrayList<String>();
        log.error("\u5546\u57ce\u751f\u6210\u91c7\u8d2d\u7533\u8bf7\u8f6c\u5355:::" + JSONObject.toJSONString(purchaseRequestHeadDTOList));
        for (PurchaseRequestHeadDTO purchaseRequestHeadDTO : purchaseRequestHeadDTOList) {
            PurchaseRequestHeadVO head = (PurchaseRequestHeadVO)((Object)SysUtil.copyProperties((Object)purchaseRequestHeadDTO, PurchaseRequestHeadVO.class));
            this.purchaseRequestHeadService.saveMain(head, SysUtil.copyProperties((List)purchaseRequestHeadDTO.getPurchaseRequestItemDTOList(), PurchaseRequestItem.class), null);
            list.add(head.getId());
        }
        List purchaseRequestHeads = this.purchaseRequestHeadService.listByIds(list);
        List list1 = ((LambdaQueryChainWrapper)this.purchaseRequestItemService.lambdaQuery().in(PurchaseRequestItem::getHeadId, list)).list();
        Map<String, List> collect = list1.stream().collect(Collectors.toMap(PurchaseRequestItem::getHeadId, p -> {
            ArrayList<PurchaseRequestItem> objects = new ArrayList<PurchaseRequestItem>();
            objects.add((PurchaseRequestItem)((Object)p));
            return objects;
        }, (objects1, objects2) -> {
            objects1.addAll(objects2);
            return objects1;
        }));
        ArrayList<PurchaseRequestHeadDTO> purchaseRequestHeadDTOS = new ArrayList<PurchaseRequestHeadDTO>();
        purchaseRequestHeads.forEach(i -> {
            PurchaseRequestHeadDTO purchaseRequestHeadDTO = (PurchaseRequestHeadDTO)SysUtil.copyProperties((Object)i, PurchaseRequestHeadDTO.class);
            if (collect.containsKey(i.getId())) {
                List purchaseRequestItems = (List)collect.get(i.getId());
                ArrayList purchaseRequestItemDTOS = SysUtil.copyProperties((List)purchaseRequestItems, PurchaseRequestItemDTO.class);
                purchaseRequestHeadDTO.setPurchaseRequestItemDTOList((List)purchaseRequestItemDTOS);
            }
            purchaseRequestHeadDTOS.add(purchaseRequestHeadDTO);
        });
        return purchaseRequestHeadDTOS;
    }

    public void refreshRequestItemToWaitOrder(List<PriceRecordsDTO> dtoList) {
        this.purchaseRequestHeadService.refreshRequestItemToWaitOrder(dtoList);
    }
}

