/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logisticspurchase.inquiry.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.HttpUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.util.encryption.RsaEncryptUtil;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.ebidding.enumerate.EbiddingQuoteTypeEnum;
import com.els.modules.enquiry.enumerate.EnquiryQuoteTypeEnum;
import com.els.modules.inquiry.config.B2bProperties;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingHeadLp;
import com.els.modules.logisticspurchase.ebidding.entity.PurchaseEbiddingItemLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryHeadLp;
import com.els.modules.logisticspurchase.enquiry.entity.PurchaseEnquiryItemLp;
import com.els.modules.logisticspurchase.inquiry.service.PublishToB2BLpService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PublishToB2BLpServiceImpl
implements PublishToB2BLpService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PublishToB2BLpServiceImpl.class);
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private B2bProperties b2bProperties;
    @Value(value="${els.path.upload}")
    private String uploadPath;
    private String[] pictures = new String[]{".BMP", ".JPG", ".JPEG", ".PNG", ".GIF"};

    @Override
    public void publishToB2B(JSONObject body, JSONArray itemList) {
        LoginUserDTO user = SysUtil.getLoginUser();
        body.put("purchaserCompany", (Object)user.getEnterpriseName());
        body.put("srmUserId", (Object)user.getId());
        String elsAccount = user.getElsAccount();
        String subAccount = user.getSubAccount();
        Set userRolesSet = this.invokeAccountRpcService.getUserRolesSet(elsAccount, subAccount);
        String roleCode = "";
        if (userRolesSet.contains("admin")) {
            roleCode = "admin";
        } else if (userRolesSet.contains("companyAdmin")) {
            roleCode = "companyAdmin";
        }
        body.put("roleCode", (Object)roleCode);
        body.put("elsAccount", (Object)elsAccount);
        body.put("subAccount", (Object)subAccount);
        body.put("linkman", (Object)user.getRealname());
        body.put("mobile", (Object)user.getPhone());
        body.put("phone", (Object)user.getPhone());
        body.put("wechat", (Object)"");
        body.put("email", (Object)user.getEmail());
        body.put("materials", (Object)itemList);
        JSONArray attachments = new JSONArray();
        List attachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(body.getString("srmId"));
        for (PurchaseAttachmentDTO attachment : attachmentList) {
            String fileName = attachment.getFileName();
            JSONObject obj = new JSONObject();
            obj.put("url", (Object)(this.uploadPath + File.separator + attachment.getFilePath()));
            obj.put("name", (Object)fileName);
            obj.put("type", (Object)this.getFileType(fileName));
            attachments.add((Object)obj);
        }
        body.put("attachments", (Object)attachments);
        String message = HttpUtil.postJson((String)this.b2bProperties.getPublishUrl(), (Map)body, PublishToB2BLpServiceImpl.getHeader());
        log.error("publish-B2B-message:{}, publishUrl:{}, body:{}, header:{}", new Object[]{message, this.b2bProperties.getPublishUrl(), JSONObject.toJSONString((Object)body), JSONObject.toJSONString(PublishToB2BLpServiceImpl.getHeader())});
    }

    private static Map<String, String> getHeader() {
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCN1m4v9Cq7z/Y4hDEpfhB4I3xCYl5KROPE30IWmwA21/gduXgfFGEi0HGKsOjJE/kO1nmoQQi/IKqh14RX9CLnQW0klnEbInvgwQ+L9yzCxWGifM156W6Puw9aYA0Eo5ZKClhWDOfS1HYWCCJWqqs+nZPxCyPtFHszPH3vJp3PxQIDAQAB";
            String str = "ENrbw+bFAUkwO/2CAEnn+g==";
            header.put("secure", RsaEncryptUtil.encrypt((String)str, (String)publicKey));
            return header;
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_fail_encryption", (String)"\u52a0\u5bc6\u5931\u8d25"));
        }
    }

    private Integer getFileType(String fileName) {
        for (String picture : this.pictures) {
            if (!fileName.toUpperCase().endsWith(picture)) continue;
            return 2;
        }
        return 1;
    }

    private String getTimeString(Date date) {
        if (date != null) {
            LocalDateTime time = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            return formatter.format(time);
        }
        return null;
    }

    @Override
    public void publishToB2B(PurchaseEnquiryHeadLp head, List<PurchaseEnquiryItemLp> itemList) {
        JSONObject body = new JSONObject();
        body.put("srmId", (Object)head.getId());
        body.put("srmBusinessNo", (Object)head.getEnquiryNumber());
        body.put("offerEndTime", (Object)this.getTimeString(head.getApplyEndTime()));
        body.put("validityDate", (Object)this.getTimeString(head.getQuoteEndTime()));
        body.put("moreInfo", (Object)head.getRemark());
        body.put("type", (Object)1);
        String isTax = EnquiryQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(head.getQuoteType()) ? "0" : "1";
        body.put("isTax", (Object)isTax);
        JSONArray materialList = new JSONArray();
        for (PurchaseEnquiryItemLp item : itemList) {
            JSONObject material = new JSONObject();
            material.put("name", (Object)(StrUtil.isBlank((CharSequence)item.getMaterialName()) ? "\u8be2\u4ef7\u5bfb\u6e90" : item.getMaterialName()));
            material.put("brand", (Object)item.getMaterialSpec());
            material.put("purchaseQuantity", (Object)(item.getRequireQuantity() == null ? BigDecimal.ONE : item.getRequireQuantity()));
            material.put("description", (Object)item.getPurchaseRemark());
            material.put("orders", (Object)item.getItemNumber());
            material.put("unit", (Object)item.getPurchaseUnit());
            materialList.add((Object)material);
        }
        this.publishToB2B(body, materialList);
    }

    @Override
    @Async
    public void publishToB2B(PurchaseEbiddingHeadLp head, List<PurchaseEbiddingItemLp> itemList) {
        JSONObject body = new JSONObject();
        body.put("srmId", (Object)head.getId());
        body.put("srmBusinessNo", (Object)head.getEbiddingNumber());
        body.put("offerEndTime", (Object)this.getTimeString(head.getApplyEndTime()));
        body.put("validityDate", (Object)this.getTimeString(head.getEndTime()));
        body.put("moreInfo", (Object)head.getPurchaseRemark());
        body.put("type", (Object)2);
        String isTax = EbiddingQuoteTypeEnum.TAX_EXCLUDING.getValue().equals(head.getQuoteType()) ? "0" : "1";
        body.put("isTax", (Object)isTax);
        JSONArray materialList = new JSONArray();
        for (PurchaseEbiddingItemLp item : itemList) {
            JSONObject material = new JSONObject();
            material.put("name", (Object)(StrUtil.isBlank((CharSequence)item.getMaterialName()) ? "\u7ade\u4ef7\u5bfb\u6e90" : item.getMaterialName()));
            material.put("brand", (Object)item.getMaterialSpec());
            material.put("purchaseQuantity", (Object)(item.getRequireQuantity() == null ? BigDecimal.ONE : item.getRequireQuantity()));
            material.put("description", (Object)item.getPurchaseRemark());
            material.put("orders", (Object)item.getItemNumber());
            material.put("unit", (Object)item.getPurchaseUnit());
            materialList.add((Object)material);
        }
        this.publishToB2B(body, materialList);
    }
}

