/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.clarification.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SysUtil;
import com.els.modules.tender.attachment.entity.CustomColumnModel;
import com.els.modules.tender.attachment.entity.PurchaseTenderBidLetterFormatGroup;
import com.els.modules.tender.attachment.entity.PurchaseTenderQuoteMaterial;
import com.els.modules.tender.attachment.enumerate.BidLetterFormatTypeEnum;
import com.els.modules.tender.clarification.entity.PurchaseClarificationBidLetterFormatGroup;
import com.els.modules.tender.clarification.entity.PurchaseClarificationPriceOpeningsTemplate;
import com.els.modules.tender.clarification.entity.PurchaseClarificationQuoteMaterial;
import com.els.modules.tender.clarification.entity.PurchaseClarificationTenderBidLetter;
import com.els.modules.tender.clarification.mapper.PurchaseClarificationBidLetterFormatGroupMapper;
import com.els.modules.tender.clarification.service.PurchaseClarificationBidLetterFormatGroupService;
import com.els.modules.tender.clarification.service.PurchaseClarificationPriceOpeningsTemplateService;
import com.els.modules.tender.clarification.service.PurchaseClarificationQuoteMaterialService;
import com.els.modules.tender.clarification.service.PurchaseClarificationTenderBidLetterService;
import com.els.modules.tender.clarification.vo.PurchaseClarificationBidLetterFormatGroupVO;
import com.els.modules.tender.clarification.vo.PurchaseClarificationQuoteMaterialDataVO;
import com.els.modules.tender.clarification.vo.PurchaseTenderClarificationBidLetterVO;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.FastJsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseClarificationBidLetterFormatGroupServiceImpl
extends BaseServiceImpl<PurchaseClarificationBidLetterFormatGroupMapper, PurchaseClarificationBidLetterFormatGroup>
implements PurchaseClarificationBidLetterFormatGroupService {
    @Autowired
    private PurchaseClarificationTenderBidLetterService clarificationBidLetterService;
    @Autowired
    private PurchaseClarificationPriceOpeningsTemplateService clarificationPriceOpeningsService;
    @Autowired
    private PurchaseClarificationQuoteMaterialService clarificationQuoteMaterialService;

    @Override
    public List<PurchaseClarificationBidLetterFormatGroup> selectByMainId(String mainId) {
        return ((PurchaseClarificationBidLetterFormatGroupMapper)this.baseMapper).selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        ((PurchaseClarificationBidLetterFormatGroupMapper)this.baseMapper).deleteByMainId(mainId);
        this.clarificationBidLetterService.deleteByMainId(mainId);
        this.clarificationPriceOpeningsService.deleteByMainId(mainId);
        this.clarificationQuoteMaterialService.deleteByMainId(mainId);
    }

    @Override
    public PurchaseClarificationBidLetterFormatGroupVO queryBidLetterFormatGroup(String mainId) {
        List<PurchaseClarificationBidLetterFormatGroup> letterFormatGroupList = this.selectByMainId(mainId);
        if (letterFormatGroupList.isEmpty()) {
            return null;
        }
        PurchaseClarificationBidLetterFormatGroupVO groupVo = new PurchaseClarificationBidLetterFormatGroupVO();
        PurchaseTenderBidLetterFormatGroup bidLetterFormatGroup = letterFormatGroupList.get(0);
        BeanUtils.copyProperties((Object)((Object)bidLetterFormatGroup), (Object)((Object)groupVo));
        List<PurchaseClarificationTenderBidLetter> clarificationBidLetterList = this.clarificationBidLetterService.selectByMainId(mainId);
        if (CollectionUtil.isEmpty(clarificationBidLetterList)) {
            return groupVo;
        }
        List<PurchaseClarificationPriceOpeningsTemplate> openingsTemplateList = this.clarificationPriceOpeningsService.selectByMainId(mainId);
        List<PurchaseClarificationQuoteMaterial> clarificationQuoteMaterialList = this.clarificationQuoteMaterialService.selectByMainId(mainId);
        Map<String, List<PurchaseClarificationQuoteMaterial>> materialDataAllGroupByBidLetterId = clarificationQuoteMaterialList.stream().collect(Collectors.groupingBy(PurchaseTenderQuoteMaterial::getBidLetterId));
        List<PurchaseTenderClarificationBidLetterVO> bidLetterVoList = clarificationBidLetterList.stream().map(bidLetter -> {
            List quoteMaterialList;
            List priceOpeningsList;
            PurchaseTenderClarificationBidLetterVO bidLetterVO = new PurchaseTenderClarificationBidLetterVO();
            BeanUtils.copyProperties((Object)bidLetter, (Object)((Object)bidLetterVO));
            if (CollectionUtil.isNotEmpty((Collection)openingsTemplateList) && CollectionUtil.isNotEmpty(priceOpeningsList = openingsTemplateList.stream().filter(priceOpening -> bidLetter.getId().equals(priceOpening.getBidLetterId())).collect(Collectors.toList()))) {
                PurchaseClarificationPriceOpeningsTemplate priceOpeningsTemplate = (PurchaseClarificationPriceOpeningsTemplate)((Object)((Object)priceOpeningsList.get(0)));
                bidLetterVO.setPriceOpenings(priceOpeningsTemplate);
                bidLetterVO.setCustomizeFieldData(priceOpeningsTemplate.getCustomizeFieldData());
                bidLetterVO.setCustomizeFieldModel(priceOpeningsTemplate.getCustomizeFieldModel());
            }
            if (CollectionUtil.isNotEmpty((Collection)(quoteMaterialList = (List)materialDataAllGroupByBidLetterId.get(bidLetter.getId())))) {
                ArrayList<PurchaseClarificationQuoteMaterialDataVO> quoteColumnList = new ArrayList<PurchaseClarificationQuoteMaterialDataVO>();
                Map<String, List<PurchaseClarificationQuoteMaterial>> materialDataAllGroupByQuoteField = quoteMaterialList.stream().collect(Collectors.groupingBy(PurchaseTenderQuoteMaterial::getQuoteField));
                for (String quoteField : materialDataAllGroupByQuoteField.keySet()) {
                    PurchaseClarificationQuoteMaterialDataVO purchaseQuoteMaterialDataVO = new PurchaseClarificationQuoteMaterialDataVO();
                    purchaseQuoteMaterialDataVO.setField(quoteField);
                    List<CustomColumnModel> columnModelList = FastJsonUtils.toList(bidLetterVO.getCustomizeFieldModel(), CustomColumnModel.class);
                    if (CollectionUtil.isNotEmpty(columnModelList)) {
                        for (CustomColumnModel customColumnModel : columnModelList) {
                            if (!quoteField.equals(customColumnModel.getField())) continue;
                            purchaseQuoteMaterialDataVO.setTitle(customColumnModel.getTitle());
                            break;
                        }
                    }
                    List<PurchaseClarificationQuoteMaterial> materialList = materialDataAllGroupByQuoteField.get(quoteField);
                    purchaseQuoteMaterialDataVO.setMaterialDataList(materialList);
                    quoteColumnList.add(purchaseQuoteMaterialDataVO);
                }
                bidLetterVO.setQuoteColumnList(quoteColumnList);
            }
            return bidLetterVO;
        }).collect(Collectors.toList());
        groupVo.setTenderBidTetterVoList(bidLetterVoList);
        return groupVo;
    }

    @Override
    public List<PurchaseClarificationTenderBidLetter> queryTenderBidLetterList(String clarificationId) {
        return this.clarificationBidLetterService.queryPurchaseTenderBidLetter(clarificationId);
    }

    @Override
    public List<PurchaseClarificationPriceOpeningsTemplate> selectByBidLetterIdList(List<String> bidLetterIdList) {
        return this.clarificationPriceOpeningsService.selectByBidLetterIds(bidLetterIdList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void addTenderBidLetter(PurchaseClarificationBidLetterFormatGroupVO bidLetterFormatGroupVo) {
        bidLetterFormatGroupVo.setDeleted(CommonConstant.DEL_FLAG_0);
        PurchaseClarificationBidLetterFormatGroup bidLetterFormatGroup = (PurchaseClarificationBidLetterFormatGroup)((Object)SysUtil.copyProperties((Object)((Object)bidLetterFormatGroupVo), PurchaseClarificationBidLetterFormatGroup.class));
        ((PurchaseClarificationBidLetterFormatGroupMapper)this.baseMapper).insert((Object)bidLetterFormatGroup);
        List<PurchaseTenderClarificationBidLetterVO> tenderBidLetterVoList = bidLetterFormatGroupVo.getTenderBidTetterVoList();
        ArrayList<PurchaseClarificationPriceOpeningsTemplate> priceOpeningsList = new ArrayList<PurchaseClarificationPriceOpeningsTemplate>(10);
        ArrayList<PurchaseClarificationTenderBidLetter> tenderBidLetterList = new ArrayList<PurchaseClarificationTenderBidLetter>();
        ArrayList<PurchaseClarificationQuoteMaterial> materialDataAllList = new ArrayList<PurchaseClarificationQuoteMaterial>();
        for (PurchaseTenderClarificationBidLetterVO tenderBidLetterVo : tenderBidLetterVoList) {
            PurchaseClarificationTenderBidLetter tenderBidLetter = (PurchaseClarificationTenderBidLetter)((Object)SysUtil.copyProperties((Object)((Object)tenderBidLetterVo), PurchaseClarificationTenderBidLetter.class));
            if (tenderBidLetter.getId() == null) {
                tenderBidLetter.setId(IdWorker.getIdStr());
            }
            tenderBidLetter.setSubpackageId(bidLetterFormatGroupVo.getSubpackageId());
            tenderBidLetter.setTenderProjectId(bidLetterFormatGroupVo.getTenderProjectId());
            tenderBidLetter.setHeadId(bidLetterFormatGroupVo.getHeadId());
            tenderBidLetter.setClarificationId(bidLetterFormatGroupVo.getClarificationId());
            tenderBidLetter.setQuoteColumnSource(bidLetterFormatGroupVo.getQuoteColumnSource());
            tenderBidLetter.setDeleted(CommonConstant.DEL_FLAG_0);
            tenderBidLetter.setProcessType(TenderFlagInjectionContext.getTenderProcessType());
            tenderBidLetter.setCheckType(TenderFlagInjectionContext.getTenderCheckType());
            if ("1".equals(TenderFlagInjectionContext.getTenderCheckType()) && "1".equals(TenderFlagInjectionContext.getTenderProcessType())) {
                String formatType = tenderBidLetter.getFormatType();
                if (!BidLetterFormatTypeEnum.OTHER.getValue().equals(formatType)) {
                    tenderBidLetter.setCurrentStep(formatType);
                }
            }
            tenderBidLetter.setGroupId(bidLetterFormatGroup.getId());
            tenderBidLetterList.add(tenderBidLetter);
            PurchaseClarificationPriceOpeningsTemplate tenderPriceOpenings = tenderBidLetterVo.getPriceOpenings();
            if (StrUtil.isBlank((CharSequence)tenderPriceOpenings.getId())) {
                tenderPriceOpenings.setId(IdWorker.getIdStr());
            }
            tenderPriceOpenings.setSubpackageId(bidLetterFormatGroupVo.getSubpackageId());
            tenderPriceOpenings.setTenderProjectId(bidLetterFormatGroupVo.getTenderProjectId());
            tenderPriceOpenings.setHeadId(bidLetterFormatGroupVo.getHeadId());
            tenderPriceOpenings.setClarificationId(bidLetterFormatGroupVo.getClarificationId());
            tenderPriceOpenings.setBidLetterId(tenderBidLetter.getId());
            tenderPriceOpenings.setDeleted(CommonConstant.DEL_FLAG_0);
            priceOpeningsList.add(tenderPriceOpenings);
            List<PurchaseClarificationQuoteMaterialDataVO> quoteColumnList = tenderBidLetterVo.getQuoteColumnList();
            if (CollectionUtil.isEmpty(quoteColumnList)) continue;
            for (PurchaseClarificationQuoteMaterialDataVO purchaseQuoteMaterialDataVO : quoteColumnList) {
                List<PurchaseClarificationQuoteMaterial> materialDataList = purchaseQuoteMaterialDataVO.getMaterialDataList();
                if (CollectionUtil.isEmpty(materialDataList)) continue;
                materialDataList.stream().forEach(materialData -> {
                    materialData.setId(IdWorker.getIdStr());
                    materialData.setQuoteColumnSource(bidLetterFormatGroupVo.getQuoteColumnSource());
                    materialData.setSubpackageId(bidLetterFormatGroupVo.getSubpackageId());
                    materialData.setTenderProjectId(bidLetterFormatGroupVo.getTenderProjectId());
                    materialData.setHeadId(bidLetterFormatGroupVo.getHeadId());
                    materialData.setClarificationId(bidLetterFormatGroupVo.getClarificationId());
                    materialData.setPriceOpeningsId(tenderPriceOpenings.getId());
                    materialData.setBidLetterId(tenderBidLetter.getId());
                    materialData.setDeleted(CommonConstant.DEL_FLAG_0);
                    materialData.setElsAccount(bidLetterFormatGroupVo.getElsAccount());
                    materialData.setQuoteTitle(purchaseQuoteMaterialDataVO.getTitle());
                    materialData.setQuoteField(purchaseQuoteMaterialDataVO.getField());
                });
                materialDataAllList.addAll(materialDataList);
            }
        }
        this.clarificationBidLetterService.saveBatch(tenderBidLetterList, 1000);
        this.clarificationPriceOpeningsService.saveBatch(priceOpeningsList, 1000);
        this.clarificationQuoteMaterialService.saveBatch(materialDataAllList, 1000);
    }
}

