/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.tender.price.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.tender.attachment.entity.CustomColumnModel;
import com.els.modules.tender.attachment.entity.PurchaseTenderQuoteMaterial;
import com.els.modules.tender.attachment.enumerate.BidLetterFormatQuoteTypeEnum;
import com.els.modules.tender.attachment.service.PurchaseTenderProjectAttachmentHeadService;
import com.els.modules.tender.attachment.vo.PurchaseQuoteMaterialDataVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterFormatGroupVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderBidLetterVO;
import com.els.modules.tender.attachment.vo.PurchaseTenderProjectAttachmentHeadVO;
import com.els.modules.tender.column.enumerate.CustomerFieldCategoryEnum;
import com.els.modules.tender.common.interceptor.TenderFlagInjectionContext;
import com.els.modules.tender.common.utils.FastJsonUtils;
import com.els.modules.tender.price.entity.PurchaseTenderControlPriceHead;
import com.els.modules.tender.price.entity.PurchaseTenderControlPriceSetting;
import com.els.modules.tender.price.mapper.PurchaseTenderControlPriceHeadMapper;
import com.els.modules.tender.price.service.PurchaseTenderControlPriceHeadService;
import com.els.modules.tender.price.service.PurchaseTenderControlPriceSettingService;
import com.els.modules.tender.price.vo.PurchaseTenderControlPriceHeadVO;
import com.els.modules.tender.project.entity.PurchaseTenderProjectSubpackageInfo;
import com.els.modules.tender.project.enumerate.SubpackageInfoCheckTypeEnum;
import com.els.modules.tender.project.enumerate.SubpackageInfoProcessTypeEnum;
import com.els.modules.tender.project.enumerate.TenderProjectSubpackageStatusEnum;
import com.els.modules.tender.project.service.PurchaseTenderProjectHeadService;
import com.els.modules.tender.project.service.PurchaseTenderProjectSubpackageInfoService;
import com.els.modules.tender.project.vo.PurchaseTenderProjectInfoVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseTenderControlPriceHeadServiceImpl
extends BaseServiceImpl<PurchaseTenderControlPriceHeadMapper, PurchaseTenderControlPriceHead>
implements PurchaseTenderControlPriceHeadService {
    @Autowired
    private PurchaseTenderControlPriceSettingService controlPriceSettingService;
    @Autowired
    private PurchaseTenderProjectAttachmentHeadService attachmentHeadService;
    @Autowired
    private PurchaseTenderProjectHeadService projectHeadService;
    @Autowired
    private PurchaseTenderProjectSubpackageInfoService subpackageInfoService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseTenderControlPriceHead purchaseTenderControlPriceHead, List<PurchaseTenderControlPriceSetting> purchaseTenderControlPriceSettingList) {
        this.checkParams(purchaseTenderControlPriceHead);
        ((PurchaseTenderControlPriceHeadMapper)this.baseMapper).insert((Object)purchaseTenderControlPriceHead);
        this.insertData(purchaseTenderControlPriceHead, purchaseTenderControlPriceSettingList);
    }

    private void checkParams(PurchaseTenderControlPriceHead controlPriceHead) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)controlPriceHead.getSubpackageId()), (String)I18nUtil.translate((String)"i18n_field_zsWWxOLVW_b61e1b17", (String)"\u5206\u5305Id\u4e0d\u80fd\u4e3a\u7a7a!"));
        PurchaseTenderProjectSubpackageInfo subpackageInfo = (PurchaseTenderProjectSubpackageInfo)((Object)this.subpackageInfoService.getById((Serializable)((Object)controlPriceHead.getSubpackageId())));
        if (SubpackageInfoProcessTypeEnum.TWO_STEP.getValue().equals(subpackageInfo.getProcessType())) {
            Assert.isTrue((subpackageInfo.getStatus() < TenderProjectSubpackageStatusEnum.FIRST_STEP_OPEN_BIDING.getValue() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_nIxIvBxiTtkW_e7f8ff36", (String)"\u7b2c\u4e00\u6b65\u5df2\u5f00\u6807\u4e0d\u5141\u8bb8\u64cd\u4f5c!"));
        } else {
            Assert.isTrue((subpackageInfo.getStatus() < TenderProjectSubpackageStatusEnum.OPEN_BIDING.getValue() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_IvBxiTtkW_794389a7", (String)"\u5df2\u5f00\u6807\u4e0d\u5141\u8bb8\u64cd\u4f5c!"));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseTenderControlPriceHead purchaseTenderControlPriceHead, List<PurchaseTenderControlPriceSetting> purchaseTenderControlPriceSettingList) {
        int count = ((PurchaseTenderControlPriceHeadMapper)this.baseMapper).updateById((Object)purchaseTenderControlPriceHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.controlPriceSettingService.deleteByMainId(purchaseTenderControlPriceHead.getId());
        this.insertData(purchaseTenderControlPriceHead, purchaseTenderControlPriceSettingList);
    }

    @Override
    public PurchaseTenderControlPriceHeadVO selectBySubpackageId(String subpackageId) {
        PurchaseTenderControlPriceHeadVO result = new PurchaseTenderControlPriceHeadVO();
        PurchaseTenderControlPriceHead controlPriceHead = ((PurchaseTenderControlPriceHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId);
        if (controlPriceHead == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)((Object)controlPriceHead), (Object)((Object)result));
        List<PurchaseTenderControlPriceSetting> priceSettingList = this.controlPriceSettingService.selectByMainId(controlPriceHead.getId());
        result.setControlPriceSettingList(priceSettingList);
        return result;
    }

    @Override
    public void deleteBySubpackageId(String subpackageId) {
        ((PurchaseTenderControlPriceHeadMapper)this.baseMapper).deleteBySubpackageId(subpackageId);
        this.controlPriceSettingService.deleteBySubpackageId(subpackageId);
    }

    @Override
    public PurchaseTenderControlPriceHeadVO queryBySubpackageId(String subpackageId) {
        PurchaseTenderControlPriceHeadVO result = new PurchaseTenderControlPriceHeadVO();
        PurchaseTenderControlPriceHead controlPriceHead = ((PurchaseTenderControlPriceHeadMapper)this.baseMapper).selectBySubpackageId(subpackageId);
        if (controlPriceHead == null) {
            PurchaseTenderProjectInfoVO projectInfoVO = this.projectHeadService.queryProjectInfoBySubpackageId(subpackageId);
            result.setSubpackageId(projectInfoVO.getSubpackageId());
            result.setTenderProjectId(projectInfoVO.getTenderProjectId());
            result.setSubpackageName(projectInfoVO.getSubpackageName());
            result.setTenderProjectName(projectInfoVO.getTenderProjectName());
            result.setTenderProjectNumber(projectInfoVO.getTenderProjectNumber());
            TenderFlagInjectionContext.setTenderCheckType(SubpackageInfoCheckTypeEnum.POST_TRIAL.getValue());
            PurchaseTenderProjectAttachmentHeadVO attachmentHeadVO = this.attachmentHeadService.queryAll(subpackageId);
            PurchaseTenderBidLetterFormatGroupVO formatGroupVo = attachmentHeadVO.getTenderBidLetterFormatGroupVo();
            result.setQuoteType(formatGroupVo.getQuoteType());
            List<PurchaseTenderBidLetterVO> tenderBidTetterVoList = formatGroupVo.getTenderBidTetterVoList();
            ArrayList<PurchaseTenderControlPriceSetting> priceSettingList = new ArrayList<PurchaseTenderControlPriceSetting>();
            if (BidLetterFormatQuoteTypeEnum.ITEMIZED_QUOTATION.getValue().equals(formatGroupVo.getQuoteType())) {
                for (PurchaseTenderBidLetterVO bidLetterVO : tenderBidTetterVoList) {
                    if ("0".equals(bidLetterVO.getQuoteBidLetter())) continue;
                    List<PurchaseQuoteMaterialDataVO> quoteColumnList = bidLetterVO.getQuoteColumnList();
                    for (PurchaseQuoteMaterialDataVO materialDataVO : quoteColumnList) {
                        for (PurchaseTenderQuoteMaterial quoteMaterial : materialDataVO.getMaterialDataList()) {
                            PurchaseTenderControlPriceSetting priceSetting = new PurchaseTenderControlPriceSetting();
                            priceSetting.setSubpackageId(subpackageId);
                            priceSetting.setTenderBidLetterId(bidLetterVO.getId());
                            priceSetting.setTenderBidLetterName(bidLetterVO.getName());
                            priceSetting.setQuoteColumnField(materialDataVO.getField());
                            priceSetting.setQuoteColumnName(materialDataVO.getTitle());
                            priceSetting.setMaterialId(quoteMaterial.getMaterialId());
                            priceSetting.setMaterialNumber(quoteMaterial.getMaterialNumber());
                            priceSetting.setMaterialName(quoteMaterial.getMaterialName());
                            priceSetting.setMaterialDesc(quoteMaterial.getMaterialDesc());
                            priceSettingList.add(priceSetting);
                        }
                    }
                }
            } else {
                for (PurchaseTenderBidLetterVO bidLetterVO : tenderBidTetterVoList) {
                    String customizeFieldModel = bidLetterVO.getCustomizeFieldModel();
                    List<CustomColumnModel> customColumnList = FastJsonUtils.toList(customizeFieldModel, CustomColumnModel.class);
                    for (CustomColumnModel tenderCustomColumn : customColumnList) {
                        if (!CustomerFieldCategoryEnum.TENDER_OFFERS_COLUMN.getValue().equals(tenderCustomColumn.getFieldCategory())) continue;
                        PurchaseTenderControlPriceSetting priceSetting = new PurchaseTenderControlPriceSetting();
                        priceSetting.setSubpackageId(subpackageId);
                        priceSetting.setTenderBidLetterId(bidLetterVO.getId());
                        priceSetting.setTenderBidLetterName(bidLetterVO.getName());
                        priceSetting.setQuoteColumnField(tenderCustomColumn.getField());
                        priceSetting.setQuoteColumnName(tenderCustomColumn.getTitle());
                        priceSettingList.add(priceSetting);
                    }
                }
            }
            result.setControlPriceSettingList(priceSettingList);
            return result;
        }
        BeanUtils.copyProperties((Object)((Object)controlPriceHead), (Object)((Object)result));
        List<PurchaseTenderControlPriceSetting> priceSettingList = this.controlPriceSettingService.selectByMainId(controlPriceHead.getId());
        result.setControlPriceSettingList(priceSettingList);
        return result;
    }

    private void insertData(PurchaseTenderControlPriceHead purchaseTenderControlPriceHead, List<PurchaseTenderControlPriceSetting> purchaseTenderControlPriceSettingList) {
        if (!CollectionUtils.isEmpty(purchaseTenderControlPriceSettingList)) {
            for (PurchaseTenderControlPriceSetting entity : purchaseTenderControlPriceSettingList) {
                entity.setHeadId(purchaseTenderControlPriceHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseTenderControlPriceHead);
            }
            this.controlPriceSettingService.saveBatch(purchaseTenderControlPriceSettingList, 2000);
        }
    }
}

