/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.adapter;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.bidding.entity.BiddingSupplier;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingProjectHead;
import com.els.modules.bidding.entity.PurchaseBiddingSpecialist;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.service.BiddingSupplierService;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.PurchaseBiddingProjectHeadService;
import com.els.modules.bidding.service.PurchaseBiddingSpecialistService;
import com.els.modules.bidding.service.impl.PurchaseBiddingProjectHeadServiceImpl;
import com.els.modules.bidding.vo.PurchaseBiddingHeadVO;
import com.els.modules.bidding.vo.PurchaseBiddingProjectHeadVO;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@RpcService(value="publishBiddingProjectAuditCallBackServiceImpl")
public class PurchaseBiddingProjectAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseBiddingProjectHeadService purchaseBiddingProjectHeadService;
    @Autowired
    private PurchaseBiddingHeadService purchaseBiddingHeadService;
    @Autowired
    private PurchaseBiddingItemService purchaseBiddingItemService;
    @Autowired
    private BiddingSupplierService biddingSupplierService;
    @Autowired
    private PurchaseBiddingSpecialistService purchaseBiddingSpecialistService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseBiddingProjectHeadVO headVO = (PurchaseBiddingProjectHeadVO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString(this.getById(flowCallbackDTO.getBusinessId())), PurchaseBiddingProjectHeadVO.class));
        List<PurchaseBiddingHead> purchaseBiddingHeadList = headVO.getPurchaseBiddingHeadList();
        if (!CollectionUtils.isEmpty(purchaseBiddingHeadList)) {
            PurchaseBiddingProjectHeadServiceImpl.checkAndSetProjectParam(headVO);
        }
        PurchaseBiddingProjectHead head = new PurchaseBiddingProjectHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)head));
        head.setBiddingStatus(BiddingStatusEnum.NEW.getValue());
        head.setPublishTime(null);
        head.setPublishUser(null);
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
        String id = flowCallbackDTO.getBusinessId();
        PurchaseBiddingProjectHead dbHead = (PurchaseBiddingProjectHead)((Object)this.purchaseBiddingProjectHeadService.getById((Serializable)((Object)id)));
        List itemList = ((LambdaQueryChainWrapper)this.purchaseBiddingItemService.lambdaQuery().eq(PurchaseBiddingItem::getProjectId, (Object)id)).list();
        List<BiddingSupplier> supplierList = this.biddingSupplierService.selectByMainId(id);
        List<PurchaseBiddingSpecialist> specialistList = this.purchaseBiddingSpecialistService.selectByMainId(id);
        List demandList = this.invokeBaseRpcService.selectPurchaseAttachmentDemandByMainId(id);
        this.purchaseBiddingProjectHeadService.publishBiddingProject(dbHead.getId());
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseBiddingProjectHead head = (PurchaseBiddingProjectHead)((Object)this.purchaseBiddingProjectHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            PurchaseBiddingHeadVO headVO = new PurchaseBiddingHeadVO();
            BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
            List<PurchaseBiddingItem> itemList = this.purchaseBiddingItemService.selectByMainId(id);
            headVO.setPurchaseBiddingItemList(itemList);
            return SrmUtil.toJSONObject((Object)((Object)headVO));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseBiddingProjectHead updateHead = new PurchaseBiddingProjectHead();
        updateHead.setId(flowCallbackDTO.getBusinessId());
        updateHead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        updateHead.setAuditStatus(auditStatus);
        this.purchaseBiddingProjectHeadService.updateById((Object)updateHead);
    }
}

