/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.cost.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.FormulaUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.cost.entity.PurchaseCostHead;
import com.els.modules.cost.entity.PurchaseCostItem;
import com.els.modules.cost.enumerate.CostStatusEnum;
import com.els.modules.cost.mapper.PurchaseCostHeadMapper;
import com.els.modules.cost.service.PurchaseCostHeadService;
import com.els.modules.cost.service.PurchaseCostItemService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PurchaseCostHeadServiceImpl
extends BaseServiceImpl<PurchaseCostHeadMapper, PurchaseCostHead>
implements PurchaseCostHeadService {
    @Autowired
    private PurchaseCostItemService purchaseCostItemService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseCostHead head, List<PurchaseCostItem> itemList) {
        this.check(itemList);
        head.setStatus(CostStatusEnum.NORMAL.getValue());
        ((PurchaseCostHeadMapper)this.baseMapper).insert((Object)head);
        this.insertData(head, itemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseCostHead head, List<PurchaseCostItem> itemList) {
        this.check(itemList);
        head.setStatus(CostStatusEnum.NORMAL.getValue());
        int count = ((PurchaseCostHeadMapper)this.baseMapper).updateById((Object)head);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.purchaseCostItemService.deleteByMainId(head.getId());
        this.insertData(head, itemList);
    }

    private void check(List<PurchaseCostItem> itemList) {
        Assert.notEmpty(itemList, (String)I18nUtil.translate((String)"i18n_alert_cVHxOLV_c6f5290a", (String)"\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        for (PurchaseCostItem item : itemList) {
            Assert.hasText((String)item.getCostCode(), (String)I18nUtil.translate((String)"i18n_alert_LvAoxOLV_8269457", (String)"\u6210\u672c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        long count = itemList.stream().map(PurchaseCostItem::getCostCode).distinct().count();
        Assert.isTrue((count == (long)itemList.size() ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_LvAoxqVB_7858029", (String)"\u6210\u672c\u7f16\u7801\u4e0d\u53ef\u91cd\u590d"));
    }

    private void insertData(PurchaseCostHead head, List<PurchaseCostItem> itemList) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            for (PurchaseCostItem item : itemList) {
                item.setId(IdWorker.getIdStr());
                item.setHeadId(head.getId());
                SysUtil.setSysParam((BaseEntity)item, (BaseEntity)head);
            }
            this.setCompute(itemList);
            this.setParentId(itemList);
            this.purchaseCostItemService.saveBatch(itemList, 2000);
        }
    }

    private void setCompute(List<PurchaseCostItem> itemList) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            List formulaList = itemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getFormula())).collect(Collectors.toList());
            HashMap<String, Boolean> computeMap = new HashMap<String, Boolean>();
            for (PurchaseCostItem item2 : formulaList) {
                Matcher matcher = FormulaUtil.getPattern().matcher(item2.getFormula());
                while (matcher.find()) {
                    computeMap.put(matcher.group(1), true);
                }
            }
            Iterator<Object> iterator = itemList.iterator();
            while (iterator.hasNext()) {
                PurchaseCostItem item2;
                item2.setCompute(computeMap.get((item2 = (PurchaseCostItem)((Object)iterator.next())).getCostCode()) != null && (Boolean)computeMap.get(item2.getCostCode()) != false ? "1" : "0");
            }
        }
    }

    private void setParentId(List<PurchaseCostItem> itemList) {
        if (CollectionUtil.isNotEmpty(itemList)) {
            Map<String, String> idMap = itemList.stream().collect(Collectors.toMap(PurchaseCostItem::getCostCode, ParentEntity::getId));
            Map<String, List<PurchaseCostItem>> parentCodeMap = itemList.stream().collect(Collectors.groupingBy(item -> item.getParentCode() == null ? "" : item.getParentCode()));
            for (Map.Entry<String, List<PurchaseCostItem>> entry : parentCodeMap.entrySet()) {
                String key = entry.getKey();
                if (!StrUtil.isNotBlank((CharSequence)key)) continue;
                List<PurchaseCostItem> value = entry.getValue();
                value.forEach(item -> item.setParentId((String)idMap.get(key)));
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchaseCostItemService.deleteByMainId(id);
        ((PurchaseCostHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void invalid(String id) {
        PurchaseCostHead dbHead = (PurchaseCostHead)((Object)this.getById((Serializable)((Object)id)));
        dbHead.setStatus(CostStatusEnum.INVALID.getValue());
        this.updateById((Object)dbHead);
    }
}

