/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.demand.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.JiMuResult;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.BusMessageVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.bidding.entity.PurchaseBiddingHead;
import com.els.modules.bidding.entity.PurchaseBiddingItem;
import com.els.modules.bidding.entity.PurchaseBiddingProjectHead;
import com.els.modules.bidding.service.PurchaseBiddingHeadService;
import com.els.modules.bidding.service.PurchaseBiddingItemService;
import com.els.modules.bidding.service.PurchaseBiddingProjectHeadService;
import com.els.modules.demand.entity.PurchaseRequestHead;
import com.els.modules.demand.entity.PurchaseRequestItem;
import com.els.modules.demand.enumerate.PurchaseRequestStatusEnum;
import com.els.modules.demand.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.demand.excel.PurchaseRequestHeadExportServiceImpl;
import com.els.modules.demand.rpc.BudgetManageLocalRpcService;
import com.els.modules.demand.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.demand.rpc.PurchaseProductInventoryLocalRpcService;
import com.els.modules.demand.rpc.PurchaseUserCartLocalRpcService;
import com.els.modules.demand.rpc.TemplateLocalRpcService;
import com.els.modules.demand.service.PurchaseRequestHeadService;
import com.els.modules.demand.service.PurchaseRequestItemService;
import com.els.modules.demand.utils.RequestItemUtils;
import com.els.modules.demand.vo.PurchaseRequestHeadVO;
import com.els.modules.demand.vo.RequestMatchInfomationVO;
import com.els.modules.ebidding.entity.PurchaseEbiddingItem;
import com.els.modules.ebidding.service.PurchaseEbiddingItemService;
import com.els.modules.enquiry.entity.PurchaseEnquiryItem;
import com.els.modules.enquiry.service.PurchaseEnquiryItemService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.material.api.enumerate.MaterialDeliveryArrangeEnum;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.order.api.service.PurchaseOrderItemRpcService;
import com.els.modules.product.api.dto.PurchaseProductInventoryDTO;
import com.els.modules.product.api.dto.PurchaseUserCartDTO;
import com.els.modules.supplier.api.enumerate.SupplierCoordinationWayEnum;
import com.els.modules.tender.approval.entity.TenderProjectApprovalItem;
import com.els.modules.tender.approval.service.TenderProjectApprovalItemService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/demand/purchaseRequestHead"})
@Tag(name="\u91c7\u8d2d\u7533\u8bf7\u5934")
@Primary
@BusinessModule(module="purchaseRequest")
public class PurchaseRequestHeadController
extends BaseController<PurchaseRequestHead, PurchaseRequestHeadService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PurchaseRequestHeadController.class);
    @Autowired
    private PurchaseRequestHeadService purchaseRequestHeadService;
    @Autowired
    private PurchaseRequestItemService purchaseRequestItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private BudgetManageLocalRpcService budgetManageRpcService;
    @Resource
    private TemplateLocalRpcService templateHeadService;
    @Resource
    private PurchaseUserCartLocalRpcService purchaseUserCartService;
    @Resource
    private PurchaseProductInventoryLocalRpcService purchaseProductInventoryService;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadService;
    @Resource
    private PurchaseEnquiryItemService enquiryItemService;
    @Resource
    private PurchaseEbiddingItemService ebiddingItemService;
    @Resource
    private PurchaseBiddingItemService biddingItemService;
    @Resource
    private PurchaseBiddingHeadService biddingHeadService;
    @Resource
    private PurchaseBiddingProjectHeadService projectHeadService;
    @Resource
    private TenderProjectApprovalItemService approvalItemService;
    @Resource
    private PurchaseOrderItemRpcService orderItemRpcService;
    @Autowired
    private RequestItemUtils requestItemUtils;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_request_requestToOrder_locker";
    private static final Long LOCK_EXPIRE_TIME = 120000L;

    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="purchaseRequest")
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:list"})
    public Result<?> queryPageList(PurchaseRequestHead purchaseRequestHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRequestHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/item/list"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:list"})
    public Result<?> queryPageList(PurchaseRequestItem purchaseRequestItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRequestItem), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/queryPageJimuList"})
    @PermissionDataView(businessType="purchaseRequest")
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:list"})
    public JiMuResult<?> queryPageJimuList(PurchaseRequestHead purchaseRequestHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseRequestHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return JiMuResult.ok((Object)pageList);
    }

    @AutoLog(value="\u91c7\u8d2d\u7533\u8bf7-\u8f6c\u8ba2\u5355-\u5339\u914d\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55")
    @Operation(summary="\u9700\u6c42\u5355\u5339\u914d\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55", description="\u9700\u6c42\u5355\u5339\u914d\u4ef7\u683c\u4fe1\u606f\u8bb0\u5f55")
    @PostMapping(value={"/requestMatchInfomationRecord"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:requestMatchInfomationRecord"})
    @SrmValidated
    public Result<?> requestMatchInfomationRecord(@RequestBody List<PurchaseRequestItem> requestItemList) {
        this.requestItemUtils.validRequestItemStatus(requestItemList);
        Assert.notEmpty(requestItemList, (String)I18nUtil.translate((String)"i18n_alert_empty_toOrderLine", (String)"\u9009\u62e9\u7684\u8f6c\u8ba2\u5355\u7684\u9700\u6c42\u884c\u4e0d\u80fd\u4e3a\u7a7a"));
        List requestItemIds = requestItemList.stream().map(ParentEntity::getId).distinct().collect(Collectors.toList());
        try {
            Object flag;
            List ids = requestItemList.stream().map(ParentEntity::getId).collect(Collectors.toList());
            PurchaseRequestItemService purchaseRequestItemService = (PurchaseRequestItemService)SpringContextUtils.getBean(PurchaseRequestItemService.class);
            List dbPurchaseRequestItems = purchaseRequestItemService.listByIds(ids);
            Assert.notEmpty((Collection)dbPurchaseRequestItems, (String)I18nUtil.translate((String)"i18n_alert_HemhxuiFjWFtHWVXVABSsKW_221943", (String)"\u7cfb\u7edf\u67e5\u8be2\u4e0d\u5230\u9009\u62e9\u7684\u6570\u636e\u8bb0\u5f55,\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5!"));
            if (CollectionUtils.isEmpty((Collection)dbPurchaseRequestItems)) {
                dbPurchaseRequestItems.forEach(item -> {
                    if ("group".equals(item.getTacticsObject()) && StrUtil.isNotBlank((CharSequence)item.getTacticsEntity())) {
                        if (item.getTacticsEntity().contains("_")) {
                            String[] split = item.getTacticsEntity().split("_");
                            item.setPurchaseGroup(split[0]);
                        } else {
                            item.setPurchaseGroup(item.getTacticsEntity());
                        }
                    }
                });
            }
            Map requestItemByNumber = dbPurchaseRequestItems.stream().collect(Collectors.toMap(ParentEntity::getId, Function.identity()));
            LoginUserDTO loginUser = SysUtil.getLoginUser();
            JSONObject companySet = loginUser.getCompanySet();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("4");
            arrayList.add("5");
            arrayList.add("6");
            boolean allowMultipleSources = false;
            if (companySet != null && "1".equals(flag = companySet.getString("allowMultipleSources"))) {
                allowMultipleSources = true;
            }
            for (PurchaseRequestItem requestItem : requestItemList) {
                PurchaseRequestItem dbRequestItem = (PurchaseRequestItem)((Object)requestItemByNumber.get(requestItem.getId()));
                if (dbRequestItem == null) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVyWWWWWWnRUVEyWWWWWWKHexMKWVXVABSsKW_43435b50", (String)"\u91c7\u8d2d\u7533\u8bf7\u53f7[${0}]\u91c7\u8d2d\u7533\u8bf7\u884c\u53f7[${1}]\u5728\u7cfb\u7edf\u4e0d\u5b58\u5728,\u8bf7\u5237\u65b0\u5217\u8868\u540e\u91cd\u8bd5!", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
                }
                if (!allowMultipleSources && arrayList.contains(requestItem.getItemStatus())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_nRUVtyWWWWWWEyWWWWWWhjLML_dfc2f225", (String)"\u91c7\u8d2d\u7533\u8bf7\u5355\u53f7:${0},\u884c\u53f7:${1},\u5bfb\u6e90\u672a\u5b8c\u6210", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
                }
                if (StrUtil.isBlank((CharSequence)requestItem.getPurchaseUnit())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_TVtWWWWWWEyWWWWWWjnRtLLVWVLDSKsItW_91b51903", (String)"\u9700\u6c42\u5355[${0}]\u884c\u53f7[${1}]\u7684\u91c7\u8d2d\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u540e\u518d\u8f6c\u8ba2\u5355!", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
                }
                BigDecimal toOrderQuantity = dbRequestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : dbRequestItem.getToOrderQuantity();
                if (toOrderQuantity.compareTo(dbRequestItem.getQuantity()) < 0) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_TVtWWWWWWEyWWWWWWjIsItWRlTXUTVWRW_fddab5f6", (String)"\u9700\u6c42\u5355[${0}]\u884c\u53f7[${1}]\u7684\u5df2\u8f6c\u8ba2\u5355\u6570\u91cf\u5fc5\u987b\u5c0f\u4e8e\u9700\u6c42\u6570\u91cf!", (String[])new String[]{requestItem.getRequestNumber(), requestItem.getItemNumber()}));
            }
            if ("mall".equals(((PurchaseRequestItem)((Object)dbPurchaseRequestItems.get(0))).getSourceType())) {
                this.purchaseRequestHeadService.generatePoolOrder(dbPurchaseRequestItems);
            }
            List<RequestMatchInfomationVO> requestMatchInfomationVOS = this.purchaseRequestHeadService.matchInformationRecords(dbPurchaseRequestItems);
            return Result.ok(requestMatchInfomationVOS);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
    }

    @AutoLog(value="\u91c7\u8d2d\u7533\u8bf7-\u751f\u6210\u8ba2\u5355")
    @Operation(summary="\u751f\u6210\u8ba2\u5355", description="\u751f\u6210\u8ba2\u5355")
    @PostMapping(value={"/requestToCreateOrder"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:requestToCreateOrder"})
    @SrmValidated
    @FormCommit
    public Result<?> requestToCreateOrder(@Valid @RequestBody List<RequestMatchInfomationVO> requestMatchInfomationList) {
        List requestItemIds = requestMatchInfomationList.stream().map(RequestMatchInfomationVO::getRequestItemId).distinct().collect(Collectors.toList());
        for (int i = 0; i < requestItemIds.size(); ++i) {
            if (this.redisUtil.tryGetDistributedLock(LOCK_KEY, (String)requestItemIds.get(i), LOCK_EXPIRE_TIME.longValue())) continue;
            if (i > 0) {
                for (int j = 0; j < i; ++j) {
                    this.redisUtil.releaseDistributedLock(LOCK_KEY, (String)requestItemIds.get(j));
                }
            }
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_RijTVcWMKiKtkjcWVRSKK_b36f72bb", (String)"\u52fe\u9009\u7684\u9700\u6c42\u884c\uff0c\u5b58\u5728\u6b63\u5728\u64cd\u4f5c\u7684\u884c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5"));
        }
        try {
            RequestMatchInfomationVO requestMatchInfomationVO1;
            List requestItemList = this.purchaseRequestItemService.listByIds(requestItemIds);
            Map collect = requestItemList.stream().collect(Collectors.toMap(ParentEntity::getId, Function.identity(), (k1, k2) -> k1));
            HashMap<String, RequestMatchInfomationVO> key = new HashMap<String, RequestMatchInfomationVO>();
            for (RequestMatchInfomationVO requestMatchInfomationVO : requestMatchInfomationList) {
                if (key.containsKey(requestMatchInfomationVO.getRequestItemId())) {
                    requestMatchInfomationVO1 = (RequestMatchInfomationVO)((Object)key.get(requestMatchInfomationVO.getRequestItemId()));
                    BigDecimal toOrderQuantity = requestMatchInfomationVO1.getToOrderQuantity().add(requestMatchInfomationVO.getToOrderQuantity());
                    if (requestMatchInfomationVO.getToOrderQuantity().compareTo(BigDecimal.valueOf(0L)) <= 0) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_field_sItWRXUWWxObLIt_79df57cd", (String)"\u8f6c\u8ba2\u5355\u6570\u91cf\u5c0f\u4e8e0\uff0c\u4e0d\u80fd\u751f\u6210\u8ba2\u5355"));
                    }
                    if (toOrderQuantity.compareTo(requestMatchInfomationVO.getQuantity()) > 0) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_field_materialCode", (String)"\u7269\u6599\u7f16\u7801") + requestMatchInfomationVO.getMaterialNumber() + I18nUtil.translate((String)"i18n_field_jsItWRxOBRqsItR_848c33d3", (String)"\u7684\u8f6c\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u8f6c\u8ba2\u5355\u91cf"));
                    }
                    requestMatchInfomationVO1.setToOrderQuantity(toOrderQuantity);
                    key.put(requestMatchInfomationVO.getRequestItemId(), requestMatchInfomationVO1);
                } else {
                    if (requestMatchInfomationVO.getToOrderQuantity().compareTo(requestMatchInfomationVO.getQuantity()) > 0) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_field_materialCode", (String)"\u7269\u6599\u7f16\u7801") + requestMatchInfomationVO.getMaterialNumber() + I18nUtil.translate((String)"i18n_field_jsItWRxOBRqsItR_848c33d3", (String)"\u7684\u8f6c\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u8f6c\u8ba2\u5355\u91cf"));
                    }
                    if (requestMatchInfomationVO.getToOrderQuantity().compareTo(BigDecimal.valueOf(0L)) <= 0) {
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_field_sItWRXUWWxObLIt_79df57cd", (String)"\u8f6c\u8ba2\u5355\u6570\u91cf\u5c0f\u4e8e0\uff0c\u4e0d\u80fd\u751f\u6210\u8ba2\u5355"));
                    }
                    requestMatchInfomationVO1 = new RequestMatchInfomationVO();
                    requestMatchInfomationVO1.setRequestNumber(requestMatchInfomationVO.getRequestNumber());
                    requestMatchInfomationVO1.setRequestItemNumber(requestMatchInfomationVO.getRequestItemNumber());
                    requestMatchInfomationVO1.setToOrderQuantity(requestMatchInfomationVO.getToOrderQuantity());
                    key.put(requestMatchInfomationVO.getRequestItemId(), requestMatchInfomationVO1);
                }
                if (SupplierCoordinationWayEnum.SRM_COORDINATIONWAY.getValue().equals(requestMatchInfomationVO.getNeedCoordination()) || MaterialDeliveryArrangeEnum.ORDER_ITEM.getValue().equals(requestMatchInfomationVO.getJit())) continue;
                throw new ELSBootException("\u7269\u6599\u7f16\u7801:" + requestMatchInfomationVO.getMaterialNumber() + "\u4f9b\u5e94\u5546:" + requestMatchInfomationVO.getSupplierName() + "\u4e0d\u652f\u6301\u8be5\u9001\u8d27\u5b89\u6392");
            }
            for (PurchaseRequestItem requestItem : requestItemList) {
                requestMatchInfomationVO1 = (RequestMatchInfomationVO)((Object)key.get(requestItem.getId()));
                BigDecimal remainToOrderQuantity = requestItem.getQuantity().subtract(requestItem.getToOrderQuantity() == null ? BigDecimal.ZERO : requestItem.getToOrderQuantity());
                if (requestMatchInfomationVO1.getToOrderQuantity().compareTo(remainToOrderQuantity) <= 0) continue;
                throw new ELSBootException(I18nUtil.translate((String)"i18n_field_materialCode", (String)"\u7269\u6599\u7f16\u7801") + requestItem.getMaterialNumber() + I18nUtil.translate((String)"i18n_field_jsItWRxOBRqsItR_848c33d3", (String)"\u7684\u8f6c\u8ba2\u5355\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u53ef\u8f6c\u8ba2\u5355\u91cf"));
            }
            List headIds = requestMatchInfomationList.stream().map(RequestMatchInfomationVO::getRequestHeadId).distinct().collect(Collectors.toList());
            Map headIdList = requestMatchInfomationList.stream().collect(Collectors.groupingBy(RequestMatchInfomationVO::getRequestHeadId, Collectors.mapping(RequestMatchInfomationVO::getRequestItemNumber, Collectors.toList())));
            List requestAttachmentDTOS = this.invokeBaseRpcService.selectPurchaseAttachmentByMainIds(headIds);
            requestAttachmentDTOS = requestAttachmentDTOS.stream().filter(x -> {
                if (CharSequenceUtil.isEmpty((CharSequence)x.getItemNumber())) {
                    return true;
                }
                List itemFileNnmber = (List)headIdList.get(x.getHeadId());
                if (CollectionUtil.isEmpty((Collection)itemFileNnmber)) {
                    return false;
                }
                return itemFileNnmber.contains(x.getItemNumber());
            }).collect(Collectors.toList());
            List<PurchaseOrderHeadDTO> res = this.purchaseRequestHeadService.requestToCreateOrder(requestMatchInfomationList);
            ArrayList allOrderAttachment = new ArrayList();
            for (PurchaseOrderHeadDTO orderHeadDTO : res) {
                String documentParentId = CharSequenceUtil.blankToDefault((CharSequence)orderHeadDTO.getDocumentParentId(), (String)"");
                List sourceHeadIds = CharSequenceUtil.split((CharSequence)documentParentId, (CharSequence)",");
                List orderAttachment = requestAttachmentDTOS.stream().filter(x -> sourceHeadIds.contains(x.getHeadId())).collect(Collectors.toList());
                if (orderAttachment.isEmpty()) continue;
                String s = JSON.toJSONString(orderAttachment);
                List attachmentDTOS = JSON.parseArray((String)s, PurchaseAttachmentDTO.class);
                int i = 1;
                for (PurchaseAttachmentDTO dto : attachmentDTOS) {
                    dto.setHeadId(orderHeadDTO.getId());
                    dto.setId(IdWorker.getIdStr());
                    dto.setRelationId(null);
                    dto.setCreateBy(null);
                    dto.setCreateById(null);
                    dto.setCreateTime(null);
                    dto.setUpdateTime(null);
                    dto.setUpdateBy(null);
                    dto.setUpdateById(null);
                    dto.setItemNumber("" + i);
                    ++i;
                }
                allOrderAttachment.addAll(attachmentDTOS);
            }
            if (CollectionUtil.isNotEmpty(allOrderAttachment)) {
                this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(allOrderAttachment);
            }
            Result result = Result.ok(res);
            return result;
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            for (String id : requestItemIds) {
                this.redisUtil.releaseDistributedLock(LOCK_KEY, id);
            }
        }
    }

    @Operation(summary="\u5408\u540c\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c\u5206\u9875\u4fe1\u606f", description="\u5408\u540c\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c\u5206\u9875\u4fe1\u606f")
    @GetMapping(value={"/contractQueryRequest"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:list"})
    public Result<?> contractQueryRequest(PurchaseRequestItem item, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        queryWrapper.notInSql((Object)"item_status", "-1, 0,-2");
        ((QueryWrapper)queryWrapper.and(qw -> ((QueryWrapper)((QueryWrapper)qw.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue())).or()).eq((Object)"audit_status", (Object)AuditStatusEnum.NO_AUDIT_REQUIRED.getValue()))).orderByDesc(true, (Object)"create_time");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u89c4\u5212\u6c42\u89e3\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c\u5206\u9875\u4fe1\u606f", description="\u89c4\u5212\u6c42\u89e3\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c\u5206\u9875\u4fe1\u606f")
    @GetMapping(value={"/lpSolveQueryRequest"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:list"})
    public Result<?> lpSolveQueryRequest(PurchaseRequestItem item, @RequestParam String startDateStr, @RequestParam String endDateStr, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        DateTime startDate = DateUtil.parse((CharSequence)startDateStr, (String)"yyyy-MM-dd");
        DateTime endDate = DateUtil.parse((CharSequence)endDateStr, (String)"yyyy-MM-dd");
        queryWrapper.in((Object)"item_status", new Object[]{"2", "7", "8", "9"});
        queryWrapper.and(qw -> ((QueryWrapper)((QueryWrapper)qw.eq((Object)"audit_status", (Object)AuditStatusEnum.AUDIT_FINISH.getValue())).or()).eq((Object)"audit_status", (Object)AuditStatusEnum.NO_AUDIT_REQUIRED.getValue()));
        queryWrapper.ge((Object)"delivery_date", (Object)startDate);
        queryWrapper.le((Object)"delivery_date", (Object)endDate);
        queryWrapper.orderByDesc(true, (Object)"create_time");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseRequestItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5bfc\u5165\u7b26\u5408\u89c4\u5212\u6c42\u89e3\u8981\u6c42\u7684\u7533\u8bf7\u884c\u6570\u636e", description="\u5bfc\u5165\u7b26\u5408\u89c4\u5212\u6c42\u89e3\u8981\u6c42\u7684\u7533\u8bf7\u884c\u6570\u636e")
    @GetMapping(value={"/lpSolveQueryRequestList"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:list"})
    public Result<?> lpSolveQueryRequest(PurchaseRequestItem item, @RequestParam String startDateStr, @RequestParam String endDateStr) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        DateTime startDate = DateUtil.parse((CharSequence)startDateStr, (String)"yyyy-MM-dd");
        DateTime endDate = DateUtil.parse((CharSequence)endDateStr, (String)"yyyy-MM-dd");
        queryWrapper.in(PurchaseRequestItem::getItemStatus, new Object[]{"2", "7", "8", "9"});
        queryWrapper.and(qw -> ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(PurchaseRequestItem::getAuditStatus, (Object)AuditStatusEnum.AUDIT_FINISH.getValue())).or()).eq(PurchaseRequestItem::getAuditStatus, (Object)AuditStatusEnum.NO_AUDIT_REQUIRED.getValue()));
        queryWrapper.ge(PurchaseRequestItem::getDeliveryDate, (Object)startDate);
        queryWrapper.le(PurchaseRequestItem::getDeliveryDate, (Object)endDate);
        queryWrapper.orderByDesc(true, BaseEntity::getCreateTime);
        List requestItemList = this.purchaseRequestItemService.list((Wrapper)queryWrapper);
        return Result.ok((Object)requestItemList);
    }

    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @AutoLog(value="\u91c7\u8d2d\u7533\u8bf7-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:add"})
    @SrmValidated
    @PermissionDataOpt(businessType="purchaseRequest", beanClass=PurchaseRequestHeadService.class)
    public Result<?> add(@RequestBody PurchaseRequestHeadVO purchaseRequestHeadPage) {
        PurchaseRequestHeadVO purchaseRequestHead = new PurchaseRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHeadPage), (Object)((Object)purchaseRequestHead));
        this.purchaseRequestHeadService.saveMain(purchaseRequestHead, purchaseRequestHeadPage.getPurchaseRequestItemList(), purchaseRequestHeadPage.getPurchaseAttachmentList());
        return Result.ok((Object)((Object)purchaseRequestHead));
    }

    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u7f16\u8f91")
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:edit"})
    @SrmValidated
    @PermissionDataOpt(businessType="purchaseRequest", beanClass=PurchaseRequestHeadService.class)
    public Result<?> edit(@RequestBody PurchaseRequestHeadVO purchaseRequestHeadPage) {
        PurchaseRequestHeadVO purchaseRequestHead = new PurchaseRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHeadPage), (Object)((Object)purchaseRequestHead));
        this.purchaseRequestHeadService.updateMain(purchaseRequestHead, purchaseRequestHeadPage.getPurchaseRequestItemList(), purchaseRequestHeadPage.getPurchaseAttachmentList());
        String id = purchaseRequestHead.getId();
        return this.queryById(id);
    }

    @Operation(summary="\u91c7\u8d2d\u7533\u8bf7\u5934-\u4f5c\u5e9f", description="\u91c7\u8d2d\u7533\u8bf7\u5934-\u4f5c\u5e9f")
    @PostMapping(value={"/cancel"})
    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u4f5c\u5e9f")
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:cancel"})
    @PermissionDataOpt(businessType="purchaseRequest", beanClass=PurchaseRequestHeadService.class)
    @SrmValidated
    public Result<?> cancel(@RequestBody PurchaseRequestHeadVO head) {
        head.setRequestStatus(PurchaseRequestStatusEnum.REQUEST_CANCAL.getValue());
        this.purchaseRequestHeadService.updateStatus(head);
        return this.commonSuccessResult(7);
    }

    @Operation(summary="\u91c7\u8d2d\u7533\u8bf7\u5934-\u64a4\u56de", description="\u91c7\u8d2d\u7533\u8bf7\u5934-\u64a4\u56de")
    @PostMapping(value={"/revoke"})
    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u4f5c\u5e9f")
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:revoke"})
    @PermissionDataOpt(businessType="purchaseRequest", beanClass=PurchaseRequestHeadService.class)
    @SrmValidated
    public Result<?> revoke(@RequestBody PurchaseRequestHeadVO head) {
        Assert.notEmpty(head.getPurchaseRequestItemList(), (String)I18nUtil.translate((String)"i18n_alert_nRTVcxOLV_f1a40e2d", (String)"\u91c7\u8d2d\u9700\u6c42\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        List<String> status = Arrays.asList(PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue(), PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue());
        ArrayList<String> itemIdList = new ArrayList<String>();
        for (PurchaseRequestItem requestItem : head.getPurchaseRequestItemList()) {
            if (status.contains(requestItem.getItemStatus())) {
                itemIdList.add(requestItem.getId());
                continue;
            }
            if (PurchaseRequestStatusItemEnum.INQUIRY_BUILT.getValue().equals(requestItem.getItemStatus()) || PurchaseRequestStatusItemEnum.INQUIRY_COMPLETED.getValue().equals(requestItem.getItemStatus())) {
                List enquiryItemList = ((LambdaQueryChainWrapper)this.enquiryItemService.lambdaQuery().like(PurchaseEnquiryItem::getSourceItemId, (Object)requestItem.getId())).list();
                String number = enquiryItemList.stream().map(PurchaseEnquiryItem::getEnquiryNumber).distinct().collect(Collectors.joining(","));
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_n0cIbLhut1_c354cd3c", (String)"\u7b2c${0}\u884c\u5df2\u751f\u6210\u8be2\u4ef7\u5355${1}", (String[])new String[]{requestItem.getItemNumber(), number}));
            }
            if (PurchaseRequestStatusItemEnum.AUCTIONS_BUILT.getValue().equals(requestItem.getItemStatus()) || PurchaseRequestStatusItemEnum.COMPLETION_OF_THE_AUCTION.getValue().equals(requestItem.getItemStatus())) {
                List ebiddingItemList = ((LambdaQueryChainWrapper)this.ebiddingItemService.lambdaQuery().like(PurchaseEbiddingItem::getSourceItemId, (Object)requestItem.getId())).list();
                String number = ebiddingItemList.stream().map(PurchaseEbiddingItem::getEbiddingNumber).distinct().collect(Collectors.joining(","));
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_n0cIbLOut1_a5cc8f38", (String)"\u7b2c${0}\u884c\u5df2\u751f\u6210\u7ade\u4ef7\u5355${1}", (String[])new String[]{requestItem.getItemNumber(), number}));
            }
            if (PurchaseRequestStatusItemEnum.TENDERS_BUILT.getValue().equals(requestItem.getItemStatus()) || PurchaseRequestStatusItemEnum.TENDER_COMPLETED.getValue().equals(requestItem.getItemStatus())) {
                List biddingItemList = ((LambdaQueryChainWrapper)this.biddingItemService.lambdaQuery().like(PurchaseBiddingItem::getSourceItemId, (Object)requestItem.getId())).list();
                if (CollectionUtil.isNotEmpty((Collection)biddingItemList)) {
                    List projectIdList = biddingItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getProjectId())).map(PurchaseBiddingItem::getProjectId).distinct().collect(Collectors.toList());
                    if (CollectionUtil.isNotEmpty(projectIdList)) {
                        String number = this.projectHeadService.listByIds(projectIdList).stream().map(PurchaseBiddingProjectHead::getProjectNumber).collect(Collectors.joining(","));
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_n0cIbLOBsYBt1_6d841c1b", (String)"\u7b2c${0}\u884c\u5df2\u751f\u6210\u591a\u6807\u5305\u62db\u6807\u5355${1}", (String[])new String[]{requestItem.getItemNumber(), number}));
                    }
                    List headIdList = biddingItemList.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getHeadId())).map(PurchaseBiddingItem::getHeadId).distinct().collect(Collectors.toList());
                    String number = this.biddingHeadService.listByIds(headIdList).stream().map(PurchaseBiddingHead::getBiddingNumber).collect(Collectors.joining(","));
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_n0cIbLtBYBt1_1ed2f493", (String)"\u7b2c${0}\u884c\u5df2\u751f\u6210\u5355\u6807\u62db\u6807\u5355${1}", (String[])new String[]{requestItem.getItemNumber(), number}));
                }
                List approvalItemList = ((LambdaQueryChainWrapper)this.approvalItemService.lambdaQuery().like(TenderProjectApprovalItem::getSourceItemId, (Object)requestItem.getId())).list();
                String number = approvalItemList.stream().map(TenderProjectApprovalItem::getProjectNumber).distinct().collect(Collectors.joining(","));
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_n0cIbLdIvd1_5132d16d", (String)"\u7b2c${0}\u884c\u5df2\u751f\u6210\u9879\u76ee\u7acb\u9879${1}", (String[])new String[]{requestItem.getItemNumber(), number}));
            }
            if (!PurchaseRequestStatusItemEnum.ORDER_PAETIAL_TRANSFER.getValue().equals(requestItem.getItemStatus()) && !PurchaseRequestStatusItemEnum.ORDER_ALL_TRANSFER.getValue().equals(requestItem.getItemStatus()) && !PurchaseRequestStatusItemEnum.ORDER_COMPLETED.getValue().equals(requestItem.getItemStatus())) continue;
            List itemDTOList = this.orderItemRpcService.listItemBySourceItemId(Arrays.asList(requestItem.getId()));
            String number = itemDTOList.stream().map(PurchaseOrderItemDTO::getOrderNumber).distinct().collect(Collectors.joining(","));
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_n0cIbLIt1_b913c7bd", (String)"\u7b2c${0}\u884c\u5df2\u751f\u6210\u8ba2\u5355${1}", (String[])new String[]{requestItem.getItemNumber(), number}));
        }
        this.purchaseRequestItemService.updateStatusById(itemIdList, PurchaseRequestStatusItemEnum.DEMAND_CLOSED.getValue());
        return Result.ok((Object)((Object)this.getData(head.getPurchaseRequestItemList().get(0).getHeadId())));
    }

    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u63d0\u4ea4")
    @Operation(summary="\u91c7\u8d2d\u7533\u8bf7-\u63d0\u4ea4\u9700\u6c42\u6c60", description="\u91c7\u8d2d\u7533\u8bf7-\u63d0\u4ea4\u9700\u6c42\u6c60")
    @PostMapping(value={"/toDemandPool"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:toDemandPool"})
    @SrmValidated
    public Result<?> toDemandPool(@RequestBody PurchaseRequestHeadVO purchaseRequestHeadPage) {
        List collect;
        this.edit(purchaseRequestHeadPage);
        List<PurchaseRequestItem> purchaseRequestItems = this.purchaseRequestItemService.selectByMainId(purchaseRequestHeadPage.getId());
        if (CollectionUtils.isEmpty(purchaseRequestItems)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_DJuTVuRRjImcdI_442c1b0e", (String)"\u63d0\u4ea4\u5230\u9700\u6c42\u6c60\u81f3\u5c11\u6709\u4e00\u4e2a\u884c\u9879\u76ee"));
        }
        HashMap itemStatusMap = new HashMap();
        purchaseRequestItems.forEach(item -> {
            Assert.isTrue((item.getQuantity() != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_empty_notQuantity", (String)"\u884c\u9700\u6c42\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.isTrue((item.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_cTVWRlTfUW_49c8866", (String)"\u884c\u9700\u6c42\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0"));
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)item.getPurchaseOrg()), (String)I18nUtil.translate((String)"i18n_alert_cXjnRVRxOLVWVKItbWsLDWSNVRGRsLDRHIdjRKVRW_306d9a1f", (String)"\u884c\u4e0a\u7684\u91c7\u8d2d\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5728\u91c7\u8d2d\u7ec4\u7ec7\u6743\u9650\u4e2d\u7ef4\u62a4,\u6216\u8005\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7ef4\u62a4\u5de5\u5382\u5bf9\u5e94\u7684\u5173\u8054\u7ec4\u7ec7!"));
            Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)item.getCompany()), (String)I18nUtil.translate((String)"i18n_alert_cXjRCooxOLVWVKVRGRsLDRHIdjXtESVRW_c851671b", (String)"\u884c\u4e0a\u7684\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u5728\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7ef4\u62a4\u5de5\u5382\u5bf9\u5e94\u7684\u4e0a\u7ea7\u4e1a\u52a1\u7ec4\u7ec7!"));
            itemStatusMap.put(item.getId(), Integer.parseInt(item.getAuditStatus()));
        });
        List<String> materialNumbers = purchaseRequestItems.stream().map(PurchaseRequestItem::getMaterialNumber).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(materialNumbers)) {
            Map<String, String> materialItemNumberMap = purchaseRequestItems.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getMaterialNumber())).collect(Collectors.toMap(PurchaseRequestItem::getMaterialNumber, PurchaseRequestItem::getItemNumber, (entity1, entity2) -> entity1));
            List<PurchaseMaterialHeadDTO> purchaseMaterialHeadDTOS = this.purchaseMaterialHeadService.listByMaterialNumbers(materialNumbers);
            List blocDelMaterial = purchaseMaterialHeadDTOS.stream().filter(material -> "1".equals(material.getBlocDel())).collect(Collectors.toList());
            String str = blocDelMaterial.stream().map(p -> p.getMaterialNumber() + "[" + (String)materialItemNumberMap.get(p.getMaterialNumber()) + "]").collect(Collectors.joining(","));
            Assert.isTrue((boolean)CollectionUtils.isEmpty(blocDelMaterial), (String)I18nUtil.translate((String)"i18n_alert_SLAo0IdcSLIqQG_9e3ad526", (String)"\u7269\u6599\u7f16\u7801:${0}\u5bf9\u5e94\u884c\u7269\u6599\u5df2\u88ab\u5220\u9664!", (String[])new String[]{str}));
        }
        if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
            this.purchaseRequestItemService.toDemandPool(purchaseRequestHeadPage);
        }
        if (!CollectionUtils.isEmpty(purchaseRequestItems)) {
            LambdaUpdateWrapper updateWrapper;
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.select(new SFunction[]{ParentEntity::getId, PurchaseRequestItem::getItemStatus, PurchaseRequestItem::getSourceType});
            wrapper.in(ParentEntity::getId, itemStatusMap.keySet());
            List items = this.purchaseRequestItemService.list((Wrapper)wrapper);
            List idsMall = items.stream().filter(item -> "mall".equals(item.getSourceType())).filter(i -> PurchaseRequestStatusItemEnum.APPROVED.getValue().equals(i.getItemStatus()) || PurchaseRequestStatusItemEnum.SEND_BACK.getValue().equals(i.getItemStatus()) || PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue().equals(i.getItemStatus())).map(ParentEntity::getId).collect(Collectors.toList());
            List idsOther = items.stream().filter(item -> !"mall".equals(item.getSourceType())).filter(i -> PurchaseRequestStatusItemEnum.APPROVED.getValue().equals(i.getItemStatus()) || PurchaseRequestStatusItemEnum.SEND_BACK.getValue().equals(i.getItemStatus())).map(ParentEntity::getId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(idsOther)) {
                updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue());
                updateWrapper.in(ParentEntity::getId, idsOther);
                this.purchaseRequestItemService.update((Wrapper)updateWrapper);
            }
            if (!CollectionUtils.isEmpty(idsMall)) {
                updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(PurchaseRequestItem::getTacticsEntity, null);
                updateWrapper.set(PurchaseRequestItem::getTacticsObject, null);
                updateWrapper.set(PurchaseRequestItem::getItemStatus, (Object)PurchaseRequestStatusItemEnum.WAIT_ORDER.getValue());
                updateWrapper.in(ParentEntity::getId, idsMall);
                this.purchaseRequestItemService.update((Wrapper)updateWrapper);
            }
        }
        if (!CollectionUtils.isEmpty(collect = purchaseRequestItems.parallelStream().filter(item -> !StrUtil.isBlank((CharSequence)item.getMaterialNumber())).filter(i -> PurchaseRequestStatusItemEnum.APPROVED.getValue().equals(i.getItemStatus()) || PurchaseRequestStatusItemEnum.SEND_BACK.getValue().equals(i.getItemStatus()) || PurchaseRequestStatusItemEnum.DEMAND_POOL.getValue().equals(i.getItemStatus())).filter(item -> !"mall".equals(item.getSourceType())).collect(Collectors.toList()))) {
            List<PurchaseRequestItem> collect1 = collect.stream().filter(item -> !"12".equals(item.getItemStatus())).collect(Collectors.toList());
            this.purchaseRequestHeadService.matchPrice(collect1);
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseRequestHeadService.lambdaUpdate().eq(ParentEntity::getId, (Object)purchaseRequestHeadPage.getId())).set(PurchaseRequestHead::getRequestStatus, (Object)PurchaseRequestStatusEnum.REQUEST_DEMAND.getValue())).update((Object)new PurchaseRequestHead());
        ArrayList<String> toElsAccountList = new ArrayList<String>();
        toElsAccountList.add(purchaseRequestHeadPage.getElsAccount());
        BusMessageVO messageVO = BusMessageVO.builder().businessId(purchaseRequestHeadPage.getId()).msgConfigCode("purchaseRequest_toDemandPool").businessBean("purchaseRequestBusinessDataRpcService").receiveAccountList(toElsAccountList).build();
        this.purchaseRequestHeadService.sendMessage(messageVO);
        return this.commonSuccessResult(3);
    }

    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @AutoLog(busModule="\u9700\u6c42\u6c60\u7ba1\u7406", value="\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:delete"})
    @PermissionDataOpt(businessType="purchaseRequest", beanClass=PurchaseRequestHeadService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.budgetManageRpcService.refundOfOccupiedAmount(id);
        this.purchaseRequestHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseRequestHeadService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @BusinessModule(module="purchaseRequest")
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseRequestHeadVO purchaseRequestHeadVO = this.getData(id);
        return Result.ok((Object)((Object)purchaseRequestHeadVO));
    }

    private PurchaseRequestHeadVO getData(String id) {
        PurchaseRequestHead purchaseRequestHead = (PurchaseRequestHead)((Object)this.purchaseRequestHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseRequestHeadVO purchaseRequestHeadVO = new PurchaseRequestHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchaseRequestHead), (Object)((Object)purchaseRequestHeadVO));
        List<PurchaseRequestItem> purchaseRequestItemList = this.purchaseRequestItemService.selectByMainId(id);
        purchaseRequestHeadVO.setPurchaseRequestItemList(purchaseRequestItemList);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseRequestHeadVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return purchaseRequestHeadVO;
    }

    @Operation(summary="\u901a\u8fc7\u91c7\u8d2d\u7533\u8bf7\u5934id\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c", description="\u901a\u8fc7\u91c7\u8d2d\u7533\u8bf7\u5934id\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u884c")
    @GetMapping(value={"/queryPurchaseRequestItemByMainId"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:view"})
    public Result<?> queryPurchaseRequestItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseRequestItem> purchaseRequestItemList = this.purchaseRequestItemService.selectByMainId(id);
        return Result.ok(purchaseRequestItemList);
    }

    @Operation(summary="\u901a\u8fc7\u91c7\u8d2d\u7533\u8bf7\u5934id\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u6587\u4ef6", description="\u901a\u8fc7\u91c7\u8d2d\u7533\u8bf7\u5934id\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u6587\u4ef6")
    @GetMapping(value={"/queryPurchaseAttachmentByMainId"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:view"})
    public Result<?> queryPurchaseAttachmentListByMainId(@RequestParam(name="id", required=true) String id) {
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        return Result.ok((Object)purchaseAttachmentList);
    }

    @AutoLog(value="\u91c7\u8d2d\u7533\u8bf7-\u5546\u54c1\u8f6c\u91c7\u8d2d\u7533\u8bf7")
    @Operation(summary="\u5546\u54c1\u8f6c\u91c7\u8d2d\u7533\u8bf7", description="\u5546\u54c1\u8f6c\u91c7\u8d2d\u7533\u8bf7")
    @PostMapping(value={"/createRequestByProduct"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:toProduct"})
    @SrmValidated
    public Result<?> createRequestByProduct(@RequestBody List<PurchaseUserCartDTO> purchaseUserCarts) {
        List<TemplateHeadDTO> templateHeadList = this.templateHeadService.getDefaultTemplateByType("purchaseRequest");
        if (org.apache.commons.collections.CollectionUtils.isEmpty(templateHeadList)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_xMKCLjnRUVIrWVGRCLIr_841b7908", (String)"\u4e0d\u5b58\u5728\u9ed8\u8ba4\u7684\u91c7\u8d2d\u7533\u8bf7\u6a21\u677f\uff0c\u8bf7\u8bbe\u7f6e\u9ed8\u8ba4\u6a21\u677f"));
        }
        PurchaseRequestHeadVO purchaseRequestHeadVO = new PurchaseRequestHeadVO();
        TemplateHeadDTO templateHead = templateHeadList.get(0);
        purchaseRequestHeadVO.setTemplateNumber(templateHead.getTemplateNumber());
        purchaseRequestHeadVO.setTemplateName(templateHead.getTemplateName());
        purchaseRequestHeadVO.setTemplateAccount(templateHead.getElsAccount());
        purchaseRequestHeadVO.setTemplateVersion(String.valueOf(templateHead.getTemplateVersion()));
        purchaseRequestHeadVO.setElsAccount(this.getTenantId());
        purchaseRequestHeadVO.setCreateBy(this.getCurrentUser().getSubAccount());
        purchaseRequestHeadVO.setCreateTime(new Date());
        purchaseRequestHeadVO.setSourceType("mall");
        purchaseRequestHeadVO.setDeleted(0);
        ArrayList<PurchaseRequestItem> purchaseRequestItemList = new ArrayList<PurchaseRequestItem>();
        ArrayList<String> cartIds = new ArrayList<String>();
        for (PurchaseUserCartDTO cart : purchaseUserCarts) {
            PurchaseRequestItem item = new PurchaseRequestItem();
            if (StrUtil.isBlank((CharSequence)cart.getProductInventoryId())) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_GMVHLVWVImW_e432dcbe", (String)"\u5e93\u5b58\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01"));
            }
            PurchaseProductInventoryDTO purchaseProductInventory = this.purchaseProductInventoryService.getById(cart.getProductInventoryId());
            if (null == purchaseProductInventory) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_GMVHLVWVImW_e432dcbe", (String)"\u5e93\u5b58\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01"));
            }
            if (StrUtil.isBlank((CharSequence)purchaseProductInventory.getProductMaterialCode())) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_GMVHvLBjRKjSLAoWVImW_ca4120c4", (String)"\u5e93\u5b58\u4fe1\u606f\u91cc\u9762\u6ca1\u6709\u5173\u8054\u7684\u7269\u6599\u7f16\u7801\uff0c\u8bf7\u68c0\u67e5\uff01"));
            }
            PurchaseMaterialHeadDTO material = this.purchaseMaterialHeadService.getMaterialHeadByNumber(purchaseProductInventory.getProductMaterialCode());
            if (null == material) {
                return Result.error((String)I18nUtil.translate((String)"i18n_alert_SLxMKWVImW_70a9c704", (String)"\u7269\u6599\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01"));
            }
            item.setRepertoryUnit(material.getRepertoryUnit());
            item.setPurchaseUnit(material.getPurchaseUnit());
            item.setMaterialNumber(material.getMaterialNumber());
            item.setMaterialDesc(material.getMaterialDesc());
            item.setMaterialName(material.getMaterialName());
            item.setCateLevelCode(material.getCateLevelCode());
            item.setMaterialSpec(material.getMaterialSpec());
            item.setMaterialType(material.getMaterialType());
            item.setMaterialTypeName(material.getMaterialTypeName());
            item.setBrand(cart.getBrandName());
            item.setBaseUnit(cart.getBasicUnit());
            item.setNetWeight(material.getNetWeight());
            item.setMaterialGroup(material.getMaterialGroup());
            item.setCateCode(material.getCateCode());
            item.setCateName(material.getCateName());
            item.setFactory(material.getFactory());
            item.setQuantity(cart.getProductCount());
            item.setRepertoryQuantity(cart.getProductCount());
            item.setSubtotalAmount(cart.getProductPrice().multiply(cart.getProductCount()));
            item.setNetPrice(cart.getProductPrice());
            item.setPrice(cart.getProductPrice());
            item.setBudgetPrice(cart.getProductPrice());
            item.setSourceType("mall");
            item.setItemStatus("0");
            item.setDeleted(0);
            item.setExpectSupplierEls(cart.getProductCreateByElesAccount());
            item.setExpectSupplierName(cart.getProductCreateBy());
            purchaseRequestItemList.add(item);
            cartIds.add(cart.getId());
        }
        BigDecimal total = purchaseRequestItemList.stream().filter(p -> p.getSubtotalAmount() != null).map(PurchaseRequestItem::getSubtotalAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        purchaseRequestHeadVO.setTotalAmount(total);
        purchaseRequestHeadVO.setPurchaseRequestItemList(purchaseRequestItemList);
        this.purchaseRequestHeadService.saveMain(purchaseRequestHeadVO, purchaseRequestItemList, purchaseRequestHeadVO.getPurchaseAttachmentList());
        this.purchaseUserCartService.delBatchPurchaseUserCart(cartIds);
        return Result.ok((Object)((Object)purchaseRequestHeadVO));
    }

    @Operation(summary="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", description="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="purchaseRequest")
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:list"})
    public Result<?> queryTabsCount(PurchaseRequestHead purchaseRequestHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select((Object[])new String[]{"request_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"request_status");
        List list = ((PurchaseRequestHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseRequestHead::getRequestStatus, PurchaseRequestHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "requestStatus", null, (long)all.intValue()));
        List srmRequestStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmRequestStatus", TenantContext.getTenant());
        for (DictDTO status : srmRequestStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "requestStatus", status.getValue(), (long)total.intValue()));
        }
        return Result.ok(result);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:export"})
    @PermissionDataView(businessType="purchaseRequest")
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseRequestHeadExportServiceImpl.class);
    }

    @Operation(summary="\u4eceERP\u83b7\u53d6\u6570\u636e", description="\u4eceERP\u83b7\u53d6\u6570\u636e")
    @GetMapping(value={"/getPurchaseRequestByERP"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:getPurchaseRequestByERP"})
    public Result<?> getPurchaseRequestByERP() {
        this.purchaseRequestHeadService.getPurchaseRequestByERP();
        return Result.ok();
    }

    @Operation(summary="SRM\u63a8\u9001\u5230ERP", description="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushPurchaseRequestData"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:pushPurchaseRequestData"})
    public Result<?> pushPurchaseRequestData(@RequestParam(value="ids") String ids) {
        this.purchaseRequestHeadService.pushPurchaseRequestData(ids);
        return this.commonSuccessResult(3);
    }

    @Operation(summary="\u590d\u5236\u5355\u636e", description="\u590d\u5236\u5355\u636e")
    @GetMapping(value={"/copy"})
    @RequiresPermissions(value={"purchaseRequest#purchaseRequestHead:copy"})
    public Result<?> copy(@RequestParam(value="id") String id) {
        PurchaseRequestHeadVO data = this.getData(id);
        this.purchaseRequestHeadService.copy(data);
        return this.commonSuccessResult(3);
    }
}

