/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.ebidding.websocket;

import cn.hutool.core.lang.UUID;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.server.PathParam;
import jakarta.websocket.server.ServerEndpoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/websocket/online/{purchaseHeadId}/{elsAccount}")
public class OnlineWebSocket {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OnlineWebSocket.class);
    private Session session;
    private String purchaseHeadId;
    private String elsAccount;
    private String id;
    private static Map<String, List<OnlineWebSocket>> clientMap = new ConcurrentHashMap<String, List<OnlineWebSocket>>();

    @OnOpen
    public void onOpen(Session session, @PathParam(value="purchaseHeadId") String purchaseHeadId, @PathParam(value="elsAccount") String elsAccount) {
        try {
            this.session = session;
            this.purchaseHeadId = purchaseHeadId;
            this.elsAccount = elsAccount;
            this.id = UUID.randomUUID().toString();
            List<Object> clients = clientMap.get(purchaseHeadId) == null ? new ArrayList() : clientMap.get(purchaseHeadId);
            clients.add(this);
            clientMap.put(purchaseHeadId, clients);
        }
        catch (Exception e) {
            log.error("\u3010OnlineWebSocket\u6d88\u606f\u3011\u5efa\u7acb\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
    }

    @OnClose
    public void onClose() {
        try {
            List<OnlineWebSocket> clients = clientMap.get(this.purchaseHeadId);
            if (clients != null) {
                List result = clients.stream().filter(socket -> !this.id.equals(socket.id)).collect(Collectors.toList());
                clientMap.put(this.purchaseHeadId, result);
            }
            log.info("\u3010OnlineWebSocket\u6d88\u606f\u3011\u8fde\u63a5\u65ad\u5f00");
        }
        catch (Exception e) {
            log.error("\u3010OnlineWebSocket\u6d88\u606f\u3011\u65ad\u5f00\u8fde\u63a5\u5f02\u5e38", (Throwable)e);
        }
    }

    @OnMessage
    public void onMessage(String message) {
        this.session.getAsyncRemote().sendText(message);
    }

    public void sendQuoteMessage(String purchaseHeadId) {
        String key = UUID.randomUUID().toString();
        log.info("[quotePriceTopic]websocket\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff0ckey\u4e3a[{}]\uff0cpurchaseHeadId\u4e3a[{}]", (Object)key, (Object)purchaseHeadId);
        List<OnlineWebSocket> clients = clientMap.get(purchaseHeadId);
        log.info("[quotePriceTopic]websocket\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff0ckey\u4e3a[{}]\uff0cpurchaseHeadId\u4e3a[{}]\uff0cclients\u7684size\u4e3a[{}]", new Object[]{key, purchaseHeadId, clients == null ? null : Integer.valueOf(clients.size())});
        if (clients != null && !clients.isEmpty()) {
            for (OnlineWebSocket socket : clients) {
                if (socket.session != null && socket.session.isOpen()) {
                    log.info("[quotePriceTopic]websocket\u6b63\u5728\u53d1\u9001\u6d88\u606f\uff0ckey\u4e3a[{}]\uff0c\u6d88\u606f\u5185\u5bb9\u4e3a[{}]", (Object)key, (Object)purchaseHeadId);
                    socket.session.getAsyncRemote().sendText(purchaseHeadId);
                    continue;
                }
                log.info("[quotePriceTopic]websocket\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff0ckey\u4e3a[{}]\uff0cpurchaseHeadId\u4e3a[{}]\uff0csocket.session\u4e3a\u7a7a\u6216\u8005close", (Object)key, (Object)purchaseHeadId);
            }
        }
        log.info("[quotePriceTopic]websocket\u7ed3\u675f\u53d1\u9001\u6d88\u606f\uff0ckey\u4e3a[{}]\uff0cpurchaseHeadId\u4e3a[{}]", (Object)key, (Object)purchaseHeadId);
    }
}

