/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.enquiry.cost.excel;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.ParentEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.enquiry.cost.entity.CostField;
import com.els.modules.enquiry.cost.service.CostFieldService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

@RpcService(value="costFieldImportExcelDataBatchImpl")
public class CostFieldImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Resource
    private CostFieldService costFieldService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        String elsAccount = TenantContext.getTenant();
        ArrayList<CostField> list = new ArrayList<CostField>();
        ArrayList<String> keyList = new ArrayList<String>();
        List list1 = this.costFieldService.list((Wrapper)new QueryWrapper().lambda().select(new SFunction[]{CostField::getFieldName}).eq(ParentEntity::getElsAccount, (Object)elsAccount));
        Map collect = list1.stream().filter(item -> StrUtil.isNotBlank((CharSequence)item.getFieldName())).collect(Collectors.toMap(CostField::getFieldName, Function.identity(), (k1, k2) -> k1));
        for (Map data : dataList) {
            CostField costField = (CostField)((Object)JSON.parseObject((String)JSON.toJSONString((Object)data), CostField.class));
            costField.setElsAccount(elsAccount);
            keyList.add(costField.getFieldName());
            if (collect.containsKey(costField.getFieldName())) continue;
            list.add(costField);
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.costFieldService.saveBatch(list, 2000);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

